/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.MailSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.MailSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MailSettingsEvent;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.EmailValidation;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MailSettingsHandler
extends BaseSettingsHandler<MailSettings, MailSettingsChangeListener> {
    protected MailSettingsHandler() {
        super(Setting.Type.MAIL, MailSettings.class);
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap mailConverters = new LinkedHashMap();
        mailConverters.put("fromMail", CoercionConverter.instance(String.class));
        mailConverters.put("smtpServer", CoercionConverter.instance(String.class));
        mailConverters.put("smtpPort", CoercionConverter.instance(Integer.TYPE));
        mailConverters.put("smtpUsername", CoercionConverter.instance(String.class));
        mailConverters.put("smtpPassword", CoercionConverter.instance(String.class));
        mailConverters.put("smtpUseTLS", CoercionConverter.instance(Boolean.TYPE));
        return mailConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator mailValidator = new Validator("settings.mail");
        mailValidator.property("fromMail").required().add(EmailValidation.instance());
        mailValidator.property("smtpServer").required();
        mailValidator.property("smtpPort").required().positiveNonZero();
        return mailValidator;
    }

    @Override
    protected void notifyListener(MailSettingsChangeListener listener, MailSettings settings) {
        listener.onMailSettingsUpdate(new MailSettingsEvent(settings));
    }
}

