/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.MailTranslation;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.MailTranslationChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MailTranslationEvent;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MailTranslationHandler
extends BaseSettingsHandler<MailTranslation, MailTranslationChangeListener> {
    private static final int MAX_SUBJECT_SIZE = 255;
    private static final int MAX_BODY_SIZE = 8000;

    protected MailTranslationHandler() {
        super(Setting.Type.MAIL_TRANSLATION, MailTranslation.class);
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap mailConverters = new LinkedHashMap();
        mailConverters.put("invitationSubject", CoercionConverter.instance(String.class));
        mailConverters.put("invitationMessage", CoercionConverter.instance(String.class));
        mailConverters.put("activationSubject", CoercionConverter.instance(String.class));
        mailConverters.put("activationMessageWithPassword", CoercionConverter.instance(String.class));
        mailConverters.put("activationMessageWithoutPassword", CoercionConverter.instance(String.class));
        mailConverters.put("resetPasswordSubject", CoercionConverter.instance(String.class));
        mailConverters.put("resetPasswordMessage", CoercionConverter.instance(String.class));
        mailConverters.put("mailValidationSubject", CoercionConverter.instance(String.class));
        mailConverters.put("mailValidationMessage", CoercionConverter.instance(String.class));
        return mailConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator mailValidator = new Validator("settings.mail");
        mailValidator.property("invitationSubject").key("settings.mail.subject").required().maxLength(255);
        mailValidator.property("invitationMessage").key("settings.mail.message").required().maxLength(8000);
        mailValidator.property("activationSubject").key("settings.mail.subject").required().maxLength(255);
        mailValidator.property("activationMessageWithPassword").key("settings.mail.message").required().maxLength(8000);
        mailValidator.property("activationMessageWithoutPassword").key("settings.mail.message").required().maxLength(8000);
        mailValidator.property("resetPasswordSubject").key("settings.mail.subject").required().maxLength(255);
        mailValidator.property("resetPasswordMessage").key("settings.mail.message").required().maxLength(8000);
        mailValidator.property("mailValidationSubject").key("settings.mail.subject").required().maxLength(255);
        mailValidator.property("mailValidationMessage").key("settings.mail.message").required().maxLength(8000);
        return mailValidator;
    }

    @Override
    protected void notifyListener(MailTranslationChangeListener listener, MailTranslation settings) {
        listener.onMailSettingsUpdate(new MailTranslationEvent(settings));
    }
}

