/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.MessageSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MessageSettingsEvent;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MessageSettingsHandler
extends BaseSettingsHandler<MessageSettings, MessageSettingsChangeListener> {
    public static final int MAX_SUBJECT_SIZE = 400;
    public static final int MAX_BODY_SIZE = 4000;
    public static final int MAX_SMS_SIZE = 256;

    protected MessageSettingsHandler() {
        super(Setting.Type.MESSAGE, MessageSettings.class);
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap messageConverters = new LinkedHashMap();
        for (MessageSettings.MessageSettingsEnum messageSetting : MessageSettings.MessageSettingsEnum.values()) {
            if (messageSetting.defaultSubject() != null) {
                messageConverters.put(messageSetting.subjectSettingName(), CoercionConverter.instance(String.class));
            }
            if (messageSetting.defaultMessage() != null) {
                messageConverters.put(messageSetting.messageSettingName(), CoercionConverter.instance(String.class));
            }
            if (messageSetting.defaultSms() == null) continue;
            messageConverters.put(messageSetting.smsSettingName(), CoercionConverter.instance(String.class));
        }
        return messageConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator messageValidator = new Validator("settings.mail");
        for (MessageSettings.MessageSettingsEnum messageSetting : MessageSettings.MessageSettingsEnum.values()) {
            if (messageSetting.defaultSubject() != null) {
                messageValidator.property(messageSetting.subjectSettingName()).required().maxLength(400);
            }
            if (messageSetting.defaultMessage() != null) {
                messageValidator.property(messageSetting.messageSettingName()).required().maxLength(4000);
            }
            if (messageSetting.defaultSms() == null) continue;
            messageValidator.property(messageSetting.smsSettingName()).required().maxLength(256);
        }
        return messageValidator;
    }

    @Override
    protected void notifyListener(MessageSettingsChangeListener listener, MessageSettings settings) {
        listener.onMessageSettingsUpdate(new MessageSettingsEvent(settings));
    }
}

