/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.settings.SettingDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.entities.settings.MailSettings;
import nl.strohalm.cyclos.entities.settings.MailTranslation;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.AccessSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.AlertSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LogSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MailSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MailTranslationChangeListener;
import nl.strohalm.cyclos.entities.settings.events.MessageSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.SettingsChangeListener;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsHandler;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.settings.exceptions.SelectedSettingTypeNotInFileException;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.XmlHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SettingsServiceImpl
implements SettingsServiceLocal,
InitializingService,
InitializingBean {
    private static final String ROOT_ELEMENT = "cyclos-settings";
    private static final String SETTINGS_ELEMENT = "settings";
    private static final String SETTING_ELEMENT = "setting";
    private static final List<String> IGNORED_SETTINGS = Arrays.asList("applicationName", "language");
    private FetchServiceLocal fetchService;
    private SettingDAO settingDao;
    private Map<Setting.Type, SettingsHandler<?, ?>> handlersMap;
    private SettingsHandler<AccessSettings, AccessSettingsChangeListener> accessSettingsHandler;
    private SettingsHandler<AlertSettings, AlertSettingsChangeListener> alertSettingsHandler;
    private SettingsHandler<LocalSettings, LocalSettingsChangeListener> localSettingsHandler;
    private SettingsHandler<LogSettings, LogSettingsChangeListener> logSettingsHandler;
    private SettingsHandler<MailSettings, MailSettingsChangeListener> mailSettingsHandler;
    private SettingsHandler<MailTranslation, MailTranslationChangeListener> mailTranslationHandler;
    private SettingsHandler<MessageSettings, MessageSettingsChangeListener> messageSettingsHandler;
    private Set<SettingsChangeListener> listenersPendingToAdd = new HashSet<SettingsChangeListener>();

    @Override
    public void addListener(SettingsChangeListener listener) {
        if (this.listenersPendingToAdd != null) {
            this.listenersPendingToAdd.add(listener);
            return;
        }
        if (listener instanceof AccessSettingsChangeListener) {
            this.accessSettingsHandler.addListener((AccessSettingsChangeListener)listener);
        }
        if (listener instanceof AlertSettingsChangeListener) {
            this.alertSettingsHandler.addListener((AlertSettingsChangeListener)listener);
        }
        if (listener instanceof LocalSettingsChangeListener) {
            this.localSettingsHandler.addListener((LocalSettingsChangeListener)listener);
        }
        if (listener instanceof LogSettingsChangeListener) {
            this.logSettingsHandler.addListener((LogSettingsChangeListener)listener);
        }
        if (listener instanceof MailSettingsChangeListener) {
            this.mailSettingsHandler.addListener((MailSettingsChangeListener)listener);
        }
        if (listener instanceof MailTranslationChangeListener) {
            this.mailTranslationHandler.addListener((MailTranslationChangeListener)listener);
        }
        if (listener instanceof MessageSettingsChangeListener) {
            this.messageSettingsHandler.addListener((MessageSettingsChangeListener)listener);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.handlersMap = new HashMap();
        this.handlersMap.put(Setting.Type.ACCESS, this.accessSettingsHandler);
        this.handlersMap.put(Setting.Type.ALERT, this.alertSettingsHandler);
        this.handlersMap.put(Setting.Type.LOCAL, this.localSettingsHandler);
        this.handlersMap.put(Setting.Type.LOG, this.logSettingsHandler);
        this.handlersMap.put(Setting.Type.MAIL, this.mailSettingsHandler);
        this.handlersMap.put(Setting.Type.MAIL_TRANSLATION, this.mailTranslationHandler);
        this.handlersMap.put(Setting.Type.MESSAGE, this.messageSettingsHandler);
        Set<SettingsChangeListener> listeners = this.listenersPendingToAdd;
        this.listenersPendingToAdd = null;
        for (SettingsChangeListener listener : listeners) {
            this.addListener(listener);
        }
    }

    @Override
    public String exportToXml(Collection<Setting.Type> types) {
        LocalSettings localSettings = this.getLocalSettings();
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"").append(localSettings.getCharset()).append("\"?>\n");
        xml.append('<').append(ROOT_ELEMENT).append(">\n");
        for (Setting.Type type : types) {
            this.appendSettingType(xml, type);
        }
        xml.append("</").append(ROOT_ELEMENT).append(">\n");
        return xml.toString();
    }

    @Override
    public AccessSettings getAccessSettings() {
        return this.accessSettingsHandler.get();
    }

    @Override
    public AlertSettings getAlertSettings() {
        return this.alertSettingsHandler.get();
    }

    @Override
    public LocalSettings getLocalSettings() {
        return this.localSettingsHandler.get();
    }

    @Override
    public LogSettings getLogSettings() {
        return this.logSettingsHandler.get();
    }

    @Override
    public MailSettings getMailSettings() {
        return this.mailSettingsHandler.get();
    }

    @Override
    public MailTranslation getMailTranslation() {
        return this.mailTranslationHandler.get();
    }

    @Override
    public MessageSettings getMessageSettings() {
        return this.messageSettingsHandler.get();
    }

    @Override
    public MemberCustomField getSmsCustomField() {
        Long id = this.getLocalSettings().getSmsCustomFieldId();
        if (id == null) {
            return null;
        }
        MemberCustomField reference = EntityHelper.reference(MemberCustomField.class, id);
        return this.fetchService.fetch(reference, new Relationship[0]);
    }

    @Override
    public List<?> importFromXml(String xml, Collection<Setting.Type> types) {
        Document doc = XmlHelper.readDocument(xml);
        Element root = doc.getDocumentElement();
        List<Element> settingTypesNodes = XmlHelper.getChilden(root, SETTINGS_ELEMENT);
        HashSet<Setting.Type> typesImported = new HashSet<Setting.Type>();
        ArrayList settings = new ArrayList();
        for (Element settingTypeNode : settingTypesNodes) {
            String settingTypeName = settingTypeNode.getAttribute("type");
            Setting.Type type = CoercionHelper.coerce(Setting.Type.class, settingTypeName);
            if (!types.contains(type)) continue;
            HashMap<String, String> values = new HashMap<String, String>();
            List<Element> settingsNodes = XmlHelper.getChilden(settingTypeNode, SETTING_ELEMENT);
            for (Element settingNode : settingsNodes) {
                String settingValue;
                String settingName = settingNode.getAttribute("name");
                if (type == Setting.Type.LOCAL && IGNORED_SETTINGS.contains(settingName)) continue;
                try {
                    settingValue = StringUtils.trimToNull((String)settingNode.getChildNodes().item(0).getNodeValue());
                }
                catch (Exception e) {
                    settingValue = null;
                }
                values.put(settingName, settingValue);
            }
            SettingsHandler<?, ?> settingsHandler = this.handlersMap.get(type);
            Object setting = settingsHandler.importFrom(values);
            typesImported.add(type);
            settings.add(setting);
        }
        ArrayList<Setting.Type> notImportedTypes = new ArrayList<Setting.Type>();
        for (Setting.Type type : types) {
            if (typesImported.contains(type)) continue;
            notImportedTypes.add(type);
        }
        if (CollectionUtils.isNotEmpty(notImportedTypes)) {
            throw new SelectedSettingTypeNotInFileException(notImportedTypes);
        }
        return settings;
    }

    @Override
    public void initializeService() {
        this.importNew();
    }

    @Override
    public void reloadTranslation() {
        this.settingDao.deleteByType(Setting.Type.MAIL_TRANSLATION, Setting.Type.MESSAGE);
        for (Setting setting : this.settingDao.listByType(Setting.Type.LOCAL)) {
            String name = setting.getName();
            if (!"applicationUsername".equals(name) && !"chargebackDescription".equals(name)) continue;
            this.settingDao.delete(setting.getId());
        }
        this.importNew();
        this.refreshTranslationRelatedHandlers();
    }

    @Override
    public void removeListener(SettingsChangeListener listener) {
        if (listener instanceof AccessSettingsChangeListener) {
            this.accessSettingsHandler.removeListener((AccessSettingsChangeListener)listener);
        }
        if (listener instanceof AlertSettingsChangeListener) {
            this.alertSettingsHandler.removeListener((AlertSettingsChangeListener)listener);
        }
        if (listener instanceof LocalSettingsChangeListener) {
            this.localSettingsHandler.removeListener((LocalSettingsChangeListener)listener);
        }
        if (listener instanceof LogSettingsChangeListener) {
            this.logSettingsHandler.removeListener((LogSettingsChangeListener)listener);
        }
        if (listener instanceof MailSettingsChangeListener) {
            this.mailSettingsHandler.removeListener((MailSettingsChangeListener)listener);
        }
        if (listener instanceof MailTranslationChangeListener) {
            this.mailTranslationHandler.removeListener((MailTranslationChangeListener)listener);
        }
        if (listener instanceof MessageSettingsChangeListener) {
            this.messageSettingsHandler.removeListener((MessageSettingsChangeListener)listener);
        }
    }

    @Override
    public AccessSettings save(AccessSettings settings) {
        return this.accessSettingsHandler.update(settings);
    }

    @Override
    public AlertSettings save(AlertSettings settings) {
        return this.alertSettingsHandler.update(settings);
    }

    @Override
    public LocalSettings save(LocalSettings settings) {
        return this.localSettingsHandler.update(settings);
    }

    @Override
    public LogSettings save(LogSettings settings) {
        return this.logSettingsHandler.update(settings);
    }

    @Override
    public MailSettings save(MailSettings settings) {
        return this.mailSettingsHandler.update(settings);
    }

    @Override
    public MailTranslation save(MailTranslation settings) {
        return this.mailTranslationHandler.update(settings);
    }

    @Override
    public MessageSettings save(MessageSettings settings) {
        return this.messageSettingsHandler.update(settings);
    }

    public void setAccessSettingsHandler(SettingsHandler<AccessSettings, AccessSettingsChangeListener> accessSettingsHandler) {
        this.accessSettingsHandler = accessSettingsHandler;
    }

    public void setAlertSettingsHandler(SettingsHandler<AlertSettings, AlertSettingsChangeListener> alertSettingsHandler) {
        this.alertSettingsHandler = alertSettingsHandler;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLocalSettingsHandler(SettingsHandler<LocalSettings, LocalSettingsChangeListener> localSettingsHandler) {
        this.localSettingsHandler = localSettingsHandler;
    }

    public void setLogSettingsHandler(SettingsHandler<LogSettings, LogSettingsChangeListener> logSettingsHandler) {
        this.logSettingsHandler = logSettingsHandler;
    }

    public void setMailSettingsHandler(SettingsHandler<MailSettings, MailSettingsChangeListener> mailSettingsHandler) {
        this.mailSettingsHandler = mailSettingsHandler;
    }

    public void setMailTranslationHandler(SettingsHandler<MailTranslation, MailTranslationChangeListener> mailTranslationHandler) {
        this.mailTranslationHandler = mailTranslationHandler;
    }

    public void setMessageSettingsHandler(SettingsHandler<MessageSettings, MessageSettingsChangeListener> messageSettingsHandler) {
        this.messageSettingsHandler = messageSettingsHandler;
    }

    public void setSettingDao(SettingDAO settingDao) {
        this.settingDao = settingDao;
    }

    @Override
    public void validate(AccessSettings settings) {
        this.accessSettingsHandler.validate(settings);
    }

    @Override
    public void validate(AlertSettings settings) {
        this.alertSettingsHandler.validate(settings);
    }

    @Override
    public void validate(LocalSettings settings) {
        this.localSettingsHandler.validate(settings);
    }

    @Override
    public void validate(LogSettings settings) {
        this.logSettingsHandler.validate(settings);
    }

    @Override
    public void validate(MailSettings settings) {
        this.mailSettingsHandler.validate(settings);
    }

    @Override
    public void validate(MailTranslation settings) {
        this.mailTranslationHandler.validate(settings);
    }

    @Override
    public void validate(MessageSettings settings) {
        this.messageSettingsHandler.validate(settings);
    }

    private void appendSetting(StringBuilder xml, Setting setting) {
        String indent2Levels = StringUtils.repeat((String)"    ", (int)2);
        String indent3Levels = StringUtils.repeat((String)"    ", (int)3);
        xml.append(indent2Levels).append(String.format("<setting name=\"%s\" >\n", setting.getName()));
        xml.append(indent3Levels).append(StringEscapeUtils.escapeXml((String)setting.getValue()));
        xml.append(indent2Levels).append("</setting>\n");
    }

    private void appendSettingType(StringBuilder xml, Setting.Type type) {
        String indent = StringUtils.repeat((String)"    ", (int)1);
        xml.append(String.format("%s<settings type=\"%s\" >\n", indent, type.getValue()));
        SettingsHandler<?, ?> handler = this.handlersMap.get(type);
        List<Setting> settings = handler.listSettings();
        for (Setting setting : settings) {
            if (type == Setting.Type.LOCAL && IGNORED_SETTINGS.contains(setting.getName())) continue;
            this.appendSetting(xml, setting);
        }
        xml.append(indent).append("</settings>\n");
    }

    private void importNew() {
        this.settingDao.importNew(this.getLocalSettings().getLocale());
        this.refreshTranslationRelatedHandlers();
    }

    private void refreshTranslationRelatedHandlers() {
        this.localSettingsHandler.refresh();
        this.messageSettingsHandler.refresh();
        this.mailTranslationHandler.refresh();
    }
}

