/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.entities.settings.MailSettings;
import nl.strohalm.cyclos.entities.settings.MailTranslation;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.SettingsChangeListener;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;

public class SettingsServiceSecurity
extends BaseServiceSecurity
implements SettingsService {
    private SettingsServiceLocal settingsService;

    @Override
    public void addListener(SettingsChangeListener listener) {
        this.settingsService.addListener(listener);
    }

    @Override
    public String exportToXml(Collection<Setting.Type> types) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_FILE).check();
        return this.settingsService.exportToXml(types);
    }

    @Override
    public AccessSettings getAccessSettings() {
        return this.settingsService.getAccessSettings();
    }

    @Override
    public AlertSettings getAlertSettings() {
        return this.settingsService.getAlertSettings();
    }

    @Override
    public LocalSettings getLocalSettings() {
        return this.settingsService.getLocalSettings();
    }

    @Override
    public LogSettings getLogSettings() {
        return this.settingsService.getLogSettings();
    }

    @Override
    public MailSettings getMailSettings() {
        return this.settingsService.getMailSettings();
    }

    @Override
    public MailTranslation getMailTranslation() {
        return this.settingsService.getMailTranslation();
    }

    @Override
    public MessageSettings getMessageSettings() {
        return this.settingsService.getMessageSettings();
    }

    @Override
    public List<?> importFromXml(String xml, Collection<Setting.Type> types) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_FILE).check();
        return this.settingsService.importFromXml(xml, types);
    }

    @Override
    public void reloadTranslation() {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_LOCAL).check();
        this.settingsService.reloadTranslation();
    }

    @Override
    public void removeListener(SettingsChangeListener listener) {
        this.settingsService.removeListener(listener);
    }

    @Override
    public AccessSettings save(AccessSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_ACCESS).check();
        return this.settingsService.save(settings);
    }

    @Override
    public AlertSettings save(AlertSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_ALERT).check();
        return this.settingsService.save(settings);
    }

    @Override
    public LocalSettings save(LocalSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_LOCAL).check();
        return this.settingsService.save(settings);
    }

    @Override
    public LogSettings save(LogSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_LOG).check();
        return this.settingsService.save(settings);
    }

    @Override
    public MailSettings save(MailSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.SETTINGS_MANAGE_MAIL).check();
        return this.settingsService.save(settings);
    }

    @Override
    public MailTranslation save(MailTranslation settings) {
        this.permissionService.permission().admin(AdminSystemPermission.TRANSLATION_MANAGE_MAIL_TRANSLATION).check();
        return this.settingsService.save(settings);
    }

    @Override
    public MessageSettings save(MessageSettings settings) {
        this.permissionService.permission().admin(AdminSystemPermission.TRANSLATION_MANAGE_NOTIFICATION).check();
        return this.settingsService.save(settings);
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(AccessSettings settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(AlertSettings settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(LocalSettings settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(LogSettings settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(MailSettings settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(MailTranslation settings) {
        this.settingsService.validate(settings);
    }

    @Override
    public void validate(MessageSettings settings) {
        this.settingsService.validate(settings);
    }
}

