/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.sms;

import java.io.Serializable;
import java.math.BigDecimal;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.utils.TimePeriod;

public class MemberGroupSmsContextImpl
implements ISmsContext,
Serializable {
    private static final long serialVersionUID = 869531744522514275L;
    private static final MemberGroupSmsContextImpl INSTANCE = new MemberGroupSmsContextImpl();

    public static MemberGroupSmsContextImpl getInstance() {
        return INSTANCE;
    }

    private MemberGroupSmsContextImpl() {
    }

    @Override
    public BigDecimal getAdditionalChargeAmount(Member member) {
        return member.getMemberGroup().getMemberSettings().getSmsChargeAmount();
    }

    @Override
    public TimePeriod getAdditionalChargedPeriod(Member member) {
        return member.getMemberGroup().getMemberSettings().getSmsAdditionalChargedPeriod();
    }

    @Override
    public int getAdditionalChargedSms(Member member) {
        return member.getMemberGroup().getMemberSettings().getSmsAdditionalCharged();
    }

    @Override
    public int getFreeSms(Member member) {
        return member.getMemberGroup().getMemberSettings().getSmsFree();
    }

    @Override
    public boolean showFreeSms(MemberSmsStatus status) {
        Member member = status.getMember();
        int threshold = member.getMemberGroup().getMemberSettings().getSmsShowFreeThreshold();
        return this.getFreeSms(member) - status.getFreeSmsSent() <= threshold;
    }
}

