/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.sms;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.sms.SmsLogDAO;
import nl.strohalm.cyclos.dao.sms.SmsLogReportTotal;
import nl.strohalm.cyclos.dao.sms.SmsTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportVO;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.services.sms.SmsLogServiceLocal;
import nl.strohalm.cyclos.utils.StringHelper;
import org.apache.commons.lang.StringUtils;

public class SmsLogServiceImpl
implements SmsLogServiceLocal {
    private SmsLogDAO smsLogDao;
    private SmsTypeDAO smsTypeDao;

    @Override
    public SmsLogReportVO getSmsLogReport(SmsLogReportQuery query) {
        SmsLogReportVO report = new SmsLogReportVO();
        if (query.isReturnTotals()) {
            List<SmsLogReportTotal> totals = this.smsLogDao.getReportTotals(query);
            for (SmsLogReportTotal total : totals) {
                report.setTotals(total.getType(), total.getStatus(), total.getTotal());
            }
        }
        report.setLogs(this.smsLogDao.search(query));
        return report;
    }

    @Override
    public Collection<SmsType> getSmsTypes() {
        return this.smsTypeDao.list();
    }

    @Override
    public SmsType loadSmsTypeByCode(String code) {
        SmsType smsType = null;
        if (StringUtils.isNotEmpty((String)code)) {
            smsType = this.smsTypeDao.loadByCode(code);
        }
        if (smsType == null) {
            throw new EntityNotFoundException(SmsType.class, null, "No sms type defined with code: '" + code + "'");
        }
        return smsType;
    }

    @Override
    public Collection<SmsType> loadSmsTypes(Collection<Long> ids) {
        return this.smsTypeDao.load(ids, new Relationship[0]);
    }

    @Override
    public SmsLog save(SmsLog smsLog) {
        smsLog.setArg0(StringHelper.replaceSupplementaryCharacters(smsLog.getArg0()));
        smsLog.setArg1(StringHelper.replaceSupplementaryCharacters(smsLog.getArg1()));
        smsLog.setArg2(StringHelper.replaceSupplementaryCharacters(smsLog.getArg2()));
        smsLog.setArg3(StringHelper.replaceSupplementaryCharacters(smsLog.getArg3()));
        smsLog.setArg4(StringHelper.replaceSupplementaryCharacters(smsLog.getArg4()));
        return this.smsLogDao.insert(smsLog);
    }

    @Override
    public List<SmsLog> search(SmsLogQuery query) {
        return this.smsLogDao.search(query);
    }

    public void setSmsLogDao(SmsLogDAO smsLogDao) {
        this.smsLogDao = smsLogDao;
    }

    public void setSmsTypeDao(SmsTypeDAO smsTypeDao) {
        this.smsTypeDao = smsTypeDao;
    }
}

