/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.sms;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportVO;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.sms.SmsLogService;
import nl.strohalm.cyclos.services.sms.SmsLogServiceLocal;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class SmsLogServiceSecurity
extends BaseServiceSecurity
implements SmsLogService {
    private SmsLogServiceLocal smsLogService;

    @Override
    public SmsLogReportVO getSmsLogReport(SmsLogReportQuery query) {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_SMS_LOGS).check();
        Collection<MemberGroup> allowed = this.permissionService.getManagedMemberGroups();
        if (CollectionUtils.isEmpty(allowed)) {
            throw new PermissionDeniedException();
        }
        query.setMemberGroups(PermissionHelper.checkSelection(allowed, query.getMemberGroups()));
        return this.smsLogService.getSmsLogReport(query);
    }

    @Override
    public Collection<SmsType> getSmsTypes() {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_SMS_LOGS).check();
        return this.smsLogService.getSmsTypes();
    }

    @Override
    public Collection<SmsType> loadSmsTypes(Collection<Long> ids) {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_SMS_LOGS).check();
        return this.smsLogService.loadSmsTypes(ids);
    }

    @Override
    public List<SmsLog> search(SmsLogQuery query) {
        if (query.getMember() == null) {
            throw new ValidationException();
        }
        this.permissionService.permission(query.getMember()).admin(AdminMemberPermission.SMS_VIEW).broker(BrokerPermission.MEMBER_SMS_VIEW).member(MemberPermission.SMS_VIEW).check();
        return this.smsLogService.search(query);
    }

    public void setSmsLogServiceLocal(SmsLogServiceLocal smsLogService) {
        this.smsLogService = smsLogService;
    }
}

