/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.sms;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.strohalm.cyclos.dao.sms.SmsMailingDAO;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsMailingQuery;
import nl.strohalm.cyclos.scheduling.polling.SmsMailingSendingPollingTask;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.sms.SmsMailingServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;

public class SmsMailingServiceImpl
implements SmsMailingServiceLocal {
    private SmsMailingDAO smsMailingDao;
    private SettingsServiceLocal settingsService;
    private MemberServiceLocal memberService;
    private MemberCustomFieldService memberCustomFieldService;
    private ApplicationServiceLocal applicationService;
    private MessageResolver messageResolver;
    private FetchServiceLocal fetchService;
    private AccountServiceLocal accountService;
    private CustomFieldHelper customFieldHelper;

    @Override
    public Map<String, String> getSmsTextVariables(List<MemberGroup> groups) {
        return this.getSmsTextVariables(groups, null, true);
    }

    @Override
    public Map<String, String> getSmsTextVariables(List<MemberGroup> groups, Member member, boolean onlyVariableNames) {
        ArrayList<VariableEntry> vars;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        if (onlyVariableNames) {
            vars = new ArrayList<VariableEntry>();
            vars.add(new VariableEntry("system_name", this.messageResolver.message("smsMailing.systemName", new Object[0])));
            this.sortByValueAndAddToMap(vars, variables);
        } else {
            variables.put("system_name", localSettings.getApplicationName());
        }
        if (onlyVariableNames) {
            vars = new ArrayList();
            vars.add(new VariableEntry("login", this.messageResolver.message("login.memberUsername", new Object[0])));
            vars.add(new VariableEntry("name", this.messageResolver.message("member.memberName", new Object[0])));
            vars.add(new VariableEntry("email", this.messageResolver.message("member.email", new Object[0])));
            this.sortByValueAndAddToMap(vars, variables);
        } else {
            variables.putAll(member.getVariableValues(localSettings));
        }
        if (onlyVariableNames) {
            vars = new ArrayList();
            vars.add(new VariableEntry("balance", this.messageResolver.message("account.balance", new Object[0])));
            vars.add(new VariableEntry("available_balance", this.messageResolver.message("account.availableBalance", new Object[0])));
            vars.add(new VariableEntry("reserved_amount", this.messageResolver.message("account.reservedAmount", new Object[0])));
            vars.add(new VariableEntry("credit_limit", this.messageResolver.message("account.creditLimit", new Object[0])));
            vars.add(new VariableEntry("upper_credit_limit", this.messageResolver.message("account.upperCreditLimit", new Object[0])));
            this.sortByValueAndAddToMap(vars, variables);
        } else {
            List<Account> allAccounts = this.accountService.getAccounts(member, Account.Relationships.TYPE);
            Account defaultAccount = this.accountService.getDefaultAccountFromList(member, allAccounts);
            AccountType defaultAccountType = defaultAccount == null ? null : defaultAccount.getType();
            AccountStatus status = this.accountService.getCurrentStatus(new AccountDTO(member, defaultAccountType));
            variables.putAll(status.getVariableValues(localSettings));
        }
        if (onlyVariableNames) {
            List<MemberCustomField> allFields = this.memberCustomFieldService.list();
            List<MemberCustomField> customFields = this.customFieldHelper.onlyInAllGroups(allFields, groups);
            ArrayList<VariableEntry> vars2 = new ArrayList<VariableEntry>();
            for (MemberCustomField mcf : customFields) {
                vars2.add(new VariableEntry(mcf.getInternalName(), mcf.getName()));
            }
            this.sortByValueAndAddToMap(vars2, variables);
        } else {
            Collection<MemberCustomFieldValue> values = member.getCustomValues();
            for (MemberCustomFieldValue fv : values) {
                CustomField cf = fv.getField();
                String fName = cf.getInternalName();
                String fValue = fv.getValue();
                variables.put(fName, fValue);
            }
        }
        return variables;
    }

    @Override
    public Map<String, String> getSmsTextVariables(Member member) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        return this.getSmsTextVariables(Collections.singletonList((MemberGroup)member.getGroup()));
    }

    @Override
    public Member nextMemberToSend(SmsMailing mailing) {
        return this.smsMailingDao.nextMemberToSend(mailing);
    }

    @Override
    public SmsMailing nextToSend() {
        SmsMailingQuery query = new SmsMailingQuery();
        query.setUniqueResult();
        query.setFinished(false);
        List<SmsMailing> list = this.search(query);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public void removeMemberFromPending(SmsMailing smsMailing, Member member) {
        this.smsMailingDao.removeMemberFromPending(smsMailing, member);
    }

    @Override
    public List<SmsMailing> search(SmsMailingQuery query) {
        return this.smsMailingDao.search(query);
    }

    @Override
    public SmsMailing send(SmsMailing smsMailing) {
        return this.doSend(smsMailing);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setSmsMailingDao(SmsMailingDAO smsMailingDao) {
        this.smsMailingDao = smsMailingDao;
    }

    @Override
    public void validate(SmsMailing smsMailing, boolean isMemberRequired) throws ValidationException {
        if (isMemberRequired && CollectionUtils.isNotEmpty(smsMailing.getGroups())) {
            throw new ValidationException();
        }
        this.getValidator(isMemberRequired).validate(smsMailing);
        this.validateVariables(smsMailing, isMemberRequired);
    }

    private SmsMailing doSend(SmsMailing smsMailing) {
        this.validate(smsMailing, smsMailing.isSingleMember());
        smsMailing.setBy((Element)LoggedUser.element());
        smsMailing.setDate(Calendar.getInstance());
        smsMailing.setSentSms(0);
        smsMailing = this.smsMailingDao.insert(smsMailing);
        if (smsMailing.isSingleMember() || !CollectionUtils.isEmpty(smsMailing.getGroups())) {
            MemberCustomField smsCustomField = this.settingsService.getSmsCustomField();
            if (smsCustomField == null) {
                throw new IllegalStateException("No custom field was set as SMS field under local settings");
            }
            this.smsMailingDao.assignUsersToSend(smsMailing, smsCustomField);
        }
        this.applicationService.awakePollingTaskOnTransactionCommit(SmsMailingSendingPollingTask.class);
        return smsMailing;
    }

    private Validator getValidator(boolean isMemberRequired) {
        Validator validator = new Validator("smsMailing");
        validator.property("text").required().maxLength(160);
        if (isMemberRequired) {
            validator.property("member").required().add(new PropertyValidation(){
                private static final long serialVersionUID = -20792899778722444L;

                @Override
                public ValidationError validate(Object object, Object property, Object value) {
                    Member member = (Member)value;
                    if (member == null) {
                        return null;
                    }
                    MemberCustomField smsCustomField = SmsMailingServiceImpl.this.settingsService.getSmsCustomField();
                    if (SmsMailingServiceImpl.this.memberService.hasValueForField(member, smsCustomField)) {
                        return null;
                    }
                    return new ValidationError("smsMailing.error.noMobilePhone", new Object[0]);
                }
            });
        }
        return validator;
    }

    private void sortByValueAndAddToMap(ArrayList<VariableEntry> vars, Map<String, String> variables) {
        Collections.sort(vars, new Comparator<VariableEntry>(){

            @Override
            public int compare(VariableEntry o1, VariableEntry o2) {
                return o1.value.compareTo(o2.value);
            }
        });
        for (VariableEntry variableEntry : vars) {
            variables.put(variableEntry.key, variableEntry.value);
        }
    }

    private void validateVariables(SmsMailing smsMailing, boolean isMemberRequired) {
        String text = smsMailing.getText();
        Map<String, String> variables = null;
        variables = isMemberRequired ? this.getSmsTextVariables(smsMailing.getMember()) : this.getSmsTextVariables(new ArrayList<MemberGroup>(smsMailing.getGroups()));
        HashSet<String> parsedVariables = new HashSet<String>();
        Pattern pattern = Pattern.compile("#[a-zA-Z_][a-zA-Z\\d_]*#");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            parsedVariables.add(matcher.group().replaceAll("#", ""));
        }
        Collection unexpectedVariables = CollectionUtils.subtract(parsedVariables, variables.keySet());
        if (CollectionUtils.isNotEmpty((Collection)unexpectedVariables)) {
            throw new ValidationException("smsMailing.error.variableNotFound", unexpectedVariables);
        }
    }

    private class VariableEntry {
        String key;
        String value;

        public VariableEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

