/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.sms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsMailingQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.sms.SmsMailingService;
import nl.strohalm.cyclos.services.sms.SmsMailingServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class SmsMailingServiceSecurity
extends BaseServiceSecurity
implements SmsMailingService {
    private SmsMailingServiceLocal smsMailingService;
    private GroupServiceLocal groupService;

    @Override
    public Map<String, String> getSmsTextVariables(List<MemberGroup> groups) {
        groups = this.checkGroups(groups);
        return this.smsMailingService.getSmsTextVariables(groups);
    }

    @Override
    public Map<String, String> getSmsTextVariables(Member member) {
        this.permissionService.checkManages(member);
        return this.smsMailingService.getSmsTextVariables(member);
    }

    @Override
    public List<SmsMailing> search(SmsMailingQuery query) {
        if (!this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_VIEW, BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS, BrokerPermission.SMS_MAILINGS_PAID_SMS_MAILINGS)) {
            throw new PermissionDeniedException();
        }
        this.applySearchRestrictions(query);
        return this.smsMailingService.search(query);
    }

    @Override
    public SmsMailing send(SmsMailing smsMailing) {
        if (smsMailing.isSingleMember()) {
            this.permissionService.permission(smsMailing.getMember()).admin(AdminMemberPermission.SMS_MAILINGS_FREE_SMS_MAILINGS).broker(BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS).check();
            smsMailing.setGroups(Collections.<MemberGroup>emptyList());
        } else {
            if (smsMailing.isFree()) {
                this.permissionService.permission().admin(AdminMemberPermission.SMS_MAILINGS_FREE_SMS_MAILINGS).broker(BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS).check();
            } else {
                this.permissionService.permission().admin(AdminMemberPermission.SMS_MAILINGS_PAID_SMS_MAILINGS).broker(BrokerPermission.SMS_MAILINGS_PAID_SMS_MAILINGS).check();
            }
            smsMailing.setGroups(this.checkGroups(new ArrayList<MemberGroup>(smsMailing.getGroups())));
        }
        return this.smsMailingService.send(smsMailing);
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setSmsMailingServiceLocal(SmsMailingServiceLocal smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    @Override
    public void validate(SmsMailing smsMailing, boolean isMemberRequired) throws ValidationException {
        if (!isMemberRequired) {
            smsMailing.setGroups(this.checkGroups(new ArrayList<MemberGroup>(smsMailing.getGroups())));
        }
        this.smsMailingService.validate(smsMailing, isMemberRequired);
    }

    private void applySearchRestrictions(SmsMailingQuery query) {
        if (LoggedUser.isBroker()) {
            query.setBroker((Member)LoggedUser.element());
            Member member = this.fetchService.fetch(query.getMember(), Member.Relationships.BROKER);
            if (member != null && !((Entity)LoggedUser.element()).equals(member.getBroker())) {
                throw new PermissionDeniedException();
            }
        } else {
            AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.MANAGES_GROUPS);
            Collection<MemberGroup> groups = query.getGroups();
            if (CollectionUtils.isEmpty(groups)) {
                query.setGroups(adminGroup.getManagesGroups());
            } else {
                groups.retainAll(adminGroup.getManagesGroups());
            }
        }
    }

    private List<MemberGroup> checkGroups(List<MemberGroup> groups) {
        GroupQuery query = new GroupQuery();
        if (LoggedUser.isAdministrator()) {
            query.setManagedBy((AdminGroup)LoggedUser.group());
        } else {
            query.setBroker(LoggedUser.member());
        }
        query.setOnlyActive(true);
        List<? extends Group> allowedGroups = this.groupService.search(query);
        groups = new ArrayList<MemberGroup>(PermissionHelper.checkSelection(allowedGroups, groups));
        return groups;
    }
}

