/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public class HistogramDTOFactory {
    private static final int MAXBARS = 39;
    private static final double LOW_BAR_LEVEL = 0.008;
    private static final int ALLOWABLE_TAIL_GAP = 3;
    private static final double MAX_REST_CAT_FRACTION = 0.09;
    private static final int CALIBRATION_PERCENTILE = 89;
    private LastRowHeaderPrefix lastRowHeaderPrefix;
    private StatisticalResultDTO result;
    private final List<Number> input;
    private List<Number> xResult;
    private List<Number> yResult;
    private double scaleFactorX;
    private final LocalSettings settings;

    public HistogramDTOFactory(List<Number> input, LocalSettings settings) {
        this.input = input;
        this.settings = settings;
        this.scaleFactorX = 1.0;
    }

    private void assignRowHeaders() {
        if (this.result == null) {
            return;
        }
        String[] rowHeaders = new String[this.xResult.size()];
        if (this.settings == null) {
            for (int i = 0; i < this.xResult.size(); ++i) {
                rowHeaders[i] = this.xResult.get(i).toString();
            }
        } else {
            for (int i = 0; i < this.xResult.size(); ++i) {
                rowHeaders[i] = this.settings.getNumberConverterForPrecision(1).toString(new BigDecimal(this.xResult.get(i).floatValue()));
            }
        }
        rowHeaders[this.xResult.size() - 1] = this.lastRowHeaderPrefix.getValue() + rowHeaders[this.xResult.size() - 1];
        this.result.setRowHeaders(rowHeaders);
    }

    private double calcClassWidth(double calibrationValue, boolean integers) {
        if (calibrationValue == 0.0) {
            this.scaleFactorX = 1.0;
            return 1.0;
        }
        double divideBy = Math.floor(this.logBase(10.0, calibrationValue));
        this.scaleFactorX = Math.pow(10.0, divideBy);
        double superRoundedValue = Math.ceil(calibrationValue / this.scaleFactorX);
        double width = superRoundedValue * Math.pow(10.0, divideBy - 1.0);
        if (integers) {
            width = width >= 0.5 ? (double)Math.round(width) : 1.0;
        }
        return width;
    }

    private double formatX(double number) {
        return number / this.scaleFactorX;
    }

    private String getScaleFactorString(String baseKey) {
        if (this.xResult == null) {
            this.produceResultArrays(baseKey);
        }
        if (this.scaleFactorX == 1.0) {
            return "";
        }
        if (this.scaleFactorX < 1.0) {
            return " ( / " + (int)(1.0 / this.scaleFactorX) + ")";
        }
        return " ( x " + (int)this.scaleFactorX + ")";
    }

    private double logBase(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    private void produceDTO(String baseKey) {
        Number[][] data = new Number[this.yResult.size()][1];
        for (int i = 0; i < this.yResult.size(); ++i) {
            data[i][0] = new StatisticalNumber(this.yResult.get(i).doubleValue(), 0);
        }
        this.result = new StatisticalResultDTO(data);
        this.result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        this.assignRowHeaders();
        this.result.setScaleFactorX(this.getScaleFactorString(baseKey));
        this.result.setShowTable(false);
    }

    private void produceJustOneBarDTO(String baseKey) {
        this.xResult.add(this.formatX(this.input.get(0).doubleValue()));
        this.yResult.add(this.input.size());
        this.lastRowHeaderPrefix = LastRowHeaderPrefix.NONE;
        this.produceDTO(baseKey);
    }

    private void produceResultArrays(String baseKey) {
        int remaining;
        int barIndex;
        if (this.input.size() < 15) {
            this.produceTooSmallDatasetDTO(baseKey);
            return;
        }
        this.yResult = new ArrayList<Number>();
        this.xResult = new ArrayList<Number>();
        List<Double> lInput = ListOperations.convertToDoubleList(this.input);
        Collections.sort(lInput);
        if (lInput.get(0).equals(lInput.get(lInput.size() - 1))) {
            this.produceJustOneBarDTO(baseKey);
            return;
        }
        boolean integers = this.input.get(0).getClass() == Integer.class;
        int calibrationPoint = (int)(Math.round((double)(89 * lInput.size()) / 100.0) - 1L);
        double calibrationValue = lInput.get(calibrationPoint);
        double classwidth = this.calcClassWidth(calibrationValue, integers);
        int maxElementIndexThisBar = 0;
        int lows = 0;
        double highest = 100.0;
        for (barIndex = 0; barIndex < 39; ++barIndex) {
            double remainingFraction;
            boolean dontwrite;
            ListIterator<Double> it = lInput.listIterator(maxElementIndexThisBar);
            int elementIndex = maxElementIndexThisBar;
            int maxElementIndexLastBar = maxElementIndexThisBar;
            double value = 0.0;
            while (it.hasNext()) {
                value = it.next();
                if (value >= (double)(barIndex + 1) * classwidth) {
                    maxElementIndexThisBar = elementIndex;
                    break;
                }
                ++elementIndex;
            }
            if (!it.hasNext() && Math.abs(value - (double)barIndex * classwidth) < 1.0E-6) {
                maxElementIndexThisBar = elementIndex;
            }
            boolean bl = dontwrite = !it.hasNext() && maxElementIndexThisBar - maxElementIndexLastBar == 0;
            if (!dontwrite) {
                if (integers) {
                    this.xResult.add(this.formatX(Math.floor(((double)barIndex + 0.5) * classwidth)));
                } else {
                    this.xResult.add(this.formatX(((double)barIndex + 0.5) * classwidth));
                }
                this.yResult.add(maxElementIndexThisBar - maxElementIndexLastBar);
                if ((double)(maxElementIndexThisBar - maxElementIndexLastBar) > highest) {
                    highest = maxElementIndexThisBar - maxElementIndexLastBar;
                }
            }
            if (!it.hasNext() || (lows = (int)((byte)((double)(maxElementIndexThisBar - maxElementIndexLastBar) < highest * 0.008 ? lows + 1 : 0))) >= 3 && maxElementIndexThisBar > calibrationPoint && (remainingFraction = (double)(this.input.size() - maxElementIndexThisBar) / (double)this.input.size()) < 0.09) break;
        }
        if ((remaining = this.input.size() - maxElementIndexThisBar) > 0) {
            this.xResult.add(this.formatX((double)(barIndex + 1) * classwidth));
            this.yResult.add(remaining);
            this.lastRowHeaderPrefix = integers ? LastRowHeaderPrefix.GREATER_EQUAL : LastRowHeaderPrefix.GREATER;
        } else {
            this.lastRowHeaderPrefix = LastRowHeaderPrefix.NONE;
        }
        this.produceDTO(baseKey);
    }

    private void produceTooSmallDatasetDTO(String baseKey) {
        this.result = StatisticalResultDTO.noDataAvailable(baseKey);
    }

    StatisticalResultDTO getResultObject(String baseKey) {
        if (this.result == null) {
            this.produceResultArrays(baseKey);
        }
        this.result.setBaseKey(baseKey);
        return this.result;
    }

    public static enum LastRowHeaderPrefix implements StringValuedEnum
    {
        NONE(""),
        GREATER(">"),
        GREATER_EQUAL("\u2265");

        private final String value;

        private LastRowHeaderPrefix(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

