/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.access.LoginHistoryDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.reports.StatisticalActivityQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.reports.StatisticalQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.services.stats.HistogramDTOFactory;
import nl.strohalm.cyclos.services.stats.StatisticalActivityServiceLocal;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalServiceImpl;
import nl.strohalm.cyclos.services.stats.activity.GrossProductPerMemberStats;
import nl.strohalm.cyclos.services.stats.activity.LoginTimesPerMemberStats;
import nl.strohalm.cyclos.services.stats.activity.TransactionCountPerMemberStats;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.statistics.ListOperations;
import nl.strohalm.cyclos.utils.statistics.Median;

public class StatisticalActivityServiceImpl
extends StatisticalServiceImpl
implements StatisticalActivityServiceLocal {
    private LoginHistoryDAO loginHistoryDao;
    private Map<String, Integer> numberOfMembersPerGroupPerPeriod;
    private StatisticalQuery cachedQueryParameters;

    @Override
    public StatisticalResultDTO getComparePeriodsGrossProduct(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        this.getInitializedPaymentFilter(queryParameters);
        GrossProductPerMemberStats statsMainPeriod = new GrossProductPerMemberStats(queryParameters, periodMain, this.getTransferDao());
        double[] periodMainSumOfTraders = statsMainPeriod.getGrossProductPerTradingMember();
        int periodMainNoOfTraders = periodMainSumOfTraders.length;
        double[] periodMainSumOfMembers = statsMainPeriod.getVolumePerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain));
        int periodMainNoOfMembers = periodMainSumOfMembers.length;
        GrossProductPerMemberStats statsCompared = new GrossProductPerMemberStats(queryParameters, periodComparedTo, this.getTransferDao());
        double[] periodComparedSumOfTraders = statsCompared.getGrossProductPerTradingMember();
        int periodComparedNofTraders = periodComparedSumOfTraders.length;
        double[] periodComparedSumOfMembers = statsCompared.getVolumePerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodComparedTo));
        int periodComparedNofMembers = periodComparedSumOfMembers.length;
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.comparePeriods.grossProduct";
        if (periodMainNoOfTraders >= 15 || periodComparedNofTraders >= 15 || periodMainNoOfMembers >= 15 || periodComparedNofMembers >= 15) {
            StatisticalNumber periodMainMedianGrossProductPerTrader = Median.getMedian(periodMainSumOfTraders, 0.05);
            StatisticalNumber periodComparedToMedianGrossProductPerTrader = Median.getMedian(periodComparedSumOfTraders, 0.05);
            StatisticalNumber periodMainMedianGrossProductPerMember = Median.getMedian(periodMainSumOfMembers, 0.05);
            StatisticalNumber periodComparedToMedianGrossProductPerMember = Median.getMedian(periodComparedSumOfMembers, 0.05);
            StatisticalNumber pTraders = StatisticalServiceImpl.calculatePvalue(periodMainSumOfTraders, periodComparedSumOfTraders);
            StatisticalNumber pAllMembers = StatisticalServiceImpl.calculatePvalue(periodMainSumOfMembers, periodComparedSumOfMembers);
            Number[][] tableCells = new Number[2][6];
            tableCells[0][0] = periodComparedToMedianGrossProductPerTrader;
            tableCells[0][1] = periodMainMedianGrossProductPerTrader;
            tableCells[0][2] = new StatisticalNumber((double)periodComparedNofTraders);
            tableCells[0][3] = new StatisticalNumber((double)periodMainNoOfTraders);
            tableCells[0][4] = StatisticalNumber.createPercentage(periodMainMedianGrossProductPerTrader, periodComparedToMedianGrossProductPerTrader);
            tableCells[0][5] = pTraders;
            tableCells[1][0] = periodComparedToMedianGrossProductPerMember;
            tableCells[1][1] = periodMainMedianGrossProductPerMember;
            tableCells[1][2] = new StatisticalNumber((double)periodComparedNofMembers);
            tableCells[1][3] = new StatisticalNumber((double)periodMainNoOfMembers);
            tableCells[1][4] = StatisticalNumber.createPercentage(periodMainMedianGrossProductPerMember, periodComparedToMedianGrossProductPerMember);
            tableCells[1][5] = pAllMembers;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.comparePeriods.grossProduct");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForCompare2Periods(result, queryParameters, 2);
            Currency currency = this.getCurrency(queryParameters);
            String[] subHeaders = new String[]{this.parenthesizeString(currency.getSymbol()), this.parenthesizeString(currency.getSymbol()), queryParameters.getPeriodComparedTo().getName(), queryParameters.getPeriodMain().getName(), "", ""};
            result.setColumnSubHeaders(subHeaders);
            result.setYAxisUnits(currency.getSymbol());
            if (queryParameters.isGrossProductGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.comparePeriods.grossProduct");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsLoginTimes(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        LoginTimesPerMemberStats statsMainPeriod = new LoginTimesPerMemberStats(queryParameters, periodMain, this.loginHistoryDao);
        List<Number> periodMainLoginTimes = statsMainPeriod.getListLoginTimes();
        int periodMainNoOfMembers = periodMainLoginTimes.size();
        LoginTimesPerMemberStats statsComparedPeriod = new LoginTimesPerMemberStats(queryParameters, periodComparedTo, this.loginHistoryDao);
        List<Number> periodComparedLoginTimes = statsComparedPeriod.getListLoginTimes();
        int periodComparedNoOfMembers = periodComparedLoginTimes.size();
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.comparePeriods.loginTimes";
        if (periodMainNoOfMembers >= 15 || periodComparedNoOfMembers >= 15) {
            StatisticalNumber periodMainMedianLoginTimesPerMember = Median.getMedian(periodMainLoginTimes, 0.05);
            StatisticalNumber periodComparedToMedianLoginTimesPerMember = Median.getMedian(periodComparedLoginTimes, 0.05);
            StatisticalNumber pValue = StatisticalServiceImpl.calculatePvalue(periodMainLoginTimes, periodComparedLoginTimes);
            Number[][] tableCells = new Number[1][4];
            tableCells[0][1] = periodMainMedianLoginTimesPerMember;
            tableCells[0][0] = periodComparedToMedianLoginTimesPerMember;
            tableCells[0][2] = StatisticalNumber.createPercentage(periodMainMedianLoginTimesPerMember, periodComparedToMedianLoginTimesPerMember);
            tableCells[0][3] = pValue;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.comparePeriods.loginTimes");
            this.passGroupFilter(result, queryParameters);
            this.setGeneralsForCompare2Periods(result, queryParameters, 1);
            String[] columnSubHeaders = new String[]{"(n=" + periodComparedNoOfMembers + ")", "(n=" + periodMainNoOfMembers + ")", "", ""};
            result.setColumnSubHeaders(columnSubHeaders);
            if (queryParameters.isLoginTimesGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.comparePeriods.loginTimes");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsNumberTransactions(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        this.getInitializedPaymentFilter(queryParameters);
        TransactionCountPerMemberStats statsMainPeriod = new TransactionCountPerMemberStats(queryParameters, periodMain, this.getTransferDao(), this.getElementDao());
        List<Number> periodMainTransactionCountTraders = statsMainPeriod.getTransactionCountPerTradingMember();
        int periodMainNofTraders = periodMainTransactionCountTraders.size();
        List<Number> periodMainTransactionCountMembers = statsMainPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain));
        int periodMainNofMembers = periodMainTransactionCountMembers.size();
        TransactionCountPerMemberStats statsCompared = new TransactionCountPerMemberStats(queryParameters, periodComparedTo, this.getTransferDao(), this.getElementDao());
        List<Number> periodComparedTransactionCountTraders = statsCompared.getTransactionCountPerTradingMember();
        int periodComparedNofTraders = periodComparedTransactionCountTraders.size();
        List<Number> periodComparedTransactionCountMembers = statsCompared.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodComparedTo));
        int periodComparedNofMembers = periodComparedTransactionCountMembers.size();
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.comparePeriods.numberTransactions";
        if (periodMainNofTraders >= 15 || periodComparedNofTraders >= 15 || periodMainNofMembers >= 15 || periodComparedNofMembers >= 15) {
            StatisticalNumber periodMainMedianTransactionCountPerTrader = Median.getMedian(periodMainTransactionCountTraders, 0.05);
            StatisticalNumber periodComparedMedianTransactionCountPerTrader = Median.getMedian(periodComparedTransactionCountTraders, 0.05);
            StatisticalNumber periodMainMedianTransactionCountPerMember = Median.getMedian(periodMainTransactionCountMembers, 0.05);
            StatisticalNumber periodComparedMedianTransactionCountPerMember = Median.getMedian(periodComparedTransactionCountMembers, 0.05);
            StatisticalNumber pTraders = StatisticalServiceImpl.calculatePvalue(ListOperations.listToArray(periodMainTransactionCountTraders), ListOperations.listToArray(periodComparedTransactionCountTraders));
            StatisticalNumber pMembers = StatisticalServiceImpl.calculatePvalue(ListOperations.listToArray(periodMainTransactionCountMembers), ListOperations.listToArray(periodComparedTransactionCountMembers));
            Number[][] tableCells = new Number[2][6];
            tableCells[0][0] = periodComparedMedianTransactionCountPerTrader;
            tableCells[0][1] = periodMainMedianTransactionCountPerTrader;
            tableCells[0][2] = periodComparedNofTraders;
            tableCells[0][3] = periodMainNofTraders;
            tableCells[0][4] = StatisticalNumber.createPercentage(periodMainMedianTransactionCountPerTrader, periodComparedMedianTransactionCountPerTrader);
            tableCells[0][5] = pTraders;
            tableCells[1][0] = periodComparedMedianTransactionCountPerMember;
            tableCells[1][1] = periodMainMedianTransactionCountPerMember;
            tableCells[1][2] = periodComparedNofMembers;
            tableCells[1][3] = periodMainNofMembers;
            tableCells[1][4] = StatisticalNumber.createPercentage(periodMainMedianTransactionCountPerMember, periodComparedMedianTransactionCountPerMember);
            tableCells[1][5] = pMembers;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.comparePeriods.numberTransactions");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForCompare2Periods(result, queryParameters, 2);
            if (queryParameters.isNumberTransactionsGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.comparePeriods.numberTransactions");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsPercentageNoTrade(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        this.getInitializedPaymentFilter(queryParameters);
        TransactionCountPerMemberStats statsMainPeriod = new TransactionCountPerMemberStats(queryParameters, periodMain, this.getTransferDao(), this.getElementDao());
        int periodMainNoOfTraders = statsMainPeriod.getTransactionCountPerTradingMember().size();
        int periodMainNoOfMembers = statsMainPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain)).size();
        TransactionCountPerMemberStats statsCompared = new TransactionCountPerMemberStats(queryParameters, periodComparedTo, this.getTransferDao(), this.getElementDao());
        int periodComparedNoOfTraders = statsCompared.getTransactionCountPerTradingMember().size();
        int periodComparedNoOfMembers = statsCompared.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodComparedTo)).size();
        Number[][] tableCells = new Number[1][4];
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.comparePeriods.percentageNoTrade";
        if (periodMainNoOfMembers >= 15 || periodComparedNoOfMembers >= 15) {
            StatisticalNumber percentageNoTradersMain = TransactionCountPerMemberStats.getPercentageNoTraders(periodMainNoOfTraders, periodMainNoOfMembers);
            StatisticalNumber percentageNoTradersCompared = TransactionCountPerMemberStats.getPercentageNoTraders(periodComparedNoOfTraders, periodComparedNoOfMembers);
            StatisticalNumber pValue = StatisticalServiceImpl.calculatePvalue(periodMainNoOfTraders, periodMainNoOfMembers, periodComparedNoOfTraders, periodComparedNoOfMembers);
            tableCells[0][0] = percentageNoTradersCompared;
            tableCells[0][1] = percentageNoTradersMain;
            tableCells[0][2] = StatisticalNumber.createPercentage(percentageNoTradersMain, percentageNoTradersCompared);
            tableCells[0][3] = pValue;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.comparePeriods.percentageNoTrade");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForCompare2Periods(result, queryParameters, 1);
            String[] columnSubHeaders = new String[]{"(n=" + periodComparedNoOfMembers + ")", "(n=" + periodMainNoOfMembers + ")", "", ""};
            result.setColumnSubHeaders(columnSubHeaders);
            if (queryParameters.isPercentageNoTradeGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.comparePeriods.percentageNoTrade");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getHistogramGrossProduct(StatisticalActivityQuery queryParameters) {
        NamedPeriod period = queryParameters.getPeriodMain();
        GrossProductPerMemberStats statsPeriod = new GrossProductPerMemberStats(queryParameters, period, this.getTransferDao());
        List<Number> listGrossProductPerAllMembers = statsPeriod.getListVolumePerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, period));
        HistogramDTOFactory histoFactory = new HistogramDTOFactory(listGrossProductPerAllMembers, this.getLocalSettings());
        String baseKey = "reports.stats.activity.histogram.grossProduct";
        StatisticalResultDTO result = histoFactory.getResultObject("reports.stats.activity.histogram.grossProduct");
        result.setColumnKeys(new String[]{"reports.stats.activity.histogram.grossProduct.xAxis"});
        Currency currency = this.getCurrency(queryParameters);
        result.setXAxisUnits(currency.getSymbol());
        this.passGroupFilter(result, queryParameters);
        this.passPaymentFilter(result, queryParameters);
        return result;
    }

    @Override
    public StatisticalResultDTO getHistogramLoginTimes(StatisticalActivityQuery queryParameters) {
        LoginTimesPerMemberStats statsPeriod = new LoginTimesPerMemberStats(queryParameters, queryParameters.getPeriodMain(), this.loginHistoryDao);
        List<Number> listLoginTimes = statsPeriod.getListLoginTimes();
        HistogramDTOFactory histoFactory = new HistogramDTOFactory(listLoginTimes, this.getLocalSettings());
        String baseKey = "reports.stats.activity.histogram.logins";
        StatisticalResultDTO result = histoFactory.getResultObject("reports.stats.activity.histogram.logins");
        result.setColumnKeys(new String[]{"reports.stats.activity.histogram.logins.xAxis"});
        this.passGroupFilter(result, queryParameters);
        return result;
    }

    @Override
    public StatisticalResultDTO getHistogramNumberTransactions(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        TransactionCountPerMemberStats statsPeriod = new TransactionCountPerMemberStats(queryParameters, periodMain, this.getTransferDao(), this.getElementDao());
        List<Number> transactionCountPerAllMembers = statsPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain));
        HistogramDTOFactory histoFactory = new HistogramDTOFactory(transactionCountPerAllMembers, this.getLocalSettings());
        String baseKey = "reports.stats.activity.histogram.numberTransactions";
        StatisticalResultDTO result = histoFactory.getResultObject("reports.stats.activity.histogram.numberTransactions");
        result.setColumnKeys(new String[]{"reports.stats.activity.histogram.numberTransactions.xAxis"});
        this.passGroupFilter(result, queryParameters);
        this.passPaymentFilter(result, queryParameters);
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodGrossProduct(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        GrossProductPerMemberStats statsMainPeriod = new GrossProductPerMemberStats(queryParameters, periodMain, this.getTransferDao());
        double[] periodMainSumOfTraders = statsMainPeriod.getGrossProductPerTradingMember();
        int periodMainNofTraders = periodMainSumOfTraders.length;
        double[] periodMainSumOfMembers = statsMainPeriod.getVolumePerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain));
        int periodMainNofMembers = periodMainSumOfMembers.length;
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.singlePeriod.grossProduct";
        if (periodMainNofTraders >= 15 || periodMainNofMembers >= 15) {
            StatisticalNumber periodMainMedianGrossProductPerTrader = Median.getMedian(periodMainSumOfTraders, 0.05);
            StatisticalNumber periodMainMedianGrossProductPerMember = Median.getMedian(periodMainSumOfMembers, 0.05);
            Number[][] tableCells = new Number[2][2];
            tableCells[0][0] = periodMainMedianGrossProductPerTrader;
            tableCells[0][1] = new StatisticalNumber((double)periodMainNofTraders);
            tableCells[1][0] = periodMainMedianGrossProductPerMember;
            tableCells[1][1] = new StatisticalNumber((double)periodMainNofMembers);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.singlePeriod.grossProduct");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForSinglePeriod(result, queryParameters, 2, true);
            Currency currency = this.getCurrency(queryParameters);
            String[] subHeaders = new String[]{this.parenthesizeString(currency.getSymbol()), queryParameters.getPeriodMain().getName()};
            result.setColumnSubHeaders(subHeaders);
            result.setYAxisUnits(currency.getSymbol());
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.singlePeriod.grossProduct");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodLoginTimes(StatisticalActivityQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        LoginTimesPerMemberStats statsMainPeriod = new LoginTimesPerMemberStats(queryParameters, periodMain, this.loginHistoryDao);
        List<Number> periodMainLoginTimes = statsMainPeriod.getListLoginTimes();
        int periodMainNoOfMembers = periodMainLoginTimes.size();
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.singlePeriod.loginTimes";
        if (periodMainNoOfMembers >= 15) {
            StatisticalNumber periodMainMedianLoginTimesPerMember = Median.getMedian(periodMainLoginTimes, 0.05);
            Number[][] tableCells = new Number[1][1];
            tableCells[0][0] = periodMainMedianLoginTimesPerMember;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.singlePeriod.loginTimes");
            this.passGroupFilter(result, queryParameters);
            this.setGeneralsForSinglePeriod(result, queryParameters, 1, false);
            String[] columnSubHeaders = new String[]{"(n=" + periodMainNoOfMembers + ")"};
            result.setColumnSubHeaders(columnSubHeaders);
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.singlePeriod.loginTimes");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodNumberTransactions(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        TransactionCountPerMemberStats statsMainPeriod = new TransactionCountPerMemberStats(queryParameters, periodMain, this.getTransferDao(), this.getElementDao());
        List<Number> periodMainTransactionCountTraders = statsMainPeriod.getTransactionCountPerTradingMember();
        int periodMainNofTraders = periodMainTransactionCountTraders.size();
        List<Number> periodMainTransactionCountMembers = statsMainPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain));
        int periodMainNofMembers = periodMainTransactionCountMembers.size();
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.singlePeriod.numberTransactions";
        if (periodMainNofTraders >= 15 || periodMainNofMembers >= 15) {
            StatisticalNumber periodMainMedianTransactionCountPerTrader = Median.getMedian(periodMainTransactionCountTraders, 0.05);
            StatisticalNumber periodMainMedianTransactionCountPerMember = Median.getMedian(periodMainTransactionCountMembers, 0.05);
            Number[][] tableCells = new Number[2][2];
            tableCells[0][0] = periodMainMedianTransactionCountPerTrader;
            tableCells[0][1] = periodMainNofTraders;
            tableCells[1][0] = periodMainMedianTransactionCountPerMember;
            tableCells[1][1] = periodMainNofMembers;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.singlePeriod.numberTransactions");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForSinglePeriod(result, queryParameters, 2, true);
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.singlePeriod.numberTransactions");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodPercentageNoTrade(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        TransactionCountPerMemberStats statsMainPeriod = new TransactionCountPerMemberStats(queryParameters, periodMain, this.getTransferDao(), this.getElementDao());
        int periodMainNoOfTraders = statsMainPeriod.getTransactionCountPerTradingMember().size();
        int periodMainNoOfMembers = statsMainPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, periodMain)).size();
        Number[][] tableCells = new Number[1][1];
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.activity.singlePeriod.percentageNoTrade";
        if (periodMainNoOfMembers >= 15) {
            StatisticalNumber percentageNoTradersMain = TransactionCountPerMemberStats.getPercentageNoTraders(periodMainNoOfTraders, periodMainNoOfMembers);
            tableCells[0][0] = percentageNoTradersMain;
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.activity.singlePeriod.percentageNoTrade");
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            this.setGeneralsForSinglePeriod(result, queryParameters, 1, false);
            String[] columnSubHeaders = new String[]{"(n=" + periodMainNoOfMembers + ")"};
            result.setColumnSubHeaders(columnSubHeaders);
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.singlePeriod.percentageNoTrade");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTheTimeGrossProduct(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        Period[] periods = queryParameters.getPeriods();
        String[] rowHeaders = new String[periods.length];
        Number[][] tableData = new Number[periods.length][4];
        int countEnoughData = 0;
        int index = 0;
        for (Period period : periods) {
            GrossProductPerMemberStats statsPeriod = new GrossProductPerMemberStats(queryParameters, period, this.getTransferDao());
            double[] periodSumOfTraders = statsPeriod.getGrossProductPerTradingMember();
            StatisticalNumber periodMedianGrossProductPerTrader = Median.getMedian(periodSumOfTraders, 0.05);
            double[] periodSumOfMembers = statsPeriod.getVolumePerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, period));
            StatisticalNumber periodMedianGrossProductPerMember = Median.getMedian(periodSumOfMembers, 0.05);
            rowHeaders[index] = this.getRowHeaders(queryParameters.getThroughTimeRange(), period);
            tableData[index][0] = periodMedianGrossProductPerTrader;
            tableData[index][1] = periodMedianGrossProductPerMember;
            tableData[index][2] = new StatisticalNumber(periodSumOfTraders.length, 0);
            tableData[index][3] = new StatisticalNumber(periodSumOfMembers.length, 0);
            if (periodMedianGrossProductPerTrader.hasEnoughData()) {
                ++countEnoughData;
            }
            ++index;
        }
        String baseKey = "reports.stats.activity.throughTime.grossProduct";
        StatisticalResultDTO result = null;
        if (countEnoughData > 1) {
            String[] columnKeys = new String[]{"reports.stats.activity.throughTime.grossProduct.col1", "reports.stats.activity.throughTime.grossProduct.col2", "reports.stats.activity.throughTime.grossProduct.col3", "reports.stats.activity.throughTime.grossProduct.col4"};
            result = new StatisticalResultDTO(tableData);
            result.setRowHeaders(rowHeaders);
            result.setBaseKey("reports.stats.activity.throughTime.grossProduct");
            result.setColumnKeys(columnKeys);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            Currency currency = this.getCurrency(queryParameters);
            result.setColumnSubHeaders(new String[]{this.parenthesizeString(currency.getSymbol()), this.parenthesizeString(currency.getSymbol()), "", ""});
            result.setYAxisUnits(currency.getSymbol());
            if (queryParameters.isGrossProductGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.throughTime.grossProduct");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTheTimeLoginTimes(StatisticalActivityQuery queryParameters) {
        Period[] periods = queryParameters.getPeriods();
        String[] rowHeaders = new String[periods.length];
        Number[][] tableData = new Number[periods.length][2];
        int countEnoughData = 0;
        int index = 0;
        for (Period period : periods) {
            LoginTimesPerMemberStats statsPeriod = new LoginTimesPerMemberStats(queryParameters, period, this.loginHistoryDao);
            List<Number> periodLoginTimesPerMember = statsPeriod.getListLoginTimes();
            StatisticalNumber periodMedianLoginTimesPerMember = Median.getMedian(periodLoginTimesPerMember, 0.05);
            rowHeaders[index] = this.getRowHeaders(queryParameters.getThroughTimeRange(), period);
            tableData[index][0] = periodMedianLoginTimesPerMember;
            tableData[index][1] = new StatisticalNumber(periodLoginTimesPerMember.size(), 0);
            if (periodMedianLoginTimesPerMember.hasEnoughData()) {
                ++countEnoughData;
            }
            ++index;
        }
        String baseKey = "reports.stats.activity.throughTime.loginTimes";
        StatisticalResultDTO result = null;
        if (countEnoughData > 1) {
            String[] columnKeys = new String[]{"reports.stats.activity.throughTime.loginTimes.col1", ""};
            result = new StatisticalResultDTO(tableData);
            result.setBaseKey("reports.stats.activity.throughTime.loginTimes");
            result.setRowHeaders(rowHeaders);
            result.setColumnKeys(columnKeys);
            result.setColumnHeader("n", 1);
            this.passGroupFilter(result, queryParameters);
            if (queryParameters.isLoginTimesGraph()) {
                result.setGraphDimensions(null, 1, null);
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.throughTime.loginTimes");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTheTimeNumberTransactions(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        Period[] periods = queryParameters.getPeriods();
        String[] rowHeaders = new String[periods.length];
        Number[][] tableData = new Number[periods.length][4];
        int countEnoughData = 0;
        int index = 0;
        for (Period period : periods) {
            TransactionCountPerMemberStats statsPeriod = new TransactionCountPerMemberStats(queryParameters, period, this.getTransferDao(), this.getElementDao());
            List<Number> periodTransactionsCountTraders = statsPeriod.getTransactionCountPerTradingMember();
            StatisticalNumber periodMedianTransactionsCountPerTrader = Median.getMedian(periodTransactionsCountTraders, 0.05);
            List<Number> periodTransactionsCountMembers = statsPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, period));
            StatisticalNumber periodMedianTransactionsCountPerMember = Median.getMedian(periodTransactionsCountMembers, 0.05);
            rowHeaders[index] = this.getRowHeaders(queryParameters.getThroughTimeRange(), period);
            tableData[index][0] = periodMedianTransactionsCountPerTrader;
            tableData[index][1] = periodMedianTransactionsCountPerMember;
            tableData[index][2] = new StatisticalNumber(periodTransactionsCountTraders.size(), 0);
            tableData[index][3] = new StatisticalNumber(periodTransactionsCountMembers.size(), 0);
            if (periodMedianTransactionsCountPerTrader.hasEnoughData()) {
                ++countEnoughData;
            }
            ++index;
        }
        String[] columnKeys = new String[]{"reports.stats.activity.throughTime.numberTransactions.col1", "reports.stats.activity.throughTime.numberTransactions.col2", "reports.stats.activity.throughTime.numberTransactions.col3", "reports.stats.activity.throughTime.numberTransactions.col4"};
        String baseKey = "reports.stats.activity.throughTime.numberTransactions";
        StatisticalResultDTO result = null;
        if (countEnoughData > 1) {
            result = new StatisticalResultDTO(tableData);
            result.setBaseKey("reports.stats.activity.throughTime.numberTransactions");
            result.setRowHeaders(rowHeaders);
            result.setColumnKeys(columnKeys);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            if (queryParameters.isNumberTransactionsGraph()) {
                result.setGraphDimensions(null, 2, null);
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.throughTime.numberTransactions");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTheTimePercentageNoTrade(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        Period[] periods = queryParameters.getPeriods();
        String[] rowHeaders = new String[periods.length];
        Number[][] tableData = new Number[periods.length][2];
        int countEnoughData = 0;
        int index = 0;
        for (Period period : periods) {
            TransactionCountPerMemberStats statsPeriod = new TransactionCountPerMemberStats(queryParameters, period, this.getTransferDao(), this.getElementDao());
            int periodNoOfTraders = statsPeriod.getTransactionCountPerTradingMember().size();
            int periodNoOfMembers = statsPeriod.getTransactionCountPerAllMembers(this.getNumberOfMembersForPeriod(queryParameters, period)).size();
            StatisticalNumber percentageOfNoTraders = TransactionCountPerMemberStats.getPercentageNoTraders(periodNoOfTraders, periodNoOfMembers);
            StatisticalNumber n = new StatisticalNumber(periodNoOfMembers, 0);
            rowHeaders[index] = this.getRowHeaders(queryParameters.getThroughTimeRange(), period);
            tableData[index][0] = percentageOfNoTraders;
            tableData[index][1] = n;
            ++index;
            if (periodNoOfMembers < 15) continue;
            ++countEnoughData;
        }
        String[] columnKeys = new String[]{"reports.stats.activity.throughTime.percentageNoTrade.col1", ""};
        String baseKey = "reports.stats.activity.throughTime.percentageNoTrade";
        StatisticalResultDTO result = null;
        if (countEnoughData > 1) {
            result = new StatisticalResultDTO(tableData);
            result.setBaseKey("reports.stats.activity.throughTime.percentageNoTrade");
            result.setRowHeaders(rowHeaders);
            result.setColumnKeys(columnKeys);
            result.setColumnHeader("n", 1);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            if (queryParameters.isPercentageNoTradeGraph()) {
                result.setGraphDimensions(null, 1, null);
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.activity.throughTime.percentageNoTrade");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getToptenPersonalGrossProduct(StatisticalActivityQuery queryParameters) {
        this.getInitializedPaymentFilter(queryParameters);
        GrossProductPerMemberStats statsPeriod = new GrossProductPerMemberStats(queryParameters, queryParameters.getPeriodMain(), this.getTransferDao());
        List rawDataListFromQueryPair = statsPeriod.getSumOfTransfersPerTrader();
        StatisticalResultDTO result = this.getTopTenFromPairList(rawDataListFromQueryPair, "reports.stats.activity.topten.grossProduct", queryParameters);
        Currency currency = this.getCurrency(queryParameters);
        result.setColumnSubHeaders(new String[]{this.parenthesizeString(currency.getSymbol())});
        return result;
    }

    @Override
    public StatisticalResultDTO getToptenPersonalLoginTimes(StatisticalActivityQuery queryParameters) {
        LoginTimesPerMemberStats statsPeriod = new LoginTimesPerMemberStats(queryParameters, queryParameters.getPeriodMain(), this.loginHistoryDao);
        List rawDataListFromQueryPair = statsPeriod.getLoginTimesPerMemberWithoutZeros();
        return this.getTopTenFromPairList(rawDataListFromQueryPair, "reports.stats.activity.topten.login", queryParameters);
    }

    @Override
    public StatisticalResultDTO getToptenPersonalNumberTransactions(StatisticalActivityQuery queryParameters) {
        TransactionCountPerMemberStats statsPeriod = new TransactionCountPerMemberStats(queryParameters, queryParameters.getPeriodMain(), this.getTransferDao(), this.getElementDao());
        List rawDataListFromQueryPair = statsPeriod.getTransfersPerTrader();
        return this.getTopTenFromPairList(rawDataListFromQueryPair, "reports.stats.activity.topten.numberTransactions", queryParameters);
    }

    public void setLoginHistoryDao(LoginHistoryDAO loginHistoryDao) {
        this.loginHistoryDao = loginHistoryDao;
    }

    private void applyColumnHeadersAndKeys(StatisticalResultDTO result, StatisticalActivityQuery queryParameters, boolean sixColumns) {
        if (sixColumns) {
            String[] columnKeys = new String[]{"", "", "", "", "reports.stats.general.growth", "reports.stats.general.p"};
            result.setColumnKeys(columnKeys);
            result.setColumnHeader("N", 3);
            result.setColumnHeader("N", 2);
            String[] columnSubHeaders = new String[]{"", "", queryParameters.getPeriodComparedTo().getName(), queryParameters.getPeriodMain().getName(), "", ""};
            result.setColumnSubHeaders(columnSubHeaders);
        } else {
            String[] columnKeys = new String[]{"", "", "reports.stats.general.growth", "reports.stats.general.p"};
            result.setColumnKeys(columnKeys);
        }
        result.setColumnHeader(queryParameters.getPeriodMain().getName(), 1);
        result.setColumnHeader(queryParameters.getPeriodComparedTo().getName(), 0);
    }

    private void applyRowKeys(StatisticalResultDTO result, int numberOfRows) {
        ArrayList<String> rowKeyList = new ArrayList<String>(numberOfRows);
        for (int i = 1; i <= numberOfRows; ++i) {
            rowKeyList.add(result.getBaseKey() + ".row" + i);
        }
        String[] rowKeys = new String[numberOfRows];
        rowKeys = rowKeyList.toArray(rowKeys);
        result.setRowKeys(rowKeys);
    }

    private void applySinglePeriodColumnHeadersAndKeys(StatisticalResultDTO result, StatisticalActivityQuery queryParameters, boolean twoColumns) {
        if (twoColumns) {
            String[] columnKeys = new String[]{"", ""};
            result.setColumnKeys(columnKeys);
            result.setColumnHeader("N", 1);
            String[] columnSubHeaders = new String[]{"", queryParameters.getPeriodMain().getName()};
            result.setColumnSubHeaders(columnSubHeaders);
        } else {
            String[] columnKeys = new String[]{""};
            result.setColumnKeys(columnKeys);
        }
        result.setColumnHeader(queryParameters.getPeriodMain().getName(), 0);
    }

    private Integer getNumberOfMembersForPeriod(StatisticalActivityQuery queryParameters, Period requestedPeriod) {
        if (this.numberOfMembersPerGroupPerPeriod == null || !this.cachedQueryParameters.equals(queryParameters)) {
            NamedPeriod periodMain;
            ArrayList<Period> periods = new ArrayList<Period>();
            if (queryParameters.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
                periods.addAll(Arrays.asList(queryParameters.getPeriods()));
            }
            if (queryParameters.getWhatToShow() == StatisticsWhatToShow.COMPARE_PERIODS) {
                periodMain = queryParameters.getPeriodMain();
                NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
                periods.add(periodMain);
                periods.add(periodComparedTo);
            }
            if (queryParameters.getWhatToShow() == StatisticsWhatToShow.SINGLE_PERIOD || queryParameters.getWhatToShow() == StatisticsWhatToShow.DISTRIBUTION) {
                periodMain = queryParameters.getPeriodMain();
                periods.add(periodMain);
            }
            Collection<Group> groups = queryParameters.getGroups();
            this.numberOfMembersPerGroupPerPeriod = new HashMap<String, Integer>();
            for (Period period : periods) {
                Integer numberOfMembers = this.getElementDao().getNumberOfMembersInGroupsInPeriod(groups, period);
                this.numberOfMembersPerGroupPerPeriod.put(period.toString(), numberOfMembers);
            }
            this.cachedQueryParameters = queryParameters;
        }
        return this.numberOfMembersPerGroupPerPeriod.get(requestedPeriod.toString());
    }

    private <S extends Entity, T extends Number> StatisticalResultDTO getTopTenFromPairList(List<Pair<S, T>> rawDataPairList, String baseKey, StatisticalActivityQuery queryParameters) {
        List<T> loginTimes;
        int lastIndex;
        int last = 10;
        if (rawDataPairList.size() < last) {
            last = rawDataPairList.size();
        }
        int extraItems = 0;
        if (last == 10 && (lastIndex = (loginTimes = ListOperations.getSecondFromPairCollection(rawDataPairList)).lastIndexOf(loginTimes.get(9))) > 9) {
            extraItems = lastIndex - 9;
        }
        String[] rowHeaders = new String[last + (extraItems > 0 ? 1 : 0)];
        StatisticalResultDTO.ResourceKey[] rowKeys = new StatisticalResultDTO.ResourceKey[last + (extraItems > 0 ? 1 : 0)];
        Number[][] tableData = new Number[last + (extraItems > 0 ? 1 : 0)][1];
        for (int i = 0; i < last; ++i) {
            Pair<S, T> pair = rawDataPairList.get(i);
            tableData[i][0] = (Number)pair.getSecond();
            rowKeys[i] = new StatisticalResultDTO.ResourceKey("", new Object[0]);
            Entity entity = (Entity)pair.getFirst();
            rowHeaders[i] = entity instanceof Member ? "" + (i + 1) + " - " + ((Member)entity).getName() : "" + (i + 1) + " - " + ((User)entity).getUsername();
            if (i != 9 || extraItems <= 0) continue;
            tableData[10][0] = (Number)pair.getSecond();
            rowKeys[10] = new StatisticalResultDTO.ResourceKey("reports.stats.activity.topten.andMore", extraItems);
        }
        StatisticalResultDTO result = null;
        if (last > 0) {
            result = new StatisticalResultDTO(tableData);
            result.setBaseKey(baseKey);
            result.setRowKeys(rowKeys);
            for (int i = 0; i < rowHeaders.length - (extraItems > 0 ? 1 : 0); ++i) {
                result.setRowHeader(rowHeaders[i], i);
            }
            result.setColumnKeys(new String[]{baseKey + ".col1"});
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        } else {
            result = StatisticalResultDTO.noDataAvailable(baseKey);
        }
        return result;
    }

    private void setGeneralsForCompare2Periods(StatisticalResultDTO result, StatisticalActivityQuery queryParameters, int numberOfRows) {
        this.applyRowKeys(result, numberOfRows);
        boolean sixColumns = numberOfRows == 2;
        this.applyColumnHeadersAndKeys(result, queryParameters, sixColumns);
    }

    private void setGeneralsForSinglePeriod(StatisticalResultDTO result, StatisticalActivityQuery queryParameters, int numberOfRows, boolean twoColumns) {
        this.applyRowKeys(result, numberOfRows);
        this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters, twoColumns);
    }
}

