/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.util.Collection;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.reports.StatisticalFinancesQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalQuery;
import nl.strohalm.cyclos.services.stats.StatisticalFinancesServiceLocal;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalServiceImpl;
import nl.strohalm.cyclos.services.stats.finances.FinanceStatsComparePeriods;
import nl.strohalm.cyclos.services.stats.finances.FinanceStatsSinglePeriod;
import nl.strohalm.cyclos.services.stats.finances.FinanceStatsThroughTime;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;

public class StatisticalFinancesServiceImpl
extends StatisticalServiceImpl
implements StatisticalFinancesServiceLocal {
    @Override
    public StatisticalResultDTO getComparePeriodsExpenditure(StatisticalFinancesQuery queryParameters) {
        FinanceStatsComparePeriods compareStats = this.getCompareStats();
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodAlt = queryParameters.getPeriodComparedTo();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.ComparePeriods.expenditure";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = compareStats.getTableCellsExpenditureComparePeriods(periodMain, periodAlt, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.ComparePeriods.expenditure");
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.assignRowKeysCompare(result, paymentFilters);
            this.passSystemAccountFilter(result, queryParameters);
            this.applyCurrency(result, queryParameters, 3, 2);
            if (queryParameters.isExpenditureGraph()) {
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 2);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.ComparePeriods.expenditure");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsIncome(StatisticalFinancesQuery queryParameters) {
        FinanceStatsComparePeriods compareStats = this.getCompareStats();
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodAlt = queryParameters.getPeriodComparedTo();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.ComparePeriods.income";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = compareStats.getTableCellsIncomeComparePeriods(periodMain, periodAlt, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.ComparePeriods.income");
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.assignRowKeysCompare(result, paymentFilters);
            this.passSystemAccountFilter(result, queryParameters);
            this.applyCurrency(result, queryParameters, 3, 2);
            if (queryParameters.isIncomeGraph()) {
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 2);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.ComparePeriods.income");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodExpenditure(StatisticalFinancesQuery queryParameters) {
        FinanceStatsSinglePeriod singlePeriodStats = this.getFinanceStats();
        NamedPeriod period = queryParameters.getPeriodMain();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.singlePeriod.expenditure";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = singlePeriodStats.getTableCellsExpenditureSinglePeriod(period, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.singlePeriod.expenditure");
            String[] colKeys = new String[]{"reports.stats.finances.expenditure"};
            result.setColumnKeys(colKeys);
            this.assignRowKeysSingle(result, paymentFilters, tableCells.length);
            this.passSystemAccountFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            result.setFilter(period);
            this.applyCurrency(result, queryParameters, 1, 1);
            if (queryParameters.isOverview()) {
                result.setShowTable(false);
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 1);
                result.setGraphType(StatisticalResultDTO.GraphType.PIE);
            } else if (queryParameters.isIncomeGraph()) {
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 1);
                result.setGraphType(StatisticalResultDTO.GraphType.PIE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.singlePeriod.expenditure");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodIncome(StatisticalFinancesQuery queryParameters) {
        FinanceStatsSinglePeriod singlePeriodStats = this.getFinanceStats();
        NamedPeriod period = queryParameters.getPeriodMain();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.singlePeriod.income";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = singlePeriodStats.getTableCellsIncomeSinglePeriod(period, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.singlePeriod.income");
            String[] colKeys = new String[]{"reports.stats.finances.income"};
            result.setColumnKeys(colKeys);
            this.assignRowKeysSingle(result, paymentFilters, tableCells.length);
            this.passSystemAccountFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            result.setFilter(period);
            this.applyCurrency(result, queryParameters, 1, 1);
            if (queryParameters.isOverview()) {
                result.setShowTable(false);
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 1);
                result.setGraphType(StatisticalResultDTO.GraphType.PIE);
            } else if (queryParameters.isIncomeGraph()) {
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, null, 1);
                result.setGraphType(StatisticalResultDTO.GraphType.PIE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.singlePeriod.income");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodOverview(StatisticalFinancesQuery queryParameters) {
        FinanceStatsSinglePeriod singlePeriodStats = this.getFinanceStats();
        NamedPeriod period = queryParameters.getPeriodMain();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.singlePeriod.overview";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = singlePeriodStats.getTableCellsOverviewSinglePeriod(period, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.singlePeriod.overview");
            String[] colKeys = new String[]{"reports.stats.finances.income", "reports.stats.finances.expenditure", "reports.stats.finances.balance"};
            result.setColumnKeys(colKeys);
            this.assignRowKeysSingle(result, paymentFilters, tableCells.length);
            this.passSystemAccountFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
            result.setFilter(period);
            this.applyCurrency(result, queryParameters, 3, 3);
            if (queryParameters.isOverviewGraph()) {
                result.setGraphDimensions(StatisticalResultDTO.TableToGraph.COLUMN_IS_CATEGORY, tableCells.length - 2, 2);
                result.setGraphType(StatisticalResultDTO.GraphType.BAR);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.singlePeriod.overview");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTimeExpenditure(StatisticalFinancesQuery queryParameters) {
        FinanceStatsThroughTime thruStats = this.getThruStats();
        Period[] periods = queryParameters.getPeriods();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.ThroughTime.expenditure";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = thruStats.getTableCellsExpenditureThroughTime(periods, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.ThroughTime.expenditure");
            this.applyColumnHeadersAndKeys(result, paymentFilters);
            this.assignRowHeaders(result, queryParameters, periods);
            this.passSystemAccountFilter(result, queryParameters);
            this.applyCurrency(result, queryParameters, paymentFilters.size(), paymentFilters.size());
            if (queryParameters.isExpenditureGraph()) {
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.ThroughTime.expenditure");
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTimeIncome(StatisticalFinancesQuery queryParameters) {
        FinanceStatsThroughTime thruStats = this.getThruStats();
        Period[] periods = queryParameters.getPeriods();
        Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.finances.ThroughTime.income";
        if (paymentFilters.size() > 0) {
            Number[][] tableCells = thruStats.getTableCellsIncomeThroughTime(periods, paymentFilters, systemAccountFilter);
            result = new StatisticalResultDTO(tableCells);
            result.setBaseKey("reports.stats.finances.ThroughTime.income");
            this.applyColumnHeadersAndKeys(result, paymentFilters);
            this.assignRowHeaders(result, queryParameters, periods);
            this.passSystemAccountFilter(result, queryParameters);
            this.applyCurrency(result, queryParameters, paymentFilters.size(), paymentFilters.size());
            if (queryParameters.isIncomeGraph()) {
                result.setGraphType(StatisticalResultDTO.GraphType.LINE);
            }
        } else {
            result = StatisticalResultDTO.noDataAvailable("reports.stats.finances.ThroughTime.income");
        }
        return result;
    }

    private void applyColumnHeadersAndKeys(StatisticalResultDTO result, Collection<PaymentFilter> paymentFilters) {
        String[] columnKeys = new String[paymentFilters.size()];
        result.setColumnKeys(columnKeys);
        int i = 0;
        for (PaymentFilter paymentFilter : paymentFilters) {
            result.setColumnHeader(paymentFilter.getName(), i++);
        }
    }

    private void applyColumnHeadersAndKeys(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        String[] columnKeys = new String[]{"", "", "reports.stats.general.growth"};
        result.setColumnKeys(columnKeys);
        result.setColumnHeader(queryParameters.getPeriodMain().getName(), 1);
        result.setColumnHeader(queryParameters.getPeriodComparedTo().getName(), 0);
    }

    private void applyCurrency(StatisticalResultDTO result, StatisticalQuery queryParameters, int totalCols, int applyToCols) {
        if (applyToCols > totalCols) {
            throw new IllegalArgumentException("Too many column subHeaders specified");
        }
        Currency currency = this.getCurrency(queryParameters);
        String[] columnSubHeaders = new String[totalCols];
        for (int i = 0; i < totalCols; ++i) {
            columnSubHeaders[i] = i < applyToCols ? this.parenthesizeString(currency.getSymbol()) : "";
        }
        result.setColumnSubHeaders(columnSubHeaders);
        result.setYAxisUnits(currency.getSymbol());
    }

    private void assignRowHeaders(StatisticalResultDTO result, StatisticalQuery queryParameters, Period[] periods) {
        String[] rowHeaders = new String[periods.length];
        int i = 0;
        for (Period period : periods) {
            rowHeaders[i++] = this.getRowHeaders(queryParameters.getThroughTimeRange(), period);
        }
        result.setRowHeaders(rowHeaders);
    }

    private void assignRowKeysCompare(StatisticalResultDTO result, Collection<PaymentFilter> paymentFilters) {
        String[] rowHeaders = new String[paymentFilters.size()];
        int i = 0;
        for (PaymentFilter filter : paymentFilters) {
            rowHeaders[i++] = filter.getName();
        }
        result.setRowHeaders(rowHeaders);
    }

    private void assignRowKeysSingle(StatisticalResultDTO result, Collection<PaymentFilter> paymentFilters, int length) {
        String[] filterNames = this.getFinanceStats().getPaymentFilterNames(paymentFilters);
        String[] rowKeys = new String[length];
        int extraKeysCount = length - filterNames.length;
        if (extraKeysCount == 2) {
            rowKeys[length - 2] = "reports.stats.finances.other";
            rowKeys[length - 1] = "reports.stats.general.sum";
        }
        if (extraKeysCount == 1) {
            rowKeys[length - 1] = "reports.stats.finances.other";
        }
        result.setRowKeys(rowKeys);
        for (int i = 0; i < filterNames.length; ++i) {
            result.setRowHeader(filterNames[i], i);
        }
    }

    private FinanceStatsComparePeriods getCompareStats() {
        return new FinanceStatsComparePeriods(this.getTransferDao());
    }

    private FinanceStatsSinglePeriod getFinanceStats() {
        return new FinanceStatsSinglePeriod(this.getTransferDao());
    }

    private FinanceStatsThroughTime getThruStats() {
        return new FinanceStatsThroughTime(this.getTransferDao());
    }
}

