/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.ads.AdDAO;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.entities.reports.StatisticalKeyDevelopmentsQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.reports.StatisticalQuery;
import nl.strohalm.cyclos.entities.reports.ThroughTimeRange;
import nl.strohalm.cyclos.services.stats.StatisticalKeyDevelopmentsServiceLocal;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalServiceImpl;
import nl.strohalm.cyclos.services.stats.general.FilterUsed;
import nl.strohalm.cyclos.services.stats.general.KeyDevelopmentsStatsPerMonthVO;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.statistics.ListOperations;
import nl.strohalm.cyclos.utils.statistics.Median;

public class StatisticalKeyDevelopmentsServiceImpl
extends StatisticalServiceImpl
implements StatisticalKeyDevelopmentsServiceLocal {
    private AdDAO adDao;
    private StatisticalKeyDevelopmentsQuery savedParameters;
    private List<Number> transactionAmounts;
    private List<Number> transactionAmounts2;

    @Override
    public StatisticalResultDTO getComparePeriodsGrossProduct(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        byte precision = (byte)this.getLocalSettings().getPrecision().getValue();
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        Collection<Group> groups = queryParameters.getGroups();
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[1][3];
        BigDecimal periodMainSumFilter = this.getSumOfTransactions(periodMain, groups, paymentFilter);
        BigDecimal periodComparedToSumFilter = this.getSumOfTransactions(periodComparedTo, groups, paymentFilter);
        tableCells[0][1] = new StatisticalNumber(periodMainSumFilter.doubleValue(), precision);
        tableCells[0][0] = new StatisticalNumber(periodComparedToSumFilter.doubleValue(), precision);
        tableCells[0][2] = StatisticalNumber.createPercentage(periodMainSumFilter, periodComparedToSumFilter);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.grossProduct");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        this.passCurrencyCompared(result, queryParameters);
        try {
            result.setRowKeys(rowKeys);
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in Gross Product");
            e.printStackTrace();
        }
        if (queryParameters.isGrossProductGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsHighestTransactionAmount(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        byte precision = (byte)this.getLocalSettings().getPrecision().getValue();
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        String baseKey = "reports.stats.keydevelopments.highestAmountPerTransaction";
        Number[][] tableCells = new Number[1][3];
        List<Number> periodMainAmounts = this.getTransactionAmounts(queryParameters, paymentFilter);
        List<Number> periodComparedAmounts = this.getTransactionAmountsComparedTo(queryParameters, paymentFilter);
        if (periodMainAmounts.size() < 15 && periodComparedAmounts.size() < 15) {
            return StatisticalResultDTO.noDataAvailable("reports.stats.keydevelopments.highestAmountPerTransaction");
        }
        Number periodMainHighestAmount = ListOperations.getMax(periodMainAmounts);
        Number periodComparedToHighestAmount = ListOperations.getMax(periodComparedAmounts);
        tableCells[0][1] = periodMainHighestAmount == null ? new StatisticalNumber() : new StatisticalNumber(periodMainHighestAmount.doubleValue(), precision);
        tableCells[0][0] = periodComparedToHighestAmount == null ? new StatisticalNumber() : new StatisticalNumber(periodComparedToHighestAmount.doubleValue(), precision);
        tableCells[0][2] = StatisticalNumber.createPercentage(periodMainHighestAmount, periodComparedToHighestAmount);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.highestAmountPerTransaction");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        this.passCurrencyCompared(result, queryParameters);
        try {
            result.setRowKeys(rowKeys);
            if (paymentFilter != null) {
                result.setRowHeader(paymentFilter.getName(), 0);
            }
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in highest transaction amount per transaction");
            e.printStackTrace();
        }
        if (queryParameters.isTransactionAmountGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsMedianAmountPerTransaction(StatisticalKeyDevelopmentsQuery queryParameters) {
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[1][4];
        String baseKey = "reports.stats.keydevelopments.averageAmountPerTransaction";
        List<Number> periodMainAmounts = this.getTransactionAmounts(queryParameters, paymentFilter);
        List<Number> periodComparedAmounts = this.getTransactionAmountsComparedTo(queryParameters, paymentFilter);
        if (periodMainAmounts.size() < 15 && periodComparedAmounts.size() < 15) {
            return StatisticalResultDTO.noDataAvailable("reports.stats.keydevelopments.averageAmountPerTransaction");
        }
        tableCells[0][1] = Median.getMedian(periodMainAmounts, 0.05);
        tableCells[0][0] = Median.getMedian(periodComparedAmounts, 0.05);
        tableCells[0][2] = StatisticalNumber.createPercentage(tableCells[0][1], tableCells[0][0]);
        tableCells[0][3] = StatisticalServiceImpl.calculatePvalue(periodMainAmounts, periodComparedAmounts);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.averageAmountPerTransaction");
        String[] rowKeys = null;
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        Currency currency = this.getCurrency(queryParameters);
        result.setColumnSubHeaders(new String[]{this.parenthesizeString(currency.getSymbol()), this.parenthesizeString(currency.getSymbol()), "", ""});
        result.setYAxisUnits(currency.getSymbol());
        try {
            result.setRowKeys(rowKeys);
            String[] columnKeys = new String[]{"", "", "reports.stats.general.growth", "reports.stats.general.p"};
            result.setColumnKeys(columnKeys);
            result.setColumnHeader(queryParameters.getPeriodMain().getName(), 1);
            result.setColumnHeader(queryParameters.getPeriodComparedTo().getName(), 0);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in average amount per transaction");
            e.printStackTrace();
        }
        if (queryParameters.isTransactionAmountGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsNumberOfAds(StatisticalKeyDevelopmentsQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        Collection<Group> groups = queryParameters.getGroups();
        Integer activeAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.ACTIVE);
        Integer scheduledAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.SCHEDULED);
        Integer expiredAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.EXPIRED);
        Integer createdAdsPeriodMain = this.adDao.getNumberOfCreatedAds(periodMain, groups);
        Integer activeAdsPeriodComparedTo = this.adDao.getNumberOfAds(periodComparedTo.getEnd(), groups, Ad.Status.ACTIVE);
        Integer scheduledAdsPeriodComparedTo = this.adDao.getNumberOfAds(periodComparedTo.getEnd(), groups, Ad.Status.SCHEDULED);
        Integer expiredAdsPeriodComparedTo = this.adDao.getNumberOfAds(periodComparedTo.getEnd(), groups, Ad.Status.EXPIRED);
        Integer createdAdsPeriodComparedTo = this.adDao.getNumberOfCreatedAds(periodComparedTo, groups);
        Number[][] tableCells = new Number[4][3];
        tableCells[0][1] = new StatisticalNumber(activeAdsPeriodMain);
        tableCells[0][0] = new StatisticalNumber(activeAdsPeriodComparedTo);
        tableCells[0][2] = StatisticalNumber.createPercentage(activeAdsPeriodMain, activeAdsPeriodComparedTo);
        tableCells[1][1] = new StatisticalNumber(scheduledAdsPeriodMain);
        tableCells[1][0] = new StatisticalNumber(scheduledAdsPeriodComparedTo);
        tableCells[1][2] = StatisticalNumber.createPercentage(scheduledAdsPeriodMain, scheduledAdsPeriodComparedTo);
        tableCells[2][1] = new StatisticalNumber(expiredAdsPeriodMain);
        tableCells[2][0] = new StatisticalNumber(expiredAdsPeriodComparedTo);
        tableCells[2][2] = StatisticalNumber.createPercentage(expiredAdsPeriodMain, expiredAdsPeriodComparedTo);
        tableCells[3][1] = new StatisticalNumber(createdAdsPeriodMain);
        tableCells[3][0] = new StatisticalNumber(createdAdsPeriodComparedTo);
        tableCells[3][2] = StatisticalNumber.createPercentage(createdAdsPeriodMain, createdAdsPeriodComparedTo);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfAds");
        String[] rowKeys = new String[]{"reports.stats.keydevelopments.numberOfAds.active", "reports.stats.keydevelopments.numberOfAds.scheduled", "reports.stats.keydevelopments.numberOfAds.expired", "reports.stats.keydevelopments.numberOfAds.created"};
        result.setFilterAsNotUsed(FilterUsed.FilterType.PAYMENT);
        try {
            result.setRowKeys(rowKeys);
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in number of ads");
            e.printStackTrace();
        }
        if (queryParameters.isNumberOfAdsGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsNumberOfMembers(StatisticalKeyDevelopmentsQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        NamedPeriod periodComparedTo = queryParameters.getPeriodComparedTo();
        Collection<Group> groups = queryParameters.getGroups();
        int periodMainMembersCount = this.getElementDao().getNumberOfMembersInGroupsInPeriod(groups, periodMain);
        int periodComparedToMembersCount = this.getElementDao().getNumberOfMembersInGroupsInPeriod(groups, periodComparedTo);
        int periodMainNewMembersCount = this.getNewMembersCount(periodMain, groups);
        int periodComparedToNewMembersCount = this.getNewMembersCount(periodComparedTo, groups);
        int periodMainDisappearedMembersCount = this.getDisappearedMembersCount(periodMain, groups);
        int periodComparedToDisappearedMembersCount = this.getDisappearedMembersCount(periodComparedTo, groups);
        Number[][] tableCells = new Number[3][3];
        tableCells[0][1] = new StatisticalNumber((double)periodMainMembersCount);
        tableCells[0][0] = new StatisticalNumber((double)periodComparedToMembersCount);
        tableCells[0][2] = StatisticalNumber.createPercentage(periodMainMembersCount, periodComparedToMembersCount);
        tableCells[1][1] = new StatisticalNumber((double)periodMainNewMembersCount);
        tableCells[1][0] = new StatisticalNumber((double)periodComparedToNewMembersCount);
        tableCells[1][2] = StatisticalNumber.createPercentage(periodMainNewMembersCount, periodComparedToNewMembersCount);
        tableCells[2][1] = new StatisticalNumber((double)periodMainDisappearedMembersCount);
        tableCells[2][0] = new StatisticalNumber((double)periodComparedToDisappearedMembersCount);
        tableCells[2][2] = StatisticalNumber.createPercentage(periodMainDisappearedMembersCount, periodComparedToDisappearedMembersCount);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfMembers");
        String[] rowKeys = new String[]{"reports.stats.keydevelopments.numberOfMembers.numberOfMembers", "reports.stats.keydevelopments.numberOfMembers.numberOfNewMembers", "reports.stats.keydevelopments.numberOfMembers.numberOfDisappearedMembers"};
        try {
            result.setRowKeys(rowKeys);
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in NumberOfMembers!");
            e.printStackTrace();
        }
        if (queryParameters.isNumberOfMembersGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsNumberOfTransactions(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[1][3];
        Integer periodMainCount = this.getTransactionAmounts(queryParameters, paymentFilter).size();
        Integer periodComparedToCount = this.getTransactionAmountsComparedTo(queryParameters, paymentFilter).size();
        tableCells[0][1] = new StatisticalNumber(periodMainCount);
        tableCells[0][0] = new StatisticalNumber(periodComparedToCount);
        tableCells[0][2] = StatisticalNumber.createPercentage(periodMainCount, periodComparedToCount);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfTransactions");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        try {
            result.setRowKeys(rowKeys);
            if (paymentFilter != null) {
                result.setRowHeader(paymentFilter.getName(), 0);
            }
            this.applyColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in NumberOfTransactions");
            e.printStackTrace();
        }
        if (queryParameters.isNumberOfTransactionsGraph()) {
            result.setGraphDimensions(null, 2, null);
            result.setGraphType(StatisticalResultDTO.GraphType.BAR);
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodGrossProduct(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        byte precision = (byte)this.getLocalSettings().getPrecision().getValue();
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        Collection<Group> groups = queryParameters.getGroups();
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[1][1];
        tableCells[0][0] = new StatisticalNumber(this.getSumOfTransactions(periodMain, groups, paymentFilter).doubleValue(), precision);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.grossProduct");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        this.passCurrencySingle(result, queryParameters);
        try {
            result.setRowKeys(rowKeys);
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in Gross Product");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodHighestTransactionAmount(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        byte precision = (byte)this.getLocalSettings().getPrecision().getValue();
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        String baseKey = "reports.stats.keydevelopments.highestAmountPerTransaction";
        Number[][] tableCells = new Number[1][1];
        List<Number> amounts = this.getTransactionAmounts(queryParameters, paymentFilter);
        if (amounts.size() < 15) {
            return StatisticalResultDTO.noDataAvailable("reports.stats.keydevelopments.highestAmountPerTransaction");
        }
        tableCells[0][0] = new StatisticalNumber(ListOperations.getMax(amounts).doubleValue(), precision);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.highestAmountPerTransaction");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        this.passCurrencySingle(result, queryParameters);
        try {
            result.setRowKeys(rowKeys);
            if (paymentFilter != null) {
                result.setRowHeader(paymentFilter.getName(), 0);
            }
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in highest transaction amount per transaction");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodMedianAmountPerTransaction(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        String baseKey = "reports.stats.keydevelopments.averageAmountPerTransaction";
        StatisticalNumber amount = Median.getMedian(this.getTransactionAmounts(queryParameters, paymentFilter), 0.05);
        if (amount.isNull()) {
            return StatisticalResultDTO.noDataAvailable("reports.stats.keydevelopments.averageAmountPerTransaction");
        }
        Number[][] tableCells = new Number[1][1];
        tableCells[0][0] = amount;
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.averageAmountPerTransaction");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        this.passCurrencySingle(result, queryParameters);
        try {
            result.setRowKeys(rowKeys);
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in average amount per transaction");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodNumberOfAds(StatisticalKeyDevelopmentsQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        Collection<Group> groups = queryParameters.getGroups();
        Integer activeAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.ACTIVE);
        Integer scheduledAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.SCHEDULED);
        Integer expiredAdsPeriodMain = this.adDao.getNumberOfAds(periodMain.getEnd(), groups, Ad.Status.EXPIRED);
        Integer createdAdsPeriodMain = this.adDao.getNumberOfCreatedAds(periodMain, groups);
        Number[][] tableCells = new Number[4][1];
        tableCells[0][0] = new StatisticalNumber(activeAdsPeriodMain);
        tableCells[1][0] = new StatisticalNumber(scheduledAdsPeriodMain);
        tableCells[2][0] = new StatisticalNumber(expiredAdsPeriodMain);
        tableCells[3][0] = new StatisticalNumber(createdAdsPeriodMain);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfAds");
        result.setFilterAsNotUsed(FilterUsed.FilterType.PAYMENT);
        String[] rowKeys = new String[]{"reports.stats.keydevelopments.numberOfAds.active", "reports.stats.keydevelopments.numberOfAds.scheduled", "reports.stats.keydevelopments.numberOfAds.expired", "reports.stats.keydevelopments.numberOfAds.created"};
        try {
            result.setRowKeys(rowKeys);
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in number of ads");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodNumberOfMembers(StatisticalKeyDevelopmentsQuery queryParameters) {
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        Collection<Group> groups = queryParameters.getGroups();
        int periodMainMembersCount = this.getElementDao().getNumberOfMembersInGroupsInPeriod(groups, periodMain);
        int periodMainNewMembersCount = this.getNewMembersCount(periodMain, groups);
        int periodMainDisappearedMembersCount = this.getDisappearedMembersCount(periodMain, groups);
        Number[][] tableCells = new Number[3][1];
        tableCells[0][0] = new StatisticalNumber((double)periodMainMembersCount);
        tableCells[1][0] = new StatisticalNumber((double)periodMainNewMembersCount);
        tableCells[2][0] = new StatisticalNumber((double)periodMainDisappearedMembersCount);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfMembers");
        String[] rowKeys = new String[]{"reports.stats.keydevelopments.numberOfMembers.numberOfMembers", "reports.stats.keydevelopments.numberOfMembers.numberOfNewMembers", "reports.stats.keydevelopments.numberOfMembers.numberOfDisappearedMembers"};
        try {
            result.setRowKeys(rowKeys);
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in NumberOfMembers!");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodNumberOfTransactions(StatisticalKeyDevelopmentsQuery queryParameters) {
        String[] rowKeys;
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[1][1];
        tableCells[0][0] = new StatisticalNumber((double)this.getTransactionAmounts(queryParameters, paymentFilter).size());
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.keydevelopments.numberOfTransactions");
        if (paymentFilter != null) {
            result.setRowHeader(paymentFilter.getName(), 0);
            rowKeys = new String[]{""};
        } else {
            rowKeys = new String[]{"reports.stats.keydevelopments.grossProduct.allTransactions"};
        }
        try {
            result.setRowKeys(rowKeys);
            if (paymentFilter != null) {
                result.setRowHeader(paymentFilter.getName(), 0);
            }
            this.applySinglePeriodColumnHeadersAndKeys(result, queryParameters);
            this.passGroupFilter(result, queryParameters);
            this.passPaymentFilter(result, queryParameters);
        }
        catch (Exception e) {
            System.out.println("Error in NumberOfTransactions");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTheTime(StatisticalKeyDevelopmentsQuery queryParameters) {
        boolean isNumberOfMembers = queryParameters.isNumberOfMembers();
        boolean isGrossProduct = queryParameters.isGrossProduct();
        boolean isNumberOfTransactions = queryParameters.isNumberOfTransactions();
        boolean isTransactionAmount = queryParameters.isTransactionAmount();
        boolean isAds = queryParameters.isNumberOfAds();
        ThroughTimeRange throughTimeRange = queryParameters.getThroughTimeRange();
        Currency currency = this.getCurrency(queryParameters);
        ArrayList<String> columnKeysList = new ArrayList<String>(5);
        ArrayList<String> columnSubHeaderList = new ArrayList<String>(5);
        int columns = 0;
        if (isNumberOfMembers) {
            columnKeysList.add("reports.stats.keydevelopments.numberOfMembers.numberOfMembers");
            columnSubHeaderList.add("");
            ++columns;
        }
        if (isGrossProduct) {
            columnKeysList.add("reports.stats.keydevelopments.grossProduct");
            columnSubHeaderList.add(this.parenthesizeString(currency.getSymbol()));
            ++columns;
        }
        if (isNumberOfTransactions) {
            columnKeysList.add("reports.stats.keydevelopments.numberOfTransactions");
            columnSubHeaderList.add("");
            ++columns;
        }
        if (isTransactionAmount) {
            columnKeysList.add("reports.stats.keydevelopments.transactionAmount.median");
            columnSubHeaderList.add(this.parenthesizeString(currency.getSymbol()));
            ++columns;
        }
        if (isAds) {
            columnKeysList.add("reports.stats.keydevelopments.numberOfAds.active");
            columnSubHeaderList.add("");
            ++columns;
        }
        String[] columnKeys = columnKeysList.toArray(new String[0]);
        String[] columnSubHeaders = columnSubHeaderList.toArray(new String[0]);
        Period[] periods = queryParameters.getPeriods();
        String[] rowHeaders = new String[periods.length];
        Number[][] tableCells = this.getThroughTheTimeCalculation(periods, queryParameters, columns, rowHeaders);
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        String baseKey = "reports.stats.keydevelopments.throughTime";
        this.passGroupFilter(result, queryParameters);
        this.passPaymentFilter(result, queryParameters);
        baseKey = throughTimeRange == ThroughTimeRange.YEAR ? baseKey + ".years" : (throughTimeRange == ThroughTimeRange.QUARTER ? baseKey + ".quarters" : baseKey + ".months");
        result.setBaseKey(baseKey);
        result.setRowHeaders(rowHeaders);
        result.setColumnKeys(columnKeys);
        result.setColumnSubHeaders(columnSubHeaders);
        result.setMultiGraph(StatisticalResultDTO.MultiGraph.BY_COLUMN);
        if (queryParameters.isThruTimeGraph()) {
            result.setGraphType(StatisticalResultDTO.GraphType.LINE);
        }
        return result;
    }

    public void setAdDao(AdDAO adDao) {
        this.adDao = adDao;
    }

    private void applyColumnHeadersAndKeys(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        String[] columnKeys = new String[]{"", "", "reports.stats.general.growth"};
        result.setColumnKeys(columnKeys);
        result.setColumnHeader(queryParameters.getPeriodMain().getName(), 1);
        result.setColumnHeader(queryParameters.getPeriodComparedTo().getName(), 0);
    }

    private void applySinglePeriodColumnHeadersAndKeys(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        String[] columnKeys = new String[]{""};
        result.setColumnKeys(columnKeys);
        result.setColumnHeader(queryParameters.getPeriodMain().getName(), 0);
    }

    private int getDisappearedMembersCount(Period period, Collection<? extends Group> groups) {
        MemberQuery memberQuery = new MemberQuery();
        memberQuery.setDeactivationPeriod(period);
        memberQuery.setGroups(groups);
        memberQuery.setPageForCount();
        return PageHelper.getTotalCount(this.getElementDao().searchHistoryRemoved(memberQuery));
    }

    private int getNewMembersCount(Period period, Collection<? extends Group> groups) {
        MemberQuery memberQuery = new MemberQuery();
        memberQuery.setCreationPeriod(period);
        memberQuery.setGroups(groups);
        memberQuery.setPageForCount();
        return PageHelper.getTotalCount(this.getElementDao().searchHistoryNew(memberQuery));
    }

    private BigDecimal getSumOfTransactions(Period period, Collection<? extends Group> groups, PaymentFilter paymentFilter) {
        StatisticalDTO dto = new StatisticalDTO();
        dto.setPeriod(period);
        dto.setGroups(groups);
        dto.setPaymentFilter(paymentFilter);
        return this.getTransferDao().getSumOfTransactions(dto);
    }

    private Number[][] getThroughTheTimeCalculation(Period[] periods, StatisticalKeyDevelopmentsQuery queryParameters, int columns, String[] rowHeaders) {
        byte precision = (byte)this.getLocalSettings().getPrecision().getValue();
        Collection<Group> groups = queryParameters.getGroups();
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        Number[][] tableCells = new Number[periods.length][columns];
        Period totalPeriod = new Period(periods[0].getBegin(), periods[periods.length - 1].getEnd());
        ThroughTimeRange throughTimeRange = queryParameters.getThroughTimeRange();
        boolean isNumberOfMembers = queryParameters.isNumberOfMembers();
        boolean isGrossProduct = queryParameters.isGrossProduct();
        boolean isNumberOfTransactions = queryParameters.isNumberOfTransactions();
        boolean isTransactionAmount = queryParameters.isTransactionAmount();
        boolean isAds = queryParameters.isNumberOfAds();
        StatisticalDTO dto = new StatisticalDTO();
        dto.setGroups(groups);
        dto.setPaymentFilter(paymentFilter);
        dto.setPeriod(totalPeriod);
        List<KeyDevelopmentsStatsPerMonthVO> grossProductPerMonth = isGrossProduct ? this.getTransferDao().getGrossProductPerMonth(dto) : null;
        List<KeyDevelopmentsStatsPerMonthVO> numberOfTransactionsPerMonth = isNumberOfTransactions ? this.getTransferDao().getNumberOfTransactionsPerMonth(dto) : null;
        int rowIndex = 0;
        for (Period period : periods) {
            int columnIndex = 0;
            rowHeaders[rowIndex] = throughTimeRange == ThroughTimeRange.YEAR ? "" + period.getBegin().get(1) : (throughTimeRange == ThroughTimeRange.QUARTER ? "" + period.getBegin().get(1) + " - " + period.getBeginQuarter().toStringRepresentation() : period.getBegin().get(1) + "-" + (period.getBegin().get(2) + 1 >= 10 ? Integer.valueOf(period.getBegin().get(2) + 1) : "0" + (period.getBegin().get(2) + 1)));
            if (isNumberOfMembers) {
                int periodMainMembersCount = this.getElementDao().getNumberOfMembersInGroupsInPeriod(groups, period);
                tableCells[rowIndex][columnIndex] = new StatisticalNumber((double)periodMainMembersCount);
                ++columnIndex;
            }
            if (isGrossProduct) {
                Double grossProduct = this.periodize(grossProductPerMonth, period);
                tableCells[rowIndex][columnIndex] = new StatisticalNumber(grossProduct, precision);
                ++columnIndex;
            }
            if (isNumberOfTransactions) {
                Double numberOfTransactions = this.periodize(numberOfTransactionsPerMonth, period);
                tableCells[rowIndex][columnIndex] = new StatisticalNumber(numberOfTransactions);
                ++columnIndex;
            }
            if (isTransactionAmount) {
                StatisticalDTO tempDto = new StatisticalDTO();
                tempDto.setGroups(groups);
                tempDto.setPaymentFilter(paymentFilter);
                tempDto.setPeriod(period);
                List<Number> transactionAmounts = this.getTransferDao().getTransactionAmounts(tempDto);
                tableCells[rowIndex][columnIndex] = Median.getMedian(transactionAmounts, 0.05);
                ++columnIndex;
            }
            if (isAds) {
                Integer activeAdsPeriodMain = this.adDao.getNumberOfAds(period.getEnd(), groups, Ad.Status.ACTIVE);
                tableCells[rowIndex][columnIndex++] = new StatisticalNumber(activeAdsPeriodMain);
            }
            ++rowIndex;
        }
        return tableCells;
    }

    private List<Number> getTransactionAmounts(StatisticalKeyDevelopmentsQuery queryParameters, PaymentFilter paymentFilter) {
        if (queryParameters.equals(this.savedParameters) && this.transactionAmounts != null) {
            return this.transactionAmounts;
        }
        NamedPeriod periodMain = queryParameters.getPeriodMain();
        Collection<Group> groups = queryParameters.getGroups();
        List<Number> amounts = this.getTransactionAmountsFromDatabase(periodMain, groups, paymentFilter);
        this.savedParameters = queryParameters;
        this.transactionAmounts = amounts;
        return amounts;
    }

    private List<Number> getTransactionAmountsComparedTo(StatisticalKeyDevelopmentsQuery queryParameters, PaymentFilter paymentFilter) {
        if (queryParameters.equals(this.savedParameters) && this.transactionAmounts2 != null) {
            return this.transactionAmounts2;
        }
        NamedPeriod period = queryParameters.getPeriodComparedTo();
        Collection<Group> groups = queryParameters.getGroups();
        List<Number> amounts = this.getTransactionAmountsFromDatabase(period, groups, paymentFilter);
        this.savedParameters = queryParameters;
        this.transactionAmounts2 = amounts;
        return amounts;
    }

    private List<Number> getTransactionAmountsFromDatabase(Period period, Collection<? extends Group> groups, PaymentFilter paymentFilter) {
        StatisticalDTO dto = new StatisticalDTO();
        dto.setPeriod(period);
        dto.setGroups(groups);
        dto.setPaymentFilter(paymentFilter);
        List<Number> list = this.getTransferDao().getTransactionAmounts(dto);
        return list;
    }

    private void passCurrencyCompared(StatisticalResultDTO result, StatisticalKeyDevelopmentsQuery queryParameters) {
        Currency currency = this.getCurrency(queryParameters);
        result.setColumnSubHeaders(new String[]{this.parenthesizeString(currency.getSymbol()), this.parenthesizeString(currency.getSymbol()), ""});
        result.setYAxisUnits(currency.getSymbol());
    }

    private void passCurrencySingle(StatisticalResultDTO result, StatisticalKeyDevelopmentsQuery queryParameters) {
        Currency currency = this.getCurrency(queryParameters);
        result.setColumnSubHeaders(new String[]{this.parenthesizeString(currency.getSymbol())});
    }

    private double periodize(List<KeyDevelopmentsStatsPerMonthVO> grossProductPerMonthList, Period period) {
        int year = period.getBegin().get(1);
        int startMonth = period.getBegin().get(2) + 1;
        int endMonth = period.getEnd().get(2) + 1;
        double result = 0.0;
        for (KeyDevelopmentsStatsPerMonthVO monthData : grossProductPerMonthList) {
            if (monthData.getMonth() < startMonth || monthData.getMonth() > endMonth || monthData.getYear() != year) continue;
            result += monthData.getDataField().doubleValue();
        }
        return result;
    }
}

