/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.services.stats.exceptions.InconsistentDataDimensionsException;
import nl.strohalm.cyclos.services.stats.general.FilterUsed;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.statistics.ListOperations;
import org.jfree.chart.plot.Marker;

public class StatisticalResultDTO
extends DataObject {
    private static final long serialVersionUID = 7243923567624382393L;
    private int rows;
    private int columns;
    private ResourceKey[] rowKeys;
    private String[] rowHeaders;
    private String[] columnKeys;
    private String[] columnHeaders;
    private String[] columnSubHeaders;
    private Number[][] tableCells;
    private Integer categoryCount;
    private Integer seriesCount;
    private String baseKey;
    private String subTitle;
    private String scaleFactorX;
    private GraphType graphType;
    private MultiGraph multiGraph;
    private boolean showTable;
    private boolean dontSwitchXY;
    private final List<FilterUsed> filtersUsed = new ArrayList<FilterUsed>();
    private String yAxisUnits = "";
    private String xAxisUnits = "";
    private String helpFile = "statistics";
    private Marker[] domainMarkers;

    static StatisticalResultDTO noDataAvailable(String key) {
        StatisticalResultDTO result = new StatisticalResultDTO();
        result.setBaseKey(key);
        return result;
    }

    public StatisticalResultDTO(Number[][] tableCells) {
        this.tableCells = tableCells;
        this.rows = tableCells.length;
        this.rowKeys = new ResourceKey[this.rows];
        this.rowHeaders = new String[this.rows];
        this.columns = tableCells[0].length;
        this.columnKeys = new String[this.columns];
        this.columnHeaders = new String[this.columns];
        this.columnSubHeaders = new String[this.columns];
        this.graphType = GraphType.NONE;
        this.multiGraph = MultiGraph.NONE;
        this.showTable = true;
    }

    private StatisticalResultDTO() {
        this.graphType = GraphType.NONE;
        this.tableCells = new Number[0][0];
    }

    public String getBaseKey() {
        return this.baseKey;
    }

    public int getCategoriesCount() {
        if (this.categoryCount != null) {
            return this.categoryCount;
        }
        return this.dontSwitchXY ? this.columns : this.rows;
    }

    public String getColumnHeader(int index) {
        return this.columnHeaders[index];
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    public String getColumnKey(int index) {
        return this.columnKeys[index];
    }

    public String[] getColumnKeys() {
        return this.columnKeys;
    }

    public String[] getColumnSubHeaders() {
        return this.columnSubHeaders;
    }

    public Marker[] getDomainMarkers() {
        return this.domainMarkers;
    }

    public List<FilterUsed> getFiltersUsed() {
        return this.filtersUsed;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    public String getHelpFile() {
        return this.helpFile;
    }

    public MultiGraph getMultiGraph() {
        return this.multiGraph;
    }

    public String getRowHeader(int index) {
        return this.rowHeaders[index];
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public String getRowKey(int index) {
        return this.rowKeys[index].getKey();
    }

    public Object[] getRowKeyArgs(int index) {
        return this.rowKeys[index].getArgs();
    }

    public ResourceKey[] getRowKeys() {
        return this.rowKeys;
    }

    public String getScaleFactorX() {
        return this.scaleFactorX;
    }

    public int getSeriesCount() {
        if (this.seriesCount != null) {
            return this.seriesCount;
        }
        return this.dontSwitchXY ? this.rows : this.columns;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public Number[][] getTableCells() {
        return this.tableCells;
    }

    public String getXAxisUnits() {
        return this.xAxisUnits;
    }

    public String getYAxisUnits() {
        return this.yAxisUnits;
    }

    public boolean hasErrorBars() {
        Number[][] arr$ = this.tableCells;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Number[] element;
            for (Number element2 : element = arr$[i$]) {
                if (!(element2 instanceof StatisticalNumber) || !((StatisticalNumber)element2).hasErrorBar()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDontSwitchXY() {
        return this.dontSwitchXY;
    }

    public boolean isShowTable() {
        return this.showTable;
    }

    public void orderSeries(byte[] seriesOrder) {
        class IndexedSerie {
            private Number[] numbers;
            private String seriesHeader;
            private String seriesSubHeader;
            private String seriesKey;
            private byte index;

            IndexedSerie(Number[] numbers, int originalIndex, byte index) {
                this.numbers = numbers;
                if (StatisticalResultDTO.this.columnHeaders != null && StatisticalResultDTO.this.columnHeaders.length > 0) {
                    this.seriesHeader = StatisticalResultDTO.this.columnHeaders[originalIndex];
                }
                this.seriesKey = StatisticalResultDTO.this.columnKeys[originalIndex];
                if (StatisticalResultDTO.this.columnSubHeaders != null && StatisticalResultDTO.this.columnSubHeaders.length > 0) {
                    this.seriesSubHeader = StatisticalResultDTO.this.columnSubHeaders[originalIndex];
                }
                this.index = index;
            }
        }
        Comparator<IndexedSerie> comparator = new Comparator<IndexedSerie>(){

            @Override
            public int compare(IndexedSerie o1, IndexedSerie o2) {
                if (o1.index == o2.index) {
                    double result = o1.numbers[0].doubleValue() - o2.numbers[0].doubleValue();
                    return (int)Math.signum(result);
                }
                return o1.index - o2.index;
            }
        };
        if (this.tableCells == null || this.columnKeys == null) {
            throw new IllegalArgumentException("Method orderSeries may only be called after setting columnKeys.");
        }
        if (this.tableCells.length == 0 || this.tableCells[0] == null || this.tableCells[0].length == 0) {
            return;
        }
        if (seriesOrder == null || seriesOrder.length != this.columnKeys.length || seriesOrder.length != this.tableCells[0].length) {
            throw new InconsistentDataDimensionsException("SeriesNames / dataset length does not match order length.");
        }
        Number[][] transposedMatrix = ListOperations.transposeMatrix(this.tableCells);
        IndexedSerie[] arrayOfSeries = new IndexedSerie[seriesOrder.length];
        for (int i = 0; i < seriesOrder.length; ++i) {
            arrayOfSeries[i] = new IndexedSerie(transposedMatrix[i], i, seriesOrder[i]);
        }
        Arrays.sort(arrayOfSeries, comparator);
        Number[][] transposedOrderedMatrix = new Number[seriesOrder.length][transposedMatrix[0].length];
        for (int i = 0; i < seriesOrder.length; ++i) {
            transposedOrderedMatrix[i] = arrayOfSeries[i].numbers;
            this.columnKeys[i] = arrayOfSeries[i].seriesKey;
            if (this.columnHeaders != null && this.columnHeaders.length > 0) {
                this.columnHeaders[i] = arrayOfSeries[i].seriesHeader;
            }
            if (this.columnSubHeaders == null || this.columnSubHeaders.length <= 0) continue;
            this.columnSubHeaders[i] = arrayOfSeries[i].seriesSubHeader;
        }
        Number[][] orderedMatrix = ListOperations.transposeMatrix(transposedOrderedMatrix);
        this.tableCells = orderedMatrix;
    }

    public void setBaseKey(String baseKey) {
        this.baseKey = baseKey;
    }

    public void setColumnHeader(String header, int index) {
        this.columnHeaders[index] = header;
    }

    public void setColumnKeys(String[] lColumnKeys) throws InconsistentDataDimensionsException {
        if (this.columns > 0 && lColumnKeys.length != this.columns) {
            throw new InconsistentDataDimensionsException("SeriesNames length and dataset length do not match.");
        }
        this.columnKeys = lColumnKeys;
    }

    public void setDomainMarkers(Marker[] markers) {
        this.domainMarkers = markers;
    }

    public void setGraphDimensions(TableToGraph tableToGraph, Integer seriesCount, Integer categoriesCount) {
        this.dontSwitchXY = tableToGraph != null && tableToGraph == TableToGraph.COLUMN_IS_CATEGORY;
        int tableSeriesCount = this.dontSwitchXY ? this.rows : this.columns;
        this.seriesCount = seriesCount != null && seriesCount < tableSeriesCount ? seriesCount : null;
        int tableCategoriesCount = this.dontSwitchXY ? this.columns : this.rows;
        this.categoryCount = categoriesCount != null && categoriesCount < tableCategoriesCount ? categoriesCount : null;
    }

    public void setGraphType(GraphType graphType) {
        this.graphType = graphType;
    }

    public void setHelpFile(String fileName) {
        this.helpFile = fileName;
    }

    public void setRowHeader(String header, int index) {
        this.rowHeaders[index] = header;
    }

    public void setRowKeys(ResourceKey[] rowKeys) throws InconsistentDataDimensionsException {
        if (this.rows > 0 && rowKeys.length != this.rows) {
            throw new InconsistentDataDimensionsException("Number of rowKeys and dataset length do not match.");
        }
        this.rowKeys = rowKeys;
    }

    public void setRowKeys(String[] rowKeys) throws InconsistentDataDimensionsException {
        if (this.rows > 0 && rowKeys.length != this.rows) {
            throw new InconsistentDataDimensionsException("Number of rowKeys and dataset length do not match.");
        }
        ResourceKey[] newRowKeys = new ResourceKey[rowKeys.length];
        for (int i = 0; i < rowKeys.length; ++i) {
            newRowKeys[i] = new ResourceKey(rowKeys[i], new Object[0]);
        }
        this.rowKeys = newRowKeys;
    }

    public void setShowTable(boolean showTable) {
        this.showTable = showTable;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setXAxisUnits(String axisUnits) {
        this.xAxisUnits = axisUnits;
    }

    public void setYAxisUnits(String axisUnits) {
        this.yAxisUnits = axisUnits;
    }

    void setColumnHeaders(String[] lColumnHeaders) throws InconsistentDataDimensionsException {
        if (this.columns > 0 && lColumnHeaders.length != this.columns) {
            throw new InconsistentDataDimensionsException("SeriesNames length and dataset length do not match.");
        }
        this.columnHeaders = lColumnHeaders;
    }

    void setColumnSubHeaders(String[] lColumnSubHeaders) throws InconsistentDataDimensionsException {
        if (this.columns > 0 && lColumnSubHeaders.length != this.columns) {
            throw new InconsistentDataDimensionsException("SeriesNames length and dataset length do not match.");
        }
        this.columnSubHeaders = lColumnSubHeaders;
    }

    void setFilter(Collection<Group> groupFilter) {
        FilterUsed filterUsed;
        if (groupFilter == null) {
            this.setFilterAsNotUsed(FilterUsed.FilterType.GROUP);
            return;
        }
        if (groupFilter.size() == 0) {
            filterUsed = FilterUsed.nothingSelected(FilterUsed.FilterType.GROUP, "member.search.allGroups");
        } else {
            ArrayList<String> names = new ArrayList<String>(groupFilter.size());
            for (Group g : groupFilter) {
                names.add(g.toString());
            }
            filterUsed = new FilterUsed(FilterUsed.FilterType.GROUP, names);
        }
        this.filtersUsed.add(filterUsed);
    }

    void setFilter(NamedPeriod period) {
        FilterUsed filterUsed = new FilterUsed(FilterUsed.FilterType.PERIOD, period.getName());
        this.filtersUsed.add(filterUsed);
    }

    void setFilter(PaymentFilter paymentFilter) {
        FilterUsed filterUsed = paymentFilter == null ? FilterUsed.nothingSelected(FilterUsed.FilterType.PAYMENT, "reports.stats.general.allPaymentTypes") : new FilterUsed(FilterUsed.FilterType.PAYMENT, paymentFilter.toString());
        this.filtersUsed.add(filterUsed);
    }

    void setFilter(SystemAccountType systemAccountFilter) {
        FilterUsed filterUsed = new FilterUsed(FilterUsed.FilterType.SYSTEM_ACCOUNT, systemAccountFilter.toString());
        this.filtersUsed.add(filterUsed);
    }

    void setFilterAsNotUsed(FilterUsed.FilterType filterType) {
        FilterUsed filterUsed = FilterUsed.noFilterUsed(filterType);
        this.filtersUsed.add(filterUsed);
    }

    void setMultiGraph(MultiGraph multiGraph) {
        this.multiGraph = multiGraph;
    }

    void setRowHeaders(String[] rowHeaders) throws InconsistentDataDimensionsException {
        if (this.rows > 0 && rowHeaders.length != this.rows) {
            throw new InconsistentDataDimensionsException("Number of rowKeys and dataset length do not match.");
        }
        this.rowHeaders = rowHeaders;
    }

    void setScaleFactorX(String scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
    }

    public static enum TableToGraph {
        COLUMN_IS_CATEGORY,
        COLUMN_IS_SERIES;

    }

    public static class ResourceKey {
        private String key;
        private Object[] args;

        public ResourceKey(String key, Object ... args) {
            this.key = key;
            this.args = args;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum MultiGraph {
        NONE,
        BY_COLUMN,
        BY_ROW;

    }

    public static enum GraphType implements StringValuedEnum
    {
        NONE("none"),
        BAR("verticalbar"),
        LINE("line"),
        PIE("pie"),
        STACKED_AREA("stackedarea");

        private final String value;

        private GraphType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

