/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javastat.inference.nonparametric.RankSumTest;
import javastat.inference.twosamples.TwoSampProps;
import nl.strohalm.cyclos.dao.accounts.CurrencyDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.reports.StatisticalFinancesQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.reports.StatisticalQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.reports.ThroughTimeRange;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalService;
import nl.strohalm.cyclos.services.stats.StatisticalServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterServiceLocal;
import nl.strohalm.cyclos.utils.Month;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.Quarter;
import nl.strohalm.cyclos.utils.statistics.ListOperations;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public abstract class StatisticalServiceImpl
implements StatisticalServiceLocal {
    private int maximumDataPoints = 1000;
    protected FetchServiceLocal fetchService;
    private SettingsServiceLocal settingsService;
    private PaymentFilterServiceLocal paymentFilterService;
    private TransferDAO transferDao;
    private CurrencyDAO currencyDao;
    private ElementDAO elementDao;

    protected static StatisticalNumber calculatePvalue(double[] array1, double[] array2) {
        StatisticalNumber p = StatisticalNumber.createNullPvalue();
        if (array1.length >= 15 && array2.length >= 15) {
            RankSumTest rst = new RankSumTest(0.05, "equal", array1, array2);
            if (!Double.isNaN(rst.pValue)) {
                p = StatisticalNumber.createPvalue(rst.pValue);
            }
        }
        return p;
    }

    protected static StatisticalNumber calculatePvalue(int proportion1, int population1, int proportion2, int population2) {
        StatisticalNumber pValue = StatisticalNumber.createNullPvalue();
        if (population1 >= 15 && population2 >= 15 && proportion1 > 0 && proportion2 > 0) {
            TwoSampProps twoSampProps = new TwoSampProps(0.05, 0.0, "equal", (double)proportion1, (double)population1, (double)proportion2, (double)population2);
            pValue = StatisticalNumber.createPvalue(twoSampProps.pValue);
        }
        return pValue;
    }

    protected static StatisticalNumber calculatePvalue(List<Number> list1, List<Number> list2) {
        double[] array1 = ListOperations.listToArray(list1);
        double[] array2 = ListOperations.listToArray(list2);
        return StatisticalServiceImpl.calculatePvalue(array1, array2);
    }

    public void setCurrencyDao(CurrencyDAO currencyDao) {
        this.currencyDao = currencyDao;
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public void setMaximumDataPoints(int maximumDataPoints) {
        this.maximumDataPoints = maximumDataPoints;
    }

    public void setPaymentFilterServiceLocal(PaymentFilterServiceLocal paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    @Override
    public void validate(Object query) {
        Validator statsValidator = new Validator("");
        statsValidator.general(new ItemsCheckedValidation(), new NumberOfDataPointsValidation());
        if (query instanceof StatisticalFinancesQuery) {
            statsValidator.general(new PaymentFiltersNotOverlappingValidation(), new NumberOfPaymentFiltersValidation());
        }
        statsValidator.validate(query);
    }

    @Deprecated
    protected StatisticalResultDTO createDataObject(int rows, int columns, int factor, byte precision) {
        int[] rowFactors = new int[rows];
        Arrays.fill(rowFactors, factor);
        return this.createDataObject(rows, columns, rowFactors, precision);
    }

    @Deprecated
    protected StatisticalResultDTO createDataObject(int rows, int columns, int[] rowFactor, byte precision) {
        Number[][] data = new Number[rows][columns];
        this.fillTwoDimensionalArray(data, rows, columns, rowFactor, precision, false);
        return new StatisticalResultDTO(data);
    }

    @Deprecated
    protected StatisticalResultDTO createDataObject(int rows, int tableFactor, StatisticalService.TableType tableType, byte precision) {
        int[] rowFactors = new int[rows];
        Arrays.fill(rowFactors, tableFactor);
        return this.createDataObject(rows, rowFactors, tableType, precision);
    }

    @Deprecated
    protected StatisticalResultDTO createDataObject(int rows, int[] rowFactors, StatisticalService.TableType tableType, byte precision) {
        int columns = 2 + tableType.getValue();
        Number[][] data = new Number[rows][columns];
        this.fillTwoDimensionalArray(data, rows, 2, rowFactors, precision, tableType != StatisticalService.TableType.GROWTH);
        for (Number[] row : data) {
            if (tableType != StatisticalService.TableType.P) {
                row[2] = StatisticalNumber.createPercentage(row[0], row[1]);
            }
            if (tableType == StatisticalService.TableType.GROWTH) continue;
            row[columns - 1] = StatisticalNumber.createPvalue(Math.random() * 0.4);
        }
        return new StatisticalResultDTO(data);
    }

    protected Currency getCurrency(StatisticalQuery queryParameters) {
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        if (systemAccountFilter != null) {
            return systemAccountFilter.getCurrency();
        }
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        if (paymentFilter != null) {
            return paymentFilter.getAccountType().getCurrency();
        }
        List<Currency> currencyList = this.currencyDao.listAll(new Relationship[0]);
        if (currencyList.size() == 1) {
            return currencyList.get(0);
        }
        Currency result = new Currency();
        result.setName("");
        result.setSymbol("");
        return result;
    }

    protected ElementDAO getElementDao() {
        return this.elementDao;
    }

    protected PaymentFilter getInitializedPaymentFilter(StatisticalQuery queryParameters) {
        PaymentFilter paymentFilter = queryParameters.getPaymentFilter();
        if (paymentFilter != null && paymentFilter.getName() == null) {
            paymentFilter = this.fetchService.fetch(paymentFilter, PaymentFilter.Relationships.TRANSFER_TYPES, PaymentFilter.Relationships.ACCOUNT_TYPE);
            queryParameters.setPaymentFilter(paymentFilter);
        }
        return paymentFilter;
    }

    protected Collection<PaymentFilter> getInitializedPaymentFilters(StatisticalQuery queryParameters) {
        Collection<PaymentFilter> paymentFilters = queryParameters.getPaymentFilters();
        ArrayList<PaymentFilter> newList = new ArrayList<PaymentFilter>(paymentFilters.size());
        boolean anyChanges = false;
        for (PaymentFilter paymentFilter : paymentFilters) {
            if (paymentFilter.getName() == null) {
                paymentFilter = this.fetchService.fetch(paymentFilter, PaymentFilter.Relationships.TRANSFER_TYPES);
                anyChanges = true;
            }
            newList.add(paymentFilter);
        }
        if (anyChanges) {
            queryParameters.setPaymentFilters(newList);
        }
        return newList;
    }

    protected SystemAccountType getInitializedSystemAccountFilter(StatisticalQuery queryParameters) {
        SystemAccountType systemAccountFilter = queryParameters.getSystemAccountFilter();
        if (systemAccountFilter != null) {
            if (systemAccountFilter.getName() == null) {
                systemAccountFilter = this.fetchService.fetch(systemAccountFilter, new Relationship[0]);
            }
            queryParameters.setSystemAccountFilter(systemAccountFilter);
        }
        return systemAccountFilter;
    }

    protected LocalSettings getLocalSettings() {
        return this.settingsService.getLocalSettings();
    }

    protected String getRowHeaders(ThroughTimeRange throughTimeRange, Period period) {
        String result = "";
        result = throughTimeRange == ThroughTimeRange.MONTH ? period.getBegin().get(1) + " - " + (period.getBegin().get(2) + 1 >= 10 ? Integer.valueOf(period.getBegin().get(2) + 1) : "0" + (period.getBegin().get(2) + 1)) : (throughTimeRange == ThroughTimeRange.QUARTER ? period.getBegin().get(1) + " - " + period.getBeginQuarter().toStringRepresentation() : "" + period.getBegin().get(1));
        return result;
    }

    protected TransferDAO getTransferDao() {
        return this.transferDao;
    }

    protected String parenthesizeString(String inputString) {
        if (inputString.length() == 0) {
            return "";
        }
        return "(" + inputString + ")";
    }

    protected void passGroupFilter(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        Collection<Group> groupFilter = queryParameters.getGroups();
        groupFilter = this.fetchService.fetch(groupFilter, new Relationship[0]);
        result.setFilter(groupFilter);
    }

    protected void passPaymentFilter(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        PaymentFilter paymentFilter = this.getInitializedPaymentFilter(queryParameters);
        if (paymentFilter == null) {
            Iterator<PaymentFilter> i$;
            Collection<PaymentFilter> paymentFilters = this.getInitializedPaymentFilters(queryParameters);
            if (paymentFilters.size() == 0) {
                result.setFilter(paymentFilter);
            } else if (paymentFilters.size() == 1 && (i$ = paymentFilters.iterator()).hasNext()) {
                PaymentFilter paymentFilterItem = i$.next();
                result.setFilter(paymentFilterItem);
                return;
            }
        } else {
            result.setFilter(paymentFilter);
        }
    }

    protected void passSystemAccountFilter(StatisticalResultDTO result, StatisticalQuery queryParameters) {
        SystemAccountType systemAccountFilter = this.getInitializedSystemAccountFilter(queryParameters);
        result.setFilter(systemAccountFilter);
    }

    private Number[][] fillTwoDimensionalArray(Number[][] data, int rows, int columns, int[] rowFactors, byte precision, boolean hasErrors) {
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                double datavalue = Math.random() * (double)rowFactors[i];
                Double errorvalue = hasErrors ? Double.valueOf(Math.random() * datavalue) : null;
                data[i][j] = new StatisticalNumber(datavalue, errorvalue, precision);
            }
        }
        return data;
    }

    class ThroughTimeRangeValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -8598196174248973591L;

        ThroughTimeRangeValidation() {
        }

        @Override
        public ValidationError validate(Object queryObj) {
            StatisticalQuery query = (StatisticalQuery)queryObj;
            StatisticsWhatToShow whatToShow = query.getWhatToShow();
            if (whatToShow != StatisticsWhatToShow.THROUGH_TIME) {
                return null;
            }
            ThroughTimeRange throughTimeRange = query.getThroughTimeRange();
            try {
                if (throughTimeRange == ThroughTimeRange.YEAR) {
                    int finalYear;
                    int initialYear = query.getInitialYear();
                    if (initialYear >= (finalYear = query.getFinalYear().intValue())) {
                        return new ValidationError("reports.stats.error.finalDateLesserThanInitialDate", new Object[0]);
                    }
                } else if (throughTimeRange == ThroughTimeRange.MONTH) {
                    int finalYear;
                    int initialYear = query.getInitialMonthYear();
                    if (initialYear > (finalYear = query.getFinalMonthYear().intValue())) {
                        return new ValidationError("reports.stats.error.finalDateLesserThanInitialDate", new Object[0]);
                    }
                    if (initialYear == finalYear) {
                        Month initialMonth = query.getInitialMonth();
                        Month finalMonth = query.getFinalMonth();
                        if (initialMonth.getValue() >= finalMonth.getValue()) {
                            return new ValidationError("reports.stats.error.finalDateLesserThanInitialDate", new Object[0]);
                        }
                    }
                } else {
                    int finalYear;
                    int initialYear = query.getInitialQuarterYear();
                    if (initialYear > (finalYear = query.getFinalQuarterYear().intValue())) {
                        return new ValidationError("reports.stats.error.finalDateLesserThanInitialDate", new Object[0]);
                    }
                    if (initialYear == finalYear) {
                        Quarter initialQuarter = query.getInitialQuarter();
                        Quarter finalQuarter = query.getFinalQuarter();
                        if (initialQuarter.getValue() >= finalQuarter.getValue()) {
                            return new ValidationError("reports.stats.error.finalDateLesserThanInitialDate", new Object[0]);
                        }
                    }
                }
            }
            catch (NullPointerException npe) {
                return new ValidationError("reports.stats.error.initialAndFinalYearsRequired", new Object[0]);
            }
            return null;
        }
    }

    class PaymentFiltersNotOverlappingValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 3261867340688839935L;

        PaymentFiltersNotOverlappingValidation() {
        }

        @Override
        public ValidationError validate(Object queryObj) {
            StatisticalQuery query = (StatisticalQuery)queryObj;
            Collection<PaymentFilter> paymentFilters = query.getPaymentFilters();
            if (paymentFilters.equals(Collections.emptyList())) {
                return new ValidationError("reports.stats.paymentFilters.nothingSelected", new Object[0]);
            }
            HashSet<TransferType> transferTypes = new HashSet<TransferType>();
            for (PaymentFilter filter : paymentFilters) {
                filter = StatisticalServiceImpl.this.paymentFilterService.load(filter.getId(), PaymentFilter.Relationships.TRANSFER_TYPES);
                Collection<TransferType> filterTransferTypes = filter.getTransferTypes();
                for (TransferType transferType : filterTransferTypes) {
                    if (transferTypes.add(transferType)) continue;
                    return new ValidationError("reports.stats.paymentFilters.noOverlap", new Object[0]);
                }
            }
            return null;
        }
    }

    class NumberOfPaymentFiltersValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 2470331423042433415L;
        private static final int MAX_FILTERS = 20;
        private static final int MAX_FILTERS_THROUGHTIME = 5;

        NumberOfPaymentFiltersValidation() {
        }

        @Override
        public ValidationError validate(Object queryObj) {
            int paymentFiltersSize;
            StatisticalQuery query = (StatisticalQuery)queryObj;
            if (!query.anyGraphChecked()) {
                return null;
            }
            int maxFilters = 20;
            if (query.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
                maxFilters = 5;
            }
            if ((paymentFiltersSize = query.getPaymentFilters().size()) > maxFilters) {
                return new ValidationError("reports.stats.paymentFilters.maxItemsExceded", maxFilters);
            }
            return null;
        }
    }

    class NumberOfDataPointsValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -8903460874373624675L;

        NumberOfDataPointsValidation() {
        }

        @Override
        public ValidationError validate(Object queryObj) {
            int nItems;
            StatisticalQuery query = (StatisticalQuery)queryObj;
            if (query.getWhatToShow() != StatisticsWhatToShow.THROUGH_TIME) {
                return null;
            }
            ValidationError error = new ThroughTimeRangeValidation().validate(queryObj);
            if (error != null) {
                return error;
            }
            try {
                nItems = query.countItemsChecked();
            }
            catch (IllegalAccessException e) {
                nItems = 5;
            }
            int nFilters = query.getPaymentFilters().size() > 0 ? query.getPaymentFilters().size() : 1;
            int nTimePoints = 0;
            float heavyness = 1.0f;
            ThroughTimeRange throughTimeRange = query.getThroughTimeRange();
            if (throughTimeRange == ThroughTimeRange.YEAR) {
                int initialYear = query.getInitialYear();
                int finalYear = query.getFinalYear();
                nTimePoints = finalYear + 1 - initialYear;
                heavyness = 2.0f;
            } else if (throughTimeRange == ThroughTimeRange.MONTH) {
                int initialMonthYear = query.getInitialMonthYear();
                int finalMonthYear = query.getFinalMonthYear();
                int initialMonth = query.getInitialMonth().getValue();
                int finalMonth = query.getFinalMonth().getValue();
                nTimePoints = 12 * (finalMonthYear - initialMonthYear) + finalMonth + 1 - initialMonth;
            } else {
                int initialQuarterYear = query.getInitialQuarterYear();
                int finalQuarterYear = query.getFinalQuarterYear();
                int initialQuarter = query.getInitialQuarter().getValue();
                int finalQuarter = query.getFinalQuarter().getValue();
                nTimePoints = 4 * (finalQuarterYear - initialQuarterYear) + finalQuarter + 1 - initialQuarter;
                heavyness = 1.5f;
            }
            int nDataPoints = nItems * nFilters * nTimePoints;
            int maxPointsCorrectedForHeavyness = Math.round((float)StatisticalServiceImpl.this.maximumDataPoints / heavyness);
            if (nDataPoints > maxPointsCorrectedForHeavyness) {
                return new ValidationError("reports.stats.general.maxItemsExceded", maxPointsCorrectedForHeavyness, nDataPoints);
            }
            return null;
        }
    }

    class ItemsCheckedValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -3678161970744028864L;

        ItemsCheckedValidation() {
        }

        @Override
        public ValidationError validate(Object queryObj) {
            int nItems;
            StatisticalQuery query = (StatisticalQuery)queryObj;
            try {
                nItems = query.countItemsChecked();
            }
            catch (IllegalAccessException e) {
                nItems = 0;
            }
            if (nItems == 0) {
                return new ValidationError("global.error.nothingSelected", new Object[0]);
            }
            return null;
        }
    }
}

