/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.reports.StatisticalTaxesQuery;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalServiceImpl;
import nl.strohalm.cyclos.services.stats.StatisticalTaxesService;
import nl.strohalm.cyclos.services.stats.StatisticalTaxesServiceLocal;
import nl.strohalm.cyclos.services.stats.taxes.TaxesPerMemberStats;
import nl.strohalm.cyclos.utils.NamedPeriod;

public class StatisticalTaxesServiceImpl
extends StatisticalServiceImpl
implements StatisticalTaxesServiceLocal {
    @Override
    public StatisticalResultDTO getComparePeriodsMaxMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsMedianPerMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsNumberOfMembers(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsRelativeToGrossProduct(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getComparePeriodsVolume(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getDistributionMedianPerMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getDistributionRelativeToGrossProduct(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodMaxMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodMedianPerMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodNumberOfMembers(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodRelativeToGrossProduct(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getSinglePeriodVolume(StatisticalTaxesQuery query) {
        int rows;
        NamedPeriod periodMain = query.getPeriodMain();
        boolean paid = query.getPaidOrNot() != StatisticalTaxesService.PaidOrNot.NOT_PAID;
        boolean notPaid = query.getPaidOrNot() != StatisticalTaxesService.PaidOrNot.PAID;
        int columns = query.getPaidOrNot() == StatisticalTaxesService.PaidOrNot.BOTH ? 4 : 2;
        Collection<AccountFee> accountFees = this.getInitializedAccountFees(query);
        Collection<TransactionFee> transactionFees = this.getInitializedTransactionFees(query);
        if (accountFees.size() > 0 && transactionFees.size() > 0) {
            ++columns;
        }
        if ((rows = accountFees.size() + transactionFees.size()) > 1) {
            ++rows;
        }
        TaxesPerMemberStats stats = new TaxesPerMemberStats(query, periodMain, this.getTransferDao());
        StatisticalResultDTO result = null;
        String baseKey = "reports.stats.taxes.singlePeriod.totalSum";
        Number[][] tableCells = new Number[rows][columns];
        Currency currency = this.getCurrency(query);
        String[] columnKeys = new String[columns];
        String[] columnSubHeaders = new String[columns];
        int colCounter = 0;
        for (int i = 0; i < rows; ++i) {
            if (paid) {
                tableCells[i][0] = new StatisticalNumber(stats.getSumsPerFee()[i].doubleValue());
                columnKeys[0] = "reports.stats.taxes.paid.paid";
                columnSubHeaders[0] = this.parenthesizeString(currency.getSymbol());
                colCounter = 1;
            }
            if (notPaid) {
                Double notPaidValue = i < accountFees.size() ? Double.valueOf(stats.getNotPaidSumsPerAccountFee()[i].doubleValue()) : null;
                columnKeys[colCounter] = "reports.stats.taxes.paid.notPaid";
                columnSubHeaders[colCounter] = this.parenthesizeString(currency.getSymbol());
                tableCells[i][colCounter++] = notPaidValue;
                if (paid) {
                    Double totalValue = i < accountFees.size() ? Double.valueOf(stats.getSumsPerFee()[i].doubleValue() + stats.getNotPaidSumsPerAccountFee()[i].doubleValue()) : null;
                    columnKeys[colCounter] = "reports.stats.general.sum";
                    columnSubHeaders[colCounter] = this.parenthesizeString(currency.getSymbol());
                    tableCells[i][colCounter++] = new StatisticalNumber(totalValue);
                }
            }
            if (accountFees.size() > 0) {
                Integer numberCharges = i < accountFees.size() ? Integer.valueOf(stats.getNumberOfCharges()[i]) : null;
                columnKeys[colCounter] = "reports.stats.taxes.numberOfCharges";
                columnSubHeaders[colCounter] = "";
                tableCells[i][colCounter++] = new StatisticalNumber(numberCharges);
            }
            if (transactionFees.size() <= 0) continue;
            Integer numberOfTransactions = i >= accountFees.size() ? Integer.valueOf(stats.getNumberOfTransactions()[i]) : null;
            columnKeys[colCounter] = "reports.stats.taxes.numberOfTransactions";
            columnSubHeaders[colCounter] = "";
            tableCells[i][colCounter] = new StatisticalNumber(numberOfTransactions);
        }
        result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("reports.stats.taxes.singlePeriod.totalSum");
        this.passGroupFilter(result, query);
        this.applyRowKeys(result, query);
        result.setColumnKeys(columnKeys);
        result.setColumnSubHeaders(columnSubHeaders);
        result.setYAxisUnits(currency.getSymbol());
        return result;
    }

    @Override
    public StatisticalResultDTO getThroughTimeMaxMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getThroughTimeMedianPerMember(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getThroughTimeNumberOfMembers(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getThroughTimeRelativeToGrossProduct(StatisticalTaxesQuery query) {
        return null;
    }

    @Override
    public StatisticalResultDTO getThroughTimeVolume(StatisticalTaxesQuery query) {
        return null;
    }

    protected Collection<AccountFee> getInitializedAccountFees(StatisticalTaxesQuery query) {
        Collection<AccountFee> accountFees = query.getAccountFees();
        ArrayList<AccountFee> newList = new ArrayList<AccountFee>(accountFees.size());
        boolean anyChanges = false;
        for (AccountFee accountFee : accountFees) {
            if (accountFee.getTransferType() == null) {
                accountFee = this.fetchService.fetch(accountFee, AccountFee.Relationships.TRANSFER_TYPE);
                anyChanges = true;
            }
            newList.add(accountFee);
        }
        if (anyChanges) {
            query.setAccountFees(newList);
        }
        return newList;
    }

    protected Collection<TransactionFee> getInitializedTransactionFees(StatisticalTaxesQuery query) {
        Collection<TransactionFee> transactionFees = query.getTransactionFees();
        ArrayList<TransactionFee> newList = new ArrayList<TransactionFee>(transactionFees.size());
        boolean anyChanges = false;
        for (TransactionFee transactionFee : transactionFees) {
            if (transactionFee.getGeneratedTransferType() == null) {
                transactionFee = this.fetchService.fetch(transactionFee, TransactionFee.Relationships.GENERATED_TRANSFER_TYPE);
                anyChanges = true;
            }
            newList.add(transactionFee);
        }
        if (anyChanges) {
            query.setTransactionFees(newList);
        }
        return newList;
    }

    private void applyRowKeys(StatisticalResultDTO result, StatisticalTaxesQuery query) {
        Collection<AccountFee> accountFees = query.getAccountFees();
        Collection<TransactionFee> transactionFees = query.getTransactionFees();
        int rows = accountFees.size() + transactionFees.size();
        if (rows > 1) {
            ++rows;
        }
        String[] rowKeys = new String[rows];
        for (int i = 0; i < rows - 1; ++i) {
            rowKeys[i] = "";
        }
        if (rows > 1) {
            rowKeys[rows - 1] = "reports.stats.general.sum";
        }
        result.setRowKeys(rowKeys);
        int rowCounter = 0;
        for (AccountFee accountFee : accountFees) {
            result.setRowHeader(accountFee.getTransferType().getName(), rowCounter++);
        }
        for (TransactionFee transactionFee : transactionFees) {
            result.setRowHeader(transactionFee.getGeneratedTransferType().getName(), rowCounter++);
        }
    }
}

