/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.activity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.reports.StatisticalActivityQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.services.stats.taxes.TransferVolumePerMemberStats;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public class GrossProductPerMemberStats
extends TransferVolumePerMemberStats {
    private final Period period;
    private final Collection<? extends Group> groups;
    private final TransferDAO transferDao;
    private final PaymentFilter paymentFilter;

    public GrossProductPerMemberStats(StatisticalActivityQuery queryParameters, Period period, TransferDAO transferDao) {
        this.transferDao = transferDao;
        this.period = period;
        this.groups = queryParameters.getGroups();
        this.paymentFilter = queryParameters.getPaymentFilter();
    }

    public double[] getGrossProductPerTradingMember() {
        List<Number> listGrossProductPerTradingMember = this.getListVolumePerTradingMember();
        return ListOperations.listToArray(listGrossProductPerTradingMember);
    }

    @Override
    public List<Pair<Member, BigDecimal>> getSumOfTransfersPerTrader() {
        StatisticalDTO dto = new StatisticalDTO(this.period, this.paymentFilter, this.groups);
        return this.transferDao.getGrossProductPerMember(dto);
    }
}

