/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.activity;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.access.LoginHistoryDAO;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.reports.StatisticalActivityQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public class LoginTimesPerMemberStats {
    private final LoginHistoryDAO loginHistoryDao;
    private final Period period;
    private final Collection<? extends Group> groups;

    public LoginTimesPerMemberStats(StatisticalActivityQuery queryParameters, Period period, LoginHistoryDAO loginHistoryDao) {
        this.loginHistoryDao = loginHistoryDao;
        this.period = period;
        this.groups = queryParameters.getGroups();
    }

    public List<Number> getListLoginTimes() {
        return ListOperations.getSecondFromPairCollection(this.getLoginTimesPerMember());
    }

    public int[] getLoginTimes() {
        List<Number> listLoginTimes = this.getListLoginTimes();
        return ListOperations.listToIntArray(listLoginTimes);
    }

    public List<Pair<User, Number>> getLoginTimesPerMember() {
        StatisticalDTO dto = new StatisticalDTO(this.period, null, this.groups);
        return this.loginHistoryDao.list(dto);
    }

    public List<Pair<User, Number>> getLoginTimesPerMemberWithoutZeros() {
        List<Pair<User, Number>> result = this.getLoginTimesPerMember();
        List<Number> loginTimes = this.getListLoginTimes();
        int index = loginTimes.indexOf(new Integer(0));
        return result.subList(0, index);
    }
}

