/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.activity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javastat.inference.onesample.OneSampProp;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.reports.StatisticalActivityQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public class TransactionCountPerMemberStats {
    private final PaymentFilter paymentFilter;
    private final TransferDAO transferDao;
    private List<Number> transfersForTraders;
    private final Period period;
    private final Collection<? extends Group> groups;

    public static StatisticalNumber getPercentageNoTraders(int npart, int nfull) {
        StatisticalNumber result = new StatisticalNumber();
        if (nfull >= 15 && nfull > 0) {
            double div = 1.0 - (double)npart / (double)nfull;
            if (nfull - npart > 0) {
                OneSampProp oneSampProp = new OneSampProp(0.05, 0.5, "equal", (double)(nfull - npart), (double)nfull);
                Double lowerBound = oneSampProp.confidenceInterval[0] * 100.0;
                Double upperBound = oneSampProp.confidenceInterval[1] * 100.0;
                result = new StatisticalNumber(div * 100.0, lowerBound, upperBound, new Integer(2).byteValue());
            } else {
                result = new StatisticalNumber(div * 100.0, new Integer(2).byteValue());
            }
        }
        return result;
    }

    public TransactionCountPerMemberStats(StatisticalActivityQuery queryParameters, Period period, TransferDAO transferDao, ElementDAO elementDao) {
        this.period = period;
        this.paymentFilter = queryParameters.getPaymentFilter();
        this.transferDao = transferDao;
        this.groups = queryParameters.getGroups();
    }

    public List<Number> getTransactionCountPerAllMembers(Integer numberOfMembersForPeriod) {
        if (this.transfersForTraders == null) {
            this.getTransactionCountPerTradingMember();
        }
        ArrayList<Number> completeList = new ArrayList<Number>();
        int extra = numberOfMembersForPeriod - this.transfersForTraders.size();
        for (int i = 0; i < extra; ++i) {
            completeList.add(new Integer(0));
        }
        completeList.addAll(this.transfersForTraders);
        return completeList;
    }

    public List<Number> getTransactionCountPerTradingMember() {
        if (this.transfersForTraders == null) {
            List<Pair<Member, Integer>> countByMember = this.getTransfersPerTrader();
            this.transfersForTraders = this.getTransfers(countByMember);
        }
        return this.transfersForTraders;
    }

    public List<Pair<Member, Integer>> getTransfersPerTrader() {
        StatisticalDTO dto = new StatisticalDTO(this.period, this.paymentFilter, this.groups);
        return this.transferDao.getNumberOfTransactionsPerMember(dto);
    }

    private List<Number> getTransfers(List<Pair<Member, Integer>> countByMember) {
        return ListOperations.getSecondNumberFromPairCollection(countByMember);
    }
}

