/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.finances;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.utils.Period;

public abstract class FinanceStats {
    protected Number[][] tableCells;
    protected Collection<PaymentFilter> paymentFilters;
    protected String[] paymentFilterNames;
    private final TransferDAO transferDao;

    protected FinanceStats(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    public String[] getPaymentFilterNames(Collection<PaymentFilter> aPaymentFilters) {
        if (!this.hasEqualParameters(aPaymentFilters) || this.paymentFilterNames == null) {
            this.paymentFilterNames = null;
            ArrayList<String> names = new ArrayList<String>();
            for (PaymentFilter paymentFilter : aPaymentFilters) {
                if (aPaymentFilters.size() == 1) {
                    for (TransferType transferType : paymentFilter.getTransferTypes()) {
                        names.add(transferType.getName());
                    }
                    break;
                }
                names.add(paymentFilter.getName());
            }
            this.paymentFilterNames = names.toArray(new String[0]);
        }
        return this.paymentFilterNames;
    }

    private StatisticalNumber getSumOfTransactions(Period aPeriod, TransferType transferType) {
        StatisticalDTO dto = new StatisticalDTO();
        dto.setPeriod(aPeriod);
        dto.setTransferType(transferType);
        BigDecimal sumOfTransaction = this.transferDao.getSumOfTransactions(dto);
        return new StatisticalNumber(sumOfTransaction.doubleValue(), 2);
    }

    private boolean hasEqualParameters(Collection<PaymentFilter> aPaymentFilters) {
        return this.paymentFilters != null && this.paymentFilters.equals(aPaymentFilters);
    }

    Number getExpenditure(Period aPeriod, PaymentFilter aPaymentFilter, SystemAccountType aSystemAccountFilter) {
        double expenditure = 0.0;
        for (TransferType transferType : aPaymentFilter.getTransferTypes()) {
            expenditure += this.getExpenditure(aPeriod, transferType, aSystemAccountFilter).doubleValue();
        }
        return new StatisticalNumber(expenditure, 2);
    }

    Number getExpenditure(Period aPeriod, TransferType transferType, SystemAccountType aSystemAccountType) {
        if (!transferType.getFrom().equals(aSystemAccountType)) {
            return new StatisticalNumber(0.0, 2);
        }
        return this.getSumOfTransactions(aPeriod, transferType);
    }

    Number getExpenditureRest(Period aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountType) {
        TransferQuery transferQuery = new TransferQuery();
        transferQuery.setFromAccountType(aSystemAccountType);
        transferQuery.setPaymentFilters(aPaymentFilters);
        transferQuery.setPeriod(aPeriod);
        BigDecimal sumOfTransactionsRest = this.transferDao.getSumOfTransactionsRest(transferQuery);
        return new StatisticalNumber(sumOfTransactionsRest.doubleValue(), 2);
    }

    Number getIncome(Period aPeriod, PaymentFilter aPaymentFilter, SystemAccountType aSystemAccountFilter) {
        double income = 0.0;
        for (TransferType transferType : aPaymentFilter.getTransferTypes()) {
            income += this.getIncome(aPeriod, transferType, aSystemAccountFilter).doubleValue();
        }
        return new StatisticalNumber(income, 2);
    }

    Number getIncome(Period aPeriod, TransferType transferType, SystemAccountType aSystemAccountType) {
        if (!transferType.getTo().equals(aSystemAccountType)) {
            return new StatisticalNumber(0.0, 2);
        }
        return this.getSumOfTransactions(aPeriod, transferType);
    }

    Number getIncomeRest(Period aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountType) {
        TransferQuery transferQuery = new TransferQuery();
        transferQuery.setToAccountType(aSystemAccountType);
        transferQuery.setPaymentFilters(aPaymentFilters);
        transferQuery.setPeriod(aPeriod);
        BigDecimal sumOfTransactionsRest = this.transferDao.getSumOfTransactionsRest(transferQuery);
        return new StatisticalNumber(sumOfTransactionsRest.doubleValue(), 2);
    }
}

