/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.finances;

import java.util.Collection;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.services.stats.finances.FinanceStats;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;

public class FinanceStatsComparePeriods
extends FinanceStats {
    public FinanceStatsComparePeriods(TransferDAO transferDao) {
        super(transferDao);
    }

    @Override
    public String[] getPaymentFilterNames(Collection<PaymentFilter> aPaymentFilters) {
        String[] result = super.getPaymentFilterNames(aPaymentFilters);
        this.paymentFilters = aPaymentFilters;
        return result;
    }

    public Number[][] getTableCellsExpenditureComparePeriods(NamedPeriod periodMain, NamedPeriod periodAlt, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        Number[][] tableCells = new Number[aPaymentFilters.size()][3];
        int i = 0;
        for (PaymentFilter paymentFilter : aPaymentFilters) {
            tableCells[i][0] = this.getExpenditure((Period)periodMain, paymentFilter, aSystemAccountFilter);
            tableCells[i][1] = this.getExpenditure((Period)periodAlt, paymentFilter, aSystemAccountFilter);
            tableCells[i][2] = StatisticalNumber.createPercentage(tableCells[i][1], tableCells[i][0]);
            ++i;
        }
        return tableCells;
    }

    public Number[][] getTableCellsIncomeComparePeriods(NamedPeriod periodMain, NamedPeriod periodAlt, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        Number[][] tableCells = new Number[aPaymentFilters.size()][3];
        int i = 0;
        for (PaymentFilter paymentFilter : aPaymentFilters) {
            tableCells[i][0] = this.getIncome((Period)periodMain, paymentFilter, aSystemAccountFilter);
            tableCells[i][1] = this.getIncome((Period)periodAlt, paymentFilter, aSystemAccountFilter);
            tableCells[i][2] = StatisticalNumber.createPercentage(tableCells[i][1], tableCells[i][0]);
            ++i;
        }
        return tableCells;
    }
}

