/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.finances;

import java.util.Collection;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.services.stats.finances.FinanceStats;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;

public class FinanceStatsSinglePeriod
extends FinanceStats {
    private Period period;
    private SystemAccountType systemAccountFilter;

    public FinanceStatsSinglePeriod(TransferDAO transferDao) {
        super(transferDao);
    }

    public Number[][] getTableCellsExpenditureSinglePeriod(NamedPeriod aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        if (!this.hasEqualParameters(aPeriod, aPaymentFilters, aSystemAccountFilter) || this.tableCells == null) {
            this.tableCells = this.getTableCellsOverviewSinglePeriod(aPeriod, aPaymentFilters, aSystemAccountFilter);
        }
        return this.getTableCellsInOrOut(FlowType.EXPENDITURE);
    }

    public Number[][] getTableCellsIncomeSinglePeriod(NamedPeriod aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        if (!this.hasEqualParameters(aPeriod, aPaymentFilters, aSystemAccountFilter) || this.tableCells == null) {
            this.tableCells = this.getTableCellsOverviewSinglePeriod(aPeriod, aPaymentFilters, aSystemAccountFilter);
        }
        return this.getTableCellsInOrOut(FlowType.INCOME);
    }

    public Number[][] getTableCellsOverviewSinglePeriod(Period aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        Number[][] lTableCells = this.tableCells;
        if (!this.hasEqualParameters(aPeriod, aPaymentFilters, aSystemAccountFilter) || this.tableCells == null) {
            if (aPaymentFilters.size() == 1) {
                for (PaymentFilter paymentFilter : aPaymentFilters) {
                    lTableCells = new Number[paymentFilter.getTransferTypes().size() + 2][3];
                    int i = 0;
                    for (TransferType transferType : paymentFilter.getTransferTypes()) {
                        lTableCells[i][0] = this.getIncome(aPeriod, transferType, aSystemAccountFilter);
                        lTableCells[i][1] = this.getExpenditure(aPeriod, transferType, aSystemAccountFilter);
                        ++i;
                    }
                }
            } else {
                lTableCells = new Number[aPaymentFilters.size() + 2][3];
                int i = 0;
                for (PaymentFilter paymentFilter : aPaymentFilters) {
                    lTableCells[i][0] = this.getIncome(aPeriod, paymentFilter, aSystemAccountFilter);
                    lTableCells[i][1] = this.getExpenditure(aPeriod, paymentFilter, aSystemAccountFilter);
                    ++i;
                }
            }
            lTableCells[lTableCells.length - 2][0] = this.getIncomeRest(aPeriod, aPaymentFilters, aSystemAccountFilter);
            lTableCells[lTableCells.length - 2][1] = this.getExpenditureRest(aPeriod, aPaymentFilters, aSystemAccountFilter);
            this.assignRowDifferences(lTableCells);
            this.assignColumnSums(lTableCells);
            this.tableCells = lTableCells;
            this.period = aPeriod;
            this.paymentFilters = aPaymentFilters;
            this.systemAccountFilter = aSystemAccountFilter;
            this.paymentFilterNames = null;
        }
        return lTableCells;
    }

    private void assignColumnSums(Number[][] tableCells) {
        int rows = tableCells.length;
        int cols = tableCells[0].length;
        for (int j = 0; j < cols; ++j) {
            double sum = 0.0;
            for (int i = 0; i < rows - 1; ++i) {
                sum += tableCells[i][j].doubleValue();
            }
            tableCells[rows - 1][j] = new StatisticalNumber(sum, 2);
        }
    }

    private void assignRowDifferences(Number[][] tableCells) {
        int rows = tableCells.length;
        int cols = tableCells[0].length;
        for (int i = 0; i < rows - 1; ++i) {
            double sum = 0.0;
            for (int j = 0; j < cols - 1; ++j) {
                if (j == 0) {
                    sum = tableCells[i][j].doubleValue();
                    continue;
                }
                sum -= tableCells[i][j].doubleValue();
            }
            tableCells[i][cols - 1] = new StatisticalNumber(sum, 2);
        }
    }

    private Number[][] getTableCellsInOrOut(FlowType flowType) {
        int col = 1;
        if (flowType == FlowType.INCOME) {
            col = 0;
        }
        Number[][] lTableCells = new Number[this.tableCells.length - 1][1];
        for (int i = 0; i < lTableCells.length; ++i) {
            lTableCells[i][0] = this.tableCells[i][col];
        }
        return lTableCells;
    }

    private boolean hasEqualParameters(Period aPeriod, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        boolean nulls = false;
        if (this.period == null || this.paymentFilters == null || this.systemAccountFilter == null) {
            nulls = true;
        }
        return !nulls && this.period.equals(aPeriod) && this.systemAccountFilter.equals(aSystemAccountFilter) && this.paymentFilters.equals(aPaymentFilters);
    }

    private static enum FlowType {
        INCOME,
        EXPENDITURE;

    }
}

