/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.finances;

import java.util.Collection;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.services.stats.finances.FinanceStats;
import nl.strohalm.cyclos.utils.Period;

public class FinanceStatsThroughTime
extends FinanceStats {
    public FinanceStatsThroughTime(TransferDAO transferDao) {
        super(transferDao);
    }

    @Override
    public String[] getPaymentFilterNames(Collection<PaymentFilter> aPaymentFilters) {
        String[] result = super.getPaymentFilterNames(aPaymentFilters);
        this.paymentFilters = aPaymentFilters;
        return result;
    }

    public Number[][] getTableCellsExpenditureThroughTime(Period[] periods, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        Number[][] tableCells = new Number[periods.length][aPaymentFilters.size()];
        int i = 0;
        for (Period period : periods) {
            int j = 0;
            for (PaymentFilter paymentFilter : aPaymentFilters) {
                tableCells[i][j] = this.getExpenditure(period, paymentFilter, aSystemAccountFilter);
                ++j;
            }
            ++i;
        }
        return tableCells;
    }

    public Number[][] getTableCellsIncomeThroughTime(Period[] periods, Collection<PaymentFilter> aPaymentFilters, SystemAccountType aSystemAccountFilter) {
        Number[][] tableCells = new Number[periods.length][aPaymentFilters.size()];
        int i = 0;
        for (Period period : periods) {
            int j = 0;
            for (PaymentFilter paymentFilter : aPaymentFilters) {
                tableCells[i][j] = this.getIncome(period, paymentFilter, aSystemAccountFilter);
                ++j;
            }
            ++i;
        }
        return tableCells;
    }
}

