/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.general;

import java.util.ArrayList;
import java.util.List;

public class FilterUsed {
    private final FilterType filterType;
    private final FilterUse filterUse;
    private final List<String> values = new ArrayList<String>(1);

    public static FilterUsed noFilterUsed(FilterType filterType) {
        FilterUsed filterUsed = new FilterUsed(filterType, FilterUse.NOT_USED);
        filterUsed.values.add("reports.stats.general.notUsed");
        return filterUsed;
    }

    public static FilterUsed nothingSelected(FilterType filterType, String nothingSelectedKey) {
        FilterUsed filterUsed = new FilterUsed(filterType, FilterUse.NO_SELECT);
        filterUsed.values.add(nothingSelectedKey);
        return filterUsed;
    }

    private FilterUsed(FilterType filterType, FilterUse filterUse) {
        this.filterType = filterType;
        this.filterUse = filterUse;
    }

    public FilterUsed(FilterType filterType, List<String> names) {
        this(filterType, FilterUse.COLLECTION);
        this.values.addAll(names);
    }

    public FilterUsed(FilterType filterType, String selectedName) {
        this(filterType, FilterUse.ITEM);
        this.values.add(selectedName);
    }

    public void addBlankRows(int rowsToAdd) {
        for (int i = 0; i < rowsToAdd; ++i) {
            this.values.add("&nbsp;");
        }
    }

    public void changeKeyToValue(String key, String message) {
        int index = this.values.indexOf(key);
        this.values.set(index, message);
    }

    public FilterUse getFilterUse() {
        return this.filterUse;
    }

    public String getHeaderKey() {
        return this.filterType.getHeaderKey();
    }

    public List<String> getValues() {
        return this.values;
    }

    public static enum FilterUse {
        DONT_SHOW,
        NOT_USED,
        NO_SELECT,
        ITEM,
        COLLECTION;

    }

    public static enum FilterType {
        SYSTEM_ACCOUNT("reports.stats.systemAccountFilter"),
        GROUP("reports.stats.general.members"),
        PAYMENT("reports.stats.general.payments"),
        PAYMENTS(""),
        PERIOD("reports.stats.general.period");

        String headerKey;

        private FilterType(String key) {
            this.headerKey = key;
        }

        private String getHeaderKey() {
            return this.headerKey;
        }
    }
}

