/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.taxes;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.entities.reports.StatisticalTaxesQuery;
import nl.strohalm.cyclos.services.stats.taxes.TransferVolumePerMemberStats;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;

public class TaxesPerMemberStats
extends TransferVolumePerMemberStats {
    private final Period period;
    private final Collection<? extends Group> groups;
    private final TransferDAO transferDao;
    private final PaymentFilter paymentFilter;

    public TaxesPerMemberStats(StatisticalTaxesQuery queryParameters, Period period, TransferDAO transferDao) {
        this.transferDao = transferDao;
        this.period = period;
        this.groups = queryParameters.getGroups();
        this.paymentFilter = queryParameters.getPaymentFilter();
    }

    public Number[] getNotPaidSumsPerAccountFee() {
        Object[] result = new Number[20];
        Arrays.fill(result, (Object)2.23);
        return result;
    }

    public Integer[] getNumberOfCharges() {
        Object[] result = new Integer[20];
        Arrays.fill(result, (Object)2);
        return result;
    }

    public Integer[] getNumberOfTransactions() {
        Object[] result = new Integer[20];
        Arrays.fill(result, (Object)20935097);
        return result;
    }

    @Override
    public List<Pair<Member, BigDecimal>> getSumOfTransfersPerTrader() {
        StatisticalDTO dto = new StatisticalDTO(this.period, this.paymentFilter, this.groups);
        return this.transferDao.getPaymentsPerMember(dto);
    }

    public Number[] getSumsPerFee() {
        Object[] result = new Number[20];
        Arrays.fill(result, (Object)223907.32);
        return result;
    }
}

