/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.stats.taxes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public abstract class TransferVolumePerMemberStats {
    protected List<Number> sumOfTransfersForTraders;

    protected static List<Number> getSumOfTransfers(List<Pair<Member, BigDecimal>> sumByMember) {
        return ListOperations.getSecondNumberFromPairCollection(sumByMember);
    }

    public List<Number> getListVolumePerAllMembers(Integer numberOfMembersForPeriod) {
        if (this.sumOfTransfersForTraders == null) {
            this.getListVolumePerTradingMember();
        }
        ArrayList<Number> completeList = new ArrayList<Number>();
        int extra = numberOfMembersForPeriod - this.sumOfTransfersForTraders.size();
        for (int i = 0; i < extra; ++i) {
            completeList.add(new Double(0.0));
        }
        completeList.addAll(this.sumOfTransfersForTraders);
        return completeList;
    }

    public List<Number> getListVolumePerTradingMember() {
        if (this.sumOfTransfersForTraders == null) {
            List<Pair<Member, BigDecimal>> sumByMember = this.getSumOfTransfersPerTrader();
            this.sumOfTransfersForTraders = TransferVolumePerMemberStats.getSumOfTransfers(sumByMember);
        }
        return this.sumOfTransfersForTraders;
    }

    public abstract List<Pair<Member, BigDecimal>> getSumOfTransfersPerTrader();

    public double[] getVolumePerAllMembers(Integer numberOfMembersForPeriod) {
        List<Number> listGrossProductPerAllMembers = this.getListVolumePerAllMembers(numberOfMembersForPeriod);
        return ListOperations.listToArray(listGrossProductPerAllMembers);
    }
}

