/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanHandler;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.lang.StringUtils;

public abstract class BaseLoanHandler
implements LoanHandler {
    protected static final float PRECISION_DELTA = 1.0E-4f;
    protected FetchServiceLocal fetchService;
    protected SettingsServiceLocal settingsService;
    protected AccountServiceLocal accountService;
    protected LoanServiceLocal loanService;
    protected PaymentServiceLocal paymentService;
    private final Loan.Type type;

    public BaseLoanHandler(Loan.Type type) {
        this.type = type;
    }

    @Override
    public final Loan buildLoan(GrantLoanDTO params) {
        TransferType transferType = params.getTransferType();
        LoanParameters loanParameters = transferType.getLoan().clone();
        LoanGroup loanGroup = this.fetchService.fetch(params.getLoanGroup(), LoanGroup.Relationships.MEMBERS);
        Loan loan = new Loan();
        loan.setLoanGroup(loanGroup);
        loan.setParameters(loanParameters);
        loan.setToMembers(new ArrayList<Member>());
        if (loanGroup != null) {
            Collection<Member> members = loanGroup.getMembers();
            if (!members.contains(params.getMember())) {
                throw new UnexpectedEntityException();
            }
            loan.getToMembers().addAll(members);
        } else {
            loan.getToMembers().add(params.getMember());
        }
        this.processGrant(loan, params);
        return loan;
    }

    @Override
    public List<TransferDTO> buildTransfersForRepayment(RepayLoanDTO dto, LoanRepaymentAmountsDTO paymentDto) {
        Loan loan = dto.getLoan();
        LoanPayment payment = loan.getFirstOpenPayment();
        LoanParameters parameters = loan.getTransfer().getType().getLoan();
        TransferType repaymentType = parameters.getRepaymentType();
        TransferDTO transfer = new TransferDTO();
        transfer.setCustomValues(dto.getCustomValues());
        transfer.setAutomatic(true);
        if (dto.getDate() != null) {
            transfer.setDate(dto.getDate());
        }
        if (LoggedUser.member() == null) {
            transfer.setFrom(this.accountService.getAccount(new AccountDTO(loan.getMember(), repaymentType.getFrom()), new Relationship[0]));
        } else {
            transfer.setFrom(this.accountService.getAccount(new AccountDTO(LoggedUser.member(), repaymentType.getFrom()), new Relationship[0]));
        }
        transfer.setTo(this.accountService.getAccount(new AccountDTO(SystemAccountOwner.instance(), repaymentType.getTo()), new Relationship[0]));
        transfer.setAmount(dto.getAmount());
        transfer.setTransferType(repaymentType);
        transfer.setLoanPayment(payment);
        transfer.setDescription(this.buildDescriptionForRepayment(repaymentType, payment));
        return Collections.singletonList(transfer);
    }

    public Loan.Type getType() {
        return this.type;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    protected String buildDescriptionForRepayment(TransferType repaymentType, LoanPayment payment) {
        String description = StringUtils.trimToEmpty((String)repaymentType.getDescription());
        UnitsConverter uc = this.settingsService.getLocalSettings().getUnitsConverter(repaymentType.getFrom().getCurrency().getPattern());
        Loan loan = payment.getLoan();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("loanAmount", uc.toString(loan.getTransfer().getAmount()));
        values.put("loanTotalAmount", uc.toString(loan.getTotalAmount()));
        values.put("paymentAmount", uc.toString(payment.getAmount()));
        values.put("paymentNumber", String.valueOf(payment.getIndex()));
        return MessageProcessingHelper.processVariables(description, values);
    }

    protected abstract void processGrant(Loan var1, GrantLoanDTO var2);
}

