/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.BaseLoanHandler;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.utils.DateHelper;

public abstract class BaseMultiplePaymentLoanHandler
extends BaseLoanHandler {
    public BaseMultiplePaymentLoanHandler(Loan.Type type) {
        super(type);
    }

    @Override
    public List<LoanPayment> calculatePaymentProjection(ProjectionDTO params) {
        BigDecimal paymentAmount;
        BigDecimal lastPaymentAmount;
        int paymentCount = params.getPaymentCount();
        BigDecimal amount = this.retrieveTotalAmount(params);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MathContext mathContext = localSettings.getMathContext();
        if (paymentCount == 1) {
            paymentAmount = lastPaymentAmount = amount;
        } else {
            paymentAmount = localSettings.round(amount.divide(new BigDecimal(paymentCount), mathContext));
            lastPaymentAmount = amount.subtract(paymentAmount.multiply(new BigDecimal(paymentCount - 1)));
        }
        Calendar firstDate = DateHelper.truncate(params.getFirstExpirationDate());
        ArrayList<LoanPayment> payments = new ArrayList<LoanPayment>();
        for (int i = 0; i < paymentCount; ++i) {
            LoanPayment loanPayment = new LoanPayment();
            loanPayment.setIndex(i);
            loanPayment.setStatus(LoanPayment.Status.OPEN);
            Calendar expiration = (Calendar)firstDate.clone();
            expiration.add(2, i);
            loanPayment.setExpirationDate(expiration);
            if (i == paymentCount - 1) {
                loanPayment.setAmount(lastPaymentAmount);
            } else {
                loanPayment.setAmount(paymentAmount);
            }
            payments.add(loanPayment);
        }
        return payments;
    }

    protected BigDecimal retrieveTotalAmount(ProjectionDTO params) {
        return params.getAmount();
    }
}

