/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.InvoiceDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.InvoicePaymentDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoicePayment;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceSummaryDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.reports.InvoiceSummaryType;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.transaction.TransactionStatus;

public class InvoiceServiceImpl
implements InvoiceServiceLocal,
InitializingService {
    private InvoiceDAO invoiceDao;
    private InvoicePaymentDAO invoicePaymentDao;
    private PaymentServiceLocal paymentService;
    private SettingsServiceLocal settingsService;
    private TransferTypeServiceLocal transferTypeService;
    private FetchServiceLocal fetchService;
    private AccountTypeServiceLocal accountTypeService;
    private AlertServiceLocal alertService;
    private MessageResolver messageResolver;
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private MemberNotificationHandler memberNotificationHandler;
    private AdminNotificationHandler adminNotificationHandler;
    private TransactionHelper transactionHelper;
    private PermissionServiceLocal permissionService;

    @Override
    public Invoice accept(Invoice inputInvoice) throws NotEnoughCreditsException, UpperCreditLimitReachedException, MaxAmountPerDayExceededException, UnexpectedEntityException {
        InvoicePayment invoicePayment;
        TransferType inputTransferType = inputInvoice.getTransferType();
        final Invoice invoice = this.fetchService.fetch(inputInvoice, new Relationship[0]);
        if (invoice.getStatus() != Invoice.Status.OPEN) {
            throw new UnexpectedEntityException();
        }
        if (invoice.getTransferType() != null) {
            inputTransferType = invoice.getTransferType();
        }
        final TransferType transferType = inputTransferType;
        final Object performedBy = LoggedUser.hasUser() ? LoggedUser.element() : null;
        List<TransferType> possibleTypes = this.getPossibleTransferTypes(invoice);
        if (!possibleTypes.contains(transferType)) {
            throw new UnexpectedEntityException();
        }
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        if (CollectionUtils.isNotEmpty(invoice.getPayments()) && (invoicePayment = invoice.getPayments().get(0)).getDate().before(today)) {
            throw new UnexpectedEntityException();
        }
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Invoice>(){

            @Override
            public Invoice afterCommit(Invoice result) {
                return InvoiceServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Invoice doInTransaction(TransactionStatus status) {
                return InvoiceServiceImpl.this.doAccept(invoice, transferType, performedBy);
            }
        });
    }

    @Override
    public int alertExpiredSystemInvoices(Calendar time) {
        AlertSettings alertSettings = this.settingsService.getAlertSettings();
        TimePeriod tp = alertSettings.getIdleInvoiceExpiration();
        if (tp == null || tp.getNumber() <= 0) {
            return 0;
        }
        Calendar limit = tp.remove(DateHelper.truncate(time));
        int processed = 0;
        InvoiceQuery query = new InvoiceQuery();
        query.fetch(RelationshipHelper.nested(Invoice.Relationships.DESTINATION_ACCOUNT_TYPE, AccountType.Relationships.CURRENCY), Invoice.Relationships.TO_MEMBER);
        query.setOwner(SystemAccountOwner.instance());
        query.setDirection(InvoiceQuery.Direction.OUTGOING);
        query.setPeriod(Period.endingAt(limit));
        query.setStatus(Invoice.Status.OPEN);
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        List<Invoice> invoices = this.search(query);
        if (!invoices.isEmpty()) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            NumberConverter<BigDecimal> numberConverter = localSettings.getNumberConverter();
            CalendarConverter dateTimeConverter = localSettings.getDateTimeConverter();
            for (Invoice invoice : invoices) {
                String amount = invoice.getDestinationAccountType() != null ? localSettings.getUnitsConverter(invoice.getDestinationAccountType().getCurrency().getPattern()).toString(invoice.getAmount()) : numberConverter.toString(invoice.getAmount());
                String date = dateTimeConverter.toString(invoice.getDate());
                this.alertService.create(invoice.getToMember(), MemberAlert.Alerts.INVOICE_IDLE_TIME_EXCEEDED, amount, date);
                invoice.setStatus(Invoice.Status.EXPIRED);
                this.invoiceDao.update(invoice);
                ++processed;
            }
        }
        return processed;
    }

    @Override
    public boolean canAccept(Invoice invoice) {
        if (!this.testAction(invoice, true)) {
            return false;
        }
        boolean asUser = false;
        if (invoice.isToSystem()) {
            if (!this.permissionService.hasPermission(AdminMemberPermission.INVOICES_ACCEPT)) {
                return false;
            }
        } else {
            Member member = invoice.getToMember();
            if (invoice.isFromSystem() ? !this.permissionService.permission(member).admin(AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM).broker(BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).hasPermission() : !this.permissionService.permission(member).admin(AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER).broker(BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).hasPermission()) {
                return false;
            }
            asUser = !ObjectUtils.equals((Object)LoggedUser.member(), (Object)member);
        }
        return this.hasTTPermission(invoice, asUser);
    }

    @Override
    public boolean canCancel(Invoice invoice) {
        if (!this.testAction(invoice, false)) {
            return false;
        }
        if (invoice.isFromSystem()) {
            return this.permissionService.hasPermission(AdminMemberPermission.INVOICES_CANCEL);
        }
        return this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_CANCEL_AS_MEMBER).broker(BrokerPermission.INVOICES_CANCEL_AS_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).hasPermission();
    }

    @Override
    public Invoice cancel(Invoice invoice) throws UnexpectedEntityException {
        if (invoice.getStatus() != Invoice.Status.OPEN) {
            throw new UnexpectedEntityException();
        }
        Object performedBy = LoggedUser.hasUser() ? LoggedUser.element() : null;
        invoice.setPerformedBy((Element)performedBy);
        invoice.setStatus(Invoice.Status.CANCELLED);
        invoice = this.invoiceDao.update(invoice);
        this.memberNotificationHandler.cancelledInvoiceNotification(invoice);
        return invoice;
    }

    @Override
    public boolean canDeny(Invoice invoice) {
        if (!this.testAction(invoice, true)) {
            return false;
        }
        boolean asUser = false;
        if (invoice.isToSystem()) {
            if (!this.permissionService.hasPermission(AdminMemberPermission.INVOICES_DENY)) {
                return false;
            }
        } else {
            if (invoice.isFromSystem()) {
                return false;
            }
            Member member = invoice.getToMember();
            if (!this.permissionService.permission(member).admin(AdminMemberPermission.INVOICES_DENY_AS_MEMBER).broker(BrokerPermission.INVOICES_DENY_AS_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).hasPermission()) {
                return false;
            }
            asUser = !ObjectUtils.equals((Object)LoggedUser.member(), (Object)member);
        }
        return this.hasTTPermission(invoice, asUser);
    }

    @Override
    public Invoice deny(Invoice invoice) throws UnexpectedEntityException {
        if (invoice.getStatus() != Invoice.Status.OPEN) {
            throw new UnexpectedEntityException();
        }
        Object performedBy = LoggedUser.hasUser() ? LoggedUser.element() : null;
        invoice.setPerformedBy((Element)performedBy);
        invoice.setStatus(Invoice.Status.DENIED);
        invoice = this.invoiceDao.update(invoice);
        AlertSettings alertSettings = this.settingsService.getAlertSettings();
        if (alertSettings.getAmountDeniedInvoices() > 0) {
            Member toMember = invoice.getToMember();
            InvoiceQuery invoiceQuery = new InvoiceQuery();
            invoiceQuery.setDirection(InvoiceQuery.Direction.INCOMING);
            invoiceQuery.setOwner(toMember);
            invoiceQuery.setStatus(Invoice.Status.DENIED);
            invoiceQuery.setPageForCount();
            int deniedInvoices = PageHelper.getTotalCount(this.invoiceDao.search(invoiceQuery));
            if (deniedInvoices >= alertSettings.getAmountDeniedInvoices()) {
                boolean hasAlert;
                AlertQuery query = new AlertQuery();
                query.setType(Alert.Type.MEMBER);
                query.setMember(toMember);
                query.setKey(MemberAlert.Alerts.DENIED_INVOICES.getValue());
                query.setPageForCount();
                boolean bl = hasAlert = PageHelper.getTotalCount(this.alertService.search(query)) > 0;
                if (!hasAlert) {
                    this.alertService.create(toMember, MemberAlert.Alerts.DENIED_INVOICES, deniedInvoices);
                }
            }
        }
        this.memberNotificationHandler.deniedInvoiceNotification(invoice);
        return invoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireScheduledInvoices(Calendar time) {
        InvoiceQuery query = new InvoiceQuery();
        query.fetch(RelationshipHelper.nested(Invoice.Relationships.DESTINATION_ACCOUNT_TYPE, AccountType.Relationships.CURRENCY));
        query.setPaymentPeriod(Period.endingAt(DateHelper.truncatePreviosDay(time)));
        query.setDirection(InvoiceQuery.Direction.OUTGOING);
        query.setStatus(Invoice.Status.OPEN);
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        List<Invoice> invoices = this.search(query);
        try {
            for (Invoice invoice : invoices) {
                invoice.setStatus(Invoice.Status.EXPIRED);
                this.invoiceDao.update(invoice);
                this.memberNotificationHandler.expiredInvoiceNotification(invoice);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(invoices);
        }
    }

    public Validator getCalculateValidator() {
        Validator calculateValidator = new Validator("invoice");
        calculateValidator.property("amount").required().positiveNonZero();
        calculateValidator.property("paymentCount").required().positiveNonZero();
        calculateValidator.property("firstExpirationDate").required().futureOrToday();
        calculateValidator.property("recurrence.number").required().positiveNonZero();
        calculateValidator.property("recurrence.field").required();
        return calculateValidator;
    }

    @Override
    public List<TransferType> getPossibleTransferTypes(Invoice invoice) {
        if (invoice.isPersistent()) {
            invoice = this.fetchService.fetch(invoice, new Relationship[0]);
        }
        if (invoice.getTransferType() != null) {
            return Collections.singletonList(invoice.getTransferType());
        }
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.fetch(TransferType.Relationships.CUSTOM_FIELDS);
        ttQuery.setChannel("web");
        ttQuery.setContext(TransactionContext.PAYMENT);
        ttQuery.setFromOwner(invoice.getTo());
        ttQuery.setToOwner(invoice.getFrom());
        ttQuery.setToAccountType(invoice.getDestinationAccountType());
        ttQuery.setUsePriority(true);
        if (CollectionUtils.isNotEmpty(invoice.getPayments())) {
            ttQuery.setSchedulable(true);
        }
        if (invoice.isToSystem()) {
            if (LoggedUser.hasUser()) {
                ttQuery.setGroup((Group)LoggedUser.group());
            }
        } else {
            ttQuery.setGroup(invoice.getToMember().getGroup());
        }
        return this.transferTypeService.search(ttQuery);
    }

    @Override
    public TransactionSummaryVO getSummary(InvoiceSummaryDTO dto) {
        return this.invoiceDao.getSummary(dto);
    }

    @Override
    public TransactionSummaryVO getSummaryByType(Currency currency, InvoiceSummaryType invoiceSummaryType) {
        Collection<MemberGroup> memberGroups = null;
        if (LoggedUser.hasUser()) {
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS);
            memberGroups = adminGroup.getManagesGroups();
        }
        return this.invoiceDao.getSummaryByType(currency, invoiceSummaryType, memberGroups);
    }

    @Override
    public void initializeService() {
        Calendar time = Calendar.getInstance();
        this.expireScheduledInvoices(time);
        this.alertExpiredSystemInvoices(time);
    }

    public List<Invoice> listFromMember(Member member) {
        InvoiceQuery query = new InvoiceQuery();
        query.setDirection(InvoiceQuery.Direction.OUTGOING);
        query.setOwner(member);
        query.setStatus(Invoice.Status.OPEN);
        return this.invoiceDao.search(query);
    }

    public List<Invoice> listToMember(Member member) {
        InvoiceQuery query = new InvoiceQuery();
        query.setDirection(InvoiceQuery.Direction.INCOMING);
        query.setOwner(member);
        query.setStatus(Invoice.Status.OPEN);
        return this.invoiceDao.search(query);
    }

    @Override
    public Invoice load(Long id, Relationship ... fetch) {
        return (Invoice)this.invoiceDao.load(id, fetch);
    }

    @Override
    public Invoice loadByPayment(Payment payment, Relationship ... fetch) {
        return this.invoiceDao.loadByPayment(payment, fetch);
    }

    @Override
    public List<Invoice> search(InvoiceQuery queryParameters) {
        return this.invoiceDao.search(queryParameters);
    }

    @Override
    public Invoice send(Invoice invoice) throws UnexpectedEntityException {
        this.preprocessInvoice(invoice);
        this.validate(invoice);
        return this.doSend(invoice, false);
    }

    @Override
    public Invoice sendAutomatically(Invoice invoice) {
        this.preprocessInvoice(invoice);
        return this.doSend(invoice, true);
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setInvoiceDao(InvoiceDAO invoiceDao) {
        this.invoiceDao = invoiceDao;
    }

    public void setInvoicePaymentDao(InvoicePaymentDAO invoicePaymentDao) {
        this.invoicePaymentDao = invoicePaymentDao;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(Invoice invoice) {
        this.getValidator(invoice).validate(invoice);
    }

    @Override
    public void validateForAccept(Invoice invoice) {
        this.getAcceptValidator().validate(invoice);
    }

    public void validateForCalculation(ProjectionDTO dto) {
        this.getCalculateValidator().validate(dto);
    }

    private Invoice doAccept(Invoice invoice, TransferType transferType, Element performedBy) {
        invoice = this.fetchService.reload(invoice, new Relationship[0]);
        performedBy = this.fetchService.reload(performedBy, new Relationship[0]);
        transferType = this.fetchService.reload(transferType, new Relationship[0]);
        TransferDTO dto = new TransferDTO();
        dto.setAutomatic(true);
        dto.setFromOwner(invoice.getTo());
        dto.setToOwner(invoice.getFrom());
        dto.setBy(performedBy);
        dto.setTransferType(transferType);
        dto.setAmount(invoice.getAmount());
        if (invoice.getSentBy() instanceof Operator) {
            dto.setReceiver(invoice.getSentBy());
        }
        dto.setDescription(invoice.getDescription());
        dto.setAccountFeeLog(invoice.getAccountFeeLog());
        dto.setCustomValues(new ArrayList<PaymentCustomFieldValue>());
        for (PaymentCustomFieldValue fieldValue : invoice.getCustomValues()) {
            PaymentCustomFieldValue transferValue = new PaymentCustomFieldValue();
            transferValue.setField(fieldValue.getField());
            transferValue.setValue(fieldValue.getValue());
            dto.getCustomValues().add(transferValue);
        }
        if (CollectionUtils.isNotEmpty(invoice.getPayments())) {
            dto.setShowScheduledToReceiver(true);
            ArrayList<ScheduledPaymentDTO> payments = new ArrayList<ScheduledPaymentDTO>();
            for (InvoicePayment invoicePayment : invoice.getPayments()) {
                ScheduledPaymentDTO scheduledPaymentDTO = new ScheduledPaymentDTO();
                scheduledPaymentDTO.setAmount(invoicePayment.getAmount());
                scheduledPaymentDTO.setDate(invoicePayment.getDate());
                payments.add(scheduledPaymentDTO);
            }
            dto.setPayments(payments);
        }
        Payment payment = this.paymentService.insertWithoutNotification(dto);
        invoice.setPayment(payment);
        invoice.setStatus(Invoice.Status.ACCEPTED);
        invoice.setPerformedBy(performedBy);
        invoice = this.invoiceDao.update(invoice);
        if (payment instanceof ScheduledPayment) {
            ScheduledPayment scheduledPayment = (ScheduledPayment)payment;
            Iterator<InvoicePayment> invoicePaymentsIterator = invoice.getPayments().iterator();
            Iterator<Transfer> transfersIterator = scheduledPayment.getTransfers().iterator();
            while (invoicePaymentsIterator.hasNext()) {
                InvoicePayment invoicePayment = invoicePaymentsIterator.next();
                Transfer transfer = transfersIterator.next();
                invoicePayment.setTransfer(transfer);
                this.invoicePaymentDao.update(invoicePayment);
            }
        }
        this.memberNotificationHandler.acceptedInvoiceNotification(invoice);
        return invoice;
    }

    private Invoice doSend(Invoice invoice, boolean automatic) {
        this.validate(invoice);
        TransferType transferType = this.fetchService.fetch(invoice.getTransferType(), TransferType.Relationships.TO);
        List<InvoicePayment> payments = invoice.getPayments();
        if (transferType != null) {
            TransferTypeQuery ttQuery = new TransferTypeQuery();
            if (!automatic) {
                ttQuery.setContext(TransactionContext.PAYMENT);
            } else {
                ttQuery.setContext(TransactionContext.AUTOMATIC);
            }
            ttQuery.setFromOwner(invoice.getTo());
            ttQuery.setToOwner(invoice.getFrom());
            List<TransferType> possibleTypes = this.transferTypeService.search(ttQuery);
            if (!possibleTypes.contains(transferType)) {
                throw new UnexpectedEntityException();
            }
            invoice.setDestinationAccountType(transferType.getTo());
        } else {
            AccountType destinationAccountType = this.fetchService.fetch(invoice.getDestinationAccountType(), new Relationship[0]);
            MemberAccountTypeQuery atQuery = new MemberAccountTypeQuery();
            atQuery.setCanPay(invoice.getTo());
            atQuery.setOwner(invoice.getFromMember());
            List<? extends AccountType> possibleTypes = this.accountTypeService.search(atQuery);
            if (!possibleTypes.contains(destinationAccountType)) {
                throw new UnexpectedEntityException();
            }
        }
        Collection<PaymentCustomFieldValue> customValues = invoice.getCustomValues();
        invoice = this.invoiceDao.insert(invoice);
        invoice.setCustomValues(customValues);
        this.paymentCustomFieldService.saveValues(invoice);
        if (CollectionUtils.isNotEmpty(payments)) {
            for (InvoicePayment payment : payments) {
                payment.setInvoice(invoice);
                this.invoicePaymentDao.insert(payment);
            }
        }
        if (invoice.isToSystem()) {
            this.adminNotificationHandler.notifySystemInvoice(invoice);
        } else {
            this.memberNotificationHandler.receivedInvoiceNotification(invoice);
        }
        return invoice;
    }

    private Validator getAcceptValidator() {
        Validator acceptValidator = new Validator("invoice");
        acceptValidator.property("id").required().positiveNonZero();
        acceptValidator.property("transferType").required();
        return acceptValidator;
    }

    private Validator getValidator(Invoice invoice) {
        Validator validator = new Validator("invoice");
        validator.property("from").required();
        validator.property("to").add(new PropertyValidation(){
            private static final long serialVersionUID = -5222363482447066104L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                Invoice invoice = (Invoice)object;
                if (invoice.getFrom() != null && invoice.getTo() != null && invoice.getFrom().equals(invoice.getTo())) {
                    return new InvalidError();
                }
                return null;
            }
        });
        validator.property("description").required().maxLength(1000);
        validator.property("amount").required().positiveNonZero();
        if (LoggedUser.hasUser()) {
            boolean asMember;
            boolean bl = asMember = !LoggedUser.accountOwner().equals(invoice.getFrom());
            if (asMember || LoggedUser.isMember() || LoggedUser.isOperator()) {
                validator.property("destinationAccountType").required();
            } else {
                validator.property("transferType").required();
            }
        }
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = 4085922259108191939L;

            @Override
            public ValidationError validate(Object object) {
                Invoice invoice = (Invoice)object;
                List<InvoicePayment> payments = invoice.getPayments();
                if (CollectionUtils.isEmpty(payments)) {
                    return null;
                }
                Member fromMember = invoice.getFromMember();
                if (fromMember == null && LoggedUser.isMember()) {
                    fromMember = (Member)LoggedUser.element();
                }
                Calendar maxPaymentDate = null;
                if (fromMember != null) {
                    fromMember = InvoiceServiceImpl.this.fetchService.fetch(fromMember, RelationshipHelper.nested(Element.Relationships.GROUP));
                    MemberGroup group = fromMember.getMemberGroup();
                    int maxSchedulingPayments = group.getMemberSettings().getMaxSchedulingPayments();
                    if (payments.size() > maxSchedulingPayments) {
                        return new ValidationError("errors.greaterEquals", InvoiceServiceImpl.this.messageResolver.message("transfer.paymentCount", new Object[0]), maxSchedulingPayments);
                    }
                    TimePeriod maxSchedulingPeriod = group.getMemberSettings().getMaxSchedulingPeriod();
                    if (maxSchedulingPeriod != null) {
                        maxPaymentDate = maxSchedulingPeriod.add(DateHelper.truncate(Calendar.getInstance()));
                    }
                }
                BigDecimal invoiceAmount = invoice.getAmount();
                BigDecimal minimumPayment = InvoiceServiceImpl.this.paymentService.getMinimumPayment();
                BigDecimal totalAmount = BigDecimal.ZERO;
                Calendar lastDate = DateHelper.truncate(Calendar.getInstance());
                for (InvoicePayment payment : payments) {
                    Calendar date = payment.getDate();
                    if (maxPaymentDate != null && date.after(maxPaymentDate)) {
                        LocalSettings localSettings = InvoiceServiceImpl.this.settingsService.getLocalSettings();
                        CalendarConverter dateConverter = localSettings.getRawDateConverter();
                        return new ValidationError("payment.invalid.schedulingDate", dateConverter.toString(maxPaymentDate));
                    }
                    BigDecimal amount = payment.getAmount();
                    if (amount == null || amount.compareTo(minimumPayment) < 0) {
                        return new RequiredError(InvoiceServiceImpl.this.messageResolver.message("transfer.amount", new Object[0]));
                    }
                    if (date == null) {
                        return new RequiredError(InvoiceServiceImpl.this.messageResolver.message("transfer.date", new Object[0]));
                    }
                    if (date.before(lastDate)) {
                        return new ValidationError("invoice.invalid.paymentDates", new Object[0]);
                    }
                    totalAmount = totalAmount.add(amount);
                    lastDate = date;
                }
                if (invoiceAmount != null && totalAmount.compareTo(invoiceAmount) != 0) {
                    return new ValidationError("invoice.invalid.paymentAmount", new Object[0]);
                }
                return null;
            }
        });
        final List<TransferType> possibleTransferTypes = this.getPossibleTransferTypes(invoice);
        if (possibleTransferTypes.size() == 1) {
            validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                @Override
                public Validator getValidator() {
                    TransferType transferType = (TransferType)possibleTransferTypes.iterator().next();
                    return InvoiceServiceImpl.this.paymentCustomFieldService.getValueValidator(transferType);
                }
            }));
        }
        return validator;
    }

    private boolean hasTTPermission(Invoice invoice, boolean asUser) {
        TransferType transferType = invoice.getTransferType();
        if (transferType != null && !transferType.getContext().isPayment()) {
            return true;
        }
        Relationship fetch = (Relationship)((Object)(asUser ? AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER : Group.Relationships.TRANSFER_TYPES));
        List ttsWithPermission = (List)PropertyHelper.get(this.fetchService.fetch(LoggedUser.group(), new Relationship[]{fetch}), fetch.getName());
        List<TransferType> possibleTransferTypes = this.getPossibleTransferTypes(invoice);
        return CollectionUtils.containsAny(possibleTransferTypes, (Collection)ttsWithPermission);
    }

    private void preprocessInvoice(Invoice invoice) {
        if (LoggedUser.hasUser()) {
            if (invoice.getFrom() == null) {
                invoice.setFrom(LoggedUser.accountOwner());
            }
            invoice.setSentBy((Element)LoggedUser.element());
        }
        if (invoice.getDate() == null) {
            invoice.setDate(Calendar.getInstance());
        }
        invoice.setStatus(Invoice.Status.OPEN);
    }

    private boolean testAction(Invoice invoice, boolean shouldBeIncoming) {
        if (!invoice.isOpen()) {
            return false;
        }
        AccountOwner owner = shouldBeIncoming ? invoice.getTo() : invoice.getFrom();
        if (owner instanceof SystemAccountOwner) {
            return LoggedUser.isAdministrator();
        }
        return this.permissionService.manages((Member)owner);
    }
}

