/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.transactions.InvoiceService;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class InvoiceServiceSecurity
extends BaseServiceSecurity
implements InvoiceService {
    private InvoiceServiceLocal invoiceService;

    @Override
    public Invoice accept(Invoice inputInvoice) throws NotEnoughCreditsException, UpperCreditLimitReachedException, MaxAmountPerDayExceededException, UnexpectedEntityException {
        Invoice invoice = this.fetch(inputInvoice);
        if (invoice.isToSystem()) {
            this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_ACCEPT).check();
        } else if (invoice.isFromSystem()) {
            this.permissionService.permission(invoice.getToMember()).admin(AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM).broker(BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).check();
        } else {
            this.permissionService.permission(invoice.getToMember()).admin(AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER).broker(BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).check();
        }
        return this.invoiceService.accept(inputInvoice);
    }

    @Override
    public boolean canAccept(Invoice invoice) {
        return this.invoiceService.canAccept(invoice);
    }

    @Override
    public boolean canCancel(Invoice invoice) {
        return this.invoiceService.canCancel(invoice);
    }

    @Override
    public Invoice cancel(Invoice invoice) throws UnexpectedEntityException {
        if ((invoice = this.fetch(invoice)).isFromSystem()) {
            this.permissionService.permission(invoice.getToMember()).admin(AdminMemberPermission.INVOICES_CANCEL).check();
        } else {
            this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_CANCEL_AS_MEMBER).broker(BrokerPermission.INVOICES_CANCEL_AS_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).check();
        }
        return this.invoiceService.cancel(invoice);
    }

    @Override
    public boolean canDeny(Invoice invoice) {
        return this.invoiceService.canDeny(invoice);
    }

    @Override
    public Invoice deny(Invoice invoice) throws UnexpectedEntityException, PermissionDeniedException {
        if ((invoice = this.fetch(invoice)).isToSystem()) {
            this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_DENY).check();
        } else {
            if (invoice.isFromSystem()) {
                throw new PermissionDeniedException();
            }
            this.permissionService.permission(invoice.getToMember()).admin(AdminMemberPermission.INVOICES_DENY_AS_MEMBER).broker(BrokerPermission.INVOICES_DENY_AS_MEMBER).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_MANAGE).check();
        }
        return this.invoiceService.deny(invoice);
    }

    @Override
    public List<TransferType> getPossibleTransferTypes(Invoice invoice) {
        invoice = this.fetch(invoice);
        this.checkView(invoice);
        return this.invoiceService.getPossibleTransferTypes(invoice);
    }

    @Override
    public Invoice load(Long id, Relationship ... fetch) {
        Invoice invoice = this.invoiceService.load(id, this.addToFetch(fetch, Invoice.Relationships.FROM_MEMBER, Invoice.Relationships.TO_MEMBER));
        this.checkView(invoice);
        return invoice;
    }

    @Override
    public List<Invoice> search(InvoiceQuery query) {
        AccountOwner owner = query.getOwner();
        if (owner == null) {
            throw new ValidationException();
        }
        if (owner instanceof SystemAccountOwner) {
            this.permissionService.permission().admin(AdminMemberPermission.INVOICES_VIEW).check();
        } else {
            this.permissionService.permission((Member)owner).admin(AdminMemberPermission.INVOICES_VIEW).broker(BrokerPermission.INVOICES_VIEW).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_VIEW).check();
        }
        Member relatedMember = query.getRelatedMember();
        if (relatedMember != null) {
            this.permissionService.checkRelatesTo(relatedMember);
        }
        if (LoggedUser.isAdministrator()) {
            query.setGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), query.getGroups()));
        }
        return this.invoiceService.search(query);
    }

    @Override
    public Invoice send(Invoice invoice) throws UnexpectedEntityException {
        if (invoice.isFromSystem()) {
            Member toMember = invoice.getToMember();
            if (toMember == null) {
                throw new ValidationException();
            }
            this.permissionService.permission(toMember).admin(AdminMemberPermission.INVOICES_SEND).check();
        } else if (invoice.isToSystem()) {
            this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM).broker(BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM).member(MemberPermission.INVOICES_SEND_TO_SYSTEM).operator(OperatorPermission.INVOICES_SEND_TO_SYSTEM).check();
        } else {
            this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER).broker(BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER).member(MemberPermission.INVOICES_SEND_TO_MEMBER).operator(OperatorPermission.INVOICES_SEND_TO_MEMBER).check();
            this.permissionService.checkRelatesTo(invoice.getToMember());
        }
        return this.invoiceService.send(invoice);
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Override
    public void validate(Invoice invoice) {
        this.invoiceService.validate(invoice);
    }

    @Override
    public void validateForAccept(Invoice invoice) {
        this.invoiceService.validateForAccept(invoice);
    }

    private void checkView(Invoice invoice) {
        boolean manageFrom = invoice.isFromSystem() ? this.permissionService.permission().admin(AdminMemberPermission.INVOICES_VIEW).hasPermission() : this.permissionService.permission(invoice.getFromMember()).admin(AdminMemberPermission.INVOICES_VIEW).broker(BrokerPermission.INVOICES_VIEW).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_VIEW).hasPermission();
        if (manageFrom) {
            return;
        }
        boolean manageTo = invoice.isToSystem() ? this.permissionService.permission().admin(AdminMemberPermission.INVOICES_VIEW).hasPermission() : this.permissionService.permission(invoice.getToMember()).admin(AdminMemberPermission.INVOICES_VIEW).broker(BrokerPermission.INVOICES_VIEW).member(new MemberPermission[0]).operator(OperatorPermission.INVOICES_VIEW).hasPermission();
        if (!manageTo) {
            throw new PermissionDeniedException();
        }
    }

    private Invoice fetch(Invoice invoice) {
        invoice = this.fetchService.fetch(invoice, Invoice.Relationships.TO_MEMBER, Invoice.Relationships.FROM_MEMBER);
        return invoice;
    }
}

