/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;

public interface LoanService
extends Service {
    public List<LoanPayment> calculatePaymentProjection(ProjectionDTO var1);

    public LoanRepaymentAmountsDTO getLoanPaymentAmount(LoanPaymentDTO var1);

    public LoanPayment discard(LoanPaymentDTO var1) throws UnexpectedEntityException;

    public Loan grant(GrantLoanDTO var1) throws CreditsException, AuthorizedPaymentInPastException;

    public Loan load(Long var1, Relationship ... var2);

    public TransactionSummaryVO loanSummary(Member var1);

    public Loan markAsInProcess(Loan var1) throws UnexpectedEntityException;

    public Loan markAsRecovered(Loan var1) throws UnexpectedEntityException;

    public Loan markAsUnrecoverable(Loan var1) throws UnexpectedEntityException;

    public TransactionSummaryVO paymentsSummary(LoanPaymentQuery var1);

    public Transfer repay(RepayLoanDTO var1) throws UpperCreditLimitReachedException, UnexpectedEntityException;

    public List<LoanPayment> search(LoanPaymentQuery var1);

    public List<Loan> search(LoanQuery var1);

    public void validate(GrantLoanDTO var1);
}

