/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.dao.accounts.loans.LoanDAO;
import nl.strohalm.cyclos.dao.accounts.loans.LoanPaymentDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantMultiPaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanHandler;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PositiveNonZeroValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.transaction.TransactionStatus;

public class LoanServiceImpl
implements LoanServiceLocal,
InitializingService {
    private TransferAuthorizationServiceLocal transferAuthorizationService;
    private static final float PRECISION_DELTA = 1.0E-4f;
    private AccountServiceLocal accountService;
    private AlertServiceLocal alertService;
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private FetchServiceLocal fetchService;
    private LoanDAO loanDao;
    private LoanPaymentDAO loanPaymentDao;
    private PaymentServiceLocal paymentService;
    private RateServiceLocal rateService;
    private SettingsServiceLocal settingsService;
    private final Map<Loan.Type, LoanHandler> handlersByType = new EnumMap<Loan.Type, LoanHandler>(Loan.Type.class);
    private PermissionServiceLocal permissionService;
    private MemberNotificationHandler memberNotificationHandler;
    private TransactionHelper transactionHelper;

    @Override
    public void alertExpiredLoans(Calendar time) {
        Calendar deadline = DateHelper.truncate(time);
        deadline.add(5, -1);
        LoanPaymentQuery query = new LoanPaymentQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(RelationshipHelper.nested(LoanPayment.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP));
        query.setExpirationPeriod(Period.endingAt(deadline));
        query.setStatus(LoanPayment.Status.OPEN);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        List<LoanPayment> payments = this.search(query);
        for (LoanPayment payment : payments) {
            Loan loan = payment.getLoan();
            payment.setStatus(LoanPayment.Status.EXPIRED);
            this.loanPaymentDao.update(payment);
            Member member = (Member)loan.getTransfer().getTo().getOwner();
            this.alertService.create(member, MemberAlert.Alerts.EXPIRED_LOAN, new Object[0]);
            this.memberNotificationHandler.expiredLoanNotification(payment);
            cacheCleaner.clearCache();
        }
    }

    @Override
    public List<LoanPayment> calculatePaymentProjection(ProjectionDTO params) {
        params.setTransferType(this.fetchService.fetch(params.getTransferType(), new Relationship[0]));
        if (params.getDate() == null) {
            params.setDate(Calendar.getInstance());
        }
        this.getProjectionValidator().validate(params);
        return this.handlersByType.get(params.getTransferType().getLoan().getType()).calculatePaymentProjection(params);
    }

    @Override
    public LoanPayment discard(LoanPaymentDTO dto) {
        LoanPaymentDTO dateDto = new LoanPaymentDTO();
        dateDto.setLoan(dto.getLoan());
        dateDto.setLoanPayment(dto.getLoanPayment());
        return this.doDiscard(dateDto);
    }

    @Override
    public LoanPayment discardByExternalTransfer(Loan loan, ExternalTransfer externalTransfer) throws UnexpectedEntityException {
        LoanPaymentDTO dto = new LoanPaymentDTO();
        dto.setLoan(loan);
        LoanPayment loanPayment = this.doDiscard(dto);
        loanPayment.setExternalTransfer(externalTransfer);
        return this.loanPaymentDao.update(loanPayment);
    }

    @Override
    public LoanRepaymentAmountsDTO getLoanPaymentAmount(LoanPaymentDTO dto) {
        LoanRepaymentAmountsDTO ret = new LoanRepaymentAmountsDTO();
        Calendar date = dto.getDate();
        if (date == null) {
            date = Calendar.getInstance();
        }
        Loan loan = this.fetchService.fetch(dto.getLoan(), Loan.Relationships.TRANSFER, Loan.Relationships.PAYMENTS);
        LoanPayment payment = this.fetchService.fetch(dto.getLoanPayment(), new Relationship[0]);
        if (payment == null) {
            payment = loan.getFirstOpenPayment();
        }
        ret.setLoanPayment(payment);
        dto.setLoan(loan);
        dto.setLoanPayment(payment);
        if (payment != null) {
            Amount expirationFee;
            BigDecimal paymentAmount;
            payment = this.fetchService.fetch(payment, LoanPayment.Relationships.TRANSFERS);
            BigDecimal remainingAmount = paymentAmount = payment.getAmount();
            Calendar expirationDate = payment.getExpirationDate();
            Calendar lastPaymentDate = (Calendar)expirationDate.clone();
            expirationDate = DateUtils.truncate((Calendar)expirationDate, (int)5);
            LoanParameters parameters = loan.getParameters();
            Collection<Transfer> transfers = payment.getTransfers();
            if (transfers == null) {
                transfers = Collections.emptyList();
            }
            BigDecimal expirationDailyInterest = CoercionHelper.coerce(BigDecimal.class, parameters.getExpirationDailyInterest());
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            MathContext mathContext = localSettings.getMathContext();
            for (Transfer transfer : transfers) {
                BigDecimal trfAmount;
                Calendar trfDate = transfer.getDate();
                trfDate = DateUtils.truncate((Calendar)trfDate, (int)5);
                BigDecimal actualAmount = trfAmount = transfer.getAmount();
                int diffDays = (int)((trfDate.getTimeInMillis() - expirationDate.getTimeInMillis()) / 86400000L);
                if (diffDays > 0 && expirationDailyInterest != null) {
                    actualAmount = actualAmount.subtract(remainingAmount.multiply(new BigDecimal(diffDays)).multiply(expirationDailyInterest.divide(new BigDecimal(100), mathContext)));
                }
                remainingAmount = remainingAmount.subtract(actualAmount);
                lastPaymentDate = (Calendar)trfDate.clone();
            }
            date = DateHelper.truncate(date);
            BigDecimal remainingAmountAtDate = remainingAmount;
            int diffDays = (int)((date.getTimeInMillis() - (expirationDate.before(lastPaymentDate) ? lastPaymentDate.getTimeInMillis() : expirationDate.getTimeInMillis())) / 86400000L);
            if (diffDays > 0 && expirationDailyInterest != null) {
                remainingAmountAtDate = remainingAmountAtDate.add(remainingAmount.multiply(new BigDecimal(diffDays)).multiply(expirationDailyInterest.divide(new BigDecimal(100), mathContext)));
            }
            if ((expirationFee = parameters.getExpirationFee()) != null && remainingAmountAtDate.compareTo(BigDecimal.ZERO) == 1 && expirationDate.before(date) && expirationFee.getValue().compareTo(BigDecimal.ZERO) == 1) {
                remainingAmountAtDate = remainingAmountAtDate.add(expirationFee.apply(remainingAmount));
            }
            ret.setRemainingAmountAtExpirationDate(localSettings.round(remainingAmount));
            ret.setRemainingAmountAtDate(localSettings.round(remainingAmountAtDate));
        }
        return ret;
    }

    @Override
    public TransactionSummaryVO getOpenLoansSummary(Currency currency) {
        LoanQuery query = new LoanQuery();
        query.setStatus(Loan.Status.OPEN);
        query.setCurrency(currency);
        if (LoggedUser.hasUser()) {
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS);
            query.setGroups(adminGroup.getManagesGroups());
        }
        return this.buildSummary(query);
    }

    @Override
    public Loan grant(GrantLoanDTO params) {
        return this.doGrant(params, true);
    }

    @Override
    public Loan grantForGuarantee(GrantLoanDTO params, boolean automaticAuthorize) {
        Loan loan = this.insert(params);
        if (automaticAuthorize && this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_AUTHORIZE) && loan.getTransfer().getNextAuthorizationLevel() != null) {
            TransferAuthorizationDTO transferAuthorizationDto = new TransferAuthorizationDTO();
            transferAuthorizationDto.setTransfer(loan.getTransfer());
            this.transferAuthorizationService.authorize(transferAuthorizationDto, false);
        }
        return loan;
    }

    @Override
    public void initializeService() {
        this.alertExpiredLoans(Calendar.getInstance());
    }

    @Override
    public Loan insert(GrantLoanDTO params) {
        return this.doGrant(params, false);
    }

    @Override
    public Loan load(Long id, Relationship ... fetch) {
        return (Loan)this.loanDao.load(id, fetch);
    }

    @Override
    public TransactionSummaryVO loanSummary(Member member) {
        LoanQuery query = new LoanQuery();
        query.setMember(member);
        query.setStatus(Loan.Status.OPEN);
        return this.buildSummary(query);
    }

    @Override
    public Loan markAsInProcess(Loan loan) throws UnexpectedEntityException {
        return this.markAs(loan, LoanPayment.Status.EXPIRED, LoanPayment.Status.IN_PROCESS);
    }

    @Override
    public Loan markAsRecovered(Loan loan) throws UnexpectedEntityException {
        return this.markAs(loan, LoanPayment.Status.IN_PROCESS, LoanPayment.Status.RECOVERED);
    }

    @Override
    public Loan markAsUnrecoverable(Loan loan) throws UnexpectedEntityException {
        return this.markAs(loan, LoanPayment.Status.IN_PROCESS, LoanPayment.Status.UNRECOVERABLE);
    }

    @Override
    public TransactionSummaryVO paymentsSummary(LoanPaymentQuery query) {
        LoanPayment.Status status = query.getStatus();
        if (status == null) {
            throw new ValidationException("status", "loanPayment.status", new RequiredError(new Object[0]));
        }
        return this.loanPaymentDao.paymentsSummary(query);
    }

    @Override
    public Transfer repay(final RepayLoanDTO params) {
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return LoanServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return LoanServiceImpl.this.doRepay(params);
            }
        });
    }

    @Override
    public List<LoanPayment> search(LoanPaymentQuery query) {
        return this.loanPaymentDao.search(query);
    }

    @Override
    public List<Loan> search(LoanQuery query) {
        if (query.getQueryStatus() == null) {
            query.setHideAuthorizationRelated(!this.permissionService.hasPermission(AdminMemberPermission.LOANS_VIEW_AUTHORIZED));
        }
        return this.loanDao.search(query);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLoanDao(LoanDAO loanDao) {
        this.loanDao = loanDao;
    }

    public void setLoanPaymentDao(LoanPaymentDAO loanPaymentDao) {
        this.loanPaymentDao = loanPaymentDao;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMultiPaymentHandler(LoanHandler handler) {
        this.handlersByType.put(Loan.Type.MULTI_PAYMENT, handler);
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setSinglePaymentHandler(LoanHandler handler) {
        this.handlersByType.put(Loan.Type.SINGLE_PAYMENT, handler);
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    public void setWithInterestHandler(LoanHandler handler) {
        this.handlersByType.put(Loan.Type.WITH_INTEREST, handler);
    }

    @Override
    public void validate(GrantLoanDTO params) {
        Validator validator = this.getValidator(params);
        if (validator == null) {
            throw new ValidationException("transferType", "loan.type", new InvalidError());
        }
        validator.validate(params);
    }

    private TransactionSummaryVO buildSummary(LoanQuery query) {
        BigDecimal amount = BigDecimal.ZERO;
        int count = 0;
        List<Loan> loans = this.loanDao.search(query);
        for (Loan loan : loans) {
            ++count;
            List<LoanPayment> payments = (loan = this.fetchService.fetch(loan, Loan.Relationships.PAYMENTS)).getPayments();
            if (payments == null) continue;
            for (LoanPayment payment : payments) {
                amount = amount.add(payment.getRemainingAmount());
            }
        }
        TransactionSummaryVO ret = new TransactionSummaryVO();
        ret.setCount(count);
        ret.setAmount(amount);
        return ret;
    }

    private LoanPayment doDiscard(LoanPaymentDTO dto) {
        Calendar date;
        Loan loan = this.fetchService.fetch(dto.getLoan(), Loan.Relationships.PAYMENTS);
        LoanPayment payment = this.fetchService.fetch(dto.getLoanPayment(), new Relationship[0]);
        Calendar calendar = date = dto.getDate() == null ? Calendar.getInstance() : dto.getDate();
        if (payment == null) {
            payment = loan.getFirstOpenPayment();
        }
        if (payment == null) {
            throw new UnexpectedEntityException();
        }
        payment.setStatus(LoanPayment.Status.DISCARDED);
        payment.setRepaymentDate(date);
        return this.loanPaymentDao.update(payment);
    }

    private Loan doGrant(final GrantLoanDTO params, boolean newTransaction) {
        this.validate(params);
        TransferType transferType = this.fetchService.fetch(params.getTransferType(), new Relationship[0]);
        params.setTransferType(transferType);
        final Loan loan = this.handlersByType.get(params.getLoanType()).buildLoan(params);
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Loan>(){

            @Override
            public Loan afterCommit(Loan result) {
                return LoanServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Loan doInTransaction(TransactionStatus status) {
                return LoanServiceImpl.this.doGrant(loan, params);
            }
        }, newTransaction);
    }

    private Loan doGrant(Loan loan, GrantLoanDTO params) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TransferType transferType = params.getTransferType();
        TransferDTO transferDto = new TransferDTO();
        if (params.isAutomatic()) {
            transferDto.setContext(TransactionContext.AUTOMATIC_LOAN);
        } else {
            transferDto.setContext(TransactionContext.LOAN);
        }
        if (params.getDate() != null) {
            transferDto.setDate(params.getDate());
        }
        transferDto.setToOwner(params.getMember());
        transferDto.setFrom(this.accountService.getAccount(new AccountDTO(SystemAccountOwner.instance(), transferType.getFrom()), new Relationship[0]));
        transferDto.setTo(this.accountService.getAccount(new AccountDTO(transferDto.getToOwner(), transferType.getTo()), new Relationship[0]));
        transferDto.setAmount(params.getAmount());
        transferDto.setDescription(params.getDescription());
        transferDto.setTransferType(transferType);
        transferDto.setCustomValues(params.getCustomValues());
        transferDto.setRates(this.rateService.applyLoan(transferDto, params));
        Transfer transfer = (Transfer)this.paymentService.insertWithoutNotification(transferDto);
        if (transfer.getProcessDate() == null && params.getDate() != null && DateHelper.daysBetween(params.getDate(), Calendar.getInstance()) != 0) {
            throw new AuthorizedPaymentInPastException();
        }
        loan.setTransfer(transfer);
        List<LoanPayment> payments = loan.getPayments();
        loan = this.loanDao.insert(loan);
        loan.setPayments(new ArrayList<LoanPayment>());
        int index = 0;
        BigDecimal total = BigDecimal.ZERO;
        for (LoanPayment payment : payments) {
            payment.setLoan(loan);
            payment.setIndex(index++);
            BigDecimal amount = localSettings.round(payment.getAmount());
            if (index == payments.size()) {
                amount = localSettings.round(loan.getTotalAmount().subtract(total));
            } else {
                total = total.add(amount);
            }
            payment.setAmount(amount);
            loan.getPayments().add(this.loanPaymentDao.insert(payment));
        }
        this.memberNotificationHandler.grantedLoanNotification(loan);
        return loan;
    }

    private Transfer doRepay(RepayLoanDTO params) {
        LoanRepaymentAmountsDTO amountsDTO;
        LoanPayment payment;
        BigDecimal amount = params.getAmount();
        if (amount.compareTo(this.paymentService.getMinimumPayment()) < 0) {
            throw new ValidationException("amount", "loan.amount", new InvalidError());
        }
        Calendar date = params.getDate();
        if (date == null) {
            date = Calendar.getInstance();
            params.setDate(date);
        }
        if ((payment = (amountsDTO = this.getLoanPaymentAmount(params)).getLoanPayment()) == null) {
            throw new UnexpectedEntityException();
        }
        BigDecimal remainingAmount = amountsDTO.getRemainingAmountAtDate();
        BigDecimal diff = remainingAmount.subtract(amount);
        MutableBoolean totallyRepaid = new MutableBoolean();
        if (diff.abs().floatValue() < 1.0E-4f) {
            amount = remainingAmount;
            totallyRepaid.setValue(true);
        } else if (diff.compareTo(BigDecimal.ZERO) < 0 || !params.getLoan().getTransfer().getType().getLoan().getType().allowsPartialRepayments()) {
            throw new ValidationException("amount", "loan.amount", new InvalidError());
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Loan loan = this.fetchService.fetch(params.getLoan(), Loan.Relationships.PAYMENTS, RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), Loan.Relationships.TO_MEMBERS);
        List<TransferDTO> transfers = this.handlersByType.get(loan.getParameters().getType()).buildTransfersForRepayment(params, amountsDTO);
        Transfer root = null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (TransferDTO dto : transfers) {
            if (dto.getAmount().floatValue() < 1.0E-4f) {
                TransferQuery tq = new TransferQuery();
                tq.setLoanPayment(payment);
                tq.setReverseOrder(true);
                tq.setUniqueResult();
                List<Transfer> paymentTransfers = this.paymentService.search(tq);
                if (paymentTransfers.isEmpty()) {
                    throw new IllegalStateException("The root transfer has amount 0 and there is no other transfers for this payment");
                }
                root = paymentTransfers.iterator().next();
                continue;
            }
            totalAmount = totalAmount.add(dto.getAmount());
            dto.setParent(root);
            dto.setLoanPayment(payment);
            Transfer transfer = (Transfer)this.paymentService.insertWithoutNotification(dto);
            if (root != null) continue;
            root = transfer;
        }
        BigDecimal totalRepaid = localSettings.round(payment.getRepaidAmount().add(totalAmount));
        payment.setRepaidAmount(totalRepaid);
        if (totallyRepaid.booleanValue()) {
            payment.setStatus(LoanPayment.Status.REPAID);
            payment.setRepaymentDate(params.getDate());
        }
        payment.setTransfers(null);
        this.loanPaymentDao.update(payment);
        return root;
    }

    private Validator getProjectionValidator() {
        Validator projectionValidator = new Validator("loan");
        projectionValidator.property("transferType").key("loan.type").required().add(new LoanTypeValidation());
        projectionValidator.property("amount").required().positiveNonZero();
        projectionValidator.property("firstExpirationDate").future().required();
        projectionValidator.property("paymentCount").required().positiveNonZero();
        return projectionValidator;
    }

    private Validator getValidator(GrantLoanDTO params) {
        Loan.Type type;
        final TransferType transferType = this.fetchService.fetch(params.getTransferType(), new Relationship[0]);
        try {
            type = transferType.getLoan().getType();
        }
        catch (Exception e) {
            return null;
        }
        Validator validator = new Validator("loan");
        validator.property("amount").required().positiveNonZero();
        Currency currency = this.fetchService.fetch(transferType.getCurrency(), Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS);
        if (currency.isEnableARate() || currency.isEnableDRate()) {
            if (params.getDate() != null) {
                Calendar now = Calendar.getInstance();
                now.add(12, -4);
                if (params.getDate().before(now)) {
                    validator.general(new GeneralValidation(){
                        private static final long serialVersionUID = -7221645724425619586L;

                        @Override
                        public ValidationError validate(Object object) {
                            return new ValidationError("payment.error.pastDateWithRates", new Object[0]);
                        }
                    });
                }
            }
        } else {
            validator.property("date").key("loan.grant.manualDate").pastOrToday();
        }
        validator.property("description").required().maxLength(1000);
        validator.property("member").key("member.member").required();
        switch (type) {
            case SINGLE_PAYMENT: {
                validator.property("repaymentDate").required();
                break;
            }
            case MULTI_PAYMENT: {
                validator.property("payments").required().add(new MultiPaymentValidation());
                break;
            }
            case WITH_INTEREST: {
                validator.property("firstRepaymentDate").future().required();
                validator.property("paymentCount").required().positiveNonZero();
            }
        }
        validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

            @Override
            public Validator getValidator() {
                return LoanServiceImpl.this.paymentCustomFieldService.getValueValidator(transferType);
            }
        }));
        return validator;
    }

    private Loan markAs(Loan loan, LoanPayment.Status expectedStatus, LoanPayment.Status newStatus) {
        loan = this.fetchService.fetch(loan, Loan.Relationships.PAYMENTS);
        for (LoanPayment current : loan.getPayments()) {
            if (current.getStatus() != expectedStatus) continue;
            current.setStatus(newStatus);
            this.loanPaymentDao.update(current);
        }
        return this.fetchService.reload(loan, new Relationship[0]);
    }

    private final class MultiPaymentValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -7905875152926109032L;

        private MultiPaymentValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            GrantMultiPaymentLoanDTO dto = (GrantMultiPaymentLoanDTO)object;
            Collection payments = (Collection)value;
            if (payments == null || payments.isEmpty()) {
                return null;
            }
            Calendar lastExpiration = DateHelper.truncate(Calendar.getInstance());
            BigDecimal paymentAmounts = BigDecimal.ZERO;
            BigDecimal totalAmount = dto.getAmount();
            boolean processAmount = totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) == 1;
            for (LoanPayment payment : payments) {
                ValidationError error = RequiredValidation.instance().validate(object, name, payment.getExpirationDate());
                BigDecimal paymentAmount = payment.getAmount();
                if (error == null) {
                    error = RequiredValidation.instance().validate(object, name, paymentAmount);
                }
                if (error == null) {
                    error = PositiveNonZeroValidation.instance().validate(object, name, paymentAmount);
                }
                if (error == null && lastExpiration.after(payment.getExpirationDate())) {
                    error = new ValidationError("loan.grant.error.unsortedPayments", new Object[0]);
                }
                if (error != null) {
                    return error;
                }
                if (processAmount) {
                    paymentAmounts = paymentAmounts.add(paymentAmount);
                }
                lastExpiration = payment.getExpirationDate();
            }
            if (paymentAmounts.subtract(totalAmount).abs().floatValue() > 1.0E-4f) {
                return new ValidationError("loan.grant.error.invalidAmount", new Object[0]);
            }
            return null;
        }
    }

    private class LoanTypeValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -7166494808222423923L;

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            TransferType transferType = (TransferType)value;
            if (transferType == null) {
                return null;
            }
            if (!transferType.isLoanType()) {
                return new InvalidError();
            }
            return null;
        }
    }
}

