/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.BaseLoanQuery;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class LoanServiceSecurity
extends BaseServiceSecurity
implements LoanService {
    private LoanServiceLocal loanService;

    @Override
    public List<LoanPayment> calculatePaymentProjection(ProjectionDTO params) {
        this.permissionService.permission().admin(AdminMemberPermission.LOANS_GRANT).check();
        return this.loanService.calculatePaymentProjection(params);
    }

    @Override
    public LoanPayment discard(LoanPaymentDTO dto) throws UnexpectedEntityException {
        this.permission(dto).admin(AdminMemberPermission.LOANS_DISCARD).check();
        Calendar date = dto.getDate();
        if (date != null) {
            this.permissionService.permission().admin(AdminMemberPermission.LOANS_REPAY_WITH_DATE).check();
        }
        return this.loanService.discard(dto);
    }

    @Override
    public LoanRepaymentAmountsDTO getLoanPaymentAmount(LoanPaymentDTO dto) {
        this.checkView(this.permission(dto));
        return this.loanService.getLoanPaymentAmount(dto);
    }

    @Override
    public Loan grant(GrantLoanDTO params) throws CreditsException {
        TransferType transferType;
        if (params.isAutomatic()) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission(params.getMember()).admin(AdminMemberPermission.LOANS_GRANT).check();
        Calendar date = params.getDate();
        if (date != null) {
            this.permissionService.permission().admin(AdminMemberPermission.LOANS_GRANT_WITH_DATE).check();
        }
        if ((transferType = params.getTransferType()) != null) {
            AdminGroup group = (AdminGroup)LoggedUser.group();
            Collection<TransferType> transferTypes = this.fetchService.fetch(group, Group.Relationships.TRANSFER_TYPES).getTransferTypes();
            if (!transferTypes.contains(transferType)) {
                throw new PermissionDeniedException();
            }
        }
        return this.loanService.grant(params);
    }

    @Override
    public Loan load(Long id, Relationship ... fetch) {
        Loan loan = this.loanService.load(id, fetch);
        this.checkView(this.permission(loan));
        return loan;
    }

    @Override
    public TransactionSummaryVO loanSummary(Member member) {
        this.checkView(this.permissionService.permission(member));
        return this.loanService.loanSummary(member);
    }

    @Override
    public Loan markAsInProcess(Loan loan) throws UnexpectedEntityException {
        this.checkExpiredStatus(loan);
        return this.loanService.markAsInProcess(loan);
    }

    @Override
    public Loan markAsRecovered(Loan loan) throws UnexpectedEntityException {
        this.checkExpiredStatus(loan);
        return this.loanService.markAsRecovered(loan);
    }

    @Override
    public Loan markAsUnrecoverable(Loan loan) throws UnexpectedEntityException {
        this.checkExpiredStatus(loan);
        return this.loanService.markAsUnrecoverable(loan);
    }

    @Override
    public TransactionSummaryVO paymentsSummary(LoanPaymentQuery query) {
        this.applyRestrictions(query);
        return this.loanService.paymentsSummary(query);
    }

    @Override
    public Transfer repay(RepayLoanDTO params) throws UpperCreditLimitReachedException, UnexpectedEntityException {
        Loan loan = this.fetchLoan(params.getLoan());
        if (LoggedUser.isMember() && loan.getLoanGroup() != null && !LoggedUser.member().equals(loan.getMember())) {
            MemberGroup group;
            boolean hasPermission = false;
            if (loan.getToMembers().contains(LoggedUser.member()) && (group = LoggedUser.member().getMemberGroup()).getMemberSettings().isRepayLoanByGroup()) {
                hasPermission = this.permissionService.permission().member(MemberPermission.LOANS_REPAY).operator(OperatorPermission.LOANS_REPAY).hasPermission();
            }
            if (!hasPermission) {
                throw new PermissionDeniedException();
            }
        } else {
            this.permission(params).admin(AdminMemberPermission.LOANS_REPAY).member(MemberPermission.LOANS_REPAY).operator(OperatorPermission.LOANS_REPAY).check();
        }
        Calendar date = params.getDate();
        if (date != null) {
            this.permissionService.permission().admin(AdminMemberPermission.LOANS_REPAY_WITH_DATE).check();
        }
        return this.loanService.repay(params);
    }

    @Override
    public List<LoanPayment> search(LoanPaymentQuery query) {
        this.applyRestrictions(query);
        return this.loanService.search(query);
    }

    @Override
    public List<Loan> search(LoanQuery query) {
        this.applyRestrictions(query);
        return this.loanService.search(query);
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    @Override
    public void validate(GrantLoanDTO params) {
        this.loanService.validate(params);
    }

    private void applyRestrictions(BaseLoanQuery query) {
        Member member = query.getMember();
        if (member == null) {
            this.permissionService.permission().admin(AdminMemberPermission.LOANS_VIEW).broker(BrokerPermission.LOANS_VIEW).member(MemberPermission.LOANS_VIEW).operator(OperatorPermission.LOANS_VIEW).check();
            if (LoggedUser.isAdministrator()) {
                query.setGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), query.getGroups()));
            } else if (LoggedUser.isBroker()) {
                query.setBroker(LoggedUser.member());
            }
        } else {
            this.permissionService.permission(member).admin(AdminMemberPermission.LOANS_VIEW).broker(BrokerPermission.LOANS_VIEW).member(MemberPermission.LOANS_VIEW).operator(OperatorPermission.LOANS_VIEW).check();
        }
    }

    private void checkExpiredStatus(Loan loan) {
        this.permission(loan).admin(AdminMemberPermission.LOANS_MANAGE_EXPIRED_STATUS).check();
    }

    private void checkView(PermissionCheck permission) {
        permission.admin(AdminMemberPermission.LOANS_VIEW).broker(BrokerPermission.LOANS_VIEW).member(MemberPermission.LOANS_VIEW).operator(OperatorPermission.LOANS_VIEW).check();
    }

    private Loan fetchLoan(Loan loan) {
        if (loan == null) {
            throw new ValidationException();
        }
        return this.fetchService.fetch(loan, RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
    }

    private boolean loggedUserManagesSomebodyWhoCanViewTheLoan(Loan loan) {
        if (this.permissionService.manages(loan.getMember())) {
            return true;
        }
        if (loan.getLoanGroup() != null) {
            for (Member member : loan.getToMembers()) {
                MemberGroup group;
                if (!this.permissionService.manages(member) || !(group = member.getMemberGroup()).getMemberSettings().isViewLoansByGroup()) continue;
                return true;
            }
        }
        return false;
    }

    private PermissionCheck permission(Loan loan) {
        if (this.loggedUserManagesSomebodyWhoCanViewTheLoan(loan = this.fetchLoan(loan))) {
            return this.permissionService.permission().admin(AdminMemberPermission.LOANS_VIEW).broker(BrokerPermission.LOANS_VIEW).member(MemberPermission.LOANS_VIEW).operator(OperatorPermission.LOANS_VIEW);
        }
        throw new PermissionDeniedException();
    }

    private PermissionCheck permission(LoanPaymentDTO dto) {
        if (dto.getLoan() != null) {
            LoanPayment loanPayment;
            if (dto.getLoanPayment() != null && !(loanPayment = this.fetchService.fetch(dto.getLoanPayment(), new Relationship[0])).getLoan().equals(dto.getLoan())) {
                throw new PermissionDeniedException();
            }
            return this.permission(dto.getLoan());
        }
        if (dto.getLoanPayment() != null) {
            LoanPayment loanPayment = this.fetchService.fetch(dto.getLoanPayment(), new Relationship[0]);
            return this.permission(loanPayment.getLoan());
        }
        throw new ValidationException();
    }
}

