/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.transactions.BaseMultiplePaymentLoanHandler;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantLoanWithInterestDTO;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.PartialInterestsAmountException;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;

public class LoanWithInterestHandler
extends BaseMultiplePaymentLoanHandler {
    public LoanWithInterestHandler() {
        super(Loan.Type.SINGLE_PAYMENT);
    }

    @Override
    public List<TransferDTO> buildTransfersForRepayment(RepayLoanDTO repayDTO, LoanRepaymentAmountsDTO amountsDTO) {
        ArrayList<TransferDTO> transfers = new ArrayList<TransferDTO>(super.buildTransfersForRepayment(repayDTO, amountsDTO));
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TransferDTO baseRepayment = (TransferDTO)transfers.get(0);
        Loan loan = repayDTO.getLoan();
        Calendar repaymentDate = repayDTO.getDate() == null ? Calendar.getInstance() : repayDTO.getDate();
        int paymentCount = loan.getPaymentCount();
        Transfer loanTransfer = loan.getTransfer();
        BigDecimal originalAmount = loanTransfer.getAmount();
        LoanParameters parameters = loanTransfer.getType().getLoan();
        LoanPayment payment = baseRepayment.getLoanPayment();
        BigDecimal paymentAmount = payment.getAmount();
        BigDecimal repaidAmount = payment.getRepaidAmount();
        BigDecimal amountToRepay = repayDTO.getAmount();
        MathContext mathContext = localSettings.getMathContext();
        BigDecimal baseAmount = localSettings.round(originalAmount.divide(new BigDecimal(paymentCount), mathContext));
        BigDecimal totalExtraAmount = paymentAmount.subtract(baseAmount);
        BigDecimal extraAmount = localSettings.round(amountToRepay.add(repaidAmount).subtract(baseAmount));
        if (extraAmount.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal paymentExpirationInterest;
            int diff;
            BigDecimal paymentExpirationFee;
            baseRepayment.setAmount(baseAmount.subtract(repaidAmount));
            if (totalExtraAmount.subtract(extraAmount).floatValue() > 1.0E-4f) {
                throw new PartialInterestsAmountException(baseAmount.subtract(repaidAmount), paymentAmount.subtract(baseAmount));
            }
            BigDecimal totalGrantFee = localSettings.round(parameters.calculateGrantFee(originalAmount));
            BigDecimal paymentGrantFee = this.componentAmount(payment, totalGrantFee);
            if (this.generateComponentTransferForAmount(paymentGrantFee)) {
                TransferDTO transfer = this.generateComponentTransfer(payment, baseRepayment, parameters, parameters.getGrantFeeRepaymentType(), paymentGrantFee);
                transfers.add(transfer);
            }
            Calendar firstExpirationDate = loan.getPayments().get(0).getExpirationDate();
            BigDecimal totalMonthlyInterest = localSettings.round(parameters.calculateMonthlyInterests(originalAmount, paymentCount, loanTransfer.getDate(), firstExpirationDate, mathContext));
            BigDecimal paymentMonthlyInterest = this.componentAmount(payment, totalMonthlyInterest);
            if (this.generateComponentTransferForAmount(paymentMonthlyInterest)) {
                TransferDTO transfer = this.generateComponentTransfer(payment, baseRepayment, parameters, parameters.getMonthlyInterestRepaymentType(), paymentMonthlyInterest);
                transfers.add(transfer);
            }
            if (this.generateComponentTransferForAmount(paymentExpirationFee = localSettings.round(parameters.calculatePaymentExpirationFee(paymentAmount, diff = DateHelper.daysBetween(payment.getExpirationDate(), repaymentDate))))) {
                TransferDTO transfer = this.generateComponentTransfer(payment, baseRepayment, parameters, parameters.getExpirationFeeRepaymentType(), paymentExpirationFee);
                transfers.add(transfer);
            }
            if (this.generateComponentTransferForAmount(paymentExpirationInterest = localSettings.round(parameters.calculatePaymentExpirationInterest(paymentAmount, diff, mathContext)))) {
                TransferDTO transfer = this.generateComponentTransfer(payment, baseRepayment, parameters, parameters.getExpirationDailyInterestRepaymentType(), paymentExpirationInterest);
                transfers.add(transfer);
            }
        }
        return transfers;
    }

    @Override
    protected void processGrant(Loan loan, GrantLoanDTO params) {
        Calendar grantDate = DateHelper.truncate(params.getDate() == null ? Calendar.getInstance() : params.getDate());
        GrantLoanWithInterestDTO dto = (GrantLoanWithInterestDTO)params;
        Calendar firstExpirationDate = DateHelper.truncate(dto.getFirstRepaymentDate());
        int parcelCount = dto.getPaymentCount();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MathContext mathContext = localSettings.getMathContext();
        BigDecimal totalAmount = loan.getParameters().calculateLoanTotal(dto.getAmount(), parcelCount, grantDate, firstExpirationDate, mathContext);
        ArrayList<LoanPayment> payments = new ArrayList<LoanPayment>(parcelCount);
        BigDecimal parcelAmount = localSettings.round(totalAmount.divide(new BigDecimal(parcelCount), mathContext));
        for (int i = 0; i < parcelCount; ++i) {
            LoanPayment payment = new LoanPayment();
            Calendar expiration = (Calendar)firstExpirationDate.clone();
            expiration.add(2, i);
            payment.setExpirationDate(expiration);
            payment.setAmount(parcelAmount);
            payments.add(payment);
        }
        loan.setTotalAmount(totalAmount);
        loan.setPayments(payments);
    }

    @Override
    protected BigDecimal retrieveTotalAmount(ProjectionDTO params) {
        Calendar grantDate = params.getDate();
        Calendar firstRepaymentDate = params.getFirstExpirationDate();
        int paymentCount = params.getPaymentCount();
        BigDecimal amount = params.getAmount();
        MathContext mathContext = this.settingsService.getLocalSettings().getMathContext();
        return params.getTransferType().getLoan().calculateLoanTotal(amount, paymentCount, grantDate, firstRepaymentDate, mathContext);
    }

    private BigDecimal componentAmount(LoanPayment payment, BigDecimal totalComponentAmount) {
        if (totalComponentAmount.floatValue() < 1.0E-4f) {
            return BigDecimal.ZERO;
        }
        int paymentCount = payment.getLoan().getPaymentCount();
        int number = payment.getNumber();
        boolean isLast = number == paymentCount;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MathContext mathContext = localSettings.getMathContext();
        BigDecimal perPaymentAmount = localSettings.round(totalComponentAmount.divide(new BigDecimal(paymentCount), mathContext));
        if (isLast) {
            return totalComponentAmount.subtract(perPaymentAmount.multiply(new BigDecimal(number).subtract(new BigDecimal(1))));
        }
        return perPaymentAmount;
    }

    private TransferDTO generateComponentTransfer(LoanPayment payment, TransferDTO baseRepayment, LoanParameters parameters, TransferType transferType, BigDecimal amount) {
        AccountOwner toOwner;
        Serializable fromOwner;
        Loan loan = payment.getLoan();
        if ((transferType = this.fetchService.fetch(transferType, RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO)).isFromSystem()) {
            fromOwner = SystemAccountOwner.instance();
            toOwner = loan.getMember();
        } else {
            fromOwner = loan.getMember();
            toOwner = SystemAccountOwner.instance();
        }
        TransferDTO transfer = new TransferDTO();
        transfer.setAutomatic(true);
        transfer.setDate(baseRepayment.getDate());
        transfer.setTransferType(transferType);
        transfer.setFrom(this.accountService.getAccount(new AccountDTO((AccountOwner)((Object)fromOwner), transferType.getFrom()), new Relationship[0]));
        transfer.setTo(this.accountService.getAccount(new AccountDTO(toOwner, transferType.getTo()), new Relationship[0]));
        transfer.setAmount(amount);
        transfer.setDescription(this.buildDescriptionForRepayment(transferType, payment));
        return transfer;
    }

    private boolean generateComponentTransferForAmount(BigDecimal amount) {
        return amount.subtract(this.paymentService.getMinimumPayment()).floatValue() > 1.0E-4f;
    }
}

