/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.BaseMultiplePaymentLoanHandler;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantMultiPaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidLoanPaymentAmountException;
import nl.strohalm.cyclos.services.transactions.exceptions.UnsortedLoanPaymentsException;

public class MultiPaymentLoanHandler
extends BaseMultiplePaymentLoanHandler {
    private static final float PRECISION_DELTA = 0.001f;

    public MultiPaymentLoanHandler() {
        super(Loan.Type.MULTI_PAYMENT);
    }

    @Override
    protected void processGrant(Loan loan, GrantLoanDTO params) {
        GrantMultiPaymentLoanDTO dto = (GrantMultiPaymentLoanDTO)params;
        List<LoanPayment> payments = dto.getPayments();
        BigDecimal amount = BigDecimal.ZERO;
        Calendar lastDate = null;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        for (LoanPayment payment : payments) {
            if (lastDate == null) {
                lastDate = payment.getExpirationDate();
            } else if (!lastDate.before(payment.getExpirationDate())) {
                throw new UnsortedLoanPaymentsException();
            }
            payment.setAmount(localSettings.round(payment.getAmount()));
            amount = amount.add(payment.getAmount());
        }
        amount = localSettings.round(amount);
        if (dto.getAmount().subtract(amount).abs().floatValue() > 0.001f) {
            throw new InvalidLoanPaymentAmountException();
        }
        loan.setTotalAmount(amount);
        loan.setPayments(payments);
    }
}

