/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.accounts.rates.ConversionSimulationDTO;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.payments.AccountHistoryParams;

public interface PaymentService
extends Service {
    public List<ScheduledPaymentDTO> calculatePaymentProjection(ProjectionDTO var1);

    public AccountHistoryResultPage getAccountHistoryResultPage(AccountHistoryParams var1);

    public AccountHistoryTransferVO getAccountHistoryTransferVO(Long var1);

    public boolean canChargeback(Transfer var1, boolean var2);

    public Transfer chargeback(Transfer var1) throws UnexpectedEntityException;

    public Payment doPayment(DoPaymentDTO var1) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException;

    public ConversionSimulationDTO getDefaultConversionDTO(MemberAccount var1, List<TransferType> var2);

    public BigDecimal getMinimumPayment();

    public StatisticalResultDTO getSimulateConversionGraph(ConversionSimulationDTO var1);

    public boolean hasPermissionsToChargeback(Transfer var1);

    public boolean isVisible(Payment var1);

    public Transfer load(Long var1, Relationship ... var2) throws EntityNotFoundException;

    public List<Transfer> search(TransferQuery var1);

    public TransactionFeePreviewForRatesDTO simulateConversion(ConversionSimulationDTO var1);

    public Payment simulatePayment(DoPaymentDTO var1) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException;

    public void validate(ConversionSimulationDTO var1);

    public void validate(DoPaymentDTO var1);

    public boolean wouldRequireAuthorization(DoPaymentDTO var1);

    public boolean wouldRequireAuthorization(Invoice var1);

    public boolean wouldRequireAuthorization(Transfer var1);

    public boolean wouldRequireAuthorization(TransferType var1, BigDecimal var2, AccountOwner var3);
}

