/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.awt.Color;
import java.awt.Paint;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.ScheduledPaymentDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TraceNumberDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.TraceNumber;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferListener;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.ConversionSimulationDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RatesPreviewDTO;
import nl.strohalm.cyclos.services.accounts.rates.RatesResultDTO;
import nl.strohalm.cyclos.services.accounts.rates.RatesToSave;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.transactions.BulkChargebackResult;
import nl.strohalm.cyclos.services.transactions.BulkPaymentResult;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.TransferMinimumPaymentException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.BuildTransferWithFeesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.BaseTransactional;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.CustomObjectHandler;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import nl.strohalm.cyclos.utils.lock.LockHandlerFactory;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.statistics.GraphHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.validation.CompareToValidation;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.UniqueError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.payments.AccountHistoryParams;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import nl.strohalm.cyclos.webservices.utils.PaymentHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.Marker;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class PaymentServiceImpl
implements PaymentServiceLocal {
    private static final float PRECISION_DELTA = 1.0E-4f;
    private static final Relationship[] CONCILIATION_FETCH = new Relationship[]{Transfer.Relationships.EXTERNAL_TRANSFER, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER)};
    private AccountServiceLocal accountService;
    private CommissionServiceLocal commissionService;
    private SettingsServiceLocal settingsService;
    private TransferAuthorizationServiceLocal transferAuthorizationService;
    private TicketServiceLocal ticketService;
    private TransactionFeeServiceLocal transactionFeeService;
    private TransferDAO transferDao;
    private TraceNumberDAO traceNumberDao;
    private ScheduledPaymentDAO scheduledPaymentDao;
    private TransferTypeServiceLocal transferTypeService;
    private FetchServiceLocal fetchService;
    private LoggingHandler loggingHandler;
    private PermissionServiceLocal permissionService;
    private AlertServiceLocal alertService;
    private MessageResolver messageResolver;
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private RateServiceLocal rateService;
    private MemberNotificationHandler memberNotificationHandler;
    private AdminNotificationHandler adminNotificationHandler;
    private TransactionHelper transactionHelper;
    private ApplicationServiceLocal applicationService;
    private LockHandlerFactory lockHandlerFactory;
    private PaymentHelper paymentHelper;
    private AccountHelper accountHelper;
    private CustomObjectHandler customObjectHandler;
    private static final Log LOG = LogFactory.getLog(PaymentServiceImpl.class);

    @Override
    public List<BulkChargebackResult> bulkChargeback(final List<Transfer> transfers) {
        return this.transactionHelper.runInNewTransaction(new Transactional<List<BulkChargebackResult>>(){

            @Override
            public List<BulkChargebackResult> afterCommit(List<BulkChargebackResult> result) {
                for (BulkChargebackResult bulkChargebackResult : result) {
                    bulkChargebackResult.setTransfer(PaymentServiceImpl.this.fetchService.fetch(bulkChargebackResult.getTransfer(), new Relationship[0]));
                }
                return result;
            }

            public List<BulkChargebackResult> doInTransaction(TransactionStatus status) {
                ArrayList<BulkChargebackResult> results = new ArrayList<BulkChargebackResult>(transfers.size());
                try {
                    for (Transfer transfer : transfers) {
                        if (transfer == null) {
                            results.add(null);
                            continue;
                        }
                        Transfer chargeback = PaymentServiceImpl.this.insertChargeback(transfer, false);
                        results.add(new BulkChargebackResult(chargeback));
                    }
                }
                catch (ApplicationException e) {
                    results.add(new BulkChargebackResult(e));
                    status.setRollbackOnly();
                }
                return results;
            }
        });
    }

    @Override
    public List<ScheduledPaymentDTO> calculatePaymentProjection(ProjectionDTO params) {
        this.getProjectionValidator().validate(params);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        int paymentCount = params.getPaymentCount();
        TimePeriod recurrence = params.getRecurrence();
        BigDecimal totalAmount = params.getAmount();
        BigDecimal paymentAmount = localSettings.round(totalAmount.divide(CoercionHelper.coerce(BigDecimal.class, paymentCount), localSettings.getMathContext()));
        BigDecimal accumulatedAmount = BigDecimal.ZERO;
        Calendar currentDate = DateHelper.truncate(params.getFirstExpirationDate());
        ArrayList<ScheduledPaymentDTO> payments = new ArrayList<ScheduledPaymentDTO>(paymentCount);
        for (int i = 0; i < paymentCount; ++i) {
            ScheduledPaymentDTO dto = new ScheduledPaymentDTO();
            dto.setDate(currentDate);
            dto.setAmount(i == paymentCount - 1 ? totalAmount.subtract(accumulatedAmount) : paymentAmount);
            payments.add(dto);
            accumulatedAmount = accumulatedAmount.add(dto.getAmount(), localSettings.getMathContext());
            currentDate = recurrence.add(currentDate);
        }
        return payments;
    }

    @Override
    public boolean canChargeback(Transfer transfer, boolean ignorePendingPayment) {
        Member toOwner;
        Member fromOwner;
        if ((transfer = this.fetchService.fetch(transfer, Payment.Relationships.FROM, Payment.Relationships.TO, Transfer.Relationships.PARENT, Transfer.Relationships.CHARGEBACK_OF, Transfer.Relationships.CHILDREN)) == null) {
            return false;
        }
        Calendar processDate = transfer.getProcessDate();
        if (!ignorePendingPayment && processDate == null) {
            return false;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TimePeriod maxChargebackTime = localSettings.getMaxChargebackTime();
        Calendar maxDate = maxChargebackTime.add(processDate);
        if (Calendar.getInstance().after(maxDate)) {
            return false;
        }
        if (transfer.getParent() != null) {
            return false;
        }
        if (transfer.getChargedBackBy() != null) {
            return false;
        }
        if (transfer.getChargebackOf() != null) {
            return false;
        }
        if (!transfer.isFromSystem() && (fromOwner = (Member)transfer.getFromOwner()).getGroup().getStatus() == Group.Status.REMOVED) {
            return false;
        }
        return transfer.isToSystem() || (toOwner = (Member)transfer.getToOwner()).getGroup().getStatus() != Group.Status.REMOVED;
    }

    @Override
    public boolean canMakePayment(AccountOwner from, AccountOwner to, TransferType transferType) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        boolean checkToMember = false;
        boolean hasPermission = false;
        if (from == null) {
            from = LoggedUser.accountOwner();
        }
        if (from instanceof SystemAccountOwner) {
            if (to instanceof SystemAccountOwner) {
                hasPermission = this.permissionService.permission().admin(AdminSystemPermission.PAYMENTS_PAYMENT).hasPermission();
            } else {
                if (transferType == null) {
                    hasPermission = this.permissionService.permission().admin(AdminMemberPermission.PAYMENTS_PAYMENT, AdminMemberPermission.LOANS_GRANT).hasPermission();
                } else {
                    AdminMemberPermission permission = transferType.isLoanType() ? AdminMemberPermission.LOANS_GRANT : AdminMemberPermission.PAYMENTS_PAYMENT;
                    hasPermission = this.permissionService.permission().admin(permission).hasPermission();
                }
                checkToMember = true;
            }
        } else {
            Member member = (Member)from;
            if (from.equals(to)) {
                hasPermission = this.permissionService.permission(member).admin(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF).broker(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF).member(MemberPermission.PAYMENTS_PAYMENT_TO_SELF).operator(OperatorPermission.PAYMENTS_PAYMENT_TO_SELF).hasPermission();
            } else if (to instanceof SystemAccountOwner) {
                hasPermission = this.permissionService.permission(member).admin(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM).broker(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM).member(MemberPermission.PAYMENTS_PAYMENT_TO_SYSTEM).operator(OperatorPermission.PAYMENTS_PAYMENT_TO_SYSTEM).hasPermission();
            } else {
                hasPermission = this.permissionService.permission(member).admin(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER).broker(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER).member(MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER).operator(OperatorPermission.PAYMENTS_PAYMENT_TO_MEMBER, OperatorPermission.PAYMENTS_POSWEB_MAKE_PAYMENT).hasPermission();
                checkToMember = true;
            }
        }
        if (hasPermission && transferType != null) {
            Collection<Object> allowedTypes = Collections.emptyList();
            if (LoggedUser.accountOwner().equals(from)) {
                Group group = (Group)this.fetchService.fetch(LoggedUser.isOperator() ? LoggedUser.member().getGroup() : LoggedUser.group(), Group.Relationships.TRANSFER_TYPES);
                allowedTypes = group.getTransferTypes();
            } else if (LoggedUser.isBroker()) {
                BrokerGroup brokerGroup = this.fetchService.fetch((BrokerGroup)LoggedUser.group(), BrokerGroup.Relationships.TRANSFER_TYPES_AS_MEMBER);
                allowedTypes = brokerGroup.getTransferTypesAsMember();
            } else if (LoggedUser.isAdministrator()) {
                AdminGroup admGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER);
                allowedTypes = admGroup.getTransferTypesAsMember();
            }
            hasPermission = allowedTypes.contains(transferType);
        }
        if (hasPermission && checkToMember) {
            return this.permissionService.relatesTo((Member)to);
        }
        return hasPermission;
    }

    @Override
    public Transfer chargeback(Transfer transfer) throws UnexpectedEntityException {
        if (!this.canChargeback(transfer, false)) {
            throw new UnexpectedEntityException();
        }
        return this.insertChargeback(transfer, true);
    }

    @Override
    public Transfer conciliate(Transfer transfer, ExternalTransfer externalTransfer) {
        Account from;
        AccountOwner owner;
        if ((transfer = this.fetchService.fetch(transfer, CONCILIATION_FETCH)) != null && transfer.getExternalTransfer() != null) {
            transfer = null;
        }
        if (transfer != null && !(owner = (from = transfer.getFrom()).getOwner()).equals(externalTransfer.getMember())) {
            transfer = null;
        }
        if (transfer == null) {
            throw new UnexpectedEntityException();
        }
        return this.transferDao.updateExternalTransfer(transfer.getId(), externalTransfer);
    }

    @Override
    public Transfer confirmPayment(String ticketStr) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, EntityNotFoundException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        PaymentRequestTicket ticket = this.ticketService.loadPendingPaymentRequest(ticketStr, new Relationship[0]);
        Member fromMember = ticket.getFrom();
        Member toMember = ticket.getTo();
        String channel = ticket.getToChannel().getInternalName();
        String description = ticket.getDescription();
        TransferDTO dto = new TransferDTO();
        dto.setFromOwner(fromMember);
        dto.setToOwner(toMember);
        dto.setTransferType(ticket.getTransferType());
        dto.setAmount(ticket.getAmount());
        dto.setChannel(channel);
        dto.setTicket(ticket);
        dto.setDescription(description);
        Transfer transfer = (Transfer)this.insert(dto, true, false);
        ticket.setStatus(Ticket.Status.OK);
        ticket.setTransfer(transfer);
        this.memberNotificationHandler.externalChannelPaymentConfirmed(ticket);
        return transfer;
    }

    @Override
    public List<BulkPaymentResult> doBulkPayment(final List<DoPaymentDTO> dtos) {
        return this.transactionHelper.runInNewTransaction(new Transactional<List<BulkPaymentResult>>(){

            @Override
            public List<BulkPaymentResult> afterCommit(List<BulkPaymentResult> result) {
                for (BulkPaymentResult bulkPaymentResult : result) {
                    bulkPaymentResult.setPayment(PaymentServiceImpl.this.fetchService.fetch(bulkPaymentResult.getPayment(), new Relationship[0]));
                }
                return result;
            }

            public List<BulkPaymentResult> doInTransaction(TransactionStatus status) {
                ArrayList<BulkPaymentResult> results = new ArrayList<BulkPaymentResult>(dtos.size());
                try {
                    for (DoPaymentDTO dto : dtos) {
                        Payment payment = PaymentServiceImpl.this.doPayment(dto, false, true, false);
                        results.add(new BulkPaymentResult(payment));
                    }
                }
                catch (ApplicationException e) {
                    results.add(new BulkPaymentResult(e));
                    status.setRollbackOnly();
                }
                return results;
            }
        });
    }

    @Override
    public Payment doPayment(DoPaymentDTO params) {
        return this.doPayment(params, true, true, false);
    }

    @Override
    public AccountHistoryResultPage getAccountHistoryResultPage(AccountHistoryParams params) {
        TransferQuery query = this.paymentHelper.toTransferQuery(params);
        List<Transfer> transfers = this.search(query);
        AccountHistoryResultPage result = this.accountHelper.toAccountHistoryResultPage(query.getOwner(), transfers);
        if (params.getShowStatus()) {
            AccountStatusVO statusVO = this.accountService.getCurrentAccountStatusVO(new AccountDTO(query.getOwner(), query.getType()));
            result.setAccountStatus(statusVO);
        }
        return result;
    }

    @Override
    public AccountHistoryTransferVO getAccountHistoryTransferVO(Long id) {
        Transfer transfer = this.load(id, new Relationship[0]);
        List<PaymentCustomField> fields = this.paymentCustomFieldService.list(transfer.getType(), false);
        return this.accountHelper.toVO(LoggedUser.member(), transfer, fields, null, null);
    }

    @Override
    public ConversionSimulationDTO getDefaultConversionDTO(MemberAccount account, List<TransferType> transferTypes) {
        account = this.fetchService.fetch(account, Account.Relationships.TYPE, MemberAccount.Relationships.MEMBER);
        AccountStatus status = this.accountService.getRatedStatus(account, null);
        ConversionSimulationDTO dto = new ConversionSimulationDTO();
        dto.setAccount(account);
        BigDecimal defaultAmount = status.getAvailableBalanceWithoutCreditLimit();
        if (BigDecimal.ZERO.compareTo(defaultAmount) > 0) {
            defaultAmount = BigDecimal.ZERO;
        }
        dto.setAmount(defaultAmount);
        for (TransferType currentTT : transferTypes) {
            if (!currentTT.isHavingRatedFees()) continue;
            dto.setTransferType(currentTT);
            break;
        }
        if (dto.getTransferType() == null) {
            dto.setTransferType(transferTypes.get(0));
        }
        dto.setDate(Calendar.getInstance());
        dto.setArate(null);
        dto.setDrate(null);
        if (dto.getTransferType().isHavingRatedFees() && BigDecimal.ZERO.compareTo(defaultAmount) < 0) {
            if (dto.getTransferType().isHavingAratedFees()) {
                BigDecimal aRate = status.getaRate();
                dto.setArate(aRate);
            }
            if (dto.getTransferType().isHavingDratedFees()) {
                BigDecimal dRate = status.getdRate();
                dto.setDrate(dRate);
            }
        }
        return dto;
    }

    @Override
    public BigDecimal getMinimumPayment() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        int precision = localSettings.getPrecision().getValue();
        BigDecimal minimumPayment = new BigDecimal(new BigInteger("1"), precision);
        return minimumPayment;
    }

    @Override
    public StatisticalResultDTO getSimulateConversionGraph(ConversionSimulationDTO input) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        byte precision = (byte)localSettings.getPrecision().getValue();
        TransactionFeePreviewForRatesDTO temp = this.simulateConversion(input);
        int series = temp.getFees().size();
        BigDecimal initialARate = null;
        RatesResultDTO rates = new RatesResultDTO();
        if (input.isUseActualRates()) {
            rates = this.rateService.getRatesForTransferFrom(input.getAccount(), input.getAmount(), null);
            rates.setDate(input.getDate());
            initialARate = rates.getaRate();
        } else {
            initialARate = input.getArate();
        }
        Double lowerLimit = initialARate == null ? null : Double.valueOf(initialARate.negate().doubleValue());
        Number[] xRange = GraphHelper.getOptimalRangeAround(0, 33.0, 0, 0.8, lowerLimit);
        Number[][] tableCells = new Number[xRange.length][series];
        String[] seriesNames = new String[series];
        byte[] seriesOrder = new byte[series];
        Calendar[] xPointDates = new Calendar[xRange.length];
        Calendar now = Calendar.getInstance();
        BigDecimal inputARate = temp.getARate();
        BigDecimal inputDRate = temp.getDRate();
        for (int i = 0; i < xRange.length; ++i) {
            ConversionSimulationDTO inputPointX = (ConversionSimulationDTO)input.clone();
            Calendar date = (Calendar)(input.isUseActualRates() ? input.getDate().clone() : now.clone());
            date.add(6, xRange[i].intValue());
            xPointDates[i] = date;
            inputPointX.setUseActualRates(false);
            if (inputARate != null) {
                BigDecimal aRate = inputARate.add(new BigDecimal(xRange[i].doubleValue()));
                inputPointX.setArate(aRate);
            }
            if (inputDRate != null) {
                BigDecimal dRate = inputDRate.subtract(new BigDecimal(xRange[i].doubleValue()));
                inputPointX.setDrate(dRate);
            }
            TransactionFeePreviewForRatesDTO tempResult = this.simulateConversion(inputPointX);
            int j = 0;
            for (TransactionFee fee : tempResult.getFees().keySet()) {
                int index;
                tableCells[i][j] = new StatisticalNumber(tempResult.getFees().get(fee).doubleValue(), precision);
                switch (fee.getChargeType()) {
                    case D_RATE: {
                        index = 2;
                        break;
                    }
                    case A_RATE: 
                    case MIXED_A_D_RATES: {
                        index = 3;
                        break;
                    }
                    default: {
                        index = 1;
                    }
                }
                seriesOrder[j] = index;
                seriesNames[j++] = fee.getName();
            }
        }
        StatisticalResultDTO result = new StatisticalResultDTO(tableCells);
        result.setBaseKey("conversionSimulation.result.graph");
        result.setHelpFile("account_management");
        Object[] rowKeys = new String[xRange.length];
        Arrays.fill(rowKeys, "");
        result.setRowKeys((String[])rowKeys);
        for (int i = 0; i < rowKeys.length; ++i) {
            String rowHeader = localSettings.getDateConverterForGraphs().toString(xPointDates[i]);
            result.setRowHeader(rowHeader, i);
        }
        Calendar baseDate = input.isUseActualRates() ? (Calendar)input.getDate().clone() : now;
        String baseDateString = localSettings.getDateConverterForGraphs().toString(baseDate);
        Marker[] markers = new Marker[]{new CategoryMarker((Comparable)((Object)baseDateString))};
        markers[0].setPaint((Paint)Color.ORANGE);
        String todayString = localSettings.getDateConverterForGraphs().toString(now);
        if (todayString.equals(baseDateString)) {
            markers[0].setLabel("global.today");
        }
        result.setDomainMarkers(markers);
        Object[] columnKeys = new String[series];
        Arrays.fill(columnKeys, "");
        result.setColumnKeys((String[])columnKeys);
        for (int j = 0; j < columnKeys.length; ++j) {
            result.setColumnHeader(seriesNames[j], j);
        }
        result.orderSeries(seriesOrder);
        TransferType tt = this.fetchService.fetch(input.getTransferType(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        result.setYAxisUnits(tt.getCurrency().getSymbol());
        result.setShowTable(false);
        result.setGraphType(StatisticalResultDTO.GraphType.STACKED_AREA);
        return result;
    }

    @Override
    public boolean hasPermissionsToChargeback(Transfer transfer) {
        boolean isFromMember;
        boolean bl = isFromMember = !(transfer = this.fetchService.fetch(transfer, RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER))).isFromSystem();
        if (isFromMember && !this.permissionService.relatesTo((Member)transfer.getFromOwner())) {
            return false;
        }
        if (transfer.isToSystem()) {
            return this.permissionService.permission().adminFor(AdminSystemPermission.PAYMENTS_CHARGEBACK, transfer.getType()).hasPermission();
        }
        return this.permissionService.permission((Member)transfer.getToOwner()).adminFor(AdminMemberPermission.PAYMENTS_CHARGEBACK, transfer.getType()).memberFor(MemberPermission.PAYMENTS_CHARGEBACK, transfer.getType()).hasPermission();
    }

    @Override
    public Payment insertWithNotification(TransferDTO dto) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException {
        Payment payment = this.insert(dto, false, false);
        if (payment instanceof Transfer) {
            this.memberNotificationHandler.automaticPaymentReceivedNotification((Transfer)payment, dto);
        }
        return payment;
    }

    @Override
    public Payment insertWithoutNotification(TransferDTO dto) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException {
        return this.insert(dto, false, false);
    }

    @Override
    public boolean isVisible(Payment payment) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        if (payment instanceof Transfer && LoggedUser.isOperator()) {
            Transfer transfer = (Transfer)payment;
            if (((Entity)LoggedUser.element()).equals(transfer.getReceiver()) || ((Entity)LoggedUser.element()).equals(transfer.getBy())) {
                return true;
            }
        }
        payment = payment instanceof Transfer ? (Payment)this.fetchService.fetch((Transfer)payment, Payment.Relationships.FROM, Payment.Relationships.TO) : (Payment)this.fetchService.fetch((ScheduledPayment)payment, Payment.Relationships.FROM, Payment.Relationships.TO);
        return this.accountService.canView(payment.getFrom()) || this.accountService.canView(payment.getTo());
    }

    @Override
    public Transfer load(Long id, Relationship ... fetch) {
        return (Transfer)this.transferDao.load(id, fetch);
    }

    @Override
    public Transfer loadTransferForReverse(String traceNumber, Relationship ... fetch) throws EntityNotFoundException {
        long clientId = LoggedUser.serviceClient().getId();
        Transfer transfer = this.transferDao.loadTransferByTraceNumber(traceNumber, clientId, new Relationship[0]);
        if (transfer == null) {
            if (!this.insertTN(LoggedUser.serviceClient().getId(), traceNumber)) {
                transfer = this.transferDao.loadTransferByTraceNumber(traceNumber, clientId, new Relationship[0]);
            }
            if (transfer == null) {
                throw new EntityNotFoundException(Transfer.class, null, String.format("TraceNumber and client id used to load: <%1$s, %2$s>", traceNumber, clientId));
            }
        }
        return transfer;
    }

    @Override
    public void notifyTransferProcessed(final Transfer transfer) {
        if (transfer.getProcessDate() == null) {
            return;
        }
        final Collection<TransferListener> listeners = this.getTransferListeners(transfer);
        if (CollectionUtils.isNotEmpty(listeners)) {
            CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

                @Override
                public void onTransactionCommit() {
                    PaymentServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            Transfer fetchedTransfer = PaymentServiceImpl.this.fetchService.fetch(transfer, Payment.Relationships.FROM, Payment.Relationships.TO);
                            for (TransferListener listener : listeners) {
                                try {
                                    listener.onTransferProcessed(fetchedTransfer);
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)("Error running TransferListener " + listener), (Throwable)e);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processScheduled(Period period) {
        TransferQuery query = new TransferQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setPeriod(period);
        query.setStatus(Payment.Status.SCHEDULED);
        query.setUnordered(true);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        List<Transfer> transfers = this.transferDao.search(query);
        try {
            for (Transfer transfer : transfers) {
                this.processScheduledTransfer(transfer, true, true, true);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(transfers);
        }
    }

    @Override
    public Transfer processScheduled(Transfer transfer) {
        return this.processScheduledTransfer(transfer, false, false, true);
    }

    @Override
    public void purgeOldTraceNumbers(Calendar time) {
        Calendar c = (Calendar)time.clone();
        c.add(5, -1);
        this.traceNumberDao.delete(c);
    }

    @Override
    public List<Transfer> search(TransferQuery query) {
        return this.transferDao.search(query);
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    public void setCustomObjectHandler(CustomObjectHandler customObjectHandler) {
        this.customObjectHandler = customObjectHandler;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLockHandlerFactory(LockHandlerFactory lockHandlerFactory) {
        this.lockHandlerFactory = lockHandlerFactory;
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentHelper(PaymentHelper paymentHelper) {
        this.paymentHelper = paymentHelper;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setScheduledPaymentDao(ScheduledPaymentDAO scheduledPaymentDao) {
        this.scheduledPaymentDao = scheduledPaymentDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTicketServiceLocal(TicketServiceLocal ticketService) {
        this.ticketService = ticketService;
    }

    public void setTraceNumberDao(TraceNumberDAO traceNumberDao) {
        this.traceNumberDao = traceNumberDao;
    }

    public void setTransactionFeeServiceLocal(TransactionFeeServiceLocal transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public TransactionFeePreviewForRatesDTO simulateConversion(ConversionSimulationDTO params) {
        TransferType transferType = params.getTransferType();
        transferType = this.fetchService.fetch(transferType, TransferType.Relationships.TO, TransferType.Relationships.TRANSACTION_FEES, RelationshipHelper.nested(SystemAccountType.Relationships.ACCOUNT));
        MemberAccount account = this.fetchService.fetch(params.getAccount(), Account.Relationships.TYPE, MemberAccount.Relationships.MEMBER);
        RatesPreviewDTO rates = new RatesPreviewDTO();
        if (params.isUseActualRates()) {
            rates = new RatesPreviewDTO(this.rateService.getRatesForTransferFrom(account, params.getAmount(), params.getDate()));
        } else {
            if (transferType.isHavingAratedFees()) {
                rates.setaRate(params.getArate());
            }
            if (transferType.isHavingDratedFees()) {
                rates.setdRate(params.getDrate());
            }
            rates.setDate(params.getDate());
            rates = new RatesPreviewDTO(this.rateService.rateToDate(rates));
        }
        rates.setGraph(params.isGraph());
        Member from = account.getMember();
        BigDecimal amount = params.getAmount();
        SystemAccountOwner to = SystemAccountOwner.instance();
        TransactionFeePreviewForRatesDTO preview = (TransactionFeePreviewForRatesDTO)this.transactionFeeService.preview(from, to, transferType, amount, rates);
        return preview;
    }

    @Override
    public Payment simulatePayment(final DoPaymentDTO params) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        return this.transactionHelper.runInNewTransaction(new BaseTransactional<Payment>(){

            public Payment doInTransaction(TransactionStatus status) {
                status.setRollbackOnly();
                return PaymentServiceImpl.this.doPayment(params, false, false, true);
            }
        });
    }

    @Override
    public void validate(ConversionSimulationDTO dto) {
        Validator validator = new Validator("");
        validator.property("amount").key("conversionSimulation.amount").required().positiveNonZero();
        if (dto.isUseActualRates()) {
            validator.property("date").key("conversionSimulation.date").required();
        } else {
            Account account = this.fetchService.fetch(dto.getAccount(), RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY));
            TransferType transferType = this.fetchService.fetch(dto.getTransferType(), TransferType.Relationships.TRANSACTION_FEES);
            Currency currency = account.getType().getCurrency();
            if (currency.isEnableARate() && transferType.isHavingAratedFees()) {
                validator.property("arate").key("conversionSimulation.aRate.targeted").required().positive();
            }
            if (currency.isEnableDRate() && transferType.isHavingDratedFees()) {
                validator.property("drate").key("conversionSimulation.dRate.targeted").required();
            }
        }
        validator.validate(dto);
    }

    @Override
    public void validate(DoPaymentDTO payment) {
        this.getPaymentValidator(payment).validate(payment);
    }

    @Override
    public void validateMaxAmountAtDate(Calendar date, Account account, TransferType transferType, BigDecimal maxAmountPerDay, BigDecimal amount) {
        BigDecimal amountOnDay;
        BigDecimal bigDecimal = maxAmountPerDay = maxAmountPerDay == null ? transferType.getMaxAmountPerDay() : maxAmountPerDay;
        if (maxAmountPerDay != null && maxAmountPerDay.floatValue() > 1.0E-4f && (amountOnDay = this.transferDao.getTransactionedAmountAt(date, account, transferType)).add(amount).compareTo(maxAmountPerDay) > 0) {
            throw new MaxAmountPerDayExceededException(date, transferType, account, amount);
        }
        if (LoggedUser.hasUser() && LoggedUser.isOperator()) {
            BigDecimal amountOnDay2;
            Operator operator = (Operator)LoggedUser.element();
            OperatorGroup group = operator.getOperatorGroup();
            BigDecimal maxAmount = (group = this.fetchService.fetch(group, OperatorGroup.Relationships.MAX_AMOUNT_PER_DAY_BY_TRANSFER_TYPE)).getMaxAmountPerDayByTransferType().get(transferType);
            if (maxAmount != null && maxAmount.floatValue() > 1.0E-4f && (amountOnDay2 = this.transferDao.getTransactionedAmountAt(date, operator, account, transferType)).add(amount).compareTo(maxAmount) == 1) {
                throw new MaxAmountPerDayExceededException(date, transferType, account, amount);
            }
        }
    }

    @Override
    public boolean wouldRequireAuthorization(DoPaymentDTO params) {
        AuthorizationLevel firstAuthorizationLevel = null;
        if (CollectionUtils.isEmpty(params.getPayments())) {
            firstAuthorizationLevel = this.firstAuthorizationLevel(params.getTransferType(), params.getAmount(), params.getFrom());
        }
        return firstAuthorizationLevel != null;
    }

    @Override
    public boolean wouldRequireAuthorization(Invoice invoice) {
        DoPaymentDTO payment = new DoPaymentDTO();
        payment.setFrom(invoice.getTo());
        payment.setTo(invoice.getFrom());
        payment.setTransferType(invoice.getTransferType());
        payment.setAmount(invoice.getAmount());
        return this.wouldRequireAuthorization(payment);
    }

    @Override
    public boolean wouldRequireAuthorization(Transfer transfer) {
        return this.firstAuthorizationLevel(transfer) != null;
    }

    @Override
    public boolean wouldRequireAuthorization(TransferType transferType, BigDecimal amount, AccountOwner from) {
        return this.firstAuthorizationLevel(transferType, amount, from) != null;
    }

    private void addAmountValidator(Validator validator, TransferType tt) {
        Validator.Property amountProperty = validator.property("amount").required().positiveNonZero();
        if (tt != null && tt.getMinAmount() != null) {
            amountProperty.greaterEquals(tt.getMinAmount());
        }
    }

    private Payment doInsert(final TransferDTO dto, boolean newTransaction, final boolean simulation) {
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Payment>(){

            @Override
            public Payment afterCommit(Payment payment) {
                return PaymentServiceImpl.this.fetchService.fetch(payment, new Relationship[0]);
            }

            public Payment doInTransaction(TransactionStatus status) {
                return PaymentServiceImpl.this.performInsert(dto, simulation);
            }
        }, newTransaction);
    }

    private Payment doPayment(DoPaymentDTO params, boolean newTransaction, boolean notify, boolean simulation) {
        if (params.getDate() != null && !this.permissionService.hasPermission(AdminMemberPermission.PAYMENTS_PAYMENT_WITH_DATE)) {
            throw new PermissionDeniedException();
        }
        this.validate(params);
        TransferDTO dto = this.verify(params);
        Payment payment = this.doInsert(dto, newTransaction, simulation);
        if (notify) {
            if (LoggedUser.isWebService()) {
                this.memberNotificationHandler.externalChannelPaymentPerformed(params, payment);
            } else {
                this.memberNotificationHandler.paymentReceivedNotification(payment);
            }
            if (payment instanceof Transfer) {
                Transfer transfer = (Transfer)payment;
                if (payment.getProcessDate() == null) {
                    this.adminNotificationHandler.notifyNewPendingPayment(transfer);
                } else {
                    this.adminNotificationHandler.notifyPayment(transfer);
                }
            }
        }
        return payment;
    }

    private Transfer doProcessScheduledTransfer(LockHandler lockHandler, Transfer transfer, boolean failOnError, boolean notifyPayer, boolean notifyReceiver) {
        ScheduledPayment scheduledPayment = (transfer = this.fetchService.fetch(transfer, Transfer.Relationships.SCHEDULED_PAYMENT)).getScheduledPayment();
        if (scheduledPayment == null || !transfer.getStatus().canPayNow()) {
            throw new UnexpectedEntityException();
        }
        Account from = transfer.getFrom();
        Account to = transfer.getTo();
        LockedAccountsOnPayments lockedAccountsOnPayments = this.applicationService.getLockedAccountsOnPayments();
        if (lockedAccountsOnPayments == LockedAccountsOnPayments.ORIGIN) {
            lockHandler.lock(from);
        } else if (lockedAccountsOnPayments == LockedAccountsOnPayments.ALL) {
            lockHandler.lock(from, to);
        }
        transfer = this.fetchService.reload(transfer, Transfer.Relationships.SCHEDULED_PAYMENT);
        scheduledPayment = transfer.getScheduledPayment();
        if (!transfer.getStatus().canPayNow()) {
            throw new UnexpectedEntityException();
        }
        BigDecimal amount = transfer.getAmount();
        TransferType transferType = transfer.getType();
        AuthorizationLevel firstAuthorizationLevel = this.firstAuthorizationLevel(transfer);
        try {
            Account fromAccountToValidate = from;
            if (scheduledPayment.isReserveAmount()) {
                fromAccountToValidate = null;
            }
            Collection<TransferListener> listeners = this.getTransferListeners(transfer);
            for (TransferListener listener : listeners) {
                listener.onBeforeValidateBalance(transfer);
            }
            this.validateAmount(amount, fromAccountToValidate, to, transfer);
            TransactionFeePreviewDTO preview = this.transactionFeeService.preview(from.getOwner(), to.getOwner(), transferType, amount);
            transfer.setAmount(preview.getFinalAmount());
            if (LoggedUser.hasUser()) {
                transfer.setBy((Element)LoggedUser.element());
            }
            boolean shouldLiberateAmount = false;
            if (firstAuthorizationLevel != null) {
                transfer.setStatus(Payment.Status.PENDING);
                transfer.setNextAuthorizationLevel(firstAuthorizationLevel);
                if (!scheduledPayment.isReserveAmount()) {
                    this.accountService.reservePending(transfer);
                }
            } else {
                RatesToSave rates = this.rateService.applyTransfer(transfer);
                Calendar processDate = rates.getFromRates() == null ? Calendar.getInstance() : rates.getFromRates().getDate();
                transfer.setStatus(Payment.Status.PROCESSED);
                transfer.setProcessDate(processDate);
                this.rateService.persist(rates);
                transfer.setEmissionDate(rates.getEmissionDate());
                transfer.setExpirationDate(rates.getExpirationDate());
                transfer.setiRate(rates.getiRate());
                shouldLiberateAmount = scheduledPayment.isReserveAmount();
                LocalSettings.TransactionNumber transactionNumber = this.settingsService.getLocalSettings().getTransactionNumber();
                if (transactionNumber != null && transactionNumber.isValid()) {
                    String generated = transactionNumber.generate(transfer.getId(), transfer.getProcessDate());
                    transfer.setTransactionNumber(generated);
                }
            }
            for (TransferListener listener : listeners) {
                listener.onTransferInserted(transfer);
            }
            this.transferDao.update(transfer);
            this.accountService.removeClosedBalancesAfter(transfer.getFrom(), transfer.getProcessDate());
            this.accountService.removeClosedBalancesAfter(transfer.getTo(), transfer.getProcessDate());
            this.notifyTransferProcessed(transfer);
            this.insertFees(lockHandler, transfer, false, amount, false, new HashSet<ChargedFee>());
            if (shouldLiberateAmount) {
                this.accountService.returnReservationForInstallment(transfer);
            }
            this.updateScheduledPaymentStatus(scheduledPayment);
            this.memberNotificationHandler.scheduledPaymentProcessingNotification(transfer, notifyPayer, notifyReceiver);
            if (transfer.getProcessDate() == null) {
                this.adminNotificationHandler.notifyNewPendingPayment(transfer);
            }
        }
        catch (RuntimeException e) {
            if (failOnError) {
                this.transferDao.updateStatus(transfer.getId(), Payment.Status.FAILED);
                this.updateScheduledPaymentStatus(scheduledPayment);
                if (scheduledPayment.isReserveAmount()) {
                    this.accountService.returnReservationForInstallment(transfer);
                }
                this.memberNotificationHandler.scheduledPaymentProcessingNotification(transfer, notifyPayer, notifyReceiver);
                if (transfer.isFromSystem()) {
                    Member member = (Member)transfer.getToOwner();
                    LocalSettings settings = this.settingsService.getLocalSettings();
                    Object[] arguments = new Object[]{settings.getUnitsConverter(transfer.getType().getFrom().getCurrency().getPattern()).toString(transfer.getAmount()), transfer.getType().getName()};
                    this.alertService.create(member, MemberAlert.Alerts.SCHEDULED_PAYMENT_FAILED, arguments);
                }
            }
            throw e;
        }
        return transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transfer doProcessScheduledTransfer(Transfer transfer, boolean failOnError, boolean notifyPayer, boolean notifyReceiver) {
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandlerIfLockingAccounts();
        try {
            Transfer transfer2 = this.doProcessScheduledTransfer(lockHandler, transfer, failOnError, notifyPayer, notifyReceiver);
            return transfer2;
        }
        finally {
            if (lockHandler != null) {
                lockHandler.release();
            }
        }
    }

    private AuthorizationLevel firstAuthorizationLevel(Transfer transfer) {
        if (transfer.getScheduledPayment() != null) {
            for (Transfer installment : transfer.getScheduledPayment().getTransfers()) {
                if (installment.getProcessDate() == null) continue;
                return null;
            }
        }
        return this.firstAuthorizationLevel(transfer.getType(), transfer.getAmount(), transfer.getFromOwner());
    }

    private AuthorizationLevel firstAuthorizationLevel(TransferType transferType, BigDecimal amount, AccountOwner from) {
        if ((transferType = this.fetchService.fetch(transferType, TransferType.Relationships.AUTHORIZATION_LEVELS)).isRequiresAuthorization() && CollectionUtils.isNotEmpty(transferType.getAuthorizationLevels())) {
            if (from == null) {
                from = LoggedUser.accountOwner();
            }
            Account account = this.accountService.getAccount(new AccountDTO(from, transferType.getFrom()), new Relationship[0]);
            BigDecimal amountSoFarToday = this.transferDao.getTransactionedAmountAt(null, account, transferType);
            AuthorizationLevel authorization = transferType.getAuthorizationLevels().iterator().next();
            BigDecimal amountToTest = amountSoFarToday.add(amount);
            if (amountToTest.compareTo(authorization.getAmount()) >= 0) {
                return transferType.getAuthorizationLevels().iterator().next();
            }
        }
        return null;
    }

    private Validator getPaymentValidator(final DoPaymentDTO payment) {
        Currency currency;
        Validator validator = new Validator("transfer");
        ArrayList<TransactionContext> possibleContexts = new ArrayList<TransactionContext>();
        possibleContexts.add(TransactionContext.PAYMENT);
        if (LoggedUser.isWebService() || LoggedUser.isSystem()) {
            possibleContexts.add(TransactionContext.AUTOMATIC);
        } else {
            possibleContexts.add(TransactionContext.SELF_PAYMENT);
        }
        validator.property("context").required().anyOf(possibleContexts);
        validator.property("to").required().key("payment.recipient");
        TransferType tt = this.fetchService.fetch(payment.getTransferType(), TransferType.Relationships.TRANSACTION_FEES, RelationshipHelper.nested(TransferType.Relationships.FROM, TransferType.Relationships.TO, AccountType.Relationships.CURRENCY, Currency.Relationships.A_RATE_PARAMETERS), RelationshipHelper.nested(TransferType.Relationships.FROM, TransferType.Relationships.TO, AccountType.Relationships.CURRENCY, Currency.Relationships.D_RATE_PARAMETERS));
        Currency currency2 = currency = tt == null ? null : tt.getCurrency();
        if (currency != null && (currency.isEnableARate() || currency.isEnableDRate())) {
            if (payment.getDate() != null) {
                validator.general(new NoPastDateWithRatesValidator());
            }
        } else {
            validator.property("date").key("payment.manualDate").past();
        }
        validator.property("ticket").add(new TicketValidation());
        this.addAmountValidator(validator, tt);
        validator.property("transferType").key("transfer.type").required();
        validator.property("description").maxLength(1000);
        validator.general(new SchedulingValidator());
        validator.general(new PendingContractValidator());
        if (payment.getTransferType() != null && payment.getTo() != null && payment.getAmount() != null) {
            TransactionFeePreviewDTO preview = this.transactionFeeService.preview(payment.getFrom(), payment.getTo(), tt, payment.getAmount());
            Validator.Property amount = validator.property("amount");
            Set<TransactionFee> fees = preview.getFees().keySet();
            BigDecimal sumOfFixedFees = BigDecimal.ZERO;
            BigDecimal sumOfPercentageFees = BigDecimal.ZERO;
            for (TransactionFee fee : fees) {
                if (!fee.isDeductAmount()) continue;
                if (fee.getChargeType() == TransactionFee.ChargeType.FIXED) {
                    sumOfFixedFees = sumOfFixedFees.add(preview.getFees().get(fee));
                    continue;
                }
                sumOfPercentageFees = sumOfPercentageFees.add(preview.getFees().get(fee));
            }
            if (sumOfFixedFees.signum() == 1) {
                int scale = 10;
                MathContext mc = new MathContext(10);
                BigDecimal sumOfPercentages = sumOfPercentageFees.divide(payment.getAmount(), mc);
                BigDecimal minimalAmount = sumOfFixedFees.divide(BigDecimal.ONE.subtract(sumOfPercentages), mc);
                amount.comparable(minimalAmount, ">", new ValidationError("errors.greaterThan", this.messageResolver.message("transactionFee.invalidChargeValue", minimalAmount)));
            } else if (preview.getFinalAmount().signum() == -1) {
                validator.general(new FinalAmountValidator());
            }
            validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                @Override
                public Validator getValidator() {
                    return PaymentServiceImpl.this.paymentCustomFieldService.getValueValidator(payment.getTransferType());
                }
            }));
        }
        return validator;
    }

    private Validator getProjectionValidator() {
        Validator projectionValidator = new Validator("transfer");
        projectionValidator.property("paymentCount").required().positiveNonZero().add(new PropertyValidation(){
            private static final long serialVersionUID = 5022911381764849941L;

            @Override
            public ValidationError validate(Object object, Object property, Object value) {
                Integer paymentCount = (Integer)value;
                if (paymentCount == null) {
                    return null;
                }
                ProjectionDTO dto = (ProjectionDTO)object;
                AccountOwner from = dto.getFrom();
                if (from instanceof Member) {
                    Member member = PaymentServiceImpl.this.fetchService.fetch((Member)from, Element.Relationships.GROUP);
                    int maxSchedulingPayments = member.getMemberGroup().getMemberSettings().getMaxSchedulingPayments();
                    return CompareToValidation.lessEquals(Integer.valueOf(maxSchedulingPayments)).validate(object, property, value);
                }
                return null;
            }
        });
        projectionValidator.property("amount").required().positiveNonZero();
        projectionValidator.property("firstExpirationDate").key("transfer.firstPaymentDate").required().add(new PropertyValidation(){
            private static final long serialVersionUID = -3612786027250751763L;

            @Override
            public ValidationError validate(Object object, Object property, Object value) {
                Calendar firstDate = CoercionHelper.coerce(Calendar.class, value);
                if (firstDate == null) {
                    return null;
                }
                if (firstDate.before(DateHelper.truncate(Calendar.getInstance()))) {
                    return new InvalidError();
                }
                return null;
            }
        });
        projectionValidator.property("recurrence.number").key("transfer.paymentEvery").required().between(1, 100);
        projectionValidator.property("recurrence.field").key("transfer.paymentEvery").required().anyOf(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS);
        return projectionValidator;
    }

    private Transfer getTopMost(Transfer transfer) {
        Transfer topMost = transfer;
        while (topMost.getParent() != null) {
            topMost = topMost.getParent();
        }
        return topMost;
    }

    private Collection<TransferListener> getTransferListeners(Transfer transfer) {
        LocalSettings settings;
        TransferType type = transfer.getType();
        ArrayList<TransferListener> result = new ArrayList<TransferListener>(2);
        if (StringUtils.isNotEmpty((String)type.getTransferListenerClass())) {
            TransferListener listener = (TransferListener)this.customObjectHandler.get(type.getTransferListenerClass());
            result.add(listener);
        }
        if (StringUtils.isNotEmpty((String)(settings = this.settingsService.getLocalSettings()).getTransferListenerClass())) {
            TransferListener listener = (TransferListener)this.customObjectHandler.get(settings.getTransferListenerClass());
            result.add(listener);
        }
        return result;
    }

    private Validator getTransferValidator(final TransferDTO transfer) {
        Validator validator = new Validator("transfer");
        TransferType tt = this.fetchService.fetch(transfer.getTransferType(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY, Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS));
        Currency currency = tt.getCurrency();
        if (currency.isEnableARate() || currency.isEnableDRate()) {
            Calendar now = Calendar.getInstance();
            now.add(12, -4);
            Calendar date = transfer.getDate();
            if (date != null && date.before(now)) {
                validator.general(new NoPastDateWithRatesValidator());
            }
        } else {
            validator.property("date").key("payment.manualDate").pastOrToday();
        }
        validator.property("fromOwner").required();
        validator.property("toOwner").required();
        this.addAmountValidator(validator, tt);
        validator.property("transferType").key("transfer.type").required();
        validator.property("description").maxLength(1000);
        validator.property("traceNumber").add(new TraceNumberValidation());
        if (transfer.getTransferType() != null) {
            validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                @Override
                public Validator getValidator() {
                    return PaymentServiceImpl.this.paymentCustomFieldService.getValueValidator(transfer.getTransferType());
                }
            }));
        }
        return validator;
    }

    private Payment insert(TransferDTO dto, boolean newTransaction, boolean simulation) {
        this.verify(dto);
        return this.doInsert(dto, newTransaction, simulation);
    }

    private Transfer insertChargeback(final Transfer transfer, boolean newTransaction) {
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return PaymentServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return PaymentServiceImpl.this.performChargeback(transfer);
            }
        }, newTransaction);
    }

    private void insertFees(LockHandler lockHandler, Transfer transfer, boolean forced, BigDecimal originalAmount, boolean simulation, Set<ChargedFee> chargedFees) {
        TransferType transferType = transfer.getType();
        Account from = transfer.getFrom();
        Account to = transfer.getTo();
        TransactionFeeQuery query = new TransactionFeeQuery();
        query.setTransferType(transferType);
        List<? extends TransactionFee> fees = this.transactionFeeService.search(query);
        BigDecimal totalPercentage = BigDecimal.ZERO;
        BigDecimal feeTotalAmount = BigDecimal.ZERO;
        Transfer topMost = this.getTopMost(transfer);
        Calendar date = topMost.getDate();
        transfer.setChildren(new ArrayList<Transfer>());
        for (TransactionFee transactionFee : fees) {
            Account toAccount;
            Account fromAccount;
            ChargedFee key = new ChargedFee(transactionFee, fromAccount = this.fetchService.fetch(from, Account.Relationships.TYPE, MemberAccount.Relationships.MEMBER), toAccount = this.fetchService.fetch(to, Account.Relationships.TYPE, MemberAccount.Relationships.MEMBER));
            if (chargedFees.contains(key)) {
                throw new ValidationException("payment.error.circularFees", new Object[0]);
            }
            chargedFees.add(key);
            BuildTransferWithFeesDTO params = new BuildTransferWithFeesDTO(date, fromAccount, toAccount, originalAmount, transactionFee, false);
            params.setEmissionDate(transfer.getEmissionDate());
            params.setExpirationDate(transfer.getExpirationDate());
            Transfer feeTransfer = this.transactionFeeService.buildTransfer(params);
            if (feeTransfer == null) continue;
            if (transactionFee instanceof SimpleTransactionFee && transactionFee.getAmount().isPercentage()) {
                BigDecimal feeValue = transactionFee.getAmount().getValue();
                if (!(totalPercentage.equals(BigDecimal.ZERO) && feeValue.doubleValue() == 100.0 || (totalPercentage = totalPercentage.add(feeValue)).compareTo(new BigDecimal(100)) != 0 || feeTransfer == null)) {
                    feeTransfer.setAmount(originalAmount.subtract(feeTotalAmount));
                }
            }
            if (feeTransfer == null || !(feeTransfer.getAmount().floatValue() > 1.0E-4f)) continue;
            feeTotalAmount = feeTotalAmount.add(feeTransfer.getAmount());
            feeTransfer.setParent(transfer);
            feeTransfer.setDate(transfer.getDate());
            feeTransfer.setStatus(transfer.getStatus());
            feeTransfer.setNextAuthorizationLevel(transfer.getNextAuthorizationLevel());
            feeTransfer.setProcessDate(transfer.getProcessDate());
            feeTransfer.setExternalTransfer(transfer.getExternalTransfer());
            feeTransfer.setBy(transfer.getBy());
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(feeTransfer.getType(), false);
            if (!CollectionUtils.isEmpty(transfer.getCustomValues())) {
                ArrayList<PaymentCustomFieldValue> feeTransferCustomValues = new ArrayList<PaymentCustomFieldValue>();
                for (PaymentCustomFieldValue fieldValue : transfer.getCustomValues()) {
                    CustomField field = fieldValue.getField();
                    if (!customFields.contains(field)) continue;
                    PaymentCustomFieldValue newFieldValue = new PaymentCustomFieldValue();
                    newFieldValue.setField(field);
                    newFieldValue.setValue(fieldValue.getValue());
                    feeTransferCustomValues.add(newFieldValue);
                }
                feeTransfer.setCustomValues((Collection<PaymentCustomFieldValue>)feeTransferCustomValues);
            }
            this.insertTransferAndPayFees(lockHandler, feeTransfer, forced, simulation, chargedFees);
            transfer.getChildren().add(feeTransfer);
        }
    }

    private boolean insertTN(final Long clientId, final String traceNumber) {
        return this.transactionHelper.runInNewTransaction(new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                TraceNumber tn = new TraceNumber();
                tn.setDate(Calendar.getInstance());
                tn.setClientId(clientId);
                tn.setTraceNumber(traceNumber);
                try {
                    PaymentServiceImpl.this.traceNumberDao.insert(tn);
                    return true;
                }
                catch (DaoException e) {
                    status.setRollbackOnly();
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, DataIntegrityViolationException.class) != -1) {
                        return false;
                    }
                    throw e;
                }
            }
        });
    }

    private Transfer insertTransferAndPayFees(LockHandler lockHandler, Transfer transfer, boolean forced, final boolean simulation, Set<ChargedFee> chargedFees) {
        Account toAccount;
        TransferType transferType = transfer.getType();
        Collection<PaymentCustomFieldValue> customValues = transfer.getCustomValues();
        Account fromAccount = transfer.getFrom();
        if (fromAccount.equals(toAccount = transfer.getTo())) {
            throw new ValidationException("payment.error.sameFromAntToInFee", new Object[0]);
        }
        if (this.applicationService.getLockedAccountsOnPayments() == LockedAccountsOnPayments.ALL) {
            lockHandler.lock(fromAccount, toAccount);
        }
        AccountOwner from = fromAccount.getOwner();
        AccountOwner to = toAccount.getOwner();
        BigDecimal originalAmount = transfer.getAmount();
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(from, to, transferType, transfer.getAmount());
        transfer.setAmount(preview.getFinalAmount());
        final Collection<TransferListener> listeners = this.getTransferListeners(transfer);
        if (!forced) {
            if (!simulation) {
                for (TransferListener listener : listeners) {
                    listener.onBeforeValidateBalance(transfer);
                }
            }
            this.validateAmount(transfer.getAmount(), fromAccount, toAccount, transfer);
        }
        transfer.setCustomValues((Collection<PaymentCustomFieldValue>)null);
        RatesToSave rates = new RatesToSave();
        if (transfer.getProcessDate() != null) {
            rates = this.rateService.applyTransfer(transfer);
            transfer.setEmissionDate(rates.getEmissionDate());
            transfer.setExpirationDate(rates.getExpirationDate());
            transfer.setiRate(rates.getiRate());
        }
        transfer = this.transferDao.insert(transfer);
        this.rateService.persist(rates);
        LocalSettings.TransactionNumber transactionNumber = this.settingsService.getLocalSettings().getTransactionNumber();
        if (transactionNumber != null && transactionNumber.isValid()) {
            String generated = transactionNumber.generate(transfer.getId(), transfer.getDate());
            this.transferDao.updateTransactionNumber(transfer.getId(), generated);
        }
        transfer.setCustomValues(customValues);
        this.paymentCustomFieldService.saveValues(transfer);
        if (transfer.getProcessDate() == null) {
            this.accountService.reservePending(transfer);
        } else {
            this.accountService.removeClosedBalancesAfter(transfer.getFrom(), transfer.getProcessDate());
            this.accountService.removeClosedBalancesAfter(transfer.getTo(), transfer.getProcessDate());
        }
        if (!simulation) {
            for (TransferListener listener : listeners) {
                listener.onTransferInserted(transfer);
            }
        }
        final Transfer toLog = transfer;
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                PaymentServiceImpl.this.loggingHandler.logTransfer(toLog);
                if (!simulation && toLog.getProcessDate() != null && !listeners.isEmpty()) {
                    PaymentServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            Transfer fetchedTransfer = PaymentServiceImpl.this.fetchService.fetch(toLog, Payment.Relationships.FROM, Payment.Relationships.TO);
                            for (TransferListener listener : listeners) {
                                try {
                                    listener.onTransferProcessed(fetchedTransfer);
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)("Error running TransferListener " + listener), (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.insertFees(lockHandler, transfer, forced, originalAmount, simulation, chargedFees);
        return transfer;
    }

    private Transfer performChargeback(LockHandler lockHandler, Transfer transfer, Transfer parentChargeback) {
        transfer = this.fetchService.fetch(transfer, Transfer.Relationships.CHILDREN);
        if (this.applicationService.getLockedAccountsOnPayments() == LockedAccountsOnPayments.ALL) {
            lockHandler.lock(transfer.getFrom(), transfer.getTo());
        }
        this.validateAmount(transfer.getAmount(), transfer.getTo(), transfer.getFrom(), transfer);
        Transfer chargeback = this.transferDao.duplicate(transfer);
        chargeback.setTraceNumber(null);
        ServiceClient serviceClient = LoggedUser.serviceClient();
        if (serviceClient != null) {
            chargeback.setClientId(serviceClient.getId());
        }
        chargeback.setChargebackOf(transfer);
        chargeback.setParent(parentChargeback);
        chargeback.setAmount(chargeback.getAmount().negate());
        Calendar now = Calendar.getInstance();
        chargeback.setDate(now);
        chargeback.setProcessDate(now);
        chargeback.setStatus(Payment.Status.PROCESSED);
        if (LoggedUser.hasUser()) {
            chargeback.setBy((Element)LoggedUser.element());
        }
        chargeback.setReceiver(null);
        chargeback.setScheduledPayment(null);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("description", transfer.getDescription());
        variables.put("date", localSettings.getDateConverter().toString(transfer.getDate()));
        chargeback.setDescription(MessageProcessingHelper.processVariables(localSettings.getChargebackDescription(), variables));
        chargeback = this.transferDao.insert(chargeback, false);
        if (CollectionUtils.isNotEmpty(transfer.getCustomValues())) {
            ArrayList<PaymentCustomFieldValue> customValues = new ArrayList<PaymentCustomFieldValue>();
            if (transfer.getCustomValues() != null) {
                for (PaymentCustomFieldValue original : transfer.getCustomValues()) {
                    PaymentCustomFieldValue newValue = new PaymentCustomFieldValue();
                    newValue.setTransfer(chargeback);
                    newValue.setField(original.getField());
                    newValue.setStringValue(original.getStringValue());
                    newValue.setPossibleValue(original.getPossibleValue());
                    customValues.add(newValue);
                }
            }
            chargeback.setCustomValues((Collection<PaymentCustomFieldValue>)customValues);
            this.paymentCustomFieldService.saveValues(chargeback);
        }
        transfer = this.transferDao.updateChargeBack(transfer, chargeback);
        LocalSettings.TransactionNumber transactionNumber = this.settingsService.getLocalSettings().getTransactionNumber();
        if (transactionNumber != null && transactionNumber.isValid()) {
            String generated = transactionNumber.generate(chargeback.getId(), chargeback.getDate());
            this.transferDao.updateTransactionNumber(chargeback.getId(), generated);
        }
        this.accountService.removeClosedBalancesAfter(chargeback.getFrom(), chargeback.getProcessDate());
        this.accountService.removeClosedBalancesAfter(chargeback.getTo(), chargeback.getProcessDate());
        this.rateService.chargeback(transfer, chargeback);
        for (Transfer child : transfer.getChildren()) {
            this.performChargeback(lockHandler, child, chargeback);
        }
        return chargeback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transfer performChargeback(Transfer transfer) {
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandlerIfLockingAccounts();
        try {
            if (this.applicationService.getLockedAccountsOnPayments() == LockedAccountsOnPayments.ORIGIN && transfer.getTo().getCreditLimit() != null) {
                lockHandler.lock(transfer.getTo());
            }
            Transfer transfer2 = this.performChargeback(lockHandler, transfer, null);
            return transfer2;
        }
        finally {
            if (lockHandler != null) {
                lockHandler.release();
            }
        }
    }

    private Payment performInsert(LockHandler lockHandler, TransferDTO dto, boolean simulation) {
        Payment payment;
        TransferType transferType = dto.getTransferType();
        Account fromAccount = this.fetchService.fetch(dto.getFrom(), RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY));
        Account toAccount = this.fetchService.fetch(dto.getTo(), MemberAccount.Relationships.MEMBER);
        if (this.applicationService.getLockedAccountsOnPayments() == LockedAccountsOnPayments.ALL) {
            lockHandler.lock(fromAccount, toAccount);
        }
        Calendar feedbackDeadline = null;
        if (transferType.isRequiresFeedback()) {
            feedbackDeadline = transferType.getFeedbackExpirationTime().add(Calendar.getInstance());
        }
        boolean hasMaxAmountPerDay = BigDecimalHelper.nvl(transferType.getMaxAmountPerDay()).compareTo(BigDecimal.ZERO) > 0;
        Calendar now = Calendar.getInstance();
        if (CollectionUtils.isEmpty(dto.getPayments())) {
            Transfer parent;
            AuthorizationLevel firstAuthorizationLevel;
            Ticket ticket;
            String traceNumber = dto.getTraceNumber();
            Long clientId = dto.getClientId();
            Transfer transfer = new Transfer();
            transfer.setFrom(fromAccount);
            transfer.setTo(toAccount);
            transfer.setBy(dto.getBy());
            transfer.setDate(now);
            transfer.setAmount(dto.getAmount());
            transfer.setType(transferType);
            transfer.setDescription(dto.getDescription());
            transfer.setAccountFeeLog(dto.getAccountFeeLog());
            transfer.setLoanPayment(dto.getLoanPayment());
            transfer.setParent(dto.getParent());
            transfer.setReceiver(dto.getReceiver());
            transfer.setExternalTransfer(dto.getExternalTransfer());
            transfer.setCustomValues(dto.getCustomValues());
            transfer.setTraceNumber(traceNumber);
            transfer.setClientId(clientId);
            transfer.setTraceData(dto.getTraceData());
            transfer.setTransactionFeedbackDeadline(feedbackDeadline);
            if (transferType.isLoanType()) {
                transfer.setEmissionDate(dto.getEmissionDate());
                transfer.setExpirationDate(dto.getExpirationDate());
                transfer.setiRate(dto.getiRate());
            }
            if (this.applicationService.getLockedAccountsOnPayments() == LockedAccountsOnPayments.ORIGIN && (fromAccount.getCreditLimit() != null || hasMaxAmountPerDay)) {
                lockHandler.lock(fromAccount);
            }
            if ((ticket = this.fetchService.reload(dto.getTicket(), new Relationship[0])) != null) {
                if (ticket.getStatus() != Ticket.Status.PENDING) {
                    throw new EntityNotFoundException(Ticket.class);
                }
                if (ticket.getAmount() != null && !ticket.getAmount().equals(transfer.getAmount())) {
                    throw new ValidationException("The payment amount is not the expected one according to the ticket", new Object[0]);
                }
                if (!ticket.getTo().equals(transfer.getToOwner())) {
                    throw new ValidationException("The payment destination member is not the expected one according to the ticket", new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)ticket.getDescription()) && StringUtils.isEmpty((String)transfer.getDescription())) {
                    transfer.setDescription(ticket.getDescription());
                }
            }
            if ((firstAuthorizationLevel = (parent = this.fetchService.fetch(dto.getParent(), Transfer.Relationships.NEXT_AUTHORIZATION_LEVEL)) != null && parent.getNextAuthorizationLevel() != null ? parent.getNextAuthorizationLevel() : this.firstAuthorizationLevel(transferType, transfer.getAmount(), transfer.getFromOwner())) != null && dto.getDate() != null && !DateUtils.isSameDay((Calendar)dto.getDate(), (Calendar)Calendar.getInstance())) {
                throw new AuthorizedPaymentInPastException();
            }
            if (firstAuthorizationLevel == null) {
                transfer.setProcessDate(dto.getDate() == null ? now : dto.getDate());
                transfer.setStatus(Payment.Status.PROCESSED);
            } else {
                transfer.setStatus(Payment.Status.PENDING);
                transfer.setNextAuthorizationLevel(firstAuthorizationLevel);
            }
            if (clientId != null && StringUtils.isNotEmpty((String)traceNumber) && !this.insertTN(clientId, traceNumber)) {
                throw new ValidationException("traceNumber", "transfer.traceNumber", new UniqueError(traceNumber));
            }
            if (!dto.isForced()) {
                this.validateMaxAmountAtDate(null, fromAccount, transferType, null, transfer.getAmount());
            }
            transfer = this.insertTransferAndPayFees(lockHandler, transfer, dto.isForced(), simulation, new HashSet<ChargedFee>());
            payment = this.transferAuthorizationService.authorizeOnInsert(lockHandler, transfer);
            if (ticket != null) {
                ticket.setAmount(payment.getAmount());
                ticket.setDescription(payment.getDescription());
                if (payment.getFrom().getOwner() instanceof Member) {
                    ticket.setFrom((Member)payment.getFrom().getOwner());
                } else {
                    ticket.setFrom(null);
                }
                ticket.setTo((Member)payment.getTo().getOwner());
                ticket.setStatus(Ticket.Status.OK);
                ticket.setTransfer((Transfer)payment);
            }
        } else {
            boolean reserveTotalAmount = transferType.isReserveTotalAmountOnScheduling();
            if (!dto.isForced() && (reserveTotalAmount || hasMaxAmountPerDay)) {
                lockHandler.lock(fromAccount);
                if (reserveTotalAmount) {
                    this.validateAmount(dto.getAmount(), fromAccount, null, null);
                }
                if (hasMaxAmountPerDay) {
                    for (ScheduledPaymentDTO current : dto.getPayments()) {
                        this.validateMaxAmountAtDate(current.getDate(), fromAccount, transferType, null, current.getAmount());
                    }
                }
            }
            Collection<PaymentCustomFieldValue> customValues = dto.getCustomValues();
            ScheduledPayment scheduledPayment = new ScheduledPayment();
            scheduledPayment.setFrom(fromAccount);
            scheduledPayment.setTo(toAccount);
            scheduledPayment.setBy(dto.getBy());
            scheduledPayment.setDate(now);
            scheduledPayment.setAmount(dto.getAmount());
            scheduledPayment.setType(transferType);
            scheduledPayment.setDescription(dto.getDescription());
            scheduledPayment.setStatus(Payment.Status.SCHEDULED);
            scheduledPayment.setReserveAmount(reserveTotalAmount);
            scheduledPayment.setShowToReceiver(transferType.isShowScheduledPaymentsToDestination() || dto.isShowScheduledToReceiver());
            scheduledPayment.setTransactionFeedbackDeadline(feedbackDeadline);
            scheduledPayment = this.scheduledPaymentDao.insert(scheduledPayment);
            scheduledPayment.setCustomValues((Collection<PaymentCustomFieldValue>)new ArrayList<PaymentCustomFieldValue>(customValues));
            this.paymentCustomFieldService.saveValues(scheduledPayment);
            ArrayList<Transfer> scheduledTransfers = new ArrayList<Transfer>();
            Transfer transferToProcess = null;
            for (ScheduledPaymentDTO current : dto.getPayments()) {
                TransferDTO currentDTO = (TransferDTO)dto.clone();
                currentDTO.setDate(current.getDate());
                currentDTO.setAmount(current.getAmount());
                currentDTO.setScheduledPayment(scheduledPayment);
                Transfer transfer = new Transfer();
                transfer.setFrom(fromAccount);
                transfer.setTo(dto.getTo());
                transfer.setBy(dto.getBy());
                transfer.setDate(current.getDate());
                transfer.setAmount(current.getAmount());
                transfer.setType(transferType);
                transfer.setDescription(dto.getDescription());
                transfer.setStatus(Payment.Status.SCHEDULED);
                transfer.setScheduledPayment(scheduledPayment);
                if (DateUtils.isSameDay((Calendar)now, (Calendar)transfer.getDate())) {
                    transferToProcess = transfer;
                    transfer.setDate(now);
                }
                transfer = this.transferDao.insert(transfer);
                transfer.setCustomValues((Collection<PaymentCustomFieldValue>)new ArrayList<PaymentCustomFieldValue>());
                if (customValues != null) {
                    for (PaymentCustomFieldValue fieldValue : customValues) {
                        PaymentCustomFieldValue newValue = new PaymentCustomFieldValue();
                        newValue.setField(fieldValue.getField());
                        newValue.setStringValue(fieldValue.getStringValue());
                        newValue.setPossibleValue(fieldValue.getPossibleValue());
                        transfer.getCustomValues().add(newValue);
                    }
                }
                this.paymentCustomFieldService.saveValues(transfer);
                scheduledTransfers.add(transfer);
            }
            scheduledPayment.setTransfers(scheduledTransfers);
            if (scheduledPayment.isReserveAmount()) {
                this.accountService.reserve(scheduledPayment);
            }
            if (transferToProcess != null) {
                this.doProcessScheduledTransfer(lockHandler, transferToProcess, true, false, true);
            }
            payment = scheduledPayment;
        }
        return payment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Payment performInsert(TransferDTO dto, boolean simulation) {
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandlerIfLockingAccounts();
        try {
            Payment payment = this.performInsert(lockHandler, dto, simulation);
            return payment;
        }
        finally {
            if (lockHandler != null) {
                lockHandler.release();
            }
        }
    }

    private Transfer processScheduledTransfer(final Transfer transfer, final boolean failOnError, final boolean notifyPayer, final boolean notifyReceiver) {
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return PaymentServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return PaymentServiceImpl.this.doProcessScheduledTransfer(transfer, failOnError, notifyPayer, notifyReceiver);
            }
        });
    }

    private ScheduledPayment updateScheduledPaymentStatus(ScheduledPayment scheduledPayment) {
        scheduledPayment = this.fetchService.fetch(scheduledPayment, ScheduledPayment.Relationships.TRANSFERS);
        scheduledPayment.setStatus(Payment.Status.PROCESSED);
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            if (transfer.getProcessDate() != null) continue;
            scheduledPayment.setStatus(transfer.getStatus());
            break;
        }
        return this.scheduledPaymentDao.update(scheduledPayment);
    }

    private void validate(TransferDTO params) {
        this.getTransferValidator(params).validate(params);
    }

    private void validateAmount(BigDecimal amount, Account fromAccount, Account toAccount, Transfer transfer) {
        BigDecimal balance;
        BigDecimal upperCreditLimit;
        BigDecimal creditLimit;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (fromAccount != null && (creditLimit = fromAccount.getCreditLimit()) != null) {
            BigDecimal available;
            AccountStatus fromStatus = this.accountService.getCurrentStatus(new AccountDTO(fromAccount));
            if (creditLimit.abs().floatValue() > -1.0E-4f && (available = localSettings.round(fromStatus.getAvailableBalance())).subtract(amount).floatValue() < -1.0E-4f) {
                boolean isOriginalAccount = transfer == null ? true : fromAccount.equals(transfer.getRootTransfer().getFrom());
                fromAccount = this.fetchService.fetch(fromAccount, Account.Relationships.TYPE);
                throw new NotEnoughCreditsException(fromAccount, amount, isOriginalAccount);
            }
        }
        if (toAccount != null && (upperCreditLimit = toAccount.getUpperCreditLimit()) != null && upperCreditLimit.floatValue() > 1.0E-4f && upperCreditLimit.subtract(balance = this.accountService.getBalance(new AccountDateDTO(toAccount))).subtract(amount).floatValue() < -1.0E-4f) {
            throw new UpperCreditLimitReachedException(localSettings.getUnitsConverter(toAccount.getType().getCurrency().getPattern()).toString(toAccount.getUpperCreditLimit()), toAccount, amount);
        }
    }

    private TransferType validateTransferType(TransferDTO params) {
        TransferType transferType = this.transferTypeService.load(params.getTransferType().getId(), TransferType.Relationships.FROM, TransferType.Relationships.TO);
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setChannel(params.getChannel());
        if (params.isAutomatic()) {
            ttQuery.setContext(transferType.isLoanType() ? TransactionContext.AUTOMATIC_LOAN : TransactionContext.AUTOMATIC);
        } else {
            ttQuery.setContext(params.getContext());
        }
        TransactionContext context = ttQuery.getContext();
        if (context != TransactionContext.AUTOMATIC && context != TransactionContext.AUTOMATIC_LOAN) {
            ttQuery.setUsePriority(true);
        }
        ttQuery.setCurrency(params.getCurrency());
        ttQuery.setFromAccountType(transferType.getFrom());
        ttQuery.setToAccountType(transferType.getTo());
        AccountOwner fromOwner = params.getFromOwner();
        if (context != TransactionContext.AUTOMATIC && context != TransactionContext.AUTOMATIC_LOAN) {
            if (params.getBy() != null && fromOwner != null && !params.getBy().getAccountOwner().equals(fromOwner)) {
                ttQuery.setBy(params.getBy());
            } else if (fromOwner instanceof Member) {
                ttQuery.setGroup(((Member)fromOwner).getGroup());
            } else if (LoggedUser.hasUser()) {
                ttQuery.setGroup((Group)LoggedUser.group());
            }
        }
        ttQuery.setFromOwner(fromOwner);
        ttQuery.setToOwner(params.getToOwner());
        List<TransferType> possibleTypes = this.transferTypeService.search(ttQuery);
        if (possibleTypes == null || !possibleTypes.contains(transferType)) {
            throw new UnexpectedEntityException("Transfer type not found for query");
        }
        return transferType;
    }

    private TransferDTO verify(DoPaymentDTO params) {
        TransferDTO dto = new TransferDTO();
        dto.setAmount(params.getAmount());
        dto.setCurrency(params.getCurrency());
        dto.setChannel(params.getChannel());
        dto.setContext(params.getContext());
        if (params.getDate() != null) {
            dto.setDate(params.getDate());
        }
        dto.setDescription(params.getDescription());
        dto.setFromOwner(params.getFrom() == null ? LoggedUser.accountOwner() : params.getFrom());
        if (LoggedUser.hasUser() && !LoggedUser.isWebService()) {
            dto.setBy((Element)LoggedUser.element());
        }
        dto.setToOwner(params.getTo());
        dto.setTicket(params.getTicket());
        dto.setTransferType(params.getTransferType());
        dto.setReceiver(params.getReceiver());
        dto.setPayments(params.getPayments());
        dto.setCustomValues(params.getCustomValues());
        dto.setTraceData(params.getTraceData());
        dto.setShowScheduledToReceiver(params.isShowScheduledToReceiver());
        ServiceClient serviceClient = LoggedUser.serviceClient();
        if (serviceClient != null && params.getTraceNumber() != null) {
            dto.setTraceNumber(params.getTraceNumber());
            dto.setClientId(serviceClient.getId());
        }
        this.verify(dto);
        return dto;
    }

    private void verify(TransferDTO params) {
        if (params.getFrom() != null) {
            Account from = this.fetchService.fetch(params.getFrom(), MemberAccount.Relationships.MEMBER);
            params.setFromOwner(from.getOwner());
        }
        if (params.getTo() != null) {
            Account to = this.fetchService.fetch(params.getTo(), MemberAccount.Relationships.MEMBER);
            params.setToOwner(to.getOwner());
        }
        this.validate(params);
        AccountOwner fromOwner = params.getFromOwner();
        AccountOwner toOwner = params.getToOwner();
        TransferType transferType = this.validateTransferType(params);
        Account fromAccount = this.accountService.getAccount(new AccountDTO(fromOwner, transferType.getFrom()), new Relationship[0]);
        Account toAccount = this.accountService.getAccount(new AccountDTO(toOwner, transferType.getTo()), new Relationship[0]);
        if (fromAccount.equals(toAccount)) {
            throw new ValidationException(new ValidationError("payment.error.sameAccount", new Object[0]));
        }
        BigDecimal amount = params.getAmount();
        if (amount.compareTo(this.getMinimumPayment()) == -1) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            throw new TransferMinimumPaymentException(localSettings.getUnitsConverter(fromAccount.getType().getCurrency().getPattern()).toString(this.getMinimumPayment()), fromAccount, amount);
        }
        params.setTransferType(transferType);
        params.setFrom(fromAccount);
        params.setTo(toAccount);
        if (StringUtils.isBlank((String)params.getDescription())) {
            params.setDescription(transferType.getDescription());
        }
    }

    private class TraceNumberValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 2424106851078796317L;

        private TraceNumberValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            TransferDTO dto = (TransferDTO)object;
            Long clientId = dto.getClientId();
            String traceNumber = dto.getTraceNumber();
            if (clientId == null || StringUtils.isEmpty((String)traceNumber)) {
                return null;
            }
            try {
                PaymentServiceImpl.this.transferDao.loadTransferByTraceNumber(traceNumber, clientId, new Relationship[0]);
                PaymentServiceImpl.this.traceNumberDao.load(clientId, traceNumber);
                return new UniqueError(traceNumber);
            }
            catch (EntityNotFoundException e) {
                return null;
            }
        }
    }

    private class TicketValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 1L;

        private TicketValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            if (value != null) {
                DoPaymentDTO dto = (DoPaymentDTO)object;
                Ticket ticket = (Ticket)value;
                if (ticket != null && dto.getChannel() != "webshop") {
                    return new InvalidError();
                }
                try {
                    ticket = PaymentServiceImpl.this.fetchService.fetch(ticket, new Relationship[0]);
                    if (ticket != null && ticket.getStatus() != Ticket.Status.PENDING) {
                        throw new EntityNotFoundException(Ticket.class);
                    }
                }
                catch (EntityNotFoundException e) {
                    return new InvalidError();
                }
            }
            return null;
        }
    }

    private final class SchedulingValidator
    implements GeneralValidation {
        private static final long serialVersionUID = 4085922259108191939L;

        private SchedulingValidator() {
        }

        @Override
        public ValidationError validate(Object object) {
            DoPaymentDTO payment = (DoPaymentDTO)object;
            List<ScheduledPaymentDTO> payments = payment.getPayments();
            if (CollectionUtils.isEmpty(payments)) {
                return null;
            }
            TransferType transferType = PaymentServiceImpl.this.fetchService.fetch(payment.getTransferType(), TransferType.Relationships.TRANSACTION_FEES);
            if (transferType == null) {
                return null;
            }
            Member fromMember = null;
            if (payment.getFrom() instanceof Member) {
                fromMember = PaymentServiceImpl.this.fetchService.fetch((Member)payment.getFrom(), Element.Relationships.GROUP);
            } else if (LoggedUser.hasUser() && LoggedUser.isMember()) {
                fromMember = (Member)LoggedUser.element();
            }
            Calendar maxPaymentDate = null;
            if (fromMember != null) {
                int maxSchedulingPayments;
                MemberGroup group = fromMember.getMemberGroup();
                int n = maxSchedulingPayments = transferType.isAllowsScheduledPayments() ? group.getMemberSettings().getMaxSchedulingPayments() : 0;
                if (payments.size() > maxSchedulingPayments) {
                    return new ValidationError("errors.greaterEquals", PaymentServiceImpl.this.messageResolver.message("transfer.paymentCount", new Object[0]), maxSchedulingPayments);
                }
                TimePeriod maxSchedulingPeriod = group.getMemberSettings().getMaxSchedulingPeriod();
                if (maxSchedulingPeriod != null) {
                    maxPaymentDate = maxSchedulingPeriod.add(DateHelper.truncate(Calendar.getInstance()));
                }
                if (payment.getTo() != null && payment.getTo() instanceof Member) {
                    Collection<? extends TransactionFee> transactionFees = PaymentServiceImpl.this.fetchService.fetch(transferType.getTransactionFees(), new Relationship[]{TransactionFee.Relationships.GENERATED_TRANSFER_TYPE});
                    for (TransactionFee transactionFee : transactionFees) {
                        List<BrokerCommissionContract> commissionContracts;
                        if (!(transactionFee instanceof BrokerCommission) || !transactionFee.isFromMember()) continue;
                        BrokerCommission brokerCommission = (BrokerCommission)transactionFee;
                        BrokerCommissionContractQuery contractsQuery = new BrokerCommissionContractQuery();
                        contractsQuery.setBrokerCommission(brokerCommission);
                        contractsQuery.setStatus(BrokerCommissionContract.Status.PENDING);
                        switch (brokerCommission.getWhichBroker()) {
                            case SOURCE: {
                                contractsQuery.setMember(fromMember);
                                break;
                            }
                            case DESTINATION: {
                                contractsQuery.setMember((Member)payment.getTo());
                            }
                        }
                        if (!CollectionUtils.isNotEmpty(commissionContracts = PaymentServiceImpl.this.commissionService.searchBrokerCommissionContracts(contractsQuery))) continue;
                        return new ValidationError("payment.error.pendingCommissionContract", brokerCommission.getName());
                    }
                }
            }
            BigDecimal paymentAmount = payment.getAmount();
            BigDecimal minimumPayment = PaymentServiceImpl.this.getMinimumPayment();
            BigDecimal totalAmount = BigDecimal.ZERO;
            Calendar lastDate = DateHelper.truncatePreviosDay(Calendar.getInstance());
            for (ScheduledPaymentDTO scheduledPaymentDTO : payments) {
                Calendar date = scheduledPaymentDTO.getDate();
                if (maxPaymentDate != null && date.after(maxPaymentDate)) {
                    LocalSettings localSettings = PaymentServiceImpl.this.settingsService.getLocalSettings();
                    CalendarConverter dateConverter = localSettings.getRawDateConverter();
                    return new ValidationError("payment.invalid.schedulingDate", dateConverter.toString(maxPaymentDate));
                }
                BigDecimal amount = scheduledPaymentDTO.getAmount();
                if (amount == null || amount.compareTo(minimumPayment) < 0) {
                    return new RequiredError(PaymentServiceImpl.this.messageResolver.message("transfer.amount", new Object[0]));
                }
                BigDecimal minAmount = transferType.getMinAmount();
                if (minAmount != null && amount.compareTo(minAmount) < 0) {
                    return new ValidationError("errors.greaterEquals", amount, minAmount);
                }
                if (date == null) {
                    return new RequiredError(PaymentServiceImpl.this.messageResolver.message("transfer.date", new Object[0]));
                }
                if (date.before(lastDate) || DateUtils.isSameDay((Calendar)date, (Calendar)lastDate)) {
                    return new ValidationError("payment.invalid.paymentDates", new Object[0]);
                }
                totalAmount = totalAmount.add(amount);
                lastDate = date;
            }
            if (paymentAmount != null && totalAmount.compareTo(paymentAmount) != 0) {
                return new ValidationError("payment.invalid.paymentAmount", new Object[0]);
            }
            return null;
        }
    }

    private final class PendingContractValidator
    implements GeneralValidation {
        private static final long serialVersionUID = 5608258953479316287L;

        private PendingContractValidator() {
        }

        @Override
        public ValidationError validate(Object object) {
            DoPaymentDTO payment = (DoPaymentDTO)object;
            Member fromMember = (Member)(payment.getFrom() instanceof Member ? payment.getFrom() : (payment.getFrom() == null ? LoggedUser.member() : null));
            if (fromMember != null) {
                fromMember = PaymentServiceImpl.this.fetchService.fetch(fromMember, Element.Relationships.GROUP);
                if (payment.getTo() != null && payment.getTo() instanceof Member && payment.getTransferType() != null) {
                    TransferType transferType = PaymentServiceImpl.this.fetchService.fetch(payment.getTransferType(), TransferType.Relationships.TRANSACTION_FEES);
                    Collection<? extends TransactionFee> transactionFees = PaymentServiceImpl.this.fetchService.fetch(transferType.getTransactionFees(), new Relationship[]{TransactionFee.Relationships.GENERATED_TRANSFER_TYPE});
                    for (TransactionFee transactionFee : transactionFees) {
                        List<BrokerCommissionContract> commissionContracts;
                        if (!(transactionFee instanceof BrokerCommission) || !transactionFee.isFromMember()) continue;
                        BrokerCommission brokerCommission = (BrokerCommission)transactionFee;
                        BrokerCommissionContractQuery contractsQuery = new BrokerCommissionContractQuery();
                        contractsQuery.setBrokerCommission(brokerCommission);
                        contractsQuery.setStatus(BrokerCommissionContract.Status.PENDING);
                        switch (brokerCommission.getWhichBroker()) {
                            case SOURCE: {
                                contractsQuery.setMember(fromMember);
                                break;
                            }
                            case DESTINATION: {
                                contractsQuery.setMember((Member)payment.getTo());
                            }
                        }
                        if (!CollectionUtils.isNotEmpty(commissionContracts = PaymentServiceImpl.this.commissionService.searchBrokerCommissionContracts(contractsQuery))) continue;
                        return new ValidationError("payment.error.pendingCommissionContract", brokerCommission.getName());
                    }
                }
            }
            return null;
        }
    }

    private static final class NoPastDateWithRatesValidator
    implements GeneralValidation {
        private static final long serialVersionUID = -6914314732478889087L;

        private NoPastDateWithRatesValidator() {
        }

        @Override
        public ValidationError validate(Object object) {
            return new ValidationError("payment.error.pastDateWithRates", new Object[0]);
        }
    }

    private final class FinalAmountValidator
    implements GeneralValidation {
        private static final long serialVersionUID = -2789145696000017181L;

        private FinalAmountValidator() {
        }

        @Override
        public ValidationError validate(Object object) {
            return new ValidationError("payment.error.negativeFinalAmount", new Object[0]);
        }
    }

    private static class ChargedFee {
        private final TransactionFee fee;
        private final Account from;
        private final Account to;

        private ChargedFee(TransactionFee fee, Account from, Account to) {
            this.fee = fee;
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChargedFee)) {
                return false;
            }
            ChargedFee f = (ChargedFee)obj;
            return new EqualsBuilder().append((Object)this.fee, (Object)f.fee).append((Object)this.from, (Object)f.from).append((Object)this.to, (Object)f.to).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.fee).append((Object)this.from).append((Object)this.to).toHashCode();
        }
    }
}

