/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.services.transactions.BulkChargebackResult;
import nl.strohalm.cyclos.services.transactions.BulkPaymentResult;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.Period;

public interface PaymentServiceLocal
extends PaymentService {
    public void validateMaxAmountAtDate(Calendar var1, Account var2, TransferType var3, BigDecimal var4, BigDecimal var5);

    public List<BulkChargebackResult> bulkChargeback(List<Transfer> var1);

    public boolean canMakePayment(AccountOwner var1, AccountOwner var2, TransferType var3);

    public Transfer conciliate(Transfer var1, ExternalTransfer var2);

    public Transfer confirmPayment(String var1) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, EntityNotFoundException, UpperCreditLimitReachedException;

    public List<BulkPaymentResult> doBulkPayment(List<DoPaymentDTO> var1);

    public Payment insertWithNotification(TransferDTO var1) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException;

    public Payment insertWithoutNotification(TransferDTO var1) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException;

    public Transfer loadTransferForReverse(String var1, Relationship ... var2) throws EntityNotFoundException;

    public void notifyTransferProcessed(Transfer var1);

    public void processScheduled(Period var1);

    public Transfer processScheduled(Transfer var1);

    public void purgeOldTraceNumbers(Calendar var1);
}

