/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.ConversionSimulationDTO;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.payments.AccountHistoryParams;
import nl.strohalm.cyclos.webservices.utils.PaymentHelper;

public class PaymentServiceSecurity
extends BaseServiceSecurity
implements PaymentService {
    private PaymentServiceLocal paymentService;
    private AccountServiceLocal accountService;
    private InvoiceServiceLocal invoiceService;
    private PaymentHelper paymentHelper;

    @Override
    public List<ScheduledPaymentDTO> calculatePaymentProjection(ProjectionDTO params) {
        return this.paymentService.calculatePaymentProjection(params);
    }

    @Override
    public boolean canChargeback(Transfer transfer, boolean ignorePendingPayment) {
        return this.paymentService.canChargeback(transfer, ignorePendingPayment);
    }

    @Override
    public Transfer chargeback(Transfer transfer) throws UnexpectedEntityException {
        this.checkChargeback(transfer);
        return this.paymentService.chargeback(transfer);
    }

    @Override
    public Payment doPayment(DoPaymentDTO params) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        this.checkPayment(params);
        return this.paymentService.doPayment(params);
    }

    @Override
    public AccountHistoryResultPage getAccountHistoryResultPage(AccountHistoryParams params) {
        TransferQuery query = this.paymentHelper.toTransferQuery(params);
        this.checkQuery(query);
        return this.paymentService.getAccountHistoryResultPage(params);
    }

    @Override
    public AccountHistoryTransferVO getAccountHistoryTransferVO(Long id) {
        this.check(this.load(id, new Relationship[0]));
        return this.paymentService.getAccountHistoryTransferVO(id);
    }

    @Override
    public ConversionSimulationDTO getDefaultConversionDTO(MemberAccount account, List<TransferType> transferTypes) {
        Member member = this.fetchService.fetch(account, MemberAccount.Relationships.MEMBER).getMember();
        this.checkConversionSimulation(member);
        return this.paymentService.getDefaultConversionDTO(account, transferTypes);
    }

    @Override
    public BigDecimal getMinimumPayment() {
        return this.paymentService.getMinimumPayment();
    }

    @Override
    public StatisticalResultDTO getSimulateConversionGraph(ConversionSimulationDTO dto) {
        Member member = this.fetchService.fetch(dto.getAccount(), MemberAccount.Relationships.MEMBER).getMember();
        this.checkConversionSimulation(member);
        return this.paymentService.getSimulateConversionGraph(dto);
    }

    @Override
    public boolean hasPermissionsToChargeback(Transfer transfer) {
        return this.paymentService.hasPermissionsToChargeback(transfer);
    }

    @Override
    public boolean isVisible(Payment payment) {
        return this.paymentService.isVisible(payment);
    }

    @Override
    public Transfer load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        HashSet<Relationship> relationships = new HashSet<Relationship>(Arrays.asList(fetch));
        relationships.add(Payment.Relationships.FROM);
        relationships.add(Payment.Relationships.TO);
        Transfer transfer = this.paymentService.load(id, relationships.toArray(new Relationship[relationships.size()]));
        this.check(transfer);
        return transfer;
    }

    @Override
    public List<Transfer> search(TransferQuery query) {
        this.checkQuery(query);
        return this.paymentService.search(query);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setPaymentHelper(PaymentHelper paymentHelper) {
        this.paymentHelper = paymentHelper;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    public TransactionFeePreviewForRatesDTO simulateConversion(ConversionSimulationDTO dto) {
        Member member = this.fetchService.fetch(dto.getAccount(), MemberAccount.Relationships.MEMBER).getMember();
        this.checkConversionSimulation(member);
        return this.paymentService.simulateConversion(dto);
    }

    @Override
    public Payment simulatePayment(DoPaymentDTO params) throws NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        this.checkPayment(params.getFrom(), params.getTo());
        return this.paymentService.simulatePayment(params);
    }

    @Override
    public void validate(ConversionSimulationDTO dto) {
        this.paymentService.validate(dto);
    }

    @Override
    public void validate(DoPaymentDTO payment) {
        this.paymentService.validate(payment);
    }

    @Override
    public boolean wouldRequireAuthorization(DoPaymentDTO dto) {
        this.checkPayment(dto.getFrom(), dto.getTo());
        return this.paymentService.wouldRequireAuthorization(dto);
    }

    @Override
    public boolean wouldRequireAuthorization(Invoice invoice) {
        if (!this.invoiceService.canAccept(invoice)) {
            throw new PermissionDeniedException();
        }
        return this.paymentService.wouldRequireAuthorization(invoice);
    }

    @Override
    public boolean wouldRequireAuthorization(Transfer transfer) {
        transfer = this.fetchService.fetch(transfer, Payment.Relationships.FROM, Payment.Relationships.TO);
        this.checkPayment(transfer.getFromOwner(), transfer.getToOwner());
        return this.paymentService.wouldRequireAuthorization(transfer);
    }

    @Override
    public boolean wouldRequireAuthorization(TransferType transferType, BigDecimal amount, AccountOwner from) {
        return this.paymentService.wouldRequireAuthorization(transferType, amount, from);
    }

    private void check(Payment payment) {
        if (payment != null && !this.isVisible(payment)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkAccountAccess(AccountOwner owner, AccountType type) {
        boolean ok;
        if (owner == null) {
            return;
        }
        if (type == null) {
            ok = this.accountService.canViewAccountsOf(owner);
        } else {
            Account account = this.accountService.getAccount(new AccountDTO(owner, type), new Relationship[0]);
            ok = this.accountService.canView(account);
        }
        if (!ok) {
            throw new PermissionDeniedException();
        }
    }

    private void checkChargeback(Transfer transfer) {
        if (!this.hasPermissionsToChargeback(transfer)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkConversionSimulation(Member member) {
    }

    private void checkPayment(AccountOwner from, AccountOwner to) {
        if (!this.paymentService.canMakePayment(from, to, null)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkPayment(DoPaymentDTO params) {
        if (params.getDate() != null) {
            this.permissionService.permission().admin(AdminMemberPermission.PAYMENTS_PAYMENT_WITH_DATE).check();
        }
        this.checkPayment(params.getFrom(), params.getTo());
    }

    private void checkQuery(TransferQuery query) {
        if (query.getOwner() == null) {
            throw new PermissionDeniedException();
        }
        this.checkAccountAccess(query.getOwner(), query.getType());
        this.checkAccountAccess(query.getFromAccountOwner(), query.getFromAccountType());
        this.checkAccountAccess(query.getToAccountOwner(), query.getToAccountType());
        this.check(query.getParent());
    }
}

