/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.ScheduledPaymentDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.webservices.model.ScheduledPaymentVO;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ScheduledPaymentServiceImpl
implements ScheduledPaymentServiceLocal,
InitializingService {
    private SettingsServiceLocal settingsService;
    private FetchServiceLocal fetchService;
    private ScheduledPaymentDAO scheduledPaymentDao;
    private TransferDAO transferDao;
    private PaymentServiceLocal paymentService;
    private PermissionServiceLocal permissionService;
    private AccountServiceLocal accountService;
    private InvoiceServiceLocal invoiceService;
    private TransferAuthorizationServiceLocal transferAuthorizationService;
    private AccountHelper accountHelper;
    private PaymentCustomFieldService paymentCustomFieldService;
    private MemberNotificationHandler memberNotificationHandler;
    private TransactionHelper transactionHelper;

    @Override
    public ScheduledPayment block(ScheduledPayment scheduledPayment) {
        scheduledPayment = this.fetchService.fetch(scheduledPayment, ScheduledPayment.Relationships.TRANSFERS);
        AccountOwner owner = LoggedUser.accountOwner();
        if (owner instanceof Member && owner.equals(scheduledPayment.getFromOwner()) && !scheduledPayment.getType().isAllowBlockScheduledPayments()) {
            throw new PermissionDeniedException();
        }
        Payment.Status status = scheduledPayment.getStatus();
        if (status == Payment.Status.PROCESSED || status == Payment.Status.BLOCKED || status == Payment.Status.CANCELED || status == Payment.Status.DENIED) {
            throw new UnexpectedEntityException();
        }
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            Payment.Status transferStatus = transfer.getStatus();
            if (transferStatus != Payment.Status.SCHEDULED && transferStatus != Payment.Status.FAILED) continue;
            this.transferDao.updateStatus(transfer.getId(), Payment.Status.BLOCKED);
        }
        return this.updateScheduledPaymentStatus(scheduledPayment);
    }

    @Override
    public boolean canBlock(ScheduledPayment scheduledPayment) {
        boolean hasScheduledTransfer = false;
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            if (transfer.getStatus() != Payment.Status.SCHEDULED) continue;
            hasScheduledTransfer = true;
            break;
        }
        if (!hasScheduledTransfer) {
            return false;
        }
        return this.hasBlockPermission(scheduledPayment);
    }

    @Override
    public boolean canCancel(ScheduledPayment scheduledPayment) {
        boolean allowUserToCancel;
        Payment.Status status = scheduledPayment.getStatus();
        if (status == Payment.Status.PROCESSED || status == Payment.Status.CANCELED || status == Payment.Status.DENIED) {
            return false;
        }
        Member loggedMember = LoggedUser.member();
        if (loggedMember != null && loggedMember.equals(scheduledPayment.getFromOwner()) && !(allowUserToCancel = scheduledPayment.getType().isAllowCancelScheduledPayments())) {
            return false;
        }
        Transfer firstPendingTransfer = null;
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            if (transfer.getStatus() != Payment.Status.PENDING) continue;
            firstPendingTransfer = transfer;
            break;
        }
        if (firstPendingTransfer != null && !this.transferAuthorizationService.canCancel(firstPendingTransfer)) {
            return false;
        }
        if (scheduledPayment.isFromSystem()) {
            return this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_CANCEL_SCHEDULED);
        }
        Member fromMember = (Member)scheduledPayment.getFromOwner();
        return this.permissionService.permission(fromMember).admin(AdminMemberPermission.PAYMENTS_CANCEL_SCHEDULED_AS_MEMBER).broker(BrokerPermission.MEMBER_PAYMENTS_CANCEL_SCHEDULED_AS_MEMBER).member(MemberPermission.PAYMENTS_CANCEL_SCHEDULED).operator(OperatorPermission.PAYMENTS_CANCEL_SCHEDULED).hasPermission();
    }

    @Override
    public ScheduledPayment cancel(ScheduledPayment scheduledPayment) {
        scheduledPayment = this.fetchService.fetch(scheduledPayment, ScheduledPayment.Relationships.TRANSFERS);
        AccountOwner owner = LoggedUser.accountOwner();
        if (owner instanceof Member && owner.equals(scheduledPayment.getFromOwner()) && !scheduledPayment.getType().isAllowCancelScheduledPayments()) {
            throw new PermissionDeniedException();
        }
        Payment.Status status = scheduledPayment.getStatus();
        if (status == Payment.Status.PROCESSED || status == Payment.Status.CANCELED || status == Payment.Status.DENIED) {
            throw new UnexpectedEntityException();
        }
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            Payment.Status transferStatus = transfer.getStatus();
            if (scheduledPayment.isReserveAmount() && (transferStatus == Payment.Status.SCHEDULED || transferStatus == Payment.Status.BLOCKED) || transferStatus == Payment.Status.PENDING) {
                this.accountService.returnReservationForInstallment(transfer);
            }
            if (transferStatus != Payment.Status.PENDING && transferStatus != Payment.Status.SCHEDULED && transferStatus != Payment.Status.FAILED && transferStatus != Payment.Status.BLOCKED) continue;
            this.transferDao.updateStatus(transfer.getId(), Payment.Status.CANCELED);
        }
        scheduledPayment.setStatus(Payment.Status.CANCELED);
        return this.scheduledPaymentDao.update(scheduledPayment);
    }

    @Override
    public void cancelScheduledPaymentsAndNotify(final Member member, Collection<MemberAccountType> accountTypes) {
        List<ScheduledPayment> scheduledPayments = this.scheduledPaymentDao.getUnrelatedPendingPayments(member, accountTypes);
        final HashSet<Member> membersToNotify = new HashSet<Member>();
        final HashSet<MemberAccountType> removedAccounts = new HashSet<MemberAccountType>();
        final MutableBoolean notifyMember = new MutableBoolean(false);
        for (ScheduledPayment scheduledPayment : scheduledPayments) {
            this.cancel(scheduledPayment);
            boolean incoming = member.equals(scheduledPayment.getToOwner());
            if (incoming) {
                if (!(scheduledPayment.getFromOwner() instanceof Member)) continue;
                Member payer = (Member)scheduledPayment.getFromOwner();
                membersToNotify.add(payer);
                if (!member.getGroup().isRemoved() && !notifyMember.booleanValue()) {
                    notifyMember.setValue(scheduledPayment.isShowToReceiver() || this.isFromInvoice(scheduledPayment));
                }
                removedAccounts.add((MemberAccountType)scheduledPayment.getTo().getType());
                continue;
            }
            if (scheduledPayment.getToOwner() instanceof Member) {
                if (scheduledPayment.isShowToReceiver() || this.isFromInvoice(scheduledPayment)) {
                    Member receiver = (Member)scheduledPayment.getToOwner();
                    membersToNotify.add(receiver);
                }
                removedAccounts.add((MemberAccountType)scheduledPayment.getFrom().getType());
            }
            if (member.getGroup().isRemoved()) continue;
            notifyMember.setValue(true);
        }
        if (!scheduledPayments.isEmpty()) {
            CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

                @Override
                public void onTransactionCommit() {
                    ScheduledPaymentServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            ScheduledPaymentServiceImpl.this.memberNotificationHandler.scheduledPaymentsCancelledNotification(member, notifyMember.booleanValue(), membersToNotify, removedAccounts);
                        }
                    });
                }
            });
        }
    }

    @Override
    public boolean canPayNow(Transfer transfer) {
        boolean canPayNow = false;
        ScheduledPayment scheduledPayment = transfer.getScheduledPayment();
        if (scheduledPayment != null) {
            canPayNow = transfer.getStatus().canPayNow();
            if (canPayNow) {
                List<Transfer> transfers = scheduledPayment.getTransfers();
                Calendar now = DateHelper.truncate(Calendar.getInstance());
                for (Transfer current : transfers) {
                    if (!current.getStatus().canPayNow() || !current.getDate().before(now)) continue;
                    canPayNow = transfer.equals(current);
                    break;
                }
            }
            if (canPayNow) {
                canPayNow = this.paymentService.canMakePayment(transfer.getFromOwner(), transfer.getToOwner(), transfer.getType());
            }
            if (canPayNow && LoggedUser.isOperator()) {
                canPayNow = this.permissionService.permission().operator(OperatorPermission.PAYMENTS_PAYMENT_TO_MEMBER).hasPermission();
            }
        }
        return canPayNow;
    }

    @Override
    public boolean canUnblock(ScheduledPayment scheduledPayment) {
        Calendar date;
        Payment firstBlockedTransfer = null;
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            if (transfer.getStatus() != Payment.Status.BLOCKED) continue;
            firstBlockedTransfer = transfer;
            break;
        }
        if (firstBlockedTransfer == null) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        if (now.after(date = firstBlockedTransfer.getDate())) {
            return false;
        }
        return this.hasBlockPermission(scheduledPayment);
    }

    @Override
    public ScheduledPaymentVO getScheduledPaymentVO(Long scheduledPaymentId) {
        ScheduledPayment scheduledPayment = this.load(scheduledPaymentId, new Relationship[0]);
        List<PaymentCustomField> fields = this.paymentCustomFieldService.list(scheduledPayment.getType(), false);
        return this.accountHelper.toVO((AccountOwner)LoggedUser.member(), scheduledPayment, fields);
    }

    @Override
    public void initializeService() {
        this.recoverScheduledPayments();
    }

    @Override
    public ScheduledPayment load(Long id, Relationship ... fetch) {
        return (ScheduledPayment)this.scheduledPaymentDao.load(id, fetch);
    }

    @Override
    public Transfer processTransfer(Transfer transfer) {
        ScheduledPayment scheduledPayment = (transfer = this.fetchService.fetch(transfer, RelationshipHelper.nested(Transfer.Relationships.SCHEDULED_PAYMENT, ScheduledPayment.Relationships.TRANSFERS))).getScheduledPayment();
        if (scheduledPayment == null) {
            throw new UnexpectedEntityException();
        }
        Payment.Status scheduledPaymentStatus = scheduledPayment.getStatus();
        if (scheduledPaymentStatus == Payment.Status.PROCESSED || scheduledPaymentStatus == Payment.Status.PENDING || scheduledPaymentStatus == Payment.Status.CANCELED || scheduledPaymentStatus == Payment.Status.DENIED) {
            throw new UnexpectedEntityException();
        }
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        Transfer firstOpenTransfer = scheduledPayment.getFirstOpenTransfer();
        if (firstOpenTransfer.getDate().before(today) && !firstOpenTransfer.equals(transfer)) {
            throw new UnexpectedEntityException();
        }
        Payment.Status firstOpenTransferStatus = firstOpenTransfer.getStatus();
        if (firstOpenTransferStatus == Payment.Status.PROCESSED || firstOpenTransferStatus == Payment.Status.CANCELED || firstOpenTransferStatus == Payment.Status.DENIED || firstOpenTransferStatus == Payment.Status.PENDING) {
            throw new UnexpectedEntityException();
        }
        return this.paymentService.processScheduled(transfer);
    }

    @Override
    public List<ScheduledPayment> search(ScheduledPaymentQuery query) {
        return this.scheduledPaymentDao.search(query);
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setScheduledPaymentDao(ScheduledPaymentDAO scheduledPaymentDao) {
        this.scheduledPaymentDao = scheduledPaymentDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    @Override
    public ScheduledPayment unblock(ScheduledPayment scheduledPayment) {
        scheduledPayment = this.fetchService.fetch(scheduledPayment, ScheduledPayment.Relationships.TRANSFERS);
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        for (Transfer transfer : scheduledPayment.getTransfers()) {
            Payment.Status transferStatus = transfer.getStatus();
            if (transferStatus != Payment.Status.BLOCKED) continue;
            if (transfer.getDate().before(today)) {
                throw new UnexpectedEntityException();
            }
            this.transferDao.updateStatus(transfer.getId(), Payment.Status.SCHEDULED);
        }
        return this.updateScheduledPaymentStatus(scheduledPayment);
    }

    @Override
    public ScheduledPayment updateScheduledPaymentStatus(ScheduledPayment scheduledPayment) {
        List<Transfer> transfers;
        Transfer firstOpenTransfer = scheduledPayment.getFirstOpenTransfer();
        Payment.Status newStatus = null;
        newStatus = firstOpenTransfer == null ? (CollectionUtils.isEmpty(transfers = scheduledPayment.getTransfers()) ? Payment.Status.PROCESSED : transfers.get(transfers.size() - 1).getStatus()) : firstOpenTransfer.getStatus();
        scheduledPayment.setStatus(newStatus);
        if (newStatus == Payment.Status.PROCESSED) {
            scheduledPayment.setProcessDate(Calendar.getInstance());
        }
        return this.scheduledPaymentDao.update(scheduledPayment);
    }

    private boolean hasBlockPermission(ScheduledPayment scheduledPayment) {
        boolean allowUserToBlock;
        Member loggedMember;
        if (scheduledPayment.isFromSystem()) {
            return this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_BLOCK_SCHEDULED);
        }
        Member fromMember = (Member)scheduledPayment.getFromOwner();
        if (fromMember.equals(loggedMember = LoggedUser.member()) && loggedMember.equals(scheduledPayment.getFromOwner()) && !(allowUserToBlock = scheduledPayment.getType().isAllowBlockScheduledPayments())) {
            return false;
        }
        return this.permissionService.permission(fromMember).admin(AdminMemberPermission.PAYMENTS_BLOCK_SCHEDULED_AS_MEMBER).broker(BrokerPermission.MEMBER_PAYMENTS_BLOCK_SCHEDULED_AS_MEMBER).member(MemberPermission.PAYMENTS_BLOCK_SCHEDULED).operator(OperatorPermission.PAYMENTS_BLOCK_SCHEDULED).hasPermission();
    }

    private boolean isFromInvoice(ScheduledPayment scheduledPayment) {
        try {
            this.invoiceService.loadByPayment(scheduledPayment, new Relationship[0]);
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    private void recoverScheduledPayments() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Calendar now = Calendar.getInstance();
        Calendar limit = DateHelper.truncate(now);
        limit.set(11, localSettings.getSchedulingHour());
        limit.add(11, -1);
        limit.set(12, localSettings.getSchedulingMinute());
        Calendar time = now.before(limit) ? DateHelper.truncatePreviosDay(now) : DateHelper.truncate(now);
        this.paymentService.processScheduled(Period.endingAt(time));
    }
}

