/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.model.ScheduledPaymentVO;

public class ScheduledPaymentServiceSecurity
extends BaseServiceSecurity
implements ScheduledPaymentService {
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    private PaymentServiceLocal paymentService;
    private AccountServiceLocal accountService;

    @Override
    public ScheduledPayment block(ScheduledPayment scheduledPayment) {
        if (!this.canBlock(scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        return this.scheduledPaymentService.block(scheduledPayment);
    }

    @Override
    public boolean canBlock(ScheduledPayment scheduledPayment) {
        return this.scheduledPaymentService.canBlock(scheduledPayment);
    }

    @Override
    public boolean canCancel(ScheduledPayment scheduledPayment) {
        return this.scheduledPaymentService.canCancel(scheduledPayment);
    }

    @Override
    public ScheduledPayment cancel(ScheduledPayment scheduledPayment) {
        if (!this.canCancel(scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        return this.scheduledPaymentService.cancel(scheduledPayment);
    }

    @Override
    public boolean canPayNow(Transfer transfer) {
        return this.scheduledPaymentService.canPayNow(transfer);
    }

    @Override
    public boolean canUnblock(ScheduledPayment scheduledPayment) {
        return this.scheduledPaymentService.canUnblock(scheduledPayment);
    }

    @Override
    public ScheduledPaymentVO getScheduledPaymentVO(Long scheduledPaymentId) {
        ScheduledPayment scheduledPayment = this.load(scheduledPaymentId, new Relationship[0]);
        this.checkView(scheduledPayment);
        return this.scheduledPaymentService.getScheduledPaymentVO(scheduledPaymentId);
    }

    @Override
    public ScheduledPayment load(Long id, Relationship ... fetch) {
        ScheduledPayment scheduledPayment = this.scheduledPaymentService.load(id, fetch);
        this.checkView(scheduledPayment);
        return scheduledPayment;
    }

    @Override
    public Transfer processTransfer(Transfer transfer) {
        if (!this.paymentService.canMakePayment(transfer.getFromOwner(), transfer.getToOwner(), transfer.getType())) {
            throw new PermissionDeniedException();
        }
        return this.scheduledPaymentService.processTransfer(transfer);
    }

    @Override
    public List<ScheduledPayment> search(ScheduledPaymentQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.scheduledPaymentService.search(query);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setScheduledPaymentServiceLocal(ScheduledPaymentServiceLocal scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    public ScheduledPayment unblock(ScheduledPayment scheduledPayment) {
        if (!this.canUnblock(scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        return this.scheduledPaymentService.unblock(scheduledPayment);
    }

    private boolean applyQueryRestrictions(ScheduledPaymentQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_SCHEDULED_INFORMATION, AdminMemberPermission.ACCOUNTS_SCHEDULED_INFORMATION).broker(BrokerPermission.ACCOUNTS_SCHEDULED_INFORMATION).member(MemberPermission.ACCOUNT_SCHEDULED_INFORMATION).operator(OperatorPermission.ACCOUNT_SCHEDULED_INFORMATION).hasPermission()) {
            return false;
        }
        if (!this.canAccessAccount(query.getOwner(), query.getAccountType())) {
            return false;
        }
        return query.getMember() == null || !(LoggedUser.isAdministrator() || LoggedUser.isBroker() ? !this.permissionService.manages(query.getMember()) : (LoggedUser.isMember() || LoggedUser.isOperator()) && !LoggedUser.member().equals(query.getOwner()));
    }

    private boolean canAccessAccount(AccountOwner owner, AccountType type) {
        if (type == null && owner != null) {
            return this.accountService.canViewAccountsOf(owner);
        }
        if (type != null && owner != null) {
            Account account = this.accountService.getAccount(new AccountDTO(owner, type), new Relationship[0]);
            return this.accountService.canView(account);
        }
        return false;
    }

    private void checkView(ScheduledPayment scheduledPayment) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_SCHEDULED_INFORMATION, AdminMemberPermission.ACCOUNTS_SCHEDULED_INFORMATION).broker(BrokerPermission.ACCOUNTS_SCHEDULED_INFORMATION).member(MemberPermission.ACCOUNT_SCHEDULED_INFORMATION).operator(OperatorPermission.ACCOUNT_SCHEDULED_INFORMATION).check();
        if (!this.paymentService.isVisible(scheduledPayment)) {
            throw new PermissionDeniedException();
        }
    }
}

