/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.services.transactions.BaseLoanHandler;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantSinglePaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.utils.TimePeriod;

public class SinglePaymentLoanHandler
extends BaseLoanHandler {
    public SinglePaymentLoanHandler() {
        super(Loan.Type.SINGLE_PAYMENT);
    }

    @Override
    public List<LoanPayment> calculatePaymentProjection(ProjectionDTO params) {
        Integer repaymentDays = params.getTransferType().getLoan().getRepaymentDays();
        TimePeriod timePeriod = new TimePeriod(repaymentDays == null ? 30 : repaymentDays, TimePeriod.Field.DAYS);
        LoanPayment payment = new LoanPayment();
        payment.setExpirationDate(timePeriod.add(params.getDate()));
        payment.setAmount(params.getAmount());
        payment.setIndex(0);
        payment.setStatus(LoanPayment.Status.OPEN);
        return Collections.singletonList(payment);
    }

    @Override
    protected void processGrant(Loan loan, GrantLoanDTO params) {
        GrantSinglePaymentLoanDTO dto = (GrantSinglePaymentLoanDTO)params;
        LoanPayment loanPayment = new LoanPayment();
        loanPayment.setExpirationDate(dto.getRepaymentDate());
        loanPayment.setAmount(params.getAmount());
        loan.setPayments(Collections.singletonList(loanPayment));
        loan.setTotalAmount(loanPayment.getAmount());
    }
}

