/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.TicketDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.TicketQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentRequestHandler;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidChannelException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class TicketServiceImpl
implements TicketServiceLocal {
    private static final int TICKET_SIZE = 32;
    private static final String POSSIBLE_TICKET_CHARS = "012345679ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private TicketDAO ticketDao;
    private FetchServiceLocal fetchService;
    private PaymentServiceLocal paymentService;
    private PermissionServiceLocal permissionService;
    private AccountTypeServiceLocal accountTypeService;
    private TransferTypeServiceLocal transferTypeService;
    private PaymentRequestHandler paymentRequestHandler;
    private AccessServiceLocal accessService;
    private MemberNotificationHandler memberNotificationHandler;
    private ChannelServiceLocal channelService;

    @Override
    public WebShopTicket cancelWebShopTicket(long ticketId, String clientIP) {
        Ticket loaded = (Ticket)this.ticketDao.load(ticketId, new Relationship[0]);
        if (!(loaded instanceof WebShopTicket)) {
            throw new EntityNotFoundException(WebShopTicket.class);
        }
        WebShopTicket ticket = (WebShopTicket)loaded;
        if (!ticket.getClientAddress().equals(clientIP)) {
            throw new PermissionDeniedException();
        }
        ticket = this.fetchService.fetch(ticket, new Relationship[0]);
        ticket.setStatus(Ticket.Status.CANCELLED);
        return this.ticketDao.update(ticket);
    }

    @Override
    public PaymentRequestTicket expirePaymentRequestTicket(PaymentRequestTicket ticket) {
        ticket = this.fetchService.fetch(ticket, new Relationship[0]);
        ticket.setStatus(Ticket.Status.EXPIRED);
        ticket = this.ticketDao.update(ticket);
        this.memberNotificationHandler.externalChannelPaymentRequestExpired(ticket);
        return ticket;
    }

    @Override
    public PaymentRequestTicket generate(PaymentRequestTicket ticket) throws InvalidChannelException, NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        this.validate(ticket);
        Member to = this.fetchService.fetch(ticket.getTo(), Element.Relationships.GROUP, Member.Relationships.CHANNELS);
        Channel toChannel = this.channelService.load(ticket.getToChannel().getId());
        Member fromMember = this.fetchService.fetch(ticket.getFrom(), new Relationship[0]);
        if (!this.accessService.isChannelEnabledForMember(toChannel.getInternalName(), fromMember)) {
            throw new InvalidChannelException(fromMember.getUsername(), toChannel.getName());
        }
        if (ticket.getTransferType() == null) {
            TransferType transferType = this.defaultTransferTypeFor(ticket);
            if (transferType == null) {
                throw new ValidationException("payment.error.noTransferType", new Object[0]);
            }
            ticket.setTransferType(transferType);
        }
        if (StringUtils.isEmpty((String)ticket.getDescription())) {
            ticket.setDescription(ticket.getTransferType().getDescription());
        }
        ticket.setCreationDate(Calendar.getInstance());
        ticket.setStatus(Ticket.Status.PENDING);
        ticket.setTicket(this.generateTicket());
        if (ticket.getCurrency() == null && ticket.getAmount() != null && ticket.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            MemberAccountType defaultAccount = this.accountTypeService.getDefault(to.getMemberGroup(), AccountType.Relationships.CURRENCY);
            ticket.setCurrency(defaultAccount.getCurrency());
        }
        final PaymentRequestTicket persistentTicket = this.ticketDao.insert(ticket);
        LoggedUser.runAs(fromMember.getUser(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TicketServiceImpl.this.simulate(persistentTicket);
                return null;
            }
        });
        this.paymentRequestHandler.sendRequest(persistentTicket);
        return persistentTicket;
    }

    @Override
    public WebShopTicket generate(WebShopTicket ticket) {
        this.validate(ticket);
        Member to = this.fetchService.fetch(ticket.getTo(), Element.Relationships.GROUP);
        if (!this.permissionService.hasPermission(to.getGroup(), MemberPermission.PAYMENTS_TICKET)) {
            throw new PermissionDeniedException();
        }
        ticket.setCreationDate(Calendar.getInstance());
        ticket.setStatus(Ticket.Status.PENDING);
        ticket.setTicket(this.generateTicket());
        if (ticket.getCurrency() == null && ticket.getAmount() != null && ticket.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            MemberAccountType defaultAccount = this.accountTypeService.getDefault(to.getMemberGroup(), AccountType.Relationships.CURRENCY);
            ticket.setCurrency(defaultAccount.getCurrency());
        }
        return this.ticketDao.insert(ticket);
    }

    public TicketDAO getTicketDao() {
        return this.ticketDao;
    }

    @Override
    public <T extends Ticket> T load(String ticket, Relationship ... fetch) {
        return this.ticketDao.load(ticket, fetch);
    }

    @Override
    public PaymentRequestTicket loadPendingPaymentRequest(String ticket, Relationship ... fetch) {
        Object loaded = this.ticketDao.load(ticket, fetch);
        if (((Ticket)loaded).getStatus() != Ticket.Status.PENDING || !(loaded instanceof PaymentRequestTicket)) {
            throw new EntityNotFoundException(PaymentRequestTicket.class);
        }
        return (PaymentRequestTicket)loaded;
    }

    @Override
    public WebShopTicket loadPendingWebShopTicket(String ticket, String clientIP, Relationship ... fetch) {
        Object loaded = this.ticketDao.load(ticket, fetch);
        if (((Ticket)loaded).getStatus() != Ticket.Status.PENDING || !(loaded instanceof WebShopTicket)) {
            throw new EntityNotFoundException(WebShopTicket.class);
        }
        WebShopTicket webShopTicket = (WebShopTicket)loaded;
        if (!webShopTicket.getClientAddress().equals(clientIP)) {
            throw new PermissionDeniedException();
        }
        return webShopTicket;
    }

    @Override
    public PaymentRequestTicket markAsFailedtoSend(PaymentRequestTicket ticket) {
        ticket = this.fetchService.fetch(ticket, new Relationship[0]);
        ticket.setStatus(Ticket.Status.FAILED);
        return this.ticketDao.update(ticket);
    }

    @Override
    public int processExpiredTickets(Calendar time) {
        Calendar createdBefore = (Calendar)time.clone();
        createdBefore.add(11, -1);
        TicketQuery query = new TicketQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setStatus(Ticket.Status.PENDING);
        query.setCreatedBefore(createdBefore);
        int count = 0;
        List<? extends Ticket> expired = this.ticketDao.search(query);
        for (Ticket ticket : expired) {
            ticket.setStatus(Ticket.Status.EXPIRED);
            this.ticketDao.update(ticket);
            ++count;
        }
        return count;
    }

    @Override
    public List<? extends Ticket> search(TicketQuery query) {
        return this.ticketDao.search(query);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPaymentRequestHandler(PaymentRequestHandler paymentRequestHandler) {
        this.paymentRequestHandler = paymentRequestHandler;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setTicketDao(TicketDAO ticketDao) {
        this.ticketDao = ticketDao;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(Ticket ticket) {
        if (ticket instanceof PaymentRequestTicket) {
            this.getPaymentRequestValidator().validate(ticket);
        } else {
            this.getWebShopValidator().validate(ticket);
        }
    }

    private TransferType defaultTransferTypeFor(PaymentRequestTicket ticket) {
        Channel channel = this.fetchService.fetch(ticket.getToChannel(), new Relationship[0]);
        Member from = this.fetchService.fetch(ticket.getFrom(), Element.Relationships.GROUP);
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setUniqueResult();
        ttQuery.setUsePriority(true);
        ttQuery.setContext(TransactionContext.PAYMENT);
        ttQuery.setFromOwner(from);
        ttQuery.setToOwner(ticket.getTo());
        ttQuery.setCurrency(ticket.getCurrency());
        ttQuery.setChannel(channel.getInternalName());
        ttQuery.setGroup(from.getGroup());
        List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
        if (transferTypes.isEmpty()) {
            return null;
        }
        return transferTypes.iterator().next();
    }

    private String generateTicket() {
        String ticket = null;
        while (ticket == null || this.ticketDao.exists(ticket)) {
            ticket = RandomStringUtils.random((int)32, (String)POSSIBLE_TICKET_CHARS);
        }
        return ticket;
    }

    private Validator getPaymentRequestValidator() {
        Validator paymentRequestValidator = new Validator("transfer");
        paymentRequestValidator.property("amount").positiveNonZero();
        paymentRequestValidator.property("from").required();
        paymentRequestValidator.property("to").required();
        paymentRequestValidator.property("description").maxLength(1000);
        paymentRequestValidator.property("fromChannel").required();
        paymentRequestValidator.property("toChannel").required();
        return paymentRequestValidator;
    }

    private Validator getWebShopValidator() {
        Validator webshopValidator = new Validator("transfer");
        webshopValidator.property("amount").positiveNonZero();
        webshopValidator.property("to").required();
        webshopValidator.property("description").maxLength(1000);
        webshopValidator.property("returnUrl").required();
        webshopValidator.property("clientAddress").required().inetAddr();
        webshopValidator.property("memberAddress").required().inetAddr();
        return webshopValidator;
    }

    private void simulate(PaymentRequestTicket ticket) {
        DoPaymentDTO dto = new DoPaymentDTO();
        dto.setContext(TransactionContext.PAYMENT);
        dto.setChannel(ticket.getToChannel().getInternalName());
        dto.setFrom(ticket.getFrom());
        dto.setTo(ticket.getTo());
        dto.setAmount(ticket.getAmount());
        dto.setCurrency(ticket.getCurrency());
        dto.setTransferType(ticket.getTransferType());
        dto.setDescription(ticket.getDescription());
        this.paymentService.simulatePayment(dto);
    }
}

