/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.List;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.TicketQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidChannelException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;

public class TicketServiceSecurity
extends BaseServiceSecurity
implements TicketService {
    private TicketServiceLocal ticketService;

    @Override
    public WebShopTicket cancelWebShopTicket(long ticketId, String clientIP) {
        return this.ticketService.cancelWebShopTicket(ticketId, clientIP);
    }

    @Override
    public PaymentRequestTicket generate(PaymentRequestTicket ticket) throws InvalidChannelException, NotEnoughCreditsException, MaxAmountPerDayExceededException, UnexpectedEntityException, UpperCreditLimitReachedException, AuthorizedPaymentInPastException {
        this.permissionService.permission(ticket.getTo()).member(MemberPermission.PAYMENTS_REQUEST).operator(OperatorPermission.PAYMENTS_REQUEST).check();
        return this.ticketService.generate(ticket);
    }

    @Override
    public WebShopTicket loadPendingWebShopTicket(String ticket, String clientIP, Relationship ... fetch) throws EntityNotFoundException {
        return this.ticketService.loadPendingWebShopTicket(ticket, clientIP, fetch);
    }

    @Override
    public List<? extends Ticket> search(TicketQuery query) {
        this.permissionService.permission(query.getTo()).member(MemberPermission.PAYMENTS_REQUEST).operator(OperatorPermission.PAYMENTS_REQUEST).check();
        return this.ticketService.search(query);
    }

    public void setTicketServiceLocal(TicketServiceLocal ticketService) {
        this.ticketService = ticketService;
    }

    @Override
    public void validate(Ticket ticket) {
        this.ticketService.validate(ticket);
    }
}

