/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.math.MathContext;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.DataObject;

public class TransactionSummaryVO
extends DataObject {
    private static final long serialVersionUID = -2308383871952147029L;
    private int count;
    private BigDecimal amount;

    public TransactionSummaryVO() {
    }

    public TransactionSummaryVO(int count, BigDecimal amount) {
        this.setCount(count);
        this.setAmount(amount);
    }

    public TransactionSummaryVO add(BigDecimal amount) {
        return this.add(1, amount);
    }

    public TransactionSummaryVO add(int count, BigDecimal amount) {
        return new TransactionSummaryVO(this.count + count, BigDecimalHelper.nvl(this.amount).add(BigDecimalHelper.nvl(amount)));
    }

    public TransactionSummaryVO add(TransactionSummaryVO other) {
        return this.add(other.getCount(), other.getAmount());
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getAverage() {
        MathContext mathContext = new MathContext(6);
        return this.count == 0 ? BigDecimal.ZERO : this.amount.divide(new BigDecimal(this.count), mathContext);
    }

    public int getCount() {
        return this.count;
    }

    public void setAmount(BigDecimal amount) {
        if ((amount = BigDecimalHelper.nvl(amount)).compareTo(BigDecimal.ZERO) < 0 && !this.allowNegative()) {
            amount = BigDecimal.ZERO;
        }
        this.amount = amount;
    }

    public void setCount(int count) {
        this.count = count < 0 ? 0 : count;
    }

    public TransactionSummaryVO subtract(BigDecimal amount) {
        return this.subtract(1, amount);
    }

    public TransactionSummaryVO subtract(int count, BigDecimal amount) {
        return this.add(-count, BigDecimalHelper.nvl(amount).negate());
    }

    public TransactionSummaryVO subtract(TransactionSummaryVO other) {
        return this.subtract(other.getCount(), other.getAmount());
    }

    protected boolean allowNegative() {
        return false;
    }
}

