/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferAuthorizationDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RatesToSave;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.AlreadyAuthorizedException;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import nl.strohalm.cyclos.utils.lock.LockHandlerFactory;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.TransactionStatus;

public class TransferAuthorizationServiceImpl
implements TransferAuthorizationServiceLocal {
    private FetchServiceLocal fetchService;
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    private TransferDAO transferDao;
    private TransferAuthorizationDAO transferAuthorizationDao;
    private AccountServiceLocal accountService;
    private MemberNotificationHandler memberNotificationHandler;
    private PermissionServiceLocal permissionService;
    private RateServiceLocal rateService;
    private LockHandlerFactory lockHandlerFactory;
    private TransactionHelper transactionHelper;
    private PaymentServiceLocal paymentService;

    @Override
    public Transfer authorize(TransferAuthorizationDTO dto) throws AlreadyAuthorizedException, EntityNotFoundException, UnexpectedEntityException {
        return this.authorize(dto, true);
    }

    @Override
    public Transfer authorize(TransferAuthorizationDTO dto, boolean newTransaction) throws AlreadyAuthorizedException, EntityNotFoundException, UnexpectedEntityException {
        return this.authorize(dto, newTransaction, false);
    }

    @Override
    public Transfer authorizeOnInsert(LockHandler lockHandler, Transfer transfer) {
        if (LoggedUser.hasUser()) {
            Member fromMember;
            transfer = this.fetchService.fetch(transfer, Transfer.Relationships.PARENT, RelationshipHelper.nested(Transfer.Relationships.NEXT_AUTHORIZATION_LEVEL, AuthorizationLevel.Relationships.ADMIN_GROUPS));
            Transfer parent = transfer.getParent();
            AuthorizationLevel authorizationLevel = transfer.getNextAuthorizationLevel();
            Member member = fromMember = transfer.isFromSystem() ? null : (Member)transfer.getFromOwner();
            if (parent == null && authorizationLevel != null) {
                boolean authorize = false;
                switch (authorizationLevel.getAuthorizer()) {
                    case BROKER: {
                        authorize = LoggedUser.isBroker() && fromMember != null && ((Entity)LoggedUser.element()).equals(fromMember.getBroker()) || LoggedUser.isAdministrator() && authorizationLevel.getAdminGroups().contains(LoggedUser.group());
                        break;
                    }
                    case ADMIN: {
                        boolean bl = authorize = LoggedUser.isAdministrator() && authorizationLevel.getAdminGroups().contains(LoggedUser.group());
                    }
                }
                if (authorize) {
                    TransferAuthorizationDTO dto = new TransferAuthorizationDTO();
                    dto.setTransfer(transfer);
                    transfer = this.doAuthorize(lockHandler, false, dto, true);
                }
            }
        }
        return transfer;
    }

    @Override
    public boolean canAuthorizeOrDeny(Transfer transfer) {
        AuthorizationLevel level = (transfer = this.fetchService.fetch(transfer, Payment.Relationships.FROM, Payment.Relationships.TO, RelationshipHelper.nested(Transfer.Relationships.NEXT_AUTHORIZATION_LEVEL, AuthorizationLevel.Relationships.ADMIN_GROUPS))).getNextAuthorizationLevel();
        if (level == null) {
            return false;
        }
        try {
            if (transfer.isFromSystem()) {
                if (!transfer.isToSystem() && level.getAuthorizer() == AuthorizationLevel.Authorizer.RECEIVER) {
                    this.permissionService.permission((Member)transfer.getToOwner()).member(MemberPermission.PAYMENTS_AUTHORIZE).operator(OperatorPermission.PAYMENTS_AUTHORIZE).check();
                } else {
                    this.permissionService.permission().admin(AdminSystemPermission.PAYMENTS_AUTHORIZE).check();
                }
            } else {
                switch (level.getAuthorizer()) {
                    case PAYER: {
                        this.permissionService.permission((Member)transfer.getFromOwner()).member(MemberPermission.PAYMENTS_AUTHORIZE).operator(OperatorPermission.PAYMENTS_AUTHORIZE).check();
                        break;
                    }
                    case RECEIVER: {
                        this.permissionService.permission((Member)transfer.getToOwner()).member(MemberPermission.PAYMENTS_AUTHORIZE).operator(OperatorPermission.PAYMENTS_AUTHORIZE).check();
                        break;
                    }
                    case BROKER: {
                        this.permissionService.permission((Member)transfer.getFromOwner()).admin(AdminMemberPermission.PAYMENTS_AUTHORIZE).broker(BrokerPermission.MEMBER_PAYMENTS_AUTHORIZE).check();
                        break;
                    }
                    case ADMIN: {
                        this.permissionService.permission((Member)transfer.getFromOwner()).admin(AdminMemberPermission.PAYMENTS_AUTHORIZE).check();
                    }
                }
            }
            if (LoggedUser.isAdministrator() && !level.getAdminGroups().contains(LoggedUser.group())) {
                throw new PermissionDeniedException();
            }
            return true;
        }
        catch (PermissionDeniedException e) {
            return false;
        }
    }

    @Override
    public boolean canCancel(Transfer transfer) {
        if (transfer.isFromSystem()) {
            return this.permissionService.permission().admin(AdminSystemPermission.PAYMENTS_CANCEL).hasPermission();
        }
        return this.permissionService.permission((Member)transfer.getFromOwner()).admin(AdminMemberPermission.PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER).broker(BrokerPermission.MEMBER_PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER).member(MemberPermission.PAYMENTS_CANCEL_AUTHORIZED).operator(OperatorPermission.PAYMENTS_CANCEL_AUTHORIZED).hasPermission();
    }

    @Override
    public Transfer cancel(final TransferAuthorizationDTO dto) throws EntityNotFoundException, UnexpectedEntityException {
        Transfer transfer = this.fetchService.fetch(dto.getTransfer(), new Relationship[0]);
        this.validateAuthorization(transfer);
        if (transfer.getScheduledPayment() != null) {
            throw new UnexpectedEntityException();
        }
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return TransferAuthorizationServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return TransferAuthorizationServiceImpl.this.doCancel(dto);
            }
        });
    }

    @Override
    public Transfer deny(final TransferAuthorizationDTO dto) throws EntityNotFoundException, UnexpectedEntityException {
        if (StringUtils.isEmpty((String)dto.getComments())) {
            throw new ValidationException("comments", "transferAuthorization.comments", new RequiredError(new Object[0]));
        }
        Transfer transfer = this.fetchService.fetch(dto.getTransfer(), new Relationship[0]);
        this.validateAuthorization(transfer);
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return TransferAuthorizationServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return TransferAuthorizationServiceImpl.this.doDeny(dto);
            }
        });
    }

    @Override
    public boolean hasAlreadyAuthorized(Transfer transfer) {
        if (!LoggedUser.hasUser()) {
            return false;
        }
        transfer = this.fetchService.fetch(transfer, Transfer.Relationships.AUTHORIZATIONS);
        Object logged = LoggedUser.element();
        for (TransferAuthorization auth : transfer.getAuthorizations()) {
            if (!((Entity)logged).equals(auth.getBy())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<TransferAuthorization> load(Collection<Long> ids, Relationship ... fetch) {
        return this.transferAuthorizationDao.load(ids, fetch);
    }

    @Override
    public TransferAuthorization load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        return (TransferAuthorization)this.transferAuthorizationDao.load(id, fetch);
    }

    @Override
    public List<TransferAuthorization> searchAuthorizations(TransferAuthorizationQuery query) {
        Element by = this.fetchService.fetch(query.getBy(), Member.Relationships.BROKER);
        if (LoggedUser.isAdministrator()) {
            query.setByAdministration(query.getBy() == null);
        } else if (LoggedUser.isBroker()) {
            query.setByAdministration(false);
            query.setBy((Element)(by == null ? LoggedUser.element() : by));
        } else {
            Member loggedMember = (Member)LoggedUser.accountOwner();
            query.setByAdministration(false);
            query.setBy(loggedMember);
        }
        return this.transferAuthorizationDao.search(query);
    }

    @Override
    public List<Transfer> searchTransfersAwaitingAuthorization(TransfersAwaitingAuthorizationQuery query) {
        query.setAuthorizer((Element)LoggedUser.element());
        return this.transferDao.searchTransfersAwaitingAuthorization(query);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLockHandlerFactory(LockHandlerFactory lockHandlerFactory) {
        this.lockHandlerFactory = lockHandlerFactory;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setScheduledPaymentServiceLocal(ScheduledPaymentServiceLocal scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferAuthorizationDao(TransferAuthorizationDAO transferAuthorizationDao) {
        this.transferAuthorizationDao = transferAuthorizationDao;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    private Transfer authorize(final TransferAuthorizationDTO dto, final boolean newTransaction, final boolean automaticallyAuthorize) {
        Transfer transfer = this.fetchService.fetch(dto.getTransfer(), new Relationship[0]);
        this.validateAuthorization(transfer);
        return this.transactionHelper.maybeRunInNewTransaction(new Transactional<Transfer>(){

            @Override
            public Transfer afterCommit(Transfer result) {
                return TransferAuthorizationServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public Transfer doInTransaction(TransactionStatus status) {
                return TransferAuthorizationServiceImpl.this.doAuthorize(null, newTransaction, dto, automaticallyAuthorize);
            }
        }, newTransaction, LockedAccountsOnPayments.ALL);
    }

    private TransferAuthorization createAuthorization(Transfer transfer, TransferAuthorization.Action action, AuthorizationLevel level, String comments, boolean showToMember) {
        TransferAuthorization transferAuthorization = new TransferAuthorization();
        transferAuthorization.setTransfer(transfer);
        transferAuthorization.setLevel(level);
        transferAuthorization.setBy((Element)LoggedUser.element());
        transferAuthorization.setDate(Calendar.getInstance());
        transferAuthorization.setAction(action);
        transferAuthorization.setComments(comments);
        transferAuthorization.setShowToMember(showToMember);
        transferAuthorization = this.transferAuthorizationDao.insert(transferAuthorization);
        return transferAuthorization;
    }

    private Transfer doAuthorize(LockHandler lockHandler, boolean newTransaction, TransferAuthorizationDTO dto, boolean automaticallyAuthorize) {
        String comments = dto.getComments();
        boolean showToMember = dto.isShowToMember();
        Transfer transfer = this.fetchService.reload(dto.getTransfer(), Transfer.Relationships.SCHEDULED_PAYMENT, Transfer.Relationships.AUTHORIZATIONS);
        Object logged = LoggedUser.element();
        for (TransferAuthorization authorization : transfer.getAuthorizations()) {
            if (!((Entity)logged).equals(authorization.getBy())) continue;
            throw new AlreadyAuthorizedException();
        }
        AuthorizationLevel authorizationLevel = transfer.getNextAuthorizationLevel();
        AuthorizationLevel nextAuthorizationLevel = this.getNextAuthorizationLevel(transfer);
        boolean processed = nextAuthorizationLevel == null;
        TransferAuthorization authorization = this.createAuthorization(transfer, TransferAuthorization.Action.AUTHORIZE, authorizationLevel, comments, showToMember);
        transfer = lockHandler == null ? this.updateAuthorizationData(transfer, nextAuthorizationLevel, processed, authorization, newTransaction) : this.doUpdateAuthorizationData(lockHandler, transfer, nextAuthorizationLevel, processed, authorization);
        transfer.getAuthorizations().add(authorization);
        if (transfer.getScheduledPayment() != null) {
            this.scheduledPaymentService.updateScheduledPaymentStatus(transfer.getScheduledPayment());
        }
        this.memberNotificationHandler.paymentAuthorizedOrDeniedNotification(transfer, !automaticallyAuthorize);
        if (processed) {
            this.paymentService.notifyTransferProcessed(transfer);
        }
        return transfer;
    }

    private Transfer doCancel(TransferAuthorizationDTO dto) {
        Transfer transfer = this.fetchService.fetch(dto.getTransfer(), new Relationship[0]);
        String comments = dto.getComments();
        AuthorizationLevel authorizationLevel = transfer.getNextAuthorizationLevel();
        transfer = this.transferDao.updateAuthorizationData(transfer.getId(), Payment.Status.CANCELED, null, null, null);
        TransferAuthorization authorization = this.createAuthorization(transfer, TransferAuthorization.Action.CANCEL, authorizationLevel, comments, true);
        this.accountService.returnReservation(authorization, transfer);
        this.updateChildTransfers(transfer, authorization);
        this.memberNotificationHandler.paymentCancelledNotification(transfer);
        return transfer;
    }

    private Transfer doDeny(TransferAuthorizationDTO dto) {
        Transfer transfer = this.fetchService.fetch(dto.getTransfer(), new Relationship[0]);
        String comments = dto.getComments();
        boolean showToMember = dto.isShowToMember();
        AuthorizationLevel authorizationLevel = transfer.getNextAuthorizationLevel();
        if ((transfer = this.transferDao.updateAuthorizationData(transfer.getId(), Payment.Status.DENIED, null, null, null)).getScheduledPayment() != null) {
            ScheduledPayment scheduledPayment = this.fetchService.fetch(transfer.getScheduledPayment(), ScheduledPayment.Relationships.TRANSFERS);
            for (Transfer currentTransfer : scheduledPayment.getTransfers()) {
                Payment.Status currentTransferStatus = currentTransfer.getStatus();
                if (currentTransferStatus != Payment.Status.PENDING && currentTransferStatus != Payment.Status.SCHEDULED && currentTransferStatus != Payment.Status.BLOCKED) continue;
                this.transferDao.updateAuthorizationData(currentTransfer.getId(), Payment.Status.DENIED, null, null, null);
            }
            this.scheduledPaymentService.updateScheduledPaymentStatus(transfer.getScheduledPayment());
        }
        TransferAuthorization authorization = this.createAuthorization(transfer, TransferAuthorization.Action.DENY, authorizationLevel, comments, showToMember);
        this.accountService.returnReservation(authorization, transfer);
        this.updateChildTransfers(transfer, authorization);
        this.memberNotificationHandler.paymentAuthorizedOrDeniedNotification(transfer, true);
        return transfer;
    }

    private Transfer doUpdateAuthorizationData(LockHandler lockHandler, Transfer transfer, AuthorizationLevel nextAuthorizationLevel, boolean processed, TransferAuthorization authorization) {
        if (processed) {
            lockHandler.lock(transfer.getFrom(), transfer.getTo());
            RatesToSave rates = this.rateService.applyTransfer(transfer);
            Calendar processDate = rates.getFromRates() == null ? Calendar.getInstance() : rates.getFromRates().getDate();
            transfer.setProcessDate(processDate);
            this.rateService.persist(rates);
            this.accountService.returnReservation(authorization, transfer);
            this.accountService.removeClosedBalancesAfter(transfer.getTo(), processDate);
            transfer = this.transferDao.updateAuthorizationData(transfer.getId(), Payment.Status.PROCESSED, null, transfer.getProcessDate(), rates);
        } else {
            transfer = this.transferDao.updateAuthorizationData(transfer.getId(), Payment.Status.PENDING, nextAuthorizationLevel, null, null);
        }
        for (Transfer childTransfer : transfer.getChildren()) {
            this.updateChildTransfer(lockHandler, transfer, childTransfer, authorization, processed);
        }
        return transfer;
    }

    private AuthorizationLevel getNextAuthorizationLevel(Transfer transfer) {
        AuthorizationLevel authorizationLevel = transfer.getNextAuthorizationLevel();
        ArrayList<AuthorizationLevel> authorizationLevels = new ArrayList<AuthorizationLevel>(transfer.getType().getAuthorizationLevels());
        int index = authorizationLevels.indexOf(authorizationLevel);
        if (index < 0 || index == authorizationLevels.size() - 1) {
            return null;
        }
        AuthorizationLevel wouldBeNext = (AuthorizationLevel)authorizationLevels.get(index + 1);
        if (transfer.getAmount().compareTo(wouldBeNext.getAmount()) < 0) {
            return null;
        }
        return wouldBeNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transfer updateAuthorizationData(Transfer transfer, AuthorizationLevel nextAuthorizationLevel, boolean processed, TransferAuthorization authorization, boolean newTransaction) {
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandlerIfLockingAtLeast(LockedAccountsOnPayments.ALL);
        try {
            Transfer transfer2 = this.doUpdateAuthorizationData(lockHandler, transfer, nextAuthorizationLevel, processed, authorization);
            return transfer2;
        }
        finally {
            if (lockHandler != null) {
                lockHandler.release();
            }
        }
    }

    private void updateChildTransfer(LockHandler lockHandler, Transfer parent, Transfer child, TransferAuthorization authorization, boolean processed) {
        child = this.fetchService.fetch(child, Transfer.Relationships.CHILDREN);
        RatesToSave rates = null;
        if (processed) {
            lockHandler.lock(child.getFrom(), child.getTo());
            rates = this.rateService.applyTransfer(child);
            child.setProcessDate(parent.getProcessDate());
            this.rateService.persist(rates);
            this.accountService.returnReservation(authorization, child);
            this.accountService.removeClosedBalancesAfter(child.getTo(), child.getProcessDate());
        }
        this.transferDao.updateAuthorizationData(child.getId(), parent.getStatus(), parent.getNextAuthorizationLevel(), parent.getProcessDate(), rates);
        if (child.getChildren() != null) {
            for (Transfer childTransfer : child.getChildren()) {
                this.updateChildTransfer(lockHandler, child, childTransfer, authorization, processed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildTransfers(Transfer transfer, TransferAuthorization authorization) {
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandlerIfLockingAtLeast(LockedAccountsOnPayments.ALL);
        try {
            for (Transfer childTransfer : transfer.getChildren()) {
                this.updateChildTransfer(lockHandler, transfer, childTransfer, authorization, true);
            }
        }
        finally {
            if (lockHandler != null) {
                lockHandler.release();
            }
        }
    }

    private void validateAuthorization(Transfer transfer) {
        if (!transfer.isRoot() || transfer.getStatus() != Payment.Status.PENDING) {
            throw new UnexpectedEntityException();
        }
    }
}

