/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationService;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.AlreadyAuthorizedException;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class TransferAuthorizationServiceSecurity
extends BaseServiceSecurity
implements TransferAuthorizationService {
    private TransferAuthorizationServiceLocal transferAuthorizationService;

    @Override
    public Transfer authorize(TransferAuthorizationDTO dto) throws AlreadyAuthorizedException, EntityNotFoundException, UnexpectedEntityException {
        if (!this.transferAuthorizationService.canAuthorizeOrDeny(dto.getTransfer())) {
            throw new PermissionDeniedException();
        }
        return this.transferAuthorizationService.authorize(dto);
    }

    @Override
    public Transfer cancel(TransferAuthorizationDTO dto) throws EntityNotFoundException, UnexpectedEntityException {
        if (!this.transferAuthorizationService.canCancel(dto.getTransfer())) {
            throw new PermissionDeniedException();
        }
        return this.transferAuthorizationService.cancel(dto);
    }

    @Override
    public Transfer deny(TransferAuthorizationDTO dto) throws EntityNotFoundException, UnexpectedEntityException {
        if (!this.transferAuthorizationService.canAuthorizeOrDeny(dto.getTransfer())) {
            throw new PermissionDeniedException();
        }
        return this.transferAuthorizationService.deny(dto);
    }

    @Override
    public boolean hasAlreadyAuthorized(Transfer transfer) {
        return this.transferAuthorizationService.hasAlreadyAuthorized(transfer);
    }

    @Override
    public List<TransferAuthorization> searchAuthorizations(TransferAuthorizationQuery query) {
        Member member;
        this.checkViewAuthorized();
        Element by = this.fetchService.fetch(query.getBy(), new Relationship[0]);
        if (by instanceof Administrator && !LoggedUser.isAdministrator()) {
            throw new PermissionDeniedException();
        }
        if (by != null) {
            this.permissionService.checkManages(by);
        }
        if ((member = query.getMember()) != null) {
            this.permissionService.checkRelatesTo(member);
        }
        return this.transferAuthorizationService.searchAuthorizations(query);
    }

    @Override
    public List<Transfer> searchTransfersAwaitingAuthorization(TransfersAwaitingAuthorizationQuery query) {
        this.checkViewAuthorized();
        Member member = query.getMember();
        if (member != null) {
            this.permissionService.checkRelatesTo(member);
        }
        return this.transferAuthorizationService.searchTransfersAwaitingAuthorization(query);
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    private void checkViewAuthorized() {
        this.permissionService.permission().admin(AdminSystemPermission.PAYMENTS_AUTHORIZE, AdminMemberPermission.PAYMENTS_AUTHORIZE).broker(BrokerPermission.MEMBER_PAYMENTS_AUTHORIZE).member(MemberPermission.PAYMENTS_AUTHORIZE).operator(OperatorPermission.PAYMENTS_AUTHORIZE).check();
    }
}

