/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.DataObject;

public class TransferDTO
extends DataObject
implements Rated {
    private static final long serialVersionUID = 4615832057413419970L;
    private AccountFeeLog accountFeeLog;
    private BigDecimal amount;
    private boolean automatic;
    private String channel;
    private TransactionContext context;
    private Calendar date;
    private String description;
    private Currency currency;
    private boolean forced;
    private Element by;
    private Account from;
    private AccountOwner fromOwner;
    private LoanPayment loanPayment;
    private Account to;
    private AccountOwner toOwner;
    private TransferType transferType;
    private Ticket ticket;
    private Transfer parent;
    private Element receiver;
    private ExternalTransfer externalTransfer;
    private List<ScheduledPaymentDTO> payments;
    private ScheduledPayment scheduledPayment;
    private Collection<PaymentCustomFieldValue> customValues;
    private boolean showScheduledToReceiver;
    private String traceNumber;
    private Long clientId;
    private String traceData;
    private Calendar emissionDate;
    private Calendar expirationDate;
    private BigDecimal iRate;

    public AccountFeeLog getAccountFeeLog() {
        return this.accountFeeLog;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Element getBy() {
        return this.by;
    }

    public String getChannel() {
        return this.channel;
    }

    public Long getClientId() {
        return this.clientId;
    }

    public TransactionContext getContext() {
        return this.context;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Calendar getEmissionDate() {
        return this.emissionDate;
    }

    @Override
    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public ExternalTransfer getExternalTransfer() {
        return this.externalTransfer;
    }

    public Account getFrom() {
        return this.from;
    }

    public AccountOwner getFromOwner() {
        return this.fromOwner;
    }

    @Override
    public BigDecimal getiRate() {
        return this.iRate;
    }

    public LoanPayment getLoanPayment() {
        return this.loanPayment;
    }

    public Transfer getParent() {
        return this.parent;
    }

    public List<ScheduledPaymentDTO> getPayments() {
        return this.payments;
    }

    public Element getReceiver() {
        return this.receiver;
    }

    public ScheduledPayment getScheduledPayment() {
        return this.scheduledPayment;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public Account getTo() {
        return this.to;
    }

    public AccountOwner getToOwner() {
        return this.toOwner;
    }

    public String getTraceData() {
        return this.traceData;
    }

    public String getTraceNumber() {
        return this.traceNumber;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isForced() {
        return this.forced;
    }

    public boolean isShowScheduledToReceiver() {
        return this.showScheduledToReceiver;
    }

    public void setAccountFeeLog(AccountFeeLog accountFeeLog) {
        this.accountFeeLog = accountFeeLog;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public void setBy(Element by) {
        this.by = by;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setContext(TransactionContext context) {
        this.context = context;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExternalTransfer(ExternalTransfer externalTransfer) {
        this.externalTransfer = externalTransfer;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setFrom(Account from) {
        this.from = from;
    }

    public void setFromOwner(AccountOwner fromOwner) {
        this.fromOwner = fromOwner;
    }

    public void setLoanPayment(LoanPayment loanPayment) {
        this.loanPayment = loanPayment;
    }

    public void setParent(Transfer parent) {
        this.parent = parent;
    }

    public void setPayments(List<ScheduledPaymentDTO> payments) {
        this.payments = payments;
    }

    public void setRates(Rated rates) {
        if (rates != null) {
            this.emissionDate = rates.getEmissionDate();
            this.expirationDate = rates.getExpirationDate();
            this.iRate = rates.getiRate();
        }
    }

    public void setReceiver(Element receiver) {
        this.receiver = receiver;
    }

    public void setScheduledPayment(ScheduledPayment scheduledPayment) {
        this.scheduledPayment = scheduledPayment;
    }

    public void setShowScheduledToReceiver(boolean showScheduledToReceiver) {
        this.showScheduledToReceiver = showScheduledToReceiver;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public void setTo(Account to) {
        this.to = to;
    }

    public void setToOwner(AccountOwner toOwner) {
        this.toOwner = toOwner;
    }

    public void setTraceData(String traceData) {
        this.traceData = traceData;
    }

    public void setTraceNumber(String traceNumber) {
        this.traceNumber = traceNumber;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public DoPaymentDTO toPaymentDTO() {
        DoPaymentDTO dto = new DoPaymentDTO();
        dto.setTransferType(this.transferType);
        dto.setTo(this.to.getOwner());
        dto.setAmount(this.amount);
        dto.setContext(this.context);
        dto.setDate(this.date);
        dto.setDescription(this.description);
        dto.setTicket(this.ticket);
        return dto;
    }
}

