/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.AuthorizationLevelDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.AuthorizationLevelServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;

public class AuthorizationLevelServiceImpl
implements AuthorizationLevelServiceLocal {
    private AuthorizationLevelDAO authorizationLevelDao;
    private FetchDAO fetchDao;
    private FetchServiceLocal fetchService;
    private TransferTypeDAO transferTypeDao;

    public Validator getValidator() {
        Validator validator = new Validator("authorizationLevel");
        validator.property("transferType").required();
        validator.property("amount").required();
        validator.property("authorizer").required();
        validator.general(new MaxLevelValidation());
        validator.general(new AmountValidation());
        validator.general(new AuthorizerLevelValidation());
        validator.general(new AdminGroupRequiredValidation());
        return validator;
    }

    public AuthorizationLevel load(Long id, Relationship ... fetch) {
        return (AuthorizationLevel)this.authorizationLevelDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        Long transferTypeId = null;
        int i$ = 0;
        Long[] arr$ = ids;
        int len$ = arr$.length;
        if (i$ < len$) {
            Long id = arr$[i$];
            AuthorizationLevel authorizationLevel = this.load(id, AuthorizationLevel.Relationships.TRANSFER_TYPE);
            transferTypeId = authorizationLevel.getTransferType().getId();
        }
        int removedAuthorizationLevels = this.authorizationLevelDao.delete(ids);
        this.updateRemainingLevels(transferTypeId);
        return removedAuthorizationLevels;
    }

    @Override
    public AuthorizationLevel save(AuthorizationLevel authorizationLevel) {
        this.validate(authorizationLevel);
        if (authorizationLevel.isTransient()) {
            Integer newLevel = this.getNewLevel(authorizationLevel);
            authorizationLevel.setLevel(newLevel);
            return this.authorizationLevelDao.insert(authorizationLevel);
        }
        return this.authorizationLevelDao.update(authorizationLevel);
    }

    public void setAuthorizationLevelDao(AuthorizationLevelDAO authorizationLevelDao) {
        this.authorizationLevelDao = authorizationLevelDao;
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setTransferTypeDao(TransferTypeDAO transferTypeDao) {
        this.transferTypeDao = transferTypeDao;
    }

    @Override
    public void validate(AuthorizationLevel authorizationLevel) throws ValidationException {
        if (authorizationLevel.isPersistent()) {
            AuthorizationLevel savedAuthorizationLevel = (AuthorizationLevel)this.authorizationLevelDao.load(authorizationLevel.getId(), new Relationship[0]);
            authorizationLevel.setAuthorizer(savedAuthorizationLevel.getAuthorizer());
        }
        TransferType transferType = this.fetchDao.fetch(authorizationLevel.getTransferType(), TransferType.Relationships.AUTHORIZATION_LEVELS);
        Collection<AuthorizationLevel> authorizationLevels = this.fetchService.fetch(transferType.getAuthorizationLevels(), new Relationship[]{RelationshipHelper.nested(AuthorizationLevel.Relationships.TRANSFER_TYPE, AuthorizationLevel.Relationships.ADMIN_GROUPS)});
        transferType.setAuthorizationLevels(authorizationLevels);
        authorizationLevel.setTransferType(transferType);
        this.getValidator().validate(authorizationLevel);
    }

    private AuthorizationLevel getHigherLevel(AuthorizationLevel authorizationLevel) {
        TransferType transferType = authorizationLevel.getTransferType();
        LinkedList<AuthorizationLevel> authorizationLevels = new LinkedList<AuthorizationLevel>(transferType.getAuthorizationLevels());
        if (CollectionUtils.isEmpty(authorizationLevels)) {
            return null;
        }
        Integer currentLevel = authorizationLevel.getLevel();
        if (currentLevel == null) {
            return null;
        }
        if (currentLevel.intValue() == authorizationLevels.size() || authorizationLevels.size() == 1) {
            return null;
        }
        return authorizationLevels.get(currentLevel);
    }

    private AuthorizationLevel getLowerLevel(AuthorizationLevel authorizationLevel) {
        TransferType transferType = authorizationLevel.getTransferType();
        LinkedList<AuthorizationLevel> authorizationLevels = new LinkedList<AuthorizationLevel>(transferType.getAuthorizationLevels());
        if (CollectionUtils.isEmpty(authorizationLevels)) {
            return null;
        }
        Integer currentLevel = authorizationLevel.getLevel();
        if (currentLevel == null) {
            return authorizationLevels.getLast();
        }
        if (currentLevel == 1 || authorizationLevels.size() == 1) {
            return null;
        }
        return authorizationLevels.get(currentLevel - 2);
    }

    private Integer getNewLevel(AuthorizationLevel authorizationLevel) {
        TransferType transferType = authorizationLevel.getTransferType();
        LinkedList<AuthorizationLevel> authorizationLevels = new LinkedList<AuthorizationLevel>(transferType.getAuthorizationLevels());
        if (CollectionUtils.isEmpty(authorizationLevels)) {
            return 1;
        }
        return authorizationLevels.size() + 1;
    }

    private void updateRemainingLevels(Long transferTypeId) {
        TransferType transferType = (TransferType)this.transferTypeDao.load(transferTypeId, TransferType.Relationships.AUTHORIZATION_LEVELS);
        Collection<AuthorizationLevel> authorizationLevels = transferType.getAuthorizationLevels();
        if (!CollectionUtils.isEmpty(authorizationLevels)) {
            int currentLevel = 1;
            for (AuthorizationLevel authorizationLevel : authorizationLevels) {
                authorizationLevel.setLevel(currentLevel);
                this.authorizationLevelDao.update(authorizationLevel);
                ++currentLevel;
            }
        }
    }

    public class MaxLevelValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -8200684320071292074L;

        @Override
        public ValidationError validate(Object object) {
            AuthorizationLevel authorizationLevel = (AuthorizationLevel)object;
            Integer level = authorizationLevel.getLevel();
            if (level == null) {
                level = AuthorizationLevelServiceImpl.this.getNewLevel(authorizationLevel);
            }
            if (level > 5) {
                return new ValidationError("authorizationLevel.error.maxLevel", 5);
            }
            return null;
        }
    }

    public class AuthorizerLevelValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 2297783229528452496L;

        @Override
        public ValidationError validate(Object object) {
            AuthorizationLevel authorizationLevel = (AuthorizationLevel)object;
            if (authorizationLevel.isTransient()) {
                AuthorizationLevel.Authorizer authorizer;
                Integer level = authorizationLevel.getLevel();
                if (level == null) {
                    level = AuthorizationLevelServiceImpl.this.getNewLevel(authorizationLevel);
                }
                if ((authorizer = authorizationLevel.getAuthorizer()) == AuthorizationLevel.Authorizer.RECEIVER && level > 1) {
                    return new ValidationError("authorizationLevel.error.receiverAuthorizerLevel", new Object[0]);
                }
                if (authorizer == AuthorizationLevel.Authorizer.BROKER) {
                    AuthorizationLevel lowerLevel;
                    if (level == 2 && (lowerLevel = AuthorizationLevelServiceImpl.this.getLowerLevel(authorizationLevel)).getAuthorizer() != AuthorizationLevel.Authorizer.RECEIVER) {
                        return new ValidationError("authorizationLevel.error.brokerLowerAuthorizerLevel", new Object[0]);
                    }
                    if (level > 2) {
                        return new ValidationError("authorizationLevel.error.brokerAuthorizerLevel", new Object[0]);
                    }
                }
            }
            return null;
        }
    }

    public class AmountValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -6923517450707542011L;

        @Override
        public ValidationError validate(Object object) {
            AuthorizationLevel authorizationLevel = (AuthorizationLevel)object;
            TransferType transferType = authorizationLevel.getTransferType();
            if (!CollectionUtils.isEmpty(transferType.getAuthorizationLevels())) {
                AuthorizationLevel lowerLevel = AuthorizationLevelServiceImpl.this.getLowerLevel(authorizationLevel);
                AuthorizationLevel higherLevel = AuthorizationLevelServiceImpl.this.getHigherLevel(authorizationLevel);
                BigDecimal amount = authorizationLevel.getAmount();
                if (amount != null) {
                    if (lowerLevel != null && amount.compareTo(lowerLevel.getAmount()) < 0) {
                        return new ValidationError("authorizationLevel.error.lowerLevelAmount", new Object[0]);
                    }
                    if (higherLevel != null && amount.compareTo(higherLevel.getAmount()) > 0) {
                        return new ValidationError("authorizationLevel.error.higherLevelAmount", new Object[0]);
                    }
                }
            }
            return null;
        }
    }

    public class AdminGroupRequiredValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -4472441677571047937L;

        @Override
        public ValidationError validate(Object object) {
            AuthorizationLevel authorizationLevel = (AuthorizationLevel)object;
            if (authorizationLevel.getAuthorizer() == AuthorizationLevel.Authorizer.ADMIN && CollectionUtils.isEmpty(authorizationLevel.getAdminGroups())) {
                return new ValidationError("authorizationLevel.error.adminGroupRequired", new Object[0]);
            }
            return null;
        }
    }
}

